/*
 * Decompiled with CFR 0.152.
 */
package com.sas.batch.metadata.access;

import com.sas.batch.localsvc.LocalServicesBatchUtility2;
import com.sas.batch.metadata.access.RB;
import com.sas.metadata.remote.AccessControlTemplate;
import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterComponent;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.OMIServerRepository;
import com.sas.services.information.metadata.AccessControlTemplateInterface;
import com.sas.services.information.metadata.AuthorizationBaseInterface;
import com.sas.services.information.metadata.AuthorizationIdentityInfo;
import com.sas.services.information.metadata.AuthorizationIdentityInfoInterface;
import com.sas.services.information.metadata.AuthorizationInfo;
import com.sas.services.information.metadata.AuthorizationInfoInterface;
import com.sas.services.information.metadata.IdentityInterface;
import com.sas.services.information.metadata.OMRAccessControlTemplate;
import com.sas.services.information.metadata.PermissionInfo;
import com.sas.services.information.metadata.PermissionInfoInterface;
import com.sas.services.util.Names;
import com.sas.text.Message;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.ParseException;

public abstract class AbstractAccessUtility
extends LocalServicesBatchUtility2 {
    protected AccessControlTemplateInterface getACTByName(String name, boolean throwNotFound) throws ServiceException, RemoteException {
        String repositoryName = null;
        if (name.contains("/")) {
            String[] elems = name.split("/");
            if (elems.length != 2) {
                throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"Common.InvalidACTName.fmt.log", (Object)name));
            }
            repositoryName = elems[0];
            name = elems[1];
        } else {
            OMIServerRepository foundation = (OMIServerRepository)this.metadataServer.getFoundationRepository();
            repositoryName = foundation.getDefaultRepositoryName();
        }
        Filter filter = new Filter();
        FilterComponent fc = new FilterComponent("Name", 0, name);
        fc.addComponent(new FilterComponent("PublicType", 0, "ACT"));
        filter.setFilterComponent(fc);
        List matches = this.metadataServer.search((FilterInterface)filter);
        for (AccessControlTemplateInterface act : matches) {
            if (!act.getRepositoryName().equalsIgnoreCase(repositoryName)) continue;
            return act;
        }
        if (throwNotFound) {
            throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"Common.ACTNotFound.fmt.log", (Object)name));
        }
        return null;
    }

    protected AccessControlTemplateInterface makeACT(String name) throws ServiceException, RemoteException {
        String repositoryId = null;
        if (name.contains("/")) {
            String[] elems = name.split("/");
            if (elems.length != 2) {
                throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"Common.InvalidACTName.fmt.log", (Object)name));
            }
            OMIRepositoryInterface repository = (OMIRepositoryInterface)this.metadataServer.getRepository(elems[0]);
            if (repository == null) {
                throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"Common.RepositoryDoesNotExist.fmt.log", (Object)elems[0]));
            }
            repositoryId = repository.getDefaultRepositoryId();
            name = elems[1];
        } else {
            OMIServerRepository foundation = (OMIServerRepository)this.metadataServer.getFoundationRepository();
            repositoryId = foundation.getDefaultRepositoryId();
        }
        Names.validateOMRObjectName((String)name, (boolean)true);
        AccessControlTemplateInterface act = (AccessControlTemplateInterface)this.metadataServer.newMetadata(repositoryId, name, "AccessControlTemplate");
        AccessControlTemplate jomaACT = (AccessControlTemplate)act.getRepositoryEntity();
        jomaACT.setPublicType("ACT");
        jomaACT.setUsageVersion(OMRAccessControlTemplate.CURRENT_VERSION.encode());
        return act;
    }

    protected IdentityInterface getIdentityByName(String name) throws ServiceException, RemoteException {
        List matches;
        FilterComponent fc;
        Filter filter;
        boolean groupOnly = false;
        boolean userOnly = false;
        if (name.endsWith("(UserGroup)")) {
            name = name.substring(0, name.length() - 11);
            groupOnly = true;
        } else if (name.endsWith("(User)")) {
            name = name.substring(0, name.length() - 6);
            userOnly = true;
        }
        if (!groupOnly) {
            filter = new Filter();
            fc = new FilterComponent("Name", 0, name);
            fc.addComponent(new FilterComponent("PublicType", 0, "User"));
            filter.setFilterComponent(fc);
            matches = this.metadataServer.search((FilterInterface)filter);
            if (!matches.isEmpty()) {
                return (IdentityInterface)matches.get(0);
            }
        }
        if (!userOnly) {
            filter = new Filter();
            fc = new FilterComponent("Name", 0, name);
            fc.addComponent(new FilterComponent("PublicType", 0, "UserGroup"));
            filter.setFilterComponent(fc);
            matches = this.metadataServer.search((FilterInterface)filter);
            if (!matches.isEmpty()) {
                return (IdentityInterface)matches.get(0);
            }
        }
        throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"Common.IdentityNotFound.fmt.log", (Object)name));
    }

    protected AuthorizationInfoInterface makeAuthInfo(AccessControl ace, AuthorizationBaseInterface authBase) throws ServiceException, RemoteException {
        AuthorizationInfo authInfo = new AuthorizationInfo();
        IdentityInterface identity = this.getIdentityByName(ace.getIdentityName());
        authInfo.setIdentityInfo((AuthorizationIdentityInfoInterface)new AuthorizationIdentityInfo(identity));
        ArrayList<PermissionInfo> perms = new ArrayList<PermissionInfo>(20);
        String[] permissionNames = ace.getPermissions();
        if (ace.containsAll()) {
            permissionNames = ace.substituteAllPermissionsToRemove(authBase, identity);
        }
        for (String permissionName : permissionNames) {
            PermissionInfoInterface.PermissionType type = ace.getType();
            if (type == null) continue;
            PermissionInfo perm = new PermissionInfo(type, permissionName);
            if (ace.getCondition() != null) {
                perm.setPermissionCondition(ace.getCondition());
            }
            perms.add(perm);
        }
        authInfo.setPermissionInfoList(perms);
        return authInfo;
    }

    protected boolean printAuthorizationInfo(AuthorizationInfoInterface info) throws RemoteException, ServiceException {
        return this.printAuthorizationInfo(info, false);
    }

    protected boolean printAuthorizationInfo(AuthorizationInfoInterface info, boolean showEffectiveAccess) throws RemoteException, ServiceException {
        boolean foundSomething = false;
        IdentityInterface identity = info.getIdentityInfo().getIdentity();
        String identityName = this.quotedIdentity(identity);
        StringBuffer granted = new StringBuffer();
        StringBuffer denied = new StringBuffer();
        for (PermissionInfoInterface perm : info.getPermissionInfoList()) {
            if (!showEffectiveAccess && !perm.getPermissionSource().equals((Object)PermissionInfoInterface.PermissionSource.EXPLICIT)) continue;
            if (perm.getPermissionType().equals((Object)PermissionInfoInterface.PermissionType.GRANT)) {
                if (perm.getPermissionCondition() != null && perm.getPermissionCondition().length() > 0) {
                    System.out.println("  -grant " + identityName + ":" + perm.getPermission());
                    System.out.println("    -condition " + this.quoted(perm.getPermissionCondition()));
                } else {
                    if (granted.length() > 0) {
                        granted.append(",");
                    }
                    granted.append(perm.getPermission());
                }
                foundSomething = true;
                continue;
            }
            if (!perm.getPermissionType().equals((Object)PermissionInfoInterface.PermissionType.DENY)) continue;
            if (denied.length() > 0) {
                denied.append(",");
            }
            denied.append(perm.getPermission());
            foundSomething = true;
        }
        if (granted.length() > 0) {
            System.out.println("  -grant " + identityName + ":" + granted.toString());
        }
        if (denied.length() > 0) {
            System.out.println("  -deny  " + identityName + ":" + denied.toString());
        }
        return foundSomething;
    }

    protected String quoted(String string) {
        Pattern pattern = Pattern.compile("\\w+");
        if (pattern.matcher(string).matches()) {
            return string;
        }
        if (!string.contains("\"")) {
            return "\"" + string + "\"";
        }
        if (!string.contains("'")) {
            return "'" + string + "'";
        }
        return "\"" + string.replaceAll("\"", "\\\\\"") + "\"";
    }

    protected String quotedIdentity(IdentityInterface identity) throws RemoteException {
        String name = identity.getName();
        if (identity.getType().equalsIgnoreCase("UserGroup")) {
            name = name + "(UserGroup)";
        }
        return this.quoted(name);
    }

    protected String quotedACTName(AccessControlTemplateInterface act) throws RemoteException, ServiceException {
        String name = act.getName();
        if (!act.getRepository().equals((Object)this.metadataServer.getFoundationRepository())) {
            name = act.getRepositoryName() + "/" + name;
        }
        return this.quoted(name);
    }

    public static class AccessControl
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String condition;
        private PermissionInfoInterface.PermissionType permissionType = null;
        private String identityName;
        private String[] permissions;
        private boolean containsAll = false;

        public AccessControl(PermissionInfoInterface.PermissionType permType, String definition) throws ParseException {
            this.permissionType = permType;
            Pattern pattern = Pattern.compile("(.*):(\\w+( \\w+)?(,\\w+( \\w+)?)*)");
            Matcher matcher = pattern.matcher(definition);
            if (!matcher.matches()) {
                throw new ParseException(Message.format((ResourceBundle)RB.getResources(), (String)"AccessControl.InvalidDefinition.fmt.log", (Object)definition));
            }
            this.identityName = matcher.group(1);
            this.permissions = matcher.group(2).split(",");
            for (int i = 0; i < this.permissions.length; ++i) {
                if (this.permissions[i].equals("RM")) {
                    this.permissions[i] = "ReadMetadata";
                    continue;
                }
                if (this.permissions[i].equals("WM")) {
                    this.permissions[i] = "WriteMetadata";
                    continue;
                }
                if (this.permissions[i].equals("WMM")) {
                    this.permissions[i] = "WriteMemberMetadata";
                    continue;
                }
                if (this.permissions[i].equals("CM")) {
                    this.permissions[i] = "CheckInMetadata";
                    continue;
                }
                if (this.permissions[i].equals("R")) {
                    this.permissions[i] = "Read";
                    continue;
                }
                if (this.permissions[i].equals("W")) {
                    this.permissions[i] = "Write";
                    continue;
                }
                if (this.permissions[i].equals("C")) {
                    this.permissions[i] = "Create";
                    continue;
                }
                if (this.permissions[i].equals("D")) {
                    this.permissions[i] = "Delete";
                    continue;
                }
                if (this.permissions[i].equals("I")) {
                    this.permissions[i] = "Insert";
                    continue;
                }
                if (this.permissions[i].equals("U")) {
                    this.permissions[i] = "Update";
                    continue;
                }
                if (this.permissions[i].equals("S")) {
                    this.permissions[i] = "Select";
                    continue;
                }
                if (this.permissions[i].equals("CT")) {
                    this.permissions[i] = "Create Table";
                    continue;
                }
                if (this.permissions[i].equals("AT")) {
                    this.permissions[i] = "Alter Table";
                    continue;
                }
                if (this.permissions[i].equals("DT")) {
                    this.permissions[i] = "Drop Table";
                    continue;
                }
                if (this.permissions[i].equals("A")) {
                    this.permissions[i] = "Administer";
                    continue;
                }
                if (this.permissions[i].equals("E")) {
                    this.permissions[i] = "Execute";
                    continue;
                }
                if (!this.permissions[i].equalsIgnoreCase("ALL")) continue;
                if (this.permissionType == PermissionInfoInterface.PermissionType.REMOVE) {
                    this.permissions[i] = "ALL";
                    this.containsAll = true;
                    continue;
                }
                throw new IllegalArgumentException(RB.getStringResource("AccessControl.InvalidPermission.fmt.log"));
            }
        }

        public String getCondition() {
            return this.condition;
        }

        public void setCondition(String condition) {
            this.condition = condition;
        }

        public PermissionInfoInterface.PermissionType getType() {
            return this.permissionType;
        }

        public boolean containsAll() {
            return this.containsAll;
        }

        public String getIdentityName() {
            return this.identityName;
        }

        public String[] getPermissions() {
            return this.permissions;
        }

        public String[] substituteAllPermissionsToRemove(AuthorizationBaseInterface authBase, IdentityInterface identity) throws RemoteException, ServiceException {
            return this.getExplicitPermissions(authBase.getAuthorizations(identity, null));
        }

        private String[] getExplicitPermissions(AuthorizationInfoInterface info) throws RemoteException, ServiceException {
            ArrayList<String> explicitPermsList = new ArrayList<String>();
            for (PermissionInfoInterface perm : info.getPermissionInfoList()) {
                if (!perm.getPermissionSource().equals((Object)PermissionInfoInterface.PermissionSource.EXPLICIT)) continue;
                explicitPermsList.add(perm.getPermission());
            }
            String[] explicitPermissions = new String[explicitPermsList.size()];
            return explicitPermsList.toArray(explicitPermissions);
        }
    }
}

