/*
 * Decompiled with CFR 0.152.
 */
package com.sas.batch.localizetable;

import com.sas.batch.localizetable.RB;
import com.sas.batch.localsvc.LocalServicesBatchUtility2;
import com.sas.codepolicy.SASScope;
import com.sas.services.ServiceException;
import com.sas.services.information.metadata.ColumnInterface;
import com.sas.services.information.metadata.DataTableInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.metadata.datalocalization.DataLocalizationModel;
import com.sas.services.information.metadata.datalocalization.InvalidModelOperationException;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

@SASScope
public class LocalizeTable
extends LocalServicesBatchUtility2 {
    public static final int ERROR_TABLE_NOT_FOUND = 9;
    public static final int ERROR_COLUMN_NOT_FOUND = 10;
    public static final int ERROR_DETAIL_TABLE_NOT_FOUND = 11;
    public static final int ERROR_NOT_DETAIL_TABLE = 12;
    public static final String OPTION_KEY = "key";
    public static final String OPTION_LOCALE = "locale";
    public static final String OPTION_LOCALIZE = "localize";
    public static final String OPTION_RESET = "reset";
    public static final String OPTION_ROW_PER_LOCALE = "rowPerLocale";
    public static final String OPTION_TABLE_PER_LOCALE = "tablePerLocale";
    private String tablePath;
    private String keyColumnName;
    private String localeColumnName;
    private Map<String, String> localizedColumns;
    private boolean resetMode;
    private boolean rowPerLocaleMode;
    private boolean tablePerLocaleMode;

    public LocalizeTable() {
        this.utilityName = "sas-localize-table";
    }

    public String getKeyColumnName() {
        return this.keyColumnName;
    }

    public void setKeyColumnName(String keyColumnName) {
        this.keyColumnName = keyColumnName;
    }

    public String getLocaleColumnName() {
        return this.localeColumnName;
    }

    public void setLocaleColumnName(String localeColumnName) {
        this.localeColumnName = localeColumnName;
    }

    public Map<String, String> getLocalizedColumns() {
        return this.localizedColumns;
    }

    public void setLocalizedColumns(Map<String, String> localizedColumns) {
        this.localizedColumns = localizedColumns;
    }

    public boolean isResetMode() {
        return this.resetMode;
    }

    public void setResetMode(boolean resetMode) {
        this.resetMode = resetMode;
    }

    public String getTablePath() {
        return this.tablePath;
    }

    public void setTablePath(String tablePath) {
        this.tablePath = tablePath;
    }

    public boolean isRowPerLocaleMode() {
        return this.rowPerLocaleMode;
    }

    public void setRowPerLocaleMode(boolean rowPerLocaleMode) {
        this.rowPerLocaleMode = rowPerLocaleMode;
    }

    public boolean isTablePerLocaleMode() {
        return this.tablePerLocaleMode;
    }

    public void setTablePerLocaleMode(boolean tablePerLocaleMode) {
        this.tablePerLocaleMode = tablePerLocaleMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int execute() throws Exception {
        if (this.localeColumnName != null && !this.rowPerLocaleMode && this.keyColumnName == null) {
            throw new IllegalArgumentException(RB.getStringResource("LocalizeTable.IllegalLocaleOption.log"));
        }
        try {
            Object localeColumn;
            DataTableInterface table;
            this.initialize();
            DataLocalizationModel model = new DataLocalizationModel();
            PathUrl rootUrl = this.metadataServer.getRootFolder().getPathUrl();
            PathUrl tableUrl = new PathUrl(rootUrl, this.tablePath);
            if (tableUrl.getType() == null) {
                tableUrl.setType("Table");
            }
            if ((table = (DataTableInterface)this.metadataServer.getObjectByPath(tableUrl)) == null) {
                this.returnCode = 9;
                throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"LocalizeTable.TableNotFound.fmt.log", (Object)this.tablePath));
            }
            boolean updated = false;
            if (this.resetMode) {
                if (model.isLocalizationDetailTable(table)) {
                    model.unmarkLocalizationDetailTable(table);
                    updated = true;
                }
                if (model.getModelType(table) != DataLocalizationModel.Type.NONE) {
                    model.setModelType(table, DataLocalizationModel.Type.NONE);
                    updated = true;
                }
            } else if (this.rowPerLocaleMode) {
                if (model.isLocalizationDetailTable(table)) {
                    model.unmarkLocalizationDetailTable(table);
                    updated = true;
                }
                if (model.getModelType(table) != DataLocalizationModel.Type.ROW_PER_LOCALE) {
                    model.setModelType(table, DataLocalizationModel.Type.ROW_PER_LOCALE);
                    updated = true;
                }
                if (this.localeColumnName != null) {
                    localeColumn = this.getTableColumn(table, this.localeColumnName, true);
                    try {
                        ColumnInterface oldColumn = model.getLocaleColumn(table);
                        if (!oldColumn.equals(localeColumn)) {
                            model.markLocaleColumn((ColumnInterface)localeColumn);
                            updated = true;
                        }
                    }
                    catch (InvalidModelOperationException e) {
                        model.markLocaleColumn((ColumnInterface)localeColumn);
                        updated = true;
                    }
                } else if (model.getLocaleColumn(table) == null) {
                    throw new IllegalArgumentException(RB.getStringResource("LocalizeTable.NoLocaleColumn.log"));
                }
            } else if (this.tablePerLocaleMode) {
                if (model.isLocalizationDetailTable(table)) {
                    model.unmarkLocalizationDetailTable(table);
                    updated = true;
                }
                if (model.getModelType(table) != DataLocalizationModel.Type.TABLE_PER_LOCALE) {
                    model.setModelType(table, DataLocalizationModel.Type.TABLE_PER_LOCALE);
                    updated = true;
                }
            } else if (this.localizedColumns != null) {
                if (model.isLocalizationDetailTable(table)) {
                    model.unmarkLocalizationDetailTable(table);
                    updated = true;
                }
                model.setModelType(table, DataLocalizationModel.Type.DETAIL_TABLES);
                for (String columnName : this.localizedColumns.keySet()) {
                    DataTableInterface detailTable;
                    ColumnInterface column = this.getTableColumn(table, columnName, true);
                    PathUrl detailTableUrl = new PathUrl(rootUrl, this.localizedColumns.get(columnName));
                    if (detailTableUrl.getType() == null) {
                        detailTableUrl.setType("Table");
                    }
                    if ((detailTable = (DataTableInterface)this.metadataServer.getObjectByPath(detailTableUrl)) == null) {
                        this.returnCode = 11;
                        throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"LocalizeTable.DetailTableNotFound.fmt.log", (Object)this.localizedColumns.get(columnName)));
                    }
                    if (!model.isLocalizationDetailTable(detailTable)) {
                        this.returnCode = 12;
                        throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"LocalizeTable.NotDetailTable.fmt.log", (Object)this.localizedColumns.get(columnName)));
                    }
                    model.setDetailTable(column, detailTable);
                }
                updated = true;
            } else if (this.keyColumnName != null) {
                if (model.getModelType(table) != DataLocalizationModel.Type.NONE) {
                    model.setModelType(table, DataLocalizationModel.Type.NONE);
                    updated = true;
                }
                ColumnInterface key = this.getTableColumn(table, this.keyColumnName, true);
                ColumnInterface locale = null;
                locale = this.localeColumnName != null ? this.getTableColumn(table, this.localeColumnName, true) : model.getLocaleColumn(table);
                if (locale == null) {
                    throw new IllegalArgumentException(RB.getStringResource("LocalizeTable.NoLocaleColumn.log"));
                }
                if (!(model.isLocalizationDetailTable(table) && key.equals((Object)model.getKeyColumn(table)) && locale.equals((Object)model.getLocalizedColumns(table)))) {
                    model.markLocalizationDetailTable(table, key, locale);
                    updated = true;
                }
            }
            if (updated) {
                table.update();
                System.out.println(Message.format((ResourceBundle)RB.getResources(), (String)"LocalizeTable.TableUpdated.fmt.log", (Object)this.tablePath));
            }
            if (model.isLocalizationDetailTable(table)) {
                System.out.println(Message.format((ResourceBundle)RB.getResources(), (String)"LocalizeTable.DetailTable.fmt.log", (Object)this.tablePath));
                ColumnInterface keyColumn = model.getKeyColumn(table);
                if (keyColumn != null) {
                    System.out.println(Message.format((ResourceBundle)RB.getResources(), (String)"LocalizeTable.KeyColumn.fmt.log", (Object)keyColumn.getName()));
                } else {
                    System.out.println(RB.getStringResource("LocalizeTable.NoKeyColumn.log"));
                    this.returnCode = 4;
                }
                ColumnInterface localeColumn2 = model.getLocaleColumn(table);
                if (localeColumn2 != null) {
                    System.out.println(Message.format((ResourceBundle)RB.getResources(), (String)"LocalizeTable.LocaleColumn.fmt.log", (Object)localeColumn2.getName()));
                    return this.returnCode;
                } else {
                    System.out.println(RB.getStringResource("LocalizeTable.NoLocaleColumn.log"));
                    this.returnCode = 4;
                }
                return this.returnCode;
            }
            switch (model.getModelType(table)) {
                case NONE: {
                    System.out.println(Message.format((ResourceBundle)RB.getResources(), (String)"LocalizeTable.NoLocalization.fmt.log", (Object)this.tablePath));
                    return this.returnCode;
                }
                case ROW_PER_LOCALE: {
                    System.out.println(Message.format((ResourceBundle)RB.getResources(), (String)"LocalizeTable.RPLLocalization.fmt.log", (Object)this.tablePath));
                    localeColumn = model.getLocaleColumn(table);
                    if (localeColumn != null) {
                        System.out.println(Message.format((ResourceBundle)RB.getResources(), (String)"LocalizeTable.LocaleColumn.fmt.log", (Object)localeColumn.getName()));
                        return this.returnCode;
                    } else {
                        System.out.println(RB.getStringResource("LocalizeTable.NoLocaleColumn.log"));
                        this.returnCode = 4;
                        return this.returnCode;
                    }
                }
                case TABLE_PER_LOCALE: {
                    System.out.println(Message.format((ResourceBundle)RB.getResources(), (String)"LocalizeTable.TPRLocalization.fmt.log", (Object)this.tablePath));
                    return this.returnCode;
                }
                case DETAIL_TABLES: {
                    System.out.println(Message.format((ResourceBundle)RB.getResources(), (String)"LocalizeTable.DTLocalization.fmt.log", (Object)this.tablePath));
                    boolean foundDetailTable = false;
                    List columns = table.getColumns();
                    for (ColumnInterface column : columns) {
                        DataTableInterface detailTable = model.getDetailTable(column);
                        if (detailTable == null) continue;
                        System.out.println(Message.format((ResourceBundle)RB.getResources(), (String)"LocalizeTable.ColumnDetailTable.fmt.log", (Object)column.getName(), (Object)detailTable.getPathUrl().getDisplayPath()));
                        foundDetailTable = true;
                    }
                    if (foundDetailTable) return this.returnCode;
                    System.out.println(RB.getStringResource("LocalizeTable.NoDetailTables.log"));
                    return this.returnCode;
                }
                default: {
                    System.out.println(Message.format((ResourceBundle)RB.getResources(), (String)"LocalizeTable.UnrecognizedLocalization.fmt.log", (Object)this.tablePath));
                    return this.returnCode;
                }
            }
        }
        finally {
            this.terminate();
        }
    }

    private ColumnInterface getTableColumn(DataTableInterface table, String columnName, boolean throwException) throws ServiceException, RemoteException {
        List columns = table.getColumns();
        for (ColumnInterface column : columns) {
            if (!columnName.equalsIgnoreCase(column.getName())) continue;
            return column;
        }
        if (throwException) {
            this.returnCode = 10;
            throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"LocalizeTable.ColumnNotFound.fmt.log", (Object)columnName));
        }
        return null;
    }

    protected Options getCommandLineOptions(boolean forHelpText) {
        Options commandLineOptions = super.getCommandLineOptions(forHelpText);
        OptionGroup mutuallyExclusiveOptions = new OptionGroup();
        Option option = new Option(OPTION_KEY, true, RB.getStringResource("LocalizeTable.Key.Desc.txt"));
        option.setArgName(RB.getStringResource("LocalizeTable.Key.ArgName.txt"));
        mutuallyExclusiveOptions.addOption(option);
        mutuallyExclusiveOptions.addOption(Option.builder((String)OPTION_LOCALIZE).desc(RB.getStringResource("LocalizeTable.Localize.Desc.txt")).argName(RB.getStringResource("LocalizeTable.Localize.ArgName.txt")).numberOfArgs(2).valueSeparator('=').build());
        option = new Option(OPTION_RESET, RB.getStringResource("LocalizeTable.Reset.Desc.txt"));
        mutuallyExclusiveOptions.addOption(option);
        option = new Option(OPTION_ROW_PER_LOCALE, RB.getStringResource("LocalizeTable.RowPerLocale.Desc.txt"));
        mutuallyExclusiveOptions.addOption(option);
        option = new Option(OPTION_TABLE_PER_LOCALE, RB.getStringResource("LocalizeTable.TablePerLocale.Desc.txt"));
        mutuallyExclusiveOptions.addOption(option);
        commandLineOptions.addOptionGroup(mutuallyExclusiveOptions);
        option = new Option(OPTION_LOCALE, true, RB.getStringResource("LocalizeTable.Locale.Desc.txt"));
        option.setArgName(RB.getStringResource("LocalizeTable.Locale.ArgName.txt"));
        commandLineOptions.addOption(option);
        return commandLineOptions;
    }

    protected boolean parse(String[] args) throws ParseException, MissingOptionException {
        if (!super.parse(args)) {
            return false;
        }
        if (this.commandLine.hasOption(OPTION_KEY)) {
            this.setKeyColumnName(this.commandLine.getOptionValue(OPTION_KEY));
        } else {
            this.setKeyColumnName(null);
        }
        if (this.commandLine.hasOption(OPTION_LOCALE)) {
            this.setLocaleColumnName(this.commandLine.getOptionValue(OPTION_LOCALE));
        } else {
            this.setLocaleColumnName(null);
        }
        HashMap<String, String> localized = null;
        for (Option option : this.commandLine.getOptions()) {
            if (!OPTION_LOCALIZE.equals(option.getOpt())) continue;
            if (localized == null) {
                localized = new HashMap<String, String>();
            }
            String[] values = option.getValues();
            localized.put(values[0], values[1]);
        }
        this.setLocalizedColumns(localized);
        this.setResetMode(this.commandLine.hasOption(OPTION_RESET));
        this.setRowPerLocaleMode(this.commandLine.hasOption(OPTION_ROW_PER_LOCALE));
        this.setTablePerLocaleMode(this.commandLine.hasOption(OPTION_TABLE_PER_LOCALE));
        List argList = this.commandLine.getArgList();
        if (argList.size() != 1) {
            this.displayHelp();
            return false;
        }
        this.setTablePath((String)argList.get(0));
        return true;
    }

    public static void main(String[] args) {
        LocalizeTable make = new LocalizeTable();
        make.executeBatch(args);
    }

    protected void displayHelp() {
        this.displayHelp(new String[]{RB.getStringResource("LocalizeTable.HelpUsage1.txt"), RB.getStringResource("LocalizeTable.HelpUsage2.txt"), RB.getStringResource("LocalizeTable.HelpUsage3.txt"), RB.getStringResource("LocalizeTable.HelpUsage4.txt"), RB.getStringResource("LocalizeTable.HelpUsage5.txt"), RB.getStringResource("LocalizeTable.HelpUsage6.txt")});
    }
}

