/*
 * Decompiled with CFR 0.152.
 */
package com.sas.batch.appmeta;

import com.sas.batch.appmeta.AppMetaException;
import com.sas.batch.appmeta.ApplicationMetadataUtility;
import com.sas.batch.appmeta.RB;
import com.sas.batch.appmeta.TypeDefinition;
import com.sas.metadata.remote.MdException;
import com.sas.services.ServiceException;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.information.OMIServer;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.storage.editableproperties.LocalizableProperties;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.storage.editableproperties.UnexpectedLocalizationException;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TypeGroup
implements LocalizableProperties {
    private ApplicationMetadataUtility _context = null;
    private String _desc = null;
    private FolderInterface _folder = null;
    private String _name = null;
    private List<TypeGroup> _subGroups = null;
    private List<TypeDefinition> _typeDefs = null;
    private TypeGroup _parent = null;

    private TypeGroup(ApplicationMetadataUtility context, TypeGroup parent) {
        this._context = context;
        this._parent = parent;
        this._subGroups = new ArrayList<TypeGroup>();
        this._typeDefs = new ArrayList<TypeDefinition>();
    }

    static TypeGroup create(Element xml, TypeGroup parent) {
        TypeGroup typeGroup = new TypeGroup(parent.getContext(), parent);
        typeGroup.loadFromXML(xml);
        parent.add(typeGroup);
        return typeGroup;
    }

    static TypeGroup createRootTypeGroup(ApplicationMetadataUtility context) {
        TypeGroup typeGroup = new TypeGroup(context, null);
        return typeGroup;
    }

    void loadFromXML(Element xml) {
        this._desc = xml.getAttribute("Desc");
        this._name = xml.getAttribute("Name");
        NodeList nodes = xml.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            String tagName = element.getTagName();
            if (tagName.equals("TypeGroup")) {
                TypeGroup.create(element, this);
                continue;
            }
            if (!tagName.equals("TypeDefinition")) continue;
            TypeDefinition.create(element, this);
        }
    }

    void add(TypeGroup group) {
        this._subGroups.add(group);
    }

    void add(TypeDefinition typeDef) {
        this._typeDefs.add(typeDef);
    }

    ApplicationMetadataUtility getContext() {
        return this._context;
    }

    String getName() {
        return this._name;
    }

    String getPath() {
        if (this._parent == null) {
            return "/System/Types";
        }
        return this._parent.getPath() + "/" + this._name;
    }

    FolderInterface getFolder() {
        return this._folder;
    }

    List<TypeGroup> getGroups() {
        ArrayList<TypeGroup> list = new ArrayList<TypeGroup>();
        for (TypeGroup group : this._subGroups) {
            list.add(group);
            list.addAll(group.getGroups());
        }
        return list;
    }

    List<TypeDefinition> getDefinitions() {
        ArrayList<TypeDefinition> list = new ArrayList<TypeDefinition>();
        for (TypeGroup group : this._subGroups) {
            list.addAll(group.getDefinitions());
        }
        for (TypeDefinition typeDef : this._typeDefs) {
            list.add(typeDef);
        }
        return list;
    }

    void mergeToMetadata(OMIServer server) throws RemoteException, MdException, AppMetaException {
        try {
            if (this._parent == null) {
                this._folder = this._context.makeFolder((MetadataServerInterface)server, this.getPath());
            } else {
                this._folder = this._parent.getFolder().getSubfolder(this._name);
                if (this._folder == null) {
                    this._folder = this._parent.getFolder().makeSubfolder(this._name);
                    this._context.getLogger().info(Message.format((ResourceBundle)RB.getResources(), (String)"ApplicationMetadataUtility.FolderCreated.fmt.log", (Object)this.getPath()));
                }
            }
        }
        catch (ServiceException e) {
            throw new AppMetaException(Message.format((ResourceBundle)RB.getResources(), (String)"TypeGroup.FolderCreateError.fmt.log", (Object)this.getPath()), e);
        }
        if (this._desc != null && this._desc.length() > 0 && !this._desc.equals(this._folder.getDescription())) {
            this._folder.setDescription(this._desc);
        }
        for (TypeGroup group : this._subGroups) {
            group.mergeToMetadata(server);
        }
        for (TypeDefinition typeDef : this._typeDefs) {
            typeDef.mergeToMetadata(server);
        }
    }

    public PropertyList getLocalizableProperties() throws UnexpectedLocalizationException {
        PropertyList list = new PropertyList();
        list.addProperty("Name", this._name);
        list.addProperty("Desc", this._desc);
        return list;
    }

    public void setLocalizableProperties(PropertyMap map) throws UnexpectedLocalizationException {
        if (map.containsProperty("Name")) {
            this._name = map.getProperty("Name");
        }
        if (map.containsProperty("Desc")) {
            this._desc = map.getProperty("Desc");
        }
    }
}

