/*
 * Decompiled with CFR 0.152.
 */
package com.sas.batch.appmeta;

import com.sas.batch.appmeta.AppMetaException;
import com.sas.batch.appmeta.Directive;
import com.sas.batch.appmeta.Directives;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.ServiceComponent;
import com.sas.metadata.remote.Tree;
import java.lang.reflect.UndeclaredThrowableException;
import java.rmi.RemoteException;
import org.w3c.dom.Element;

final class RefDirective
extends Directive {
    private String _actual = null;

    private RefDirective(Directives directives) {
        super(directives);
        this._directives = directives;
    }

    static RefDirective create(Directives directives) {
        RefDirective directive = new RefDirective(directives);
        return directive;
    }

    String getActual() {
        return this._actual;
    }

    void loadFromXML(Element xml) throws AppMetaException {
        this._name = xml.getAttribute("Name");
        super.getCommonAttributes(xml);
        this._actual = xml.getAttribute("Actual");
        if (!("Delete".equals(this._action) || this._actual != null && this._actual.length() != 0)) {
            throw new AppMetaException("Actual must be specified for RefDirective elements.");
        }
    }

    @Override
    void loadFromMetadata(ServiceComponent directive, Element parent) throws MdException {
        this._jomaObject = directive;
        this.getCommonObjectAttributes();
        if (this._directivePropertySet != null) {
            try {
                for (Object item : this._directivePropertySet.getSetProperties()) {
                    Property property = (Property)item;
                    if (!property.getName().equals("Actual")) continue;
                    this._actual = property.getDefaultValue();
                }
            }
            catch (RemoteException e) {
                throw new UndeclaredThrowableException(e);
            }
        }
        Element dir = parent.getOwnerDocument().createElement("RefDirective");
        parent.appendChild(dir);
        this.setCommonObjectAttributes(dir);
        if (this._actual != null) {
            dir.setAttribute("Actual", this._actual);
        }
        this.loadKeywordsFromMetadata(dir);
    }

    @Override
    void mergeToMetadata() throws MdException {
        if (super.mergeToMetadataBase()) {
            return;
        }
        try {
            Tree directivesObject = this._directives.getJomaObject();
            MdObjectStore store = (MdObjectStore)directivesObject.getObjectStore();
            String reposId = directivesObject.getId().substring(0, 8);
            this._typeProperty.setDefaultValue("REF");
            Property property = (Property)store.getFactory().createComplexMetadataObject(store, "Actual", "Property", reposId);
            property.setPropertyName("Actual");
            property.setSQLType(12);
            property.setDefaultValue(this._actual);
            property.setAssociatedPropertySet(this._directivePropertySet);
        }
        catch (RemoteException e) {
            throw new UndeclaredThrowableException(e);
        }
    }
}

