/*
 * Decompiled with CFR 0.152.
 */
package com.sas.batch.appmeta;

import com.sas.batch.appmeta.AppMetaException;
import com.sas.batch.appmeta.Application;
import com.sas.batch.appmeta.Directive;
import com.sas.batch.appmeta.RefDirective;
import com.sas.batch.appmeta.URLDirective;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.ServiceComponent;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.Tree;
import com.sas.storage.editableproperties.LocalizableProperties;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.storage.editableproperties.UnexpectedLocalizationException;
import java.lang.reflect.UndeclaredThrowableException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

final class Directives
implements LocalizableProperties {
    private Application _application = null;
    private List<Directive> _directives = new ArrayList<Directive>();
    private Tree _jomaObject = null;

    private Directives() {
    }

    static Directives create(Application application) {
        Directives directives = new Directives();
        directives._application = application;
        return directives;
    }

    Application getApplication() {
        return this._application;
    }

    Tree getJomaObject() {
        return this._jomaObject;
    }

    void loadFromXML(Element xml) throws AppMetaException {
        NodeList nodes = xml.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Directive directive;
            Node node = nodes.item(i);
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            String tagName = element.getTagName();
            if (tagName.equals("URLDirective")) {
                directive = URLDirective.create(this);
                ((URLDirective)directive).loadFromXML(element);
                this._directives.add(directive);
                continue;
            }
            if (!tagName.equals("RefDirective")) continue;
            directive = RefDirective.create(this);
            ((RefDirective)directive).loadFromXML(element);
            this._directives.add(directive);
        }
    }

    void loadFromMetadata(Tree tree, Element parent) throws MdException {
        this._jomaObject = tree;
        Element dirs = parent.getOwnerDocument().createElement("Directives");
        parent.appendChild(dirs);
        try {
            block2: for (Object item : tree.getMembers()) {
                ServiceComponent sc;
                if (!(item instanceof ServiceComponent) || !(sc = (ServiceComponent)item).getClassIdentifier().equals("com.sas.framework.directives.client.Directive")) continue;
                for (Object rawprop : sc.getProperties()) {
                    Directive directive;
                    Property property = (Property)rawprop;
                    if (!property.getName().equals("Type")) continue;
                    if (property.getDefaultValue().equalsIgnoreCase("URL")) {
                        directive = URLDirective.create(this);
                    } else {
                        if (!property.getDefaultValue().equalsIgnoreCase("REF")) continue block2;
                        directive = RefDirective.create(this);
                    }
                    ((Directive)directive).loadFromMetadata(sc, dirs);
                    this._directives.add(directive);
                    continue block2;
                }
            }
        }
        catch (RemoteException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    void mergeToMetadata() throws MdException {
        String _desc = null;
        try {
            if (this._application.getName() != null) {
                _desc = "Directive definitions for " + this._application.getName();
            }
            AssociationList trees = ((SoftwareComponent)this._application.getJomaObject()).getSoftwareTrees();
            for (Tree tree : trees) {
                if (!tree.getName().equals("Directives")) continue;
                this._jomaObject = tree;
                if (_desc == null || this._jomaObject.getDesc().equals(_desc)) break;
                this._jomaObject.setDesc(_desc);
                break;
            }
            if (this._jomaObject == null) {
                MdObjectStore store = (MdObjectStore)this._application.getJomaObject().getObjectStore();
                this._jomaObject = (Tree)store.getFactory().createComplexMetadataObject(store, "Directives", "Tree", this._application.getJomaObject().getId().substring(0, 8));
                if (_desc != null) {
                    this._jomaObject.setDesc(_desc);
                }
                this._jomaObject.getSoftwareComponents().add((Object)this._application.getJomaObject());
            }
            if (this._jomaObject.isNewObject()) {
                this._jomaObject.setTreeType("Directives");
            }
        }
        catch (RemoteException e) {
            throw new UndeclaredThrowableException(e);
        }
        for (Directive directive : this._directives) {
            directive.mergeToMetadata();
        }
    }

    public PropertyList getLocalizableProperties() throws UnexpectedLocalizationException {
        PropertyList list = new PropertyList();
        for (Directive directive : this._directives) {
            list.addProperty(directive.getName(), directive.getLocalizableProperties());
        }
        return list;
    }

    public void setLocalizableProperties(PropertyMap map) throws UnexpectedLocalizationException {
        for (Directive directive : this._directives) {
            String propertyName = directive.getName();
            if (!map.containsNestedProperty(propertyName)) continue;
            directive.setLocalizableProperties(map.getNestedProperties(propertyName));
        }
    }
}

