/*
 * Decompiled with CFR 0.152.
 */
package com.sas.batch.appmeta;

import com.sas.batch.appmeta.AppMetaException;
import com.sas.batch.appmeta.ApplicationMetadataUtility;
import com.sas.batch.appmeta.ConfigurableObject;
import com.sas.batch.appmeta.ConfigurationPrompts;
import com.sas.batch.appmeta.ConfigurationProperty;
import com.sas.batch.appmeta.MetadataBase;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.PromptGroup;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertySet;
import com.sas.storage.editableproperties.MultiLocaleProperties;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.storage.editableproperties.UnexpectedLocalizationException;
import java.lang.reflect.UndeclaredThrowableException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

final class Configuration
extends MetadataBase
implements MultiLocaleProperties {
    private ConfigurableObject _parent = null;
    private List<ConfigurationProperty> _properties = new ArrayList<ConfigurationProperty>();
    private ConfigurationPrompts _prompts = null;
    private ConfigurationPrompts _preferences = null;
    private final String PROPERTIES_KEY = "Properties";
    private final String PROMPTS_KEY = "Prompts";
    private final String PREFERENCES_KEY = "Preferences";

    private Configuration(ApplicationMetadataUtility context) {
        super(context);
    }

    static Configuration create(ConfigurableObject parent) {
        Configuration properties = new Configuration(parent.getContext());
        properties._parent = parent;
        properties._name = "Application Configuration";
        return properties;
    }

    ConfigurableObject getParent() {
        return this._parent;
    }

    void loadFromXML(Element xml) throws AppMetaException {
        this._desc = xml.getAttribute("Desc");
        NodeList nodes = xml.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            String tagName = element.getTagName();
            if (tagName.equals("Property")) {
                ConfigurationProperty property = ConfigurationProperty.create(this);
                property.loadFromXML(element);
                this._properties.add(property);
                continue;
            }
            if (tagName.equals("PromptGroup") || tagName.equals("Prompts")) {
                this._prompts = ConfigurationPrompts.create(this);
                this._prompts.loadFromXML(element);
                continue;
            }
            if (!tagName.equals("Preferences")) continue;
            this._preferences = ConfigurationPrompts.create(this);
            this._preferences.loadFromXML(element);
        }
    }

    void loadFromMetadata(PropertySet set, Element parent) throws MdException {
        this._jomaObject = set;
        Element cfg = parent.getOwnerDocument().createElement("Configuration");
        parent.appendChild(cfg);
        try {
            AssociationList properties = set.getSetProperties();
            for (Object item : properties) {
                Property prop = (Property)item;
                ConfigurationProperty property = ConfigurationProperty.create(this);
                property.loadFromMetadata(prop, cfg);
                this._properties.add(property);
            }
            AssociationList prompts = this._parent.getJomaObject().getPrompts();
            for (Object item : prompts) {
                if (!(item instanceof PromptGroup)) continue;
                PromptGroup promptDef = (PromptGroup)item;
                if (promptDef.getName().equals("Application Configuration")) {
                    this._prompts = ConfigurationPrompts.create(this);
                    this._prompts.loadFromMetadata(promptDef, cfg);
                    continue;
                }
                if (!promptDef.getName().equals("Application Preferences")) continue;
                this._preferences = ConfigurationPrompts.create(this);
                this._preferences.loadFromMetadata(promptDef, cfg);
            }
        }
        catch (RemoteException e) {
            throw new UndeclaredThrowableException(e);
        }
        if (cfg.getFirstChild() == null) {
            parent.removeChild(cfg);
        }
    }

    void mergeToMetadata() throws MdException {
        PropertySet set = null;
        try {
            AssociationList sets = this._parent.getJomaObject().getPropertySets();
            for (Object item : sets) {
                set = (PropertySet)item;
                if (set.getName().equals("Application Configuration")) {
                    this._jomaObject = set;
                    break;
                }
                set = null;
            }
            if (this._jomaObject == null) {
                MdObjectStore store = (MdObjectStore)this._parent.getJomaObject().getObjectStore();
                set = (PropertySet)store.getFactory().createComplexMetadataObject(store, this._name, "PropertySet", this._parent.getJomaObject().getId().substring(0, 8));
                set.setPropertySetName(this._name);
                set.setDesc(this._desc);
                set.setOwningObject(this._parent.getJomaObject());
                this._jomaObject = set;
            }
        }
        catch (RemoteException e) {
            throw new UndeclaredThrowableException(e);
        }
        for (ConfigurationProperty property : this._properties) {
            property.mergeToMetadata();
        }
        if (this._prompts != null) {
            this._prompts.mergeToMetadata();
        }
        if (this._preferences != null) {
            this._preferences.mergeToMetadata();
        }
    }

    public PropertyList getLocalizableProperties() throws UnexpectedLocalizationException {
        PropertyList list = new PropertyList();
        PropertyList propList = new PropertyList();
        for (ConfigurationProperty property : this._properties) {
            propList.addProperty(property.getName(), property.getLocalizableProperties());
        }
        list.addProperty("Properties", propList);
        if (this._prompts != null) {
            list.addProperty("Prompts", this._prompts.getLocalizableProperties());
        }
        if (this._preferences != null) {
            list.addProperty("Preferences", this._preferences.getLocalizableProperties());
        }
        return list;
    }

    public void setLocalizableProperties(PropertyMap map) throws UnexpectedLocalizationException {
        if (map.containsNestedProperty("Properties")) {
            PropertyMap propMap = map.getNestedProperties("Properties");
            for (ConfigurationProperty property : this._properties) {
                String propertyName = property.getName();
                if (!propMap.containsNestedProperty(propertyName)) continue;
                property.setLocalizableProperties(propMap.getNestedProperties(propertyName));
            }
        }
        if (this._prompts != null && map.containsNestedProperty("Prompts")) {
            this._prompts.setLocalizableProperties(map.getNestedProperties("Prompts"));
        }
        if (this._preferences != null && map.containsNestedProperty("Preferences")) {
            this._preferences.setLocalizableProperties(map.getNestedProperties("Preferences"));
        }
    }

    public void beginLocalization() throws UnexpectedLocalizationException {
        if (this._prompts != null) {
            this._prompts.beginLocalization();
        }
    }

    public void endLocalization() throws UnexpectedLocalizationException {
        if (this._prompts != null) {
            this._prompts.endLocalization();
        }
    }

    public Collection<Locale> getLocales() throws UnexpectedLocalizationException {
        if (this._prompts != null) {
            return this._prompts.getLocales();
        }
        return null;
    }

    public PropertyList getLocalizableProperties(Locale locale) throws UnexpectedLocalizationException {
        PropertyList list = new PropertyList();
        if (this._prompts != null) {
            list.addProperty("Prompts", this._prompts.getLocalizableProperties(locale));
        }
        if (this._preferences != null) {
            list.addProperty("Preferences", this._preferences.getLocalizableProperties(locale));
        }
        return list;
    }

    public void setLocalizableProperties(Locale locale, PropertyMap map) throws UnexpectedLocalizationException {
        if (this._prompts != null && map.containsNestedProperty("Prompts")) {
            this._prompts.setLocalizableProperties(locale, map.getNestedProperties("Prompts"));
        }
        if (this._preferences != null && map.containsNestedProperty("Preferences")) {
            this._preferences.setLocalizableProperties(locale, map.getNestedProperties("Preferences"));
        }
    }
}

