/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals.customizers.tsmanager;

import com.sas.meta.SASOMI.IOMI;
import com.sas.meta.SASOMI.ISecurityAdmin;
import com.sas.meta.SASOMI.ISecurityAdminHelper;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.DataSourceName;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.Directory;
import com.sas.metadata.remote.Group;
import com.sas.metadata.remote.Identity;
import com.sas.metadata.remote.IdentityGroup;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.Login;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASClientConnection;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.ServiceComponent;
import com.sas.metadata.remote.ServiceType;
import com.sas.metadata.remote.TSNamespace;
import com.sas.metadata.remote.Tree;
import com.sas.swing.visuals.dualselector.DualListSelector;
import com.sas.swing.visuals.util.Util;
import com.sas.visuals.util.XMLUtility;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsDescriptionWizardTab;
import com.sas.workspace.mgmt.MnemonicModel;
import com.sas.workspace.mgmt.visuals.Server;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.rmi.RemoteException;
import java.text.CollationKey;
import java.text.Collator;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import org.omg.CORBA.Object;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class TSServiceTypeTab
extends WsDescriptionWizardTab {
    protected ServerComponent m_tserver;
    protected SASClientConnection m_SASClientConn;
    protected WAWizardDialog m_parent;
    protected Directory m_dirObject;
    protected Tree m_dTree;
    protected IdentityGroup m_stashAdminIdentity;
    protected Group m_serviceGroup;
    protected Tree m_tsTree;
    protected boolean m_isAuthorized;
    protected MdObjectStore m_store;
    protected ServiceType m_serviceType;
    protected ServiceType m_lserviceType;
    protected IdentityGroup m_sasuserId;
    protected IdentityGroup m_publicId;
    private JLabel m_typeLabel;
    protected List m_changeList;
    protected Group m_group;
    protected Tree m_locUsersTree;
    protected ButtonGroup m_butTypeGroup;
    protected JRadioButton m_tserverButton;
    protected JRadioButton m_serviceButton;
    protected LogicalServer m_lserver;
    protected WAPanel m_aPanel;
    protected WAPanel m_dPanel;
    private DualListSelector m_dualList;
    private JScrollPane m_listScroller;
    private IdentityGroup m_identityInitial;
    private JList m_idJList;
    private List m_availableList;
    private List m_selectedList;
    private boolean m_isUpdate;
    protected JLabel m_dirLabel;
    protected JLabel m_listLabel;
    protected JButton m_dBtn;
    protected WATextField m_dirText;
    private static final String CONNTABLESERVICE = "Connection: TableService - ";
    private static final String COMMONTEMPLATE = "com/sas/workspace/mgmt/visuals/res/";
    private static final String TSDRIVERTEMPLATE = "TableServer_Drivers.xml";
    private static final WAdminResource bundle = WAdminResource.getBundle(TSServiceTypeTab.class);
    private static final long serialVersionUID = -830524542507057977L;
    private static final String TSADMIN = "TS Administrators";
    private static final String DBADMIN = "Database Administrators";
    private static final String TSTREE_TREENAME = "Configuration";
    private static final String TSDIR_DIRNAME = "Content Location";
    private static final String TSDIR_ROLE = "CONTENT_LOCATION";
    private static final String CONFIG_TREETYPE = "TS Config";
    private static final String AUTOMETACACHE = "AutoMetaCache";
    private static final String DRIVERCONNECT_TREENAME = "DriverConnect Users";
    private static final String DRIVERS_TREENAME = "Drivers";
    private static final String SSO_TREETYPE = "SSO Tree";
    private static final String SERVICELOCUNAME = "Local Users";
    private static final String LOGICALTABLESERVICE = "Logical Table Service";
    private static final String LOGICALIOMSERVER = "Logical IOM Server";
    private static final String SERVICEUSERS = "Service Users";
    private static final String TSSOURCE_TREENAME = "Configuration";
    private static final String TABLESERVICE = "Table Service";
    private static final String IOMSERVER = "IOM Server";
    private static final String SPD = "SPD";
    private static final String BASE = "BASE";
    private static final String SASSTORE = "SAS STORE";
    private static final String SQLSOURCE_NAMESPACETYPE = "SQL Source";
    public static final String SQLDATA = "SQL Data";
    private static final String ROLE = "ROLE";
    private static final String PUBLICz = "PUBLIC";
    private static final String SASUSERS = "SASUSERS";
    private static final String SASDATABASE = "SAS Database";
    private static final String LOCALHOST = "localhost";
    private static final String NONE = "none";
    private static final String LOCAL = "LOCAL";
    private static final String TKTS = "TKTS";
    private static final String YES = "YES";
    private static final String TSSOURCE_PUBLICTYPE = "TSSourceTree";
    private static final String SQLSOURCE_PUBLICTYPE = "TSNamespace.SQLRoot";
    private static final String USAGEVERSION = "1000000";
    private static final String DSNDBAdminNone = "<None>";

    public TSServiceTypeTab(ServerComponent server) {
        this.m_tserver = server;
        this.m_isUpdate = true;
        try {
            if (this.m_tserver.isNewObject()) {
                this.m_isUpdate = false;
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        this.m_isAuthorized = true;
        this.initialize();
        this.layoutWidgets();
    }

    public void populateStore() {
        String ckCreate = null;
        try {
            WAWizardDialog parent;
            this.m_store = (MdObjectStore)this.m_tserver.getObjectStore();
            AssociationList lServerList = new Vector(1);
            lServerList = this.m_tserver.getUsedByComponents();
            for (int l = 0; l < lServerList.size(); ++l) {
                if (!(lServerList.get(l) instanceof LogicalServer)) continue;
                this.m_lserver = (LogicalServer)lServerList.get(l);
            }
            if (this.m_lserver == null) {
                MessageUtil.displayMessage((String)bundle.getString("TSAdmin.NotAuthorized.Error.txt"), (int)0);
                this.m_isAuthorized = false;
                return;
            }
            AssociationList lSTypeList = new Vector(1);
            lSTypeList = this.m_lserver.getServiceTypes();
            for (int l = 0; l < lSTypeList.size(); ++l) {
                if (!(lSTypeList.get(l) instanceof ServiceType)) continue;
                this.m_lserviceType = (ServiceType)lSTypeList.get(l);
            }
            if (this.m_lserviceType == null) {
                MessageUtil.displayMessage((String)bundle.getString("TService.LogServerST.Missing.txt"), (int)0);
                return;
            }
            String compareName = "";
            int indx = -1;
            indx = this.m_tserver.getName().indexOf(bundle.getString("TableServer.DataService.Suffix.txt"));
            compareName = indx < 0 ? TSServiceTypeTab._getTSNameWithoutSuffix(bundle.getString("TableServer.ServerComponent.Suffix.txt").trim(), this.m_tserver.getName()) : this.m_tserver.getName().substring(0, indx - 1);
            AssociationList connList = new Vector(1);
            connList = this.m_tserver.getSourceConnections(true);
            for (int c = 0; c < connList.size(); ++c) {
                if (!(connList.get(c) instanceof SASClientConnection) || !((SASClientConnection)connList.get(c)).getName().equals(CONNTABLESERVICE + compareName)) continue;
                this.m_SASClientConn = (SASClientConnection)connList.get(c);
                break;
            }
            if (!this.m_isUpdate && (ckCreate = (String)(parent = (WAWizardDialog)this.getTopLevelAncestor()).getWizardData("CREATEOBJECTS")) == null) {
                this._createTSObjects();
            }
            if (this.m_isUpdate || ckCreate != null) {
                AssociationList serviceTypeList = new Vector(1);
                serviceTypeList = this.m_tserver.getServiceTypes();
                if (serviceTypeList.size() <= 0) {
                    MessageUtil.displayMessage((String)bundle.getString("TService.ServiceType.Missing.txt"), (int)0);
                    return;
                }
                this.m_serviceType = (ServiceType)serviceTypeList.get(0);
                AssociationList grpList = new Vector(1);
                grpList = this.m_tserver.getGroups();
                for (int g = 0; g < grpList.size(); ++g) {
                    if (!(grpList.get(g) instanceof Group) || !((Group)grpList.get(g)).getName().equals(TSADMIN)) continue;
                    this.m_group = (Group)grpList.get(g);
                    break;
                }
                if (this.m_group == null) {
                    MessageUtil.displayMessage((String)bundle.getString("TService.AdminGroup.Missing.txt"), (int)0);
                    return;
                }
                AssociationList idList = this.m_group.getMembers();
                for (int m = 0; m < idList.size(); ++m) {
                    if (!(idList.get(m) instanceof IdentityGroup)) continue;
                    this.m_identityInitial = (IdentityGroup)idList.get(m);
                    break;
                }
                AssociationList tsTreeList = new Vector(1);
                tsTreeList = this.m_tserver.getSoftwareTrees();
                for (int t = 0; t < tsTreeList.size(); ++t) {
                    if (((Tree)tsTreeList.get(t)).getTreeType().equals(CONFIG_TREETYPE)) {
                        this.m_tsTree = (Tree)tsTreeList.get(t);
                        continue;
                    }
                    if (!((Tree)tsTreeList.get(t)).getTreeType().equals(SSO_TREETYPE)) continue;
                    this.m_locUsersTree = (Tree)tsTreeList.get(t);
                }
                if (this.m_tsTree == null) {
                    MessageUtil.displayMessage((String)bundle.getString("TSAdmin.NotAuthorized.Error.txt"), (int)0);
                    this.m_isAuthorized = false;
                    return;
                }
                if (this.m_locUsersTree == null) {
                    MessageUtil.displayMessage((String)bundle.getString("TService.LocalUsersGroup.Missing.txt"), (int)0);
                    this.m_isAuthorized = false;
                    return;
                }
                AssociationList dirList = new Vector(1);
                dirList = this.m_tsTree.getMembers();
                for (int d = 0; d < dirList.size(); ++d) {
                    if (!(dirList.get(d) instanceof Directory) || !((Directory)dirList.get(d)).getName().equals(TSDIR_DIRNAME)) continue;
                    this.m_dirObject = (Directory)dirList.get(d);
                    break;
                }
                if (this.m_dirObject == null) {
                    this.m_dirObject = (Directory)Workspace.getMdFactory().createComplexMetadataObject(this.m_store, null, TSDIR_DIRNAME, "Directory", this.m_tserver.getRepositoryID());
                    this.m_dirObject.setDirectoryRole(TSDIR_ROLE);
                    this.m_dirObject.getTrees().add((java.lang.Object)this.m_tsTree);
                }
                this.m_serviceGroup = this._getServiceUsersGroup();
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Reading");
            return;
        }
        this._populateIdentities();
        if (this.m_availableList.size() == 0) {
            MessageUtil.displayMessage((String)bundle.getString("NoIdentityObjects.txt"), (int)0);
            return;
        }
        if (!this.m_isUpdate && ckCreate == null) {
            WAWizardDialog parent = (WAWizardDialog)this.getTopLevelAncestor();
            parent.replaceWizardData("CREATEOBJECTS", (java.lang.Object)"NO");
        }
        this.setStorePopulated(true);
    }

    public void moveDataToView() {
        if (!this.m_isAuthorized) {
            MessageUtil.displayMessage((String)bundle.getString("TSAdmin.NotAuthorized.Error.txt"), (int)0);
            return;
        }
        try {
            if (this.m_serviceType.getName().equals(IOMSERVER)) {
                this.m_tserverButton.setSelected(true);
                this.m_dualList.setEnabled(false);
            } else {
                this.m_serviceButton.setSelected(true);
                this.m_dualList.setEnabled(true);
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        if (this.m_dirObject != null) {
            try {
                this.m_dirText.setText(this.m_dirObject.getDirectoryName());
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        this._loadList();
        this._loadDualIdentities();
    }

    public void moveDataToStore() {
        if (!this.m_isAuthorized) {
            return;
        }
        try {
            if (this.m_isUpdate) {
                if (!this.m_dirObject.getDirectoryName().equals(this.m_dirText.getText())) {
                    this.m_dirObject.setDirectoryName(this.m_dirText.getText());
                    this.m_dirObject.updateMetadataAll();
                }
                if (!this.m_identityInitial.getName().equals(((IdentityGroup)this.m_idJList.getSelectedValue()).getName())) {
                    this.m_group.getMembers().remove((java.lang.Object)this.m_identityInitial);
                    this.m_group.getMembers().add(this.m_idJList.getSelectedValue());
                    this.m_group.setDesc("From Server Manager");
                    this.m_group.updateMetadataAll();
                    this._updateTSACEObjects(this.m_identityInitial);
                }
            } else {
                this.m_dirObject.setDirectoryName(this.m_dirText.getText());
                if (this.m_identityInitial == null) {
                    this.m_group.getMembers().add(this.m_idJList.getSelectedValue());
                } else if (!this.m_identityInitial.getName().equals(((IdentityGroup)this.m_idJList.getSelectedValue()).getName())) {
                    this.m_group.getMembers().remove((java.lang.Object)this.m_identityInitial);
                    this.m_group.getMembers().add(this.m_idJList.getSelectedValue());
                }
                this.m_identityInitial = (IdentityGroup)this.m_idJList.getSelectedValue();
            }
            if (this.m_serviceButton.isSelected()) {
                this._createSASClientConn();
                this._resolveServiceUsers();
            } else {
                this._removeServiceUsers();
            }
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Writing");
            return;
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public boolean validateData() {
        ListModel targetListModel;
        if (!this.m_isAuthorized) {
            return false;
        }
        if (this.m_availableList.size() == 0) {
            MessageUtil.displayMessage((String)bundle.getString("TSService.Id.Required.txt"), (int)0);
            return false;
        }
        if (this.m_dirText.getText().equals("")) {
            MessageUtil.displayMessage((String)bundle.getString("TSService.DirName.Required.txt"), (int)0);
            return false;
        }
        if (this.m_serviceButton.isSelected() && (targetListModel = this.m_dualList.getTargetModel()).getSize() == 0) {
            MessageUtil.displayMessage((String)bundle.getString("TSService.NoGroup.txt"), (int)0);
            return false;
        }
        return true;
    }

    public String createFinishString() {
        try {
            if (!this.m_isUpdate) {
                String strFinish = Util.getDisplayLabel((String)bundle.getString("TSService.Dir.Label.NoMn.txt")) + "\n\t" + this.m_dirObject.getDirectoryName() + "\n";
                if (this.m_serviceType.getName().equals(IOMSERVER)) {
                    strFinish = strFinish + Util.getDisplayLabel((String)bundle.getString("TSService.serverType.Label.txt")) + "\n\t" + Util.getDisplayLabel((String)bundle.getString("TSServiceTypeTab.button1.txt")) + "\n";
                } else {
                    strFinish = strFinish + Util.getDisplayLabel((String)bundle.getString("TSService.serverType.Label.txt")) + "\n\t" + Util.getDisplayLabel((String)bundle.getString("TSServiceTypeTab.button2.txt")) + "\n";
                    strFinish = strFinish + Util.getDisplayLabel((String)bundle.getString("TSAdmin.TableService.Label.txt")) + "\n\t";
                    String selStr = "";
                    for (int s = 0; s < this.m_selectedList.size(); ++s) {
                        selStr = selStr + ((CMetadata)this.m_selectedList.get(s)).getName() + "\n\t";
                    }
                    strFinish = strFinish + selStr + "\n";
                }
                strFinish = strFinish + Util.getDisplayLabel((String)bundle.getString("TSService.List.Label.NoMn.txt")) + "\n\t" + ((CMetadata)this.m_idJList.getSelectedValue()).getName() + "\n";
                return strFinish;
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return "";
    }

    public void initialize() {
        this.m_dirText = new WATextField(30);
        this.m_dirText.setMaxCharacters(256);
        this.m_dirText.setToolTipText(bundle.getString("TSService.Dir.Label.txt.Tooltip.txt"));
        this.m_dirText.setName("SASDBNewName");
        this.m_dirLabel = new JLabel();
        MnemonicModel.setLabelTextAndMnemonic(this.m_dirLabel, bundle.getString("TSService.Dir.Label.txt"));
        this.m_dirLabel.setLabelFor((Component)this.m_dirText);
        this.m_dBtn = new JButton();
        MnemonicModel.setButtonTextAndMnemonic(this.m_dBtn, bundle.getString("Common.Select.Button.txt"));
        this.m_dBtn.setToolTipText(bundle.getString("Common.Select.Tooltip.Dir.txt"));
        this.m_dBtn.setBorderPainted(true);
        this.m_dBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                JFileChooser fileDialog = new JFileChooser();
                fileDialog.setFileSelectionMode(1);
                int returnVal = fileDialog.showDialog((Component)event.getSource(), bundle.getString("Common.Select.txt"));
                if (returnVal == 0) {
                    File file = fileDialog.getSelectedFile();
                    String strFile = file.toString();
                    TSServiceTypeTab.this.m_dirText.setText(strFile);
                }
            }
        });
        this.m_typeLabel = new JLabel();
        this.m_typeLabel.setText(bundle.getString("TSService.serverType.Label.txt"));
        this.m_tserverButton = new JRadioButton();
        MnemonicModel.setButtonTextAndMnemonic(this.m_tserverButton, bundle.getString("TSServiceTypeTab.button1.txt"));
        this.m_serviceButton = new JRadioButton();
        MnemonicModel.setButtonTextAndMnemonic(this.m_serviceButton, bundle.getString("TSServiceTypeTab.button2.txt"));
        this.m_butTypeGroup = new ButtonGroup();
        this.m_butTypeGroup.add(this.m_tserverButton);
        this.m_butTypeGroup.add(this.m_serviceButton);
        this.m_tserverButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                TSServiceTypeTab.this._onType();
            }
        });
        this.m_serviceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                TSServiceTypeTab.this._onType();
            }
        });
        this.m_dPanel = new WAPanel();
        this.m_dPanel.setBorder((Border)new TitledBorder(bundle.getString("TSAdmin.TableService.Title.txt")));
        this.m_aPanel = new WAPanel();
        this.m_aPanel.setBorder((Border)new TitledBorder(""));
        this.m_dualList = new DualListSelector();
        this.m_dualList.setSourceLabel(MnemonicModel.getLabelWithoutMnemonic(bundle.getString("TSAdmin.TableService.Available.txt")));
        this.m_dualList.setTargetLabel(MnemonicModel.getLabelWithoutMnemonic(bundle.getString("TSAdmin.TableService.Selected.txt")));
        this.m_dualList.setToolTipText(bundle.getString("TSAdmin.TableService.Dual.Tooltip.txt"));
        if (this.m_isUpdate) {
            this.m_dualList.setPreferredSize(new Dimension(240, 235));
        } else {
            this.m_dualList.setPreferredSize(new Dimension(240, 85));
        }
        this.m_idJList = new JList();
        this.m_idJList.setSelectionMode(0);
        this.m_listScroller = new JScrollPane();
        if (this.m_isUpdate) {
            this.m_listScroller.setPreferredSize(new Dimension(210, 240));
        } else {
            this.m_listScroller.setPreferredSize(new Dimension(210, 90));
        }
        this.m_listScroller.setHorizontalScrollBarPolicy(30);
        this.m_listScroller.setVerticalScrollBarPolicy(20);
        this.m_listLabel = new JLabel();
        MnemonicModel.setLabelTextAndMnemonic(this.m_listLabel, bundle.getString("TSService.List.Label.txt"));
        this.m_listLabel.setLabelFor(this.m_idJList);
        this.m_listScroller.getViewport().setView(this.m_idJList);
        this.m_listScroller.setColumnHeaderView(this.m_listLabel);
    }

    public void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        int row = 0;
        this.add(this.m_dirLabel, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 12, 0, 0), 0, 0));
        this.add((Component)this.m_dirText, new GridBagConstraints(1, row, 2, 1, 1.0, 0.0, 18, 2, new Insets(0, 10, 0, 0), 0, 0));
        this.add(this.m_dBtn, new GridBagConstraints(3, row, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 10, 0, 15), 0, 0));
        this.add(this.m_typeLabel, new GridBagConstraints(0, ++row, 1, 1, 1.0, 0.0, 18, 0, new Insets(5, 12, 0, 0), 0, 0));
        this.add(this.m_tserverButton, new GridBagConstraints(1, row, 1, 1, 1.0, 0.0, 18, 0, new Insets(5, 10, 0, 0), 0, 0));
        this.add(this.m_serviceButton, new GridBagConstraints(2, row, 1, 1, 1.0, 0.0, 18, 0, new Insets(5, 0, 0, 15), 0, 0));
        this.add(this.m_listScroller, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.m_aPanel.add((Component)this.m_listScroller);
        this.add((Component)this.m_aPanel, new GridBagConstraints(0, ++row, 2, 3, 0.0, 0.0, 18, 0, new Insets(7, 0, 0, 0), 0, 0));
        this.add((Component)this.m_dualList, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.m_dPanel.add((Component)this.m_dualList);
        this.add((Component)this.m_dPanel, new GridBagConstraints(2, row, 2, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void _onType() {
        try {
            if (this.m_tserverButton.isSelected()) {
                this.m_serviceType.setName(IOMSERVER);
                this.m_lserviceType.setName(LOGICALIOMSERVER);
                DefaultListModel availableModel = new DefaultListModel();
                DefaultListModel selectedModel = new DefaultListModel();
                selectedModel.clear();
                for (int a = 0; a < this.m_availableList.size(); ++a) {
                    if (((Identity)this.m_availableList.get(a)).getName().equals(SASUSERS) || ((Identity)this.m_availableList.get(a)).getName().equals(PUBLICz)) continue;
                    availableModel.addElement(this.m_availableList.get(a));
                }
                this.m_dualList.setModel(availableModel);
                this.m_dualList.setTargetModel(selectedModel);
                this.m_dualList.setEnabled(false);
            } else {
                this.m_serviceType.setName(TABLESERVICE);
                this.m_lserviceType.setName(LOGICALTABLESERVICE);
                this.m_dualList.setEnabled(true);
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void onNext() {
    }

    public void onBack() {
    }

    protected void _loadList() {
        try {
            List dbAdminList = new Vector(1);
            boolean excludeDB = true;
            String strSelect = bundle.getString("TSAdmin.FindDBADMINS1.xml") + "'" + DBADMIN + "']Trees/Tree[@TreeType='" + CONFIG_TREETYPE + "']ParentTree/Tree[@Id='" + this.m_tsTree.getFQID() + "']]\"/>";
            int flags = 392;
            dbAdminList = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)this.m_store, "A0000001." + this.m_tserver.getRepositoryID(), "IdentityGroup", flags, strSelect);
            int selectID = 0;
            int totalInList = 0;
            DefaultListModel idJListModel = new DefaultListModel();
            this.m_idJList.setModel(idJListModel);
            for (int i = 0; i < this.m_availableList.size(); ++i) {
                if (((Identity)this.m_availableList.get(i)).getName().equals(SASUSERS)) {
                    this.m_sasuserId = (IdentityGroup)this.m_availableList.get(i);
                    continue;
                }
                if (((Identity)this.m_availableList.get(i)).getName().equals(PUBLICz)) {
                    this.m_publicId = (IdentityGroup)this.m_availableList.get(i);
                    continue;
                }
                if (!(this.m_availableList.get(i) instanceof IdentityGroup) || ((IdentityGroup)this.m_availableList.get(i)).getGroupType().equals(ROLE)) continue;
                excludeDB = false;
                for (int db = 0; db < dbAdminList.size(); ++db) {
                    if (!((IdentityGroup)this.m_availableList.get(i)).getId().equals(((IdentityGroup)dbAdminList.get(db)).getId())) continue;
                    excludeDB = true;
                    break;
                }
                if (excludeDB) continue;
                idJListModel.addElement(this.m_availableList.get(i));
                if (this.m_identityInitial != null && this.m_identityInitial.getName().equals(((IdentityGroup)this.m_availableList.get(i)).getName())) {
                    selectID = totalInList;
                }
                ++totalInList;
            }
            if (totalInList == 0) {
                MessageUtil.displayMessage((String)bundle.getString("TSAdmin.Missing.Identity.txt"), (int)0);
                return;
            }
            int maxNumRows = 4;
            if (totalInList < maxNumRows) {
                maxNumRows = totalInList;
            }
            this.m_idJList.setVisibleRowCount(maxNumRows);
            this.m_listScroller.getViewport().setView(this.m_idJList);
            this.revalidate();
            this.m_idJList.ensureIndexIsVisible(this.m_idJList.getSelectedIndex());
            if (totalInList > 0) {
                this.m_idJList.setSelectedIndex(selectID);
                this.m_idJList.ensureIndexIsVisible(this.m_idJList.getSelectedIndex());
            }
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Reading");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    public void _assocDrivers() {
        String xmlString = " ";
        try {
            String fileName = "com/sas/workspace/mgmt/visuals/res/TableServer_Drivers.xml";
            URL url = XMLUtility.urlFromFile((String)fileName, (ClassLoader)((java.lang.Object)((java.lang.Object)this)).getClass().getClassLoader());
            Document doc = Workspace.getMdFactory().getOMIUtil().parseXML(url);
            xmlString = Workspace.getMdFactory().getUtil().createStringForNode((Node)doc);
            Workspace.getMdFactory().getOMIUtil().populateStoreFromString(this.m_dTree.getObjectStore(), xmlString, 1, true);
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Reading");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        catch (IOException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        try {
            this.m_changeList = new Vector(1);
            String reposid = this.m_dTree.getRepositoryID();
            String objectid = "";
            this.m_changeList = this.m_dTree.getObjectStore().getChangedObjects();
            for (int changeIndex = 0; changeIndex < this.m_changeList.size(); ++changeIndex) {
                Root changeRoot = (Root)this.m_changeList.get(changeIndex);
                if (!changeRoot.getCMetadataType().equals("ConfiguredComponent")) continue;
                objectid = changeRoot.getId();
                objectid = objectid.substring(objectid.indexOf(".") + 1);
                objectid = reposid + "." + objectid;
                changeRoot.setFQID(objectid);
                changeRoot.getTrees().add((java.lang.Object)this.m_dTree);
            }
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    public boolean _createTSObjects() {
        try {
            this.m_group = (Group)Workspace.getMdFactory().createComplexMetadataObject(this.m_store, null, TSADMIN, "Group", this.m_tserver.getRepositoryID());
            this.m_tserver.getGroups().add((java.lang.Object)this.m_group);
            this.m_serviceType = (ServiceType)Workspace.getMdFactory().createComplexMetadataObject(this.m_store, null, IOMSERVER, "ServiceType", this.m_tserver.getRepositoryID());
            this.m_tserver.getServiceTypes().add((java.lang.Object)this.m_serviceType);
            this.m_tserverButton.setSelected(true);
            this.m_tsTree = (Tree)Workspace.getMdFactory().createComplexMetadataObject(this.m_store, null, "Configuration", "Tree", this.m_tserver.getRepositoryID());
            this.m_tsTree.setTreeType(CONFIG_TREETYPE);
            this.m_dirObject = (Directory)Workspace.getMdFactory().createComplexMetadataObject(this.m_store, null, TSDIR_DIRNAME, "Directory", this.m_tserver.getRepositoryID());
            this.m_dirObject.setDirectoryName(this.m_dirText.getText());
            this.m_dirObject.setIsRelative(1);
            this.m_dirObject.setDirectoryRole(TSDIR_ROLE);
            this.m_tsTree.getMembers().add((java.lang.Object)this.m_dirObject);
            Tree dConnTree = (Tree)Workspace.getMdFactory().createComplexMetadataObject(this.m_store, null, DRIVERCONNECT_TREENAME, "Tree", this.m_tserver.getRepositoryID());
            dConnTree.setTreeType(CONFIG_TREETYPE);
            this.m_tsTree.getSubTrees().add((java.lang.Object)dConnTree);
            this.m_dTree = (Tree)Workspace.getMdFactory().createComplexMetadataObject(this.m_store, null, DRIVERS_TREENAME, "Tree", this.m_tserver.getRepositoryID());
            this.m_dTree.setTreeType(CONFIG_TREETYPE);
            this._assocDrivers();
            this.m_tsTree.getSubTrees().add((java.lang.Object)this.m_dTree);
            Tree newTree = (Tree)Workspace.getMdFactory().createComplexMetadataObject(this.m_store, null, SERVICELOCUNAME, "Tree", this.m_tserver.getRepositoryID());
            newTree.setTreeType(SSO_TREETYPE);
            this.m_serviceGroup = (Group)Workspace.getMdFactory().createComplexMetadataObject(this.m_store, null, SERVICEUSERS, "Group", this.m_tserver.getRepositoryID());
            newTree.getMembers().add((java.lang.Object)this.m_serviceGroup);
            this.m_tserver.getSoftwareTrees().add((java.lang.Object)newTree);
            Property metaCacheProp = (Property)Workspace.getMdFactory().createComplexMetadataObject(this.m_store, null, AUTOMETACACHE, "Property", this.m_tserver.getRepositoryID());
            metaCacheProp.setDefaultValue(YES);
            this.m_tserver.getProperties().add((java.lang.Object)metaCacheProp);
            this._createBaseSPD(BASE);
            this._createBaseSPD(SPD);
            this.m_tserver.getSoftwareTrees().add((java.lang.Object)this.m_tsTree);
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Reading");
            return false;
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        return true;
    }

    public void _createBaseSPD(String nodeName) {
        try {
            ServiceComponent sasDBServer = (ServiceComponent)Workspace.getMdFactory().createComplexMetadataObject(this.m_store, null, nodeName, "ServiceComponent", this.m_tserver.getRepositoryID());
            sasDBServer.setDesc("SAS Database " + nodeName);
            if (nodeName.equals(BASE)) {
                sasDBServer.setClassIdentifier(BASE);
            } else {
                sasDBServer.setClassIdentifier(SPD);
            }
            sasDBServer.getUsedByComponents().add((java.lang.Object)this.m_tserver);
            ServiceType myService = (ServiceType)Workspace.getMdFactory().createComplexMetadataObject(this.m_store, null, SASSTORE, "ServiceType", this.m_tserver.getRepositoryID());
            sasDBServer.getServiceTypes().add((java.lang.Object)myService);
            Tree config = null;
            Group group = null;
            TSNamespace sqlSource = null;
            config = (Tree)Workspace.getMdFactory().createComplexMetadataObject(this.m_store, null, "Configuration", "Tree", this.m_tserver.getRepositoryID(), null);
            config.setTreeType(CONFIG_TREETYPE);
            config.setPublicType(TSSOURCE_PUBLICTYPE);
            config.setUsageVersion(USAGEVERSION);
            group = (Group)Workspace.getMdFactory().createComplexMetadataObject(this.m_store, null, DBADMIN, "Group", this.m_tserver.getRepositoryID());
            sqlSource = (TSNamespace)Workspace.getMdFactory().createComplexMetadataObject(this.m_store, null, SQLDATA, "TSNamespace", this.m_tserver.getRepositoryID());
            sqlSource.setNamespaceType(SQLSOURCE_NAMESPACETYPE);
            sqlSource.setNamespaceName(SQLSOURCE_NAMESPACETYPE);
            sqlSource.setPublicType(SQLSOURCE_PUBLICTYPE);
            sqlSource.setUsageVersion(USAGEVERSION);
            config.getMembers().add((java.lang.Object)group);
            config.getMembers().add((java.lang.Object)sasDBServer);
            config.getMembers().add((java.lang.Object)sqlSource);
            this.m_tsTree.getSubTrees().add((java.lang.Object)config);
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Reading");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    public static List sortAccending(List contentList) {
        CollationKey[] keys = TSServiceTypeTab.convertToCollatorKeys(contentList);
        if (keys == null) {
            return null;
        }
        for (int i = 0; i < keys.length; ++i) {
            for (int j = i + 1; j < keys.length; ++j) {
                if (keys[i].compareTo(keys[j]) <= 0) continue;
                CollationKey temp = keys[i];
                keys[i] = keys[j];
                keys[j] = temp;
            }
        }
        return TSServiceTypeTab.getSortedList(contentList, keys);
    }

    protected static List getSortedList(List contentList, CollationKey[] keys) {
        Vector<CMetadata> sortedList = new Vector<CMetadata>(1);
        for (int i = 0; i < keys.length; ++i) {
            String name = keys[i].getSourceString();
            try {
                CMetadata contentItem = null;
                for (int j = 0; j < contentList.size(); ++j) {
                    CMetadata currentItem = (CMetadata)contentList.get(j);
                    if (currentItem instanceof Login) {
                        if (!((Login)currentItem).getUserID().equalsIgnoreCase(name)) continue;
                        contentItem = currentItem;
                        break;
                    }
                    if (!currentItem.getName().equalsIgnoreCase(name)) continue;
                    contentItem = currentItem;
                    break;
                }
                if (contentItem == null) continue;
                sortedList.add(i, contentItem);
                continue;
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        return sortedList;
    }

    protected static CollationKey[] convertToCollatorKeys(List contentList) {
        Collator collator = Collator.getInstance(Locale.getDefault());
        collator.setStrength(2);
        CollationKey[] keys = new CollationKey[contentList.size()];
        boolean itemNotRecognized = false;
        try {
            for (int i = 0; i < contentList.size(); ++i) {
                java.lang.Object contentItem = contentList.get(i);
                keys[i] = contentItem instanceof Login ? collator.getCollationKey(((Login)contentItem).getUserID()) : collator.getCollationKey(((CMetadata)contentItem).getName());
            }
            if (itemNotRecognized) {
                return null;
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return keys;
    }

    private void _DSNTSACE(IdentityGroup oldIdentity, IdentityGroup newIdentity) {
        List dsnList = new Vector(1);
        try {
            String strSelect = bundle.getString("DSNAllDSNsFor.ServerComponent.xml").trim() + "'" + this.m_tserver.getFQID() + "']]\"/>";
            int flags = 392;
            dsnList = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)this.m_store, "A0000001." + this.m_tserver.getRepositoryID(), "DataSourceName", flags, strSelect);
            if (dsnList.size() == 0) {
                return;
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Reading");
        }
        String userid = "";
        String oUserid = "";
        try {
            if (newIdentity != null) {
                userid = newIdentity.getName();
            }
            if (oldIdentity != null) {
                oUserid = oldIdentity.getName();
            }
        }
        catch (RemoteException e1) {
            e1.printStackTrace();
        }
        try {
            for (int d = 0; d < dsnList.size(); ++d) {
                if (newIdentity != null) {
                    TSServiceTypeTab.addACEDSNTSAdmin(((DataSourceName)dsnList.get(d)).getFQID(), userid);
                }
                if (oldIdentity == null) continue;
                TSServiceTypeTab.removeACEDSNTSAdmin(((DataSourceName)dsnList.get(d)).getFQID(), oUserid);
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    private void _resolveServiceUsers() {
        try {
            boolean modified = false;
            ListModel targetListModel = this.m_dualList.getTargetModel();
            Vector postselectedList = new Vector(1);
            for (int tIndex = 0; tIndex < targetListModel.getSize(); ++tIndex) {
                postselectedList.add(targetListModel.getElementAt(tIndex));
            }
            if (this.m_isUpdate) {
                for (int subtract = this.m_selectedList.size() - 1; subtract > -1; --subtract) {
                    if (postselectedList.contains(this.m_selectedList.get(subtract))) continue;
                    this.m_serviceGroup.getMembers().remove(this.m_selectedList.get(subtract));
                    modified = true;
                }
            } else {
                for (int r = 0; r < this.m_selectedList.size(); ++r) {
                    this.m_serviceGroup.getMembers().remove((java.lang.Object)((Identity)this.m_selectedList.get(r)));
                }
            }
            for (int i = 0; i < postselectedList.size(); ++i) {
                if (this.m_selectedList.contains(postselectedList.get(i))) continue;
                this.m_serviceGroup.getMembers().add(postselectedList.get(i));
                modified = true;
            }
            if (this.m_isUpdate && modified) {
                this.m_serviceGroup.updateMetadataAll();
            }
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Writing");
            return;
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    private boolean _updateTSACEObjects(IdentityGroup oldIdentity) {
        int t;
        AssociationList tsSourceList = new Vector(1);
        String tsfqid = "";
        String tsAdminName = "";
        String oldtsAdminName = "";
        String tssfqid = "";
        String lfqid = "";
        try {
            oldtsAdminName = oldIdentity.getName();
            tsAdminName = ((IdentityGroup)this.m_idJList.getSelectedValue()).getName();
            lfqid = this.m_lserver.getFQID();
            TSServiceTypeTab.addACELServerTSAdmin(lfqid, tsAdminName);
            tsfqid = this.m_tsTree.getFQID();
            TSServiceTypeTab.addACETSTreeTSAdmin(tsfqid, tsAdminName);
            tsSourceList = this.m_tsTree.getSubTrees(true);
            for (t = 0; t < tsSourceList.size(); ++t) {
                if (!((Tree)tsSourceList.get(t)).getPublicType().equals(TSSOURCE_PUBLICTYPE)) continue;
                tssfqid = ((Tree)tsSourceList.get(t)).getFQID();
                TSServiceTypeTab.addACETSSourceTSAdmin(tssfqid, tsAdminName);
            }
            this._DSNTSACE(oldIdentity, (IdentityGroup)this.m_idJList.getSelectedValue());
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Writing");
        }
        if (oldIdentity != null) {
            try {
                for (t = 0; t < tsSourceList.size(); ++t) {
                    if (((Tree)tsSourceList.get(t)).getName().equals(DRIVERCONNECT_TREENAME) || ((Tree)tsSourceList.get(t)).getName().equals(DRIVERS_TREENAME)) continue;
                    tssfqid = ((Tree)tsSourceList.get(t)).getFQID();
                    TSServiceTypeTab.removeACETSSourceTSAdmin(tssfqid, oldtsAdminName);
                }
                TSServiceTypeTab.removeACETSTreeTSAdmin(tsfqid, oldtsAdminName);
                TSServiceTypeTab.removeACELServerTSAdmin(lfqid, oldtsAdminName);
            }
            catch (RemoteException e2) {
                e2.printStackTrace();
            }
        }
        return true;
    }

    private void _loadDualIdentities() {
        int selectidx = 0;
        String ckCreate = null;
        DefaultListModel availableModel = new DefaultListModel();
        DefaultListModel selectedModel = new DefaultListModel();
        try {
            WAWizardDialog parent;
            if (!this.m_isUpdate && (ckCreate = (String)(parent = (WAWizardDialog)this.getTopLevelAncestor()).getWizardData("CREATEOBJECTS")) != null) {
                this.m_selectedList = this.m_serviceGroup.getMembers();
            }
            for (int s = 0; s < this.m_selectedList.size(); ++s) {
                selectedModel.add(selectidx, this.m_selectedList.get(s));
                ++selectidx;
            }
            boolean skip = false;
            for (int a = 0; a < this.m_availableList.size(); ++a) {
                skip = false;
                for (int e = 0; e < this.m_selectedList.size(); ++e) {
                    if (!((Identity)this.m_availableList.get(a)).getName().equals(((Identity)this.m_selectedList.get(e)).getName())) continue;
                    skip = true;
                    break;
                }
                if (skip || ((Identity)this.m_availableList.get(a)).getName().equals(SASUSERS) || ((Identity)this.m_availableList.get(a)).getName().equals(PUBLICz)) continue;
                availableModel.addElement(this.m_availableList.get(a));
            }
            this.m_dualList.setModel(availableModel);
            this.m_dualList.setTargetModel(selectedModel);
            if (availableModel.size() == 0) {
                MessageUtil.displayMessage((String)bundle.getString("Common.NoIdentityObjects.txt"), (int)0);
                return;
            }
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Reading");
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    private void _removeServiceUsers() {
        if (this.m_serviceGroup == null) {
            return;
        }
        try {
            for (int r = 0; r < this.m_selectedList.size(); ++r) {
                this.m_serviceGroup.getMembers().remove((java.lang.Object)((Identity)this.m_selectedList.get(r)));
            }
            if (this.m_isUpdate) {
                this.m_serviceGroup.updateMetadataAll();
            }
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Reading");
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    private Group _getServiceUsersGroup() {
        java.lang.Object grpList = new Vector(1);
        Group serviceGroup = null;
        try {
            if (this.m_isUpdate) {
                String strSelect = bundle.getString("TService.ServiceUserGroup.Select.xml") + "'" + this.m_tserver.getFQID() + "']]\"/>";
                int flags = 400;
                grpList = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset(this.m_tserver.getObjectStore(), "A0000001." + this.m_tserver.getRepositoryID(), "Group", flags, strSelect);
                if (grpList.size() > 0) {
                    serviceGroup = (Group)grpList.get(0);
                } else {
                    MessageUtil.displayMessage((String)bundle.getString("TService.LocalUsersGroup.Missing.txt"), (int)0);
                }
            } else {
                grpList = this.m_locUsersTree.getMembers();
                if (grpList.size() > 0) {
                    serviceGroup = (Group)grpList.get(0);
                }
            }
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Reading");
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return serviceGroup;
    }

    private void _populateIdentities() {
        AssociationList memList = new Vector(1);
        this.m_availableList = new Vector(1);
        this.m_selectedList = new Vector(1);
        try {
            String strSelect = bundle.getString("Identity.ExcludeRole.xml");
            int flags = 400;
            this.m_availableList = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)this.m_store, "A0000001." + this.m_tserver.getRepositoryID(), "Identity", flags, strSelect);
            List sortedList = null;
            if (this.m_availableList.size() > 0 && (sortedList = TSServiceTypeTab.sortAccending(this.m_availableList)) != null) {
                this.m_availableList = sortedList;
            }
            if ((memList = this.m_serviceGroup.getMembers()).size() > 0) {
                for (int g = 0; g < memList.size(); ++g) {
                    if (!(memList.get(g) instanceof Identity)) continue;
                    this.m_selectedList.add(memList.get(g));
                }
            }
            List sortedList2 = new Vector(1);
            if (this.m_selectedList.size() > 0 && (sortedList2 = TSServiceTypeTab.sortAccending(this.m_selectedList)) != null) {
                this.m_selectedList = sortedList2;
            }
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Reading");
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addACEDSNTSAdmin(String dsnFQID, String tsAdminId) {
        String userid = tsAdminId;
        if (userid == null || userid == "") {
            return;
        }
        String[][] dsnAuth = new String[][]{{"IdentityGroup", userid, "G", "ReadMetadata", ""}, {"IdentityGroup", userid, "G", "WriteMetadata", ""}};
        ISecurityAdmin isa = null;
        try {
            IOMI omiHandle = Workspace.getWorkspace().getCMRHandle();
            isa = ISecurityAdminHelper.narrow((Object)Workspace.getMdFactory().getConnection().MakeISecurityConnection(omiHandle));
            String resource = "OMSOBJ:DataSourceName/" + dsnFQID;
            isa.SetAuthorizationsOnObj("", resource, 0, dsnAuth);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Writing");
        }
        catch (Exception ex) {
            String strMessage = ex.getMessage();
            MessageUtil.displayMessage((String)strMessage, (int)0);
        }
        finally {
            if (isa != null) {
                isa._release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeACEDSNTSAdmin(String dsnFQID, String tsAdminId) {
        String userid = tsAdminId;
        if (userid == null || userid.equals("") || userid.equals(DSNDBAdminNone)) {
            return;
        }
        String[][] dsnAuth = new String[][]{{"IdentityGroup", userid, "R", "ReadMetadata", ""}, {"IdentityGroup", userid, "R", "WriteMetadata", ""}};
        ISecurityAdmin isa = null;
        try {
            IOMI omiHandle = Workspace.getWorkspace().getCMRHandle();
            isa = ISecurityAdminHelper.narrow((Object)Workspace.getMdFactory().getConnection().MakeISecurityConnection(omiHandle));
            String resource = "OMSOBJ:DataSourceName/" + dsnFQID;
            isa.SetAuthorizationsOnObj("", resource, 0, dsnAuth);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Writing");
        }
        catch (Exception ex) {
            String strMessage = ex.getMessage();
            MessageUtil.displayMessage((String)strMessage, (int)0);
        }
        finally {
            if (isa != null) {
                isa._release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeACELServerTSAdmin(String lserverFQID, String tsAdminId) {
        String userid = tsAdminId;
        ISecurityAdmin isa = null;
        String[][] RLServerAuth = new String[][]{{"IdentityGroup", userid, "R", "ReadMetadata", ""}, {"IdentityGroup", userid, "R", "WriteMetadata", ""}, {"IdentityGroup", userid, "R", "CheckInMetadata", ""}, {"IdentityGroup", userid, "R", "Read", ""}, {"IdentityGroup", userid, "R", "Write", ""}, {"IdentityGroup", userid, "R", "Administer", ""}, {"IdentityGroup", userid, "R", "Create", ""}, {"IdentityGroup", userid, "R", "Delete", ""}, {"IdentityGroup", userid, "R", "Execute", ""}, {"IdentityGroup", userid, "R", "WriteMemberMetadata", ""}, {"IdentityGroup", userid, "R", "Create Table", ""}, {"IdentityGroup", userid, "R", "Drop Table", ""}, {"IdentityGroup", userid, "R", "Alter Table", ""}, {"IdentityGroup", userid, "R", "Select", ""}, {"IdentityGroup", userid, "R", "Insert", ""}, {"IdentityGroup", userid, "R", "Update", ""}, {"IdentityGroup", userid, "R", "References", ""}};
        try {
            IOMI omiHandle = Workspace.getWorkspace().getCMRHandle();
            isa = ISecurityAdminHelper.narrow((Object)Workspace.getMdFactory().getConnection().MakeISecurityConnection(omiHandle));
            String resource = "OMSOBJ:LogicalServer/" + lserverFQID;
            isa.SetAuthorizationsOnObj("", resource, 0, RLServerAuth);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Writing");
        }
        catch (Exception ex) {
            String strMessage = ex.getMessage();
            MessageUtil.displayMessage((String)strMessage, (int)0);
        }
        finally {
            if (isa != null) {
                isa._release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeACETSTreeTSAdmin(String tsTreeFQID, String oldtsAdminId) {
        String userid = oldtsAdminId;
        if (userid == null || userid.equals("") || userid.equals(DSNDBAdminNone)) {
            return;
        }
        String[][] TSTreeAuth = new String[][]{{"IdentityGroup", userid, "R", "ReadMetadata", ""}, {"IdentityGroup", userid, "R", "WriteMetadata", ""}};
        ISecurityAdmin isa = null;
        try {
            IOMI omiHandle = Workspace.getWorkspace().getCMRHandle();
            isa = ISecurityAdminHelper.narrow((Object)Workspace.getMdFactory().getConnection().MakeISecurityConnection(omiHandle));
            String resource = "OMSOBJ:Tree/" + tsTreeFQID;
            isa.SetAuthorizationsOnObj("", resource, 0, TSTreeAuth);
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Writing");
        }
        catch (Exception ex) {
            String strMessage = ex.getMessage();
            MessageUtil.displayMessage((String)strMessage, (int)0);
        }
        finally {
            if (isa != null) {
                isa._release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeACETSSourceTSAdmin(String treeFQID, String oldtsAdminId) {
        String userid = oldtsAdminId;
        if (userid == null || userid.equals("") || userid.equals(DSNDBAdminNone)) {
            return;
        }
        String[][] treeAuth = new String[][]{{"IdentityGroup", userid, "R", "ReadMetadata", ""}};
        ISecurityAdmin isa = null;
        try {
            IOMI omiHandle = Workspace.getWorkspace().getCMRHandle();
            isa = ISecurityAdminHelper.narrow((Object)Workspace.getMdFactory().getConnection().MakeISecurityConnection(omiHandle));
            String resource = "OMSOBJ:Tree/" + treeFQID;
            isa.SetAuthorizationsOnObj("", resource, 0, treeAuth);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Writing");
        }
        catch (Exception ex) {
            String strMessage = ex.getMessage();
            MessageUtil.displayMessage((String)strMessage, (int)0);
        }
        finally {
            if (isa != null) {
                isa._release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addACELServerTSAdmin(String fqid, String tsAdminId) {
        String userid = tsAdminId;
        ISecurityAdmin isa = null;
        String[][] LServerAuth = new String[][]{{"IdentityGroup", userid, "G", "ReadMetadata", ""}, {"IdentityGroup", userid, "G", "WriteMetadata", ""}, {"IdentityGroup", userid, "G", "CheckInMetadata", ""}, {"IdentityGroup", userid, "G", "Read", ""}, {"IdentityGroup", userid, "G", "Write", ""}, {"IdentityGroup", userid, "G", "Administer", ""}, {"IdentityGroup", userid, "G", "Create", ""}, {"IdentityGroup", userid, "G", "Delete", ""}, {"IdentityGroup", userid, "G", "Execute", ""}, {"IdentityGroup", userid, "G", "WriteMemberMetadata", ""}, {"IdentityGroup", userid, "G", "Create Table", ""}, {"IdentityGroup", userid, "G", "Drop Table", ""}, {"IdentityGroup", userid, "G", "Alter Table", ""}, {"IdentityGroup", userid, "G", "Select", ""}, {"IdentityGroup", userid, "G", "Insert", ""}, {"IdentityGroup", userid, "G", "Update", ""}, {"IdentityGroup", userid, "G", "References", ""}};
        try {
            IOMI omiHandle = Workspace.getWorkspace().getCMRHandle();
            isa = ISecurityAdminHelper.narrow((Object)Workspace.getMdFactory().getConnection().MakeISecurityConnection(omiHandle));
            String resource = "OMSOBJ:LogicalServer/" + fqid;
            isa.SetAuthorizationsOnObj("", resource, 0, LServerAuth);
        }
        catch (Exception ex) {
            String strMessage = ex.getMessage();
            MessageUtil.displayMessage((String)strMessage, (int)0);
        }
        finally {
            if (isa != null) {
                isa._release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addACETSTreeTSAdmin(String tsTreeFQID, String tsAdminId) {
        String userid = tsAdminId;
        String[][] TSTreeAuth = new String[][]{{"IdentityGroup", userid, "G", "ReadMetadata", ""}, {"IdentityGroup", userid, "G", "WriteMetadata", ""}};
        ISecurityAdmin isa = null;
        try {
            IOMI omiHandle = Workspace.getWorkspace().getCMRHandle();
            isa = ISecurityAdminHelper.narrow((Object)Workspace.getMdFactory().getConnection().MakeISecurityConnection(omiHandle));
            String resource = "OMSOBJ:Tree/" + tsTreeFQID;
            isa.SetAuthorizationsOnObj("", resource, 0, TSTreeAuth);
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Reading");
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (Exception ex) {
            String strMessage = ex.getMessage();
            MessageUtil.displayMessage((String)strMessage, (int)0);
        }
        finally {
            if (isa != null) {
                isa._release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addACETSSourceTSAdmin(String treeFQID, String tsAdminId) {
        String userid = tsAdminId;
        String[][] treeAuth = new String[][]{{"IdentityGroup", userid, "G", "ReadMetadata", ""}};
        ISecurityAdmin isa = null;
        try {
            IOMI omiHandle = Workspace.getWorkspace().getCMRHandle();
            isa = ISecurityAdminHelper.narrow((Object)Workspace.getMdFactory().getConnection().MakeISecurityConnection(omiHandle));
            String resource = "OMSOBJ:Tree/" + treeFQID;
            isa.SetAuthorizationsOnObj("", resource, 0, treeAuth);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Writing");
        }
        catch (Exception ex) {
            String strMessage = ex.getMessage();
            MessageUtil.displayMessage((String)strMessage, (int)0);
        }
        finally {
            if (isa != null) {
                isa._release();
            }
        }
    }

    protected void _createSASClientConn() {
        try {
            if (this.m_SASClientConn != null) {
                return;
            }
            String tName = "";
            int indx = this.m_tserver.getName().indexOf(bundle.getString("TableServer.DataService.Suffix.txt"));
            tName = indx < 0 ? TSServiceTypeTab._getTSNameWithoutSuffix(bundle.getString("TableServer.ServerComponent.Suffix.txt").trim(), this.m_tserver.getName()) : this.m_tserver.getName().substring(0, indx - 1);
            this.m_SASClientConn = (SASClientConnection)Workspace.getMdFactory().createComplexMetadataObject(this.m_store, null, CONNTABLESERVICE + tName, "SASClientConnection", this.m_tserver.getRepositoryID());
            this.m_SASClientConn.setRemoteAddress(LOCALHOST);
            this.m_SASClientConn.setAuthenticationType(NONE);
            this.m_SASClientConn.setCommunicationProtocol(LOCAL);
            this.m_SASClientConn.setApplicationProtocol(TKTS);
            this.m_SASClientConn.setSource((DeployedComponent)this.m_tserver);
            if (this.m_isUpdate) {
                this.m_SASClientConn.updateMetadataAll();
            }
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Writing");
        }
        catch (Exception ex) {
            String strMessage = ex.getMessage();
            MessageUtil.displayMessage((String)strMessage, (int)0);
        }
    }

    protected void _removeSASClientConn() {
        try {
            if (this.m_SASClientConn == null) {
                return;
            }
            if (this.m_isUpdate) {
                Root editableSCC = Server.createNewEditableObject((Root)this.m_SASClientConn);
                Workspace.getMdFactory().deleteMetadataObject((CMetadata)editableSCC);
            } else {
                this.m_SASClientConn.delete();
            }
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Deleting");
        }
        catch (Exception ex) {
            String strMessage = ex.getMessage();
            MessageUtil.displayMessage((String)strMessage, (int)0);
        }
    }

    public void keyPressed(KeyEvent ke) {
        switch (ke.getKeyCode()) {
            default: 
        }
    }

    private static String _getTSNameWithoutSuffix(String suffix, String tname) {
        String retTname = "";
        int indx = 0;
        retTname = tname;
        indx = retTname.indexOf(suffix);
        if (indx > 0) {
            retTname = retTname.substring(0, indx - 1);
        }
        return retTname;
    }

    public class dirFilter
    extends FileFilter {
        @Override
        public boolean accept(File f) {
            return f.isDirectory();
        }

        @Override
        public String getDescription() {
            return null;
        }
    }
}

