/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals.customizers.proxy;

import com.sas.workspace.mgmt.visuals.customizers.iom.IOMProperty;
import com.sas.workspace.mgmt.visuals.customizers.proxy.InvalidProxyURIException;
import java.net.URI;

public class ProxyListItem {
    private String m_scheme;
    private String m_host;
    private int m_port;
    private String m_path;
    protected static String[] m_supportedSchemes = new String[]{"http", "https"};
    protected static int[] m_defPorts = new int[]{80, 443};
    public static int DEFAULT_PORT = -1;
    private String m_id;
    private String m_prevURI;

    public ProxyListItem() {
        this("http");
    }

    public ProxyListItem(String scheme, String host, int port, String path) {
        this.m_scheme = scheme;
        this.m_host = host;
        this.m_port = port;
        this.m_path = path;
        this.m_id = "";
    }

    public ProxyListItem(String scheme, String host, int port) {
        this(scheme, host, port, null);
    }

    public ProxyListItem(String scheme, String host) {
        this(scheme, host, 0);
    }

    public ProxyListItem(String scheme) {
        this(scheme, "");
    }

    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof ProxyListItem) {
            return ((ProxyListItem)obj).toString().equals(this.toString());
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_host == null ? 0 : this.m_host.hashCode());
        result = 31 * result + (this.m_path == null ? 0 : this.m_path.hashCode());
        result = 31 * result + this.m_port;
        result = 31 * result + (this.m_scheme == null ? 0 : this.m_scheme.hashCode());
        return result;
    }

    public static int getDefaultPortForScheme(String scheme) {
        for (int i = 0; i < m_supportedSchemes.length; ++i) {
            if (!m_supportedSchemes[i].equalsIgnoreCase(scheme)) continue;
            return m_defPorts[i];
        }
        return 0;
    }

    public static ProxyListItem fromURI(URI uri) {
        return new ProxyListItem(uri.getScheme(), uri.getHost(), uri.getPort(), uri.getPath());
    }

    public URI getURI() {
        return URI.create(this.toString());
    }

    public String getScheme() {
        return this.m_scheme;
    }

    public void setScheme(String scheme) {
        this.m_scheme = scheme;
    }

    public String getHost() {
        return this.m_host;
    }

    public void setHost(String host) {
        this.m_host = host;
        if (host.equals("")) {
            this.m_host = "localhost";
        }
    }

    public void setPort(int port) {
        this.m_port = port;
        if (port == DEFAULT_PORT) {
            this.m_port = ProxyListItem.getDefaultPortForScheme(this.m_scheme);
        }
    }

    public int getPort() {
        if (this.isUsingDefaultPort()) {
            return ProxyListItem.getDefaultPortForScheme(this.m_scheme);
        }
        return this.m_port;
    }

    public String getPath() {
        return this.m_path;
    }

    public void setPath(String path) {
        this.m_path = path;
    }

    public String toString() {
        StringBuilder uriBuilder = new StringBuilder();
        uriBuilder.append(this.m_scheme + "://" + this.m_host);
        if (!this.isUsingDefaultPort()) {
            uriBuilder.append(":" + String.valueOf(this.m_port));
        }
        if (this.m_path != null && this.m_path.length() != 0) {
            uriBuilder.append(this.m_path);
        }
        return uriBuilder.toString();
    }

    public static void validate(URI uri) throws InvalidProxyURIException {
        String scheme = uri.getScheme();
        boolean ok = false;
        if (scheme == null) {
            throw new InvalidProxyURIException(IOMProperty.getDisplayString(0, "Proxy.URI.Error.InvalidFormatError.Message.xmlKey.txt"));
        }
        for (int i = 0; i < m_supportedSchemes.length && !ok; ++i) {
            if (!m_supportedSchemes[i].equalsIgnoreCase(scheme)) continue;
            ok = true;
        }
        if (!ok) {
            throw new InvalidProxyURIException(IOMProperty.getDisplayString(0, "Proxy.URI.Error.UnsupportedScheme.Message.xmlKey.txt"));
        }
        if (uri.getPort() != DEFAULT_PORT && uri.getPort() > 65535) {
            throw new InvalidProxyURIException(IOMProperty.getDisplayString(0, "Proxy.URI.Error.InvalidPort.Message.xmlKey.txt"));
        }
    }

    public boolean isUsingDefaultPort() {
        if (this.m_port == DEFAULT_PORT) {
            return true;
        }
        return this.m_port == ProxyListItem.getDefaultPortForScheme(this.m_scheme);
    }

    public String getEntryID() {
        return this.m_id;
    }

    public void setEntryID(String id) {
        this.m_id = id;
    }

    public void setPreviousURI(String uri) {
        this.m_prevURI = uri;
    }

    public String getPreviousURI() {
        return this.m_prevURI;
    }

    public boolean hasBeenUpdated() {
        return this.toString().equals(this.m_prevURI);
    }
}

