/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals.customizers.hadoop;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.CustomAssociation;
import com.sas.metadata.remote.Extension;
import com.sas.metadata.remote.Identity;
import com.sas.metadata.remote.Login;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.ServerComponent;
import com.sas.visuals.Resources;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsDescriptionWizardTab;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class EncryptionPanel
extends WsDescriptionWizardTab {
    private static String ENCRYPTION_ENABLED_SERVER = "EncryptionEnabled";
    private static String ENCRYPTION_ENABLED_LIBRARY = "VA.Encryption.Enabled";
    private static String ENCRYPTION_ENABLED_YES = "Yes";
    private static String ENCRYPTION_ENABLED_NO = "No";
    private static String ENCRYPTION_ENABLED_INHERITED = "Inherited";
    private static String CUSTOMASSOC_SERVER_NAME = "SecuredHadoopServer";
    private static String CUSTOMASSOC_SERVER_PARTNERNAME = "HadoopSecurityKey";
    private static String CUSTOMASSOC_LIBRARY_NAME = "SecuredHDFSLibrary";
    private static String CUSTOMASSOC_LIBRARY_PARTNERNAME = "HDFSSecurityKey";
    private static String LOGIN_SERVER_NAME = "Hadoop Server Security Key";
    private static String LOGIN_LIBRARY_NAME = "HDFS Library Security Key";
    private Root m_root;
    private ServerComponent m_server;
    private SASLibrary m_library;
    private String m_strReposID;
    private WATextArea m_lblTitle;
    private JLabel m_lblEnable;
    private JRadioButton m_rdoYes;
    private JRadioButton m_rdoNo;
    private JRadioButton m_rdoInherit;
    private JLabel m_lblNew;
    private JPasswordField m_pwdNew;
    private JLabel m_lblConfirm;
    private JPasswordField m_pwdConfirm;
    private JLabel m_lblWarnIcon;
    private WATextArea m_lblWarning;
    protected static final WAdminResource m_bundle = new WAdminResource(EncryptionPanel.class);
    private static final long serialVersionUID = 1L;

    public EncryptionPanel(Root root, String reposID) {
        this.m_root = root;
        if (root instanceof ServerComponent) {
            this.m_server = (ServerComponent)root;
        }
        if (root instanceof SASLibrary) {
            this.m_library = (SASLibrary)root;
        }
        this.m_strReposID = reposID;
        this.initialize();
        this.layoutWidgets();
    }

    public void moveDataToStore() {
        block26: {
            try {
                String strEncryptionEnabled = new String();
                if (this.m_rdoYes.isSelected()) {
                    strEncryptionEnabled = ENCRYPTION_ENABLED_YES;
                } else if (this.m_rdoNo.isSelected()) {
                    strEncryptionEnabled = ENCRYPTION_ENABLED_NO;
                } else if (this.m_library != null && this.m_rdoInherit.isSelected()) {
                    strEncryptionEnabled = ENCRYPTION_ENABLED_INHERITED;
                }
                if (this.m_server != null) {
                    boolean bPropertyFound = false;
                    AssociationList lstProperties = this.m_server.getProperties();
                    for (Property property : lstProperties) {
                        if (!property.getPropertyName().equalsIgnoreCase(ENCRYPTION_ENABLED_SERVER)) continue;
                        if (!strEncryptionEnabled.equalsIgnoreCase(property.getDefaultValue())) {
                            property.setDefaultValue(strEncryptionEnabled);
                        }
                        bPropertyFound = true;
                        break;
                    }
                    if (!bPropertyFound) {
                        Property property = (Property)Workspace.getMdFactory().createComplexMetadataObject((MdObjectStore)this.m_server.getObjectStore(), null, "Property", "Property", this.m_strReposID.substring(9));
                        property.setPropertyName(ENCRYPTION_ENABLED_SERVER);
                        property.setDefaultValue(strEncryptionEnabled);
                        property.setSQLType(12);
                        this.m_server.getProperties().add((Object)property);
                    }
                } else if (this.m_library != null) {
                    boolean bExtensionFound = false;
                    AssociationList lstExtensions = this.m_library.getExtensions();
                    for (Extension extension : lstExtensions) {
                        if (!extension.getName().equalsIgnoreCase(ENCRYPTION_ENABLED_LIBRARY)) continue;
                        if (!strEncryptionEnabled.equalsIgnoreCase(extension.getValue())) {
                            extension.setValue(strEncryptionEnabled);
                        }
                        bExtensionFound = true;
                        break;
                    }
                    if (!bExtensionFound) {
                        Extension extension = (Extension)Workspace.getMdFactory().createComplexMetadataObject((MdObjectStore)this.m_library.getObjectStore(), null, "Extension", "Extension", this.m_strReposID.substring(9));
                        extension.setName(ENCRYPTION_ENABLED_LIBRARY);
                        extension.setValue(strEncryptionEnabled);
                        this.m_library.getExtensions().add((Object)extension);
                    }
                }
                String strEncryptKey = String.valueOf(this.m_pwdNew.getPassword());
                boolean bKeyFound = false;
                String strCustomAssocName = new String();
                String strCustomAssocPartnerName = new String();
                String strLoginName = new String();
                if (this.m_server != null) {
                    strCustomAssocName = CUSTOMASSOC_SERVER_NAME;
                    strCustomAssocPartnerName = CUSTOMASSOC_SERVER_PARTNERNAME;
                    strLoginName = LOGIN_SERVER_NAME;
                } else if (this.m_library != null) {
                    strCustomAssocName = CUSTOMASSOC_LIBRARY_NAME;
                    strCustomAssocPartnerName = CUSTOMASSOC_LIBRARY_PARTNERNAME;
                    strLoginName = LOGIN_LIBRARY_NAME;
                }
                if (this.m_rdoYes.isSelected()) {
                    AssociationList lstAssociations = this.m_root.getReferencedObjects();
                    for (CustomAssociation association : lstAssociations) {
                        if (!association.getName().equalsIgnoreCase(strCustomAssocName)) continue;
                        Login login = (Login)association.getOwningObject();
                        if (!strEncryptKey.equalsIgnoreCase(login.getPassword())) {
                            login.setPassword(strEncryptKey);
                        }
                        bKeyFound = true;
                        break;
                    }
                    if (!bKeyFound) {
                        CustomAssociation association = (CustomAssociation)Workspace.getMdFactory().createComplexMetadataObject((MdObjectStore)this.m_root.getObjectStore(), null, "CustomAssociation", "CustomAssociation", this.m_strReposID.substring(9));
                        association.setName(strCustomAssocName);
                        association.setisOwned(1);
                        association.setPartnerName(strCustomAssocPartnerName);
                        this.m_root.getReferencedObjects().add((Object)association);
                        Login login = (Login)Workspace.getMdFactory().createComplexMetadataObject((MdObjectStore)this.m_root.getObjectStore(), null, "Login", "Login", this.m_strReposID.substring(9));
                        login.setName(strLoginName);
                        login.setPassword(strEncryptKey);
                        association.setOwningObject((Root)login);
                        String strSelect = "<XMLSELECT search=\"*[@Name='sastrust']\"/>";
                        int flags = 8600;
                        List lstIdentities = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset(this.m_root.getObjectStore(), "A0000001." + this.m_root.getRepositoryID(), "Identity", flags, strSelect);
                        Iterator iterator = lstIdentities.iterator();
                        if (iterator.hasNext()) {
                            Identity identity = (Identity)iterator.next();
                            login.setAssociatedIdentity(identity);
                            login.setUserID(strCustomAssocPartnerName + " " + this.m_root.getName() + "-" + String.valueOf(identity.getLogins().size()));
                        }
                    }
                    break block26;
                }
                AssociationList lstAssociations = this.m_root.getReferencedObjects();
                for (CustomAssociation association : lstAssociations) {
                    if (!association.getName().equalsIgnoreCase(strCustomAssocName)) continue;
                    Login login = (Login)association.getOwningObject();
                    Workspace.getMdFactory().deleteMetadataObject((CMetadata)login);
                    Workspace.getMdFactory().deleteMetadataObject((CMetadata)association);
                    break;
                }
            }
            catch (MdException exc) {
                Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
            }
            catch (RemoteException exc) {
                Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
            }
        }
    }

    public void moveDataToView() {
        try {
            if (this.m_server != null) {
                AssociationList lstProperties = this.m_server.getProperties();
                for (Property property : lstProperties) {
                    if (!property.getPropertyName().equalsIgnoreCase(ENCRYPTION_ENABLED_SERVER)) continue;
                    this.m_rdoYes.setSelected(property.getDefaultValue().equalsIgnoreCase(ENCRYPTION_ENABLED_YES));
                    this.m_rdoNo.setSelected(property.getDefaultValue().equalsIgnoreCase(ENCRYPTION_ENABLED_NO));
                    break;
                }
            } else if (this.m_library != null) {
                AssociationList lstExtensions = this.m_library.getExtensions();
                for (Extension extension : lstExtensions) {
                    if (!extension.getName().equalsIgnoreCase(ENCRYPTION_ENABLED_LIBRARY)) continue;
                    this.m_rdoYes.setSelected(extension.getValue().equalsIgnoreCase(ENCRYPTION_ENABLED_YES));
                    this.m_rdoNo.setSelected(extension.getValue().equalsIgnoreCase(ENCRYPTION_ENABLED_NO));
                    this.m_rdoInherit.setSelected(extension.getValue().equalsIgnoreCase(ENCRYPTION_ENABLED_INHERITED));
                    break;
                }
            }
            String strCustomAssocName = new String();
            if (this.m_server != null) {
                strCustomAssocName = CUSTOMASSOC_SERVER_NAME;
            } else if (this.m_library != null) {
                strCustomAssocName = CUSTOMASSOC_LIBRARY_NAME;
            }
            AssociationList lstAssociations = this.m_root.getReferencedObjects();
            for (CustomAssociation association : lstAssociations) {
                if (!association.getName().equalsIgnoreCase(strCustomAssocName)) continue;
                Login login = (Login)association.getOwningObject();
                this.m_pwdNew.setText(login.getPassword());
                this.m_pwdConfirm.setText(login.getPassword());
                break;
            }
        }
        catch (MdException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
        this.enableFields();
    }

    public boolean validateData() {
        if (this.m_rdoYes.isSelected()) {
            if (String.valueOf(this.m_pwdNew.getPassword()).length() == 0) {
                String strMessage = m_bundle.getString("EncryptionPanel.Required.NewEncryptKey.txt");
                String strTitle = m_bundle.getString("EncryptionPanel.Confirm.Title.txt");
                MessageUtil.displayMessage((String)strMessage, (String)strTitle, (int)0);
                return false;
            }
            if (String.valueOf(this.m_pwdNew.getPassword()).length() > 64) {
                String strMessage = m_bundle.getString("EncryptionPanel.NewEncryptKey.MaxChars.txt");
                String strTitle = m_bundle.getString("EncryptionPanel.Confirm.Title.txt");
                MessageUtil.displayMessage((String)strMessage, (String)strTitle, (int)0);
                return false;
            }
            if (String.valueOf(this.m_pwdConfirm.getPassword()).length() == 0) {
                String strMessage = m_bundle.getString("EncryptionPanel.Required.ConfirmEncryptKey.txt");
                String strTitle = m_bundle.getString("EncryptionPanel.Confirm.Title.txt");
                MessageUtil.displayMessage((String)strMessage, (String)strTitle, (int)0);
                return false;
            }
            if (!String.valueOf(this.m_pwdNew.getPassword()).equals(String.valueOf(this.m_pwdConfirm.getPassword()))) {
                String strMessage = m_bundle.getString("EncryptionPanel.Confirm.Message.txt");
                String strTitle = m_bundle.getString("EncryptionPanel.Confirm.Title.txt");
                MessageUtil.displayMessage((String)strMessage, (String)strTitle, (int)0);
                return false;
            }
        }
        return true;
    }

    private void enableFields() {
        if (!Workspace.getWorkspace().isUnrestrictedUser()) {
            this.m_lblEnable.setEnabled(false);
            this.m_rdoYes.setEnabled(false);
            this.m_rdoNo.setEnabled(false);
            if (this.m_library != null) {
                this.m_rdoInherit.setEnabled(false);
            }
        }
        this.m_lblNew.setEnabled(Workspace.getWorkspace().isUnrestrictedUser() && this.m_rdoYes.isSelected());
        this.m_pwdNew.setEditable(Workspace.getWorkspace().isUnrestrictedUser() && this.m_rdoYes.isSelected());
        this.m_lblConfirm.setEnabled(Workspace.getWorkspace().isUnrestrictedUser() && this.m_rdoYes.isSelected());
        this.m_pwdConfirm.setEditable(Workspace.getWorkspace().isUnrestrictedUser() && this.m_rdoYes.isSelected());
        this.m_lblWarnIcon.setEnabled(Workspace.getWorkspace().isUnrestrictedUser() && this.m_rdoYes.isSelected());
        this.m_lblWarning.setEnabled(Workspace.getWorkspace().isUnrestrictedUser() && this.m_rdoYes.isSelected());
    }

    public String createFinishString() {
        String strFinish = m_bundle.getString("EncryptionPanel.EnableEncryption.txt") + "\n\t";
        if (this.m_rdoYes.isSelected()) {
            strFinish = strFinish + m_bundle.getString("EncryptionPanel.Yes.txt") + "\n";
        } else if (this.m_rdoNo.isSelected()) {
            strFinish = strFinish + m_bundle.getString("EncryptionPanel.No.txt") + "\n";
        } else if (this.m_library != null && this.m_rdoInherit.isSelected()) {
            strFinish = strFinish + m_bundle.getString("EncryptionPanel.Inherit.txt") + "\n";
        }
        return strFinish;
    }

    protected void initialize() {
        if (this.m_server != null) {
            this.m_lblTitle = new WATextArea(m_bundle.getString("EncryptionPanel.Server.Title.txt"));
        } else if (this.m_library != null) {
            this.m_lblTitle = new WATextArea(m_bundle.getString("EncryptionPanel.Library.Title.txt"));
        }
        this.m_lblTitle.setFont(UIManager.getFont("Label.font"));
        this.m_lblTitle.setBehavior(1);
        this.m_lblTitle.setLineWrap(true);
        this.m_lblTitle.setWrapStyleWord(true);
        this.m_lblEnable = new JLabel(m_bundle.getString("EncryptionPanel.EnableEncryption.txt"));
        ButtonGroup grpRadio = new ButtonGroup();
        this.m_rdoYes = new JRadioButton(m_bundle.getString("EncryptionPanel.Yes.txt"));
        this.m_rdoYes.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                EncryptionPanel.this.enableFields();
            }
        });
        this.m_rdoNo = new JRadioButton(m_bundle.getString("EncryptionPanel.No.txt"));
        this.m_rdoNo.setSelected(true);
        this.m_rdoNo.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                EncryptionPanel.this.enableFields();
            }
        });
        grpRadio.add(this.m_rdoYes);
        grpRadio.add(this.m_rdoNo);
        if (this.m_library != null) {
            this.m_rdoInherit = new JRadioButton(m_bundle.getString("EncryptionPanel.Inherit.txt"));
            this.m_rdoInherit.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent evt) {
                    EncryptionPanel.this.enableFields();
                }
            });
            grpRadio.add(this.m_rdoInherit);
        }
        this.m_lblNew = new JLabel(m_bundle.getString("EncryptionPanel.NewEncryptKey.txt"));
        this.m_pwdNew = new JPasswordField();
        this.m_pwdNew.setToolTipText(m_bundle.getString("EncryptionPanel.NewEncryptKey.tooltip.txt"));
        this.m_lblConfirm = new JLabel(m_bundle.getString("EncryptionPanel.ConfirmEncryptKey.txt"));
        this.m_pwdConfirm = new JPasswordField();
        this.m_pwdConfirm.setToolTipText(m_bundle.getString("EncryptionPanel.ConfirmEncryptKey.tooltip.txt"));
        this.m_lblWarnIcon = new JLabel(Resources.getImageIcon((String)m_bundle.getString("EncryptionPanel.Warning.Icon.image"), (int)32));
        this.m_lblWarning = new WATextArea(m_bundle.getString("EncryptionPanel.Warning.txt"));
        this.m_lblWarning.setFont(UIManager.getFont("Label.font"));
        this.m_lblWarning.setBehavior(1);
        this.m_lblWarning.setLineWrap(true);
        this.m_lblWarning.setWrapStyleWord(true);
        this.enableFields();
    }

    protected void layoutWidgets() {
        LayoutManager layout;
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        int gridy = 0;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy++;
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.gridwidth = 0;
        gbc.insets = new Insets(0, 0, 0, 0);
        gridBagLayout.setConstraints((Component)this.m_lblTitle, gbc);
        this.add((Component)this.m_lblTitle);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 0, 0, 0);
        gridBagLayout.setConstraints(this.m_lblEnable, gbc);
        this.add(this.m_lblEnable);
        JPanel pnlRadios = new JPanel();
        pnlRadios.add(this.m_rdoYes);
        pnlRadios.add(this.m_rdoNo);
        if (this.m_library != null) {
            pnlRadios.add(this.m_rdoInherit);
        }
        if ((layout = pnlRadios.getLayout()) instanceof FlowLayout) {
            ((FlowLayout)layout).setAlignment(0);
        }
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.gridwidth = 0;
        gbc.insets = new Insets(12, 12, 0, 0);
        gridBagLayout.setConstraints(pnlRadios, gbc);
        this.add(pnlRadios);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 0, 0, 0);
        gridBagLayout.setConstraints(this.m_lblNew, gbc);
        this.add(this.m_lblNew);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(12, 12, 0, 0);
        gridBagLayout.setConstraints(this.m_pwdNew, gbc);
        this.add(this.m_pwdNew);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 0, 0, 0);
        gridBagLayout.setConstraints(this.m_lblConfirm, gbc);
        this.add(this.m_lblConfirm);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(12, 12, 0, 0);
        gridBagLayout.setConstraints(this.m_pwdConfirm, gbc);
        this.add(this.m_pwdConfirm);
        JPanel pnlWarning = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        pnlWarning.setLayout(gbl);
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.insets = new Insets(0, 0, 0, 0);
        gbl.setConstraints(this.m_lblWarnIcon, c);
        pnlWarning.add(this.m_lblWarnIcon);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 1.0;
        c.fill = 2;
        c.gridwidth = 0;
        c.insets = new Insets(0, 12, 0, 0);
        gbl.setConstraints((Component)this.m_lblWarning, c);
        pnlWarning.add((Component)this.m_lblWarning);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy++;
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.gridwidth = 0;
        gbc.insets = new Insets(12, 0, 0, 0);
        gridBagLayout.setConstraints(pnlWarning, gbc);
        this.add(pnlWarning);
        JPanel eaterPanel = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.gridwidth = 0;
        gbc.gridheight = 0;
        gridBagLayout.setConstraints(eaterPanel, gbc);
        this.add(eaterPanel);
    }
}

