/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals.customizers.grid;

import com.sas.services.information.ServerInterface;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsStringTableColumn;
import com.sas.workspace.mgmt.visuals.customizers.grid.BasicMetadataUser;
import com.sas.workspace.mgmt.visuals.customizers.grid.GAOTemplate;
import com.sas.workspace.mgmt.visuals.customizers.grid.GridServerPropertyPanel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class GaoMappingTableModel
extends WsAbstractTableModel {
    private static final long serialVersionUID = 1L;
    public static final int APP_COLUMN = 0;
    public static final int IDENTITIES_COLUMN = 1;
    public static final int OBJECT_COLUMN = 2;
    public static final int GAOID_COLUMN = 3;
    private int appColWidth = 199;
    private int objColWidth = 199;
    private int identColWidth = 244;
    private int gaoIdColWidth = 0;
    private final WAdminResource bundle = WAdminResource.getBundle(GaoMappingTableModel.class);
    private final String GOS_COLNAME = this.bundle.getString("GridServerPropertyPanel.gridappcol.label.txt");
    private final String IDENTITY_COLNAME = this.bundle.getString("GridServerPropertyPanel.identitiescol.label.txt");
    private HashMap<GAOTemplate, List<HashMap<String, List<BasicMetadataUser>>>> m_dataMap;
    private ServerInterface m_server = null;
    private GridServerPropertyPanel m_panel = null;

    public GaoMappingTableModel(HashMap<GAOTemplate, List<HashMap<String, List<BasicMetadataUser>>>> dataMap, ServerInterface m_server2, GridServerPropertyPanel panel) {
        this.m_dataMap = dataMap;
        this.m_server = m_server2;
        this.m_panel = panel;
        this._buildColumn();
        this.moveDataToModel();
    }

    public void moveDataToStore() {
    }

    private void _buildColumn() {
        this.m_aColumns = new WsAbstractTableColumn[4];
        this.m_aColumns[0] = new WsStringTableColumn(0, this.bundle.getString("GridServerPropertyPanel.sasappcol.label.txt"), this.appColWidth);
        this.m_aColumns[1] = new WsStringTableColumn(1, this.IDENTITY_COLNAME, this.identColWidth);
        this.m_aColumns[2] = new WsStringTableColumn(2, this.GOS_COLNAME, this.objColWidth);
        this.m_aColumns[3] = new WsStringTableColumn(3, "", this.gaoIdColWidth);
        this.m_aColumns[2].setEditable(false);
        this.m_aColumns[0].setEditable(false);
        this.m_aColumns[1].setEditable(false);
        this.m_aColumns[3].setEditable(false);
    }

    public void moveDataToModel() {
        this.populateModel(this.m_dataMap);
    }

    private void populateModel(HashMap<GAOTemplate, List<HashMap<String, List<BasicMetadataUser>>>> m_dataMap) {
        for (Map.Entry<GAOTemplate, List<HashMap<String, List<BasicMetadataUser>>>> pairs : m_dataMap.entrySet()) {
            GAOTemplate t = pairs.getKey();
            List<HashMap<String, List<BasicMetadataUser>>> mapList = pairs.getValue();
            for (HashMap<String, List<BasicMetadataUser>> map : mapList) {
                for (Map.Entry<String, List<BasicMetadataUser>> entry : map.entrySet()) {
                    ArrayList<String> row = new ArrayList<String>();
                    String sasAppName = entry.getKey().toString();
                    List<BasicMetadataUser> identityList = entry.getValue();
                    String userList = "";
                    for (BasicMetadataUser user : identityList) {
                        userList = userList + user + ";";
                    }
                    row.add(0, sasAppName);
                    row.add(1, this.getStringCleaned(userList));
                    row.add(2, t.getName());
                    row.add(3, t.getMetaId());
                    this.m_lData.add(row);
                }
            }
        }
        this.fireTableModelPopulated();
    }

    private String getStringCleaned(String origS) {
        origS.trim();
        int pos = origS.lastIndexOf(";");
        String newString = null;
        if (pos == -1) {
            return origS;
        }
        newString = origS.substring(0, pos);
        return newString;
    }

    public void populateStore() {
        this.setStorePopulated(true);
    }

    public void deleteSelectedRows(int[] rows) {
        Arrays.sort(rows);
        for (int index = rows.length - 1; index >= 0; --index) {
            String sasApp = this.getValueAt(rows[index], 0).toString();
            String gaoName = this.getValueAt(rows[index], 2).toString();
            this.deleteRow(rows[index]);
            this.deleteMappedRow(sasApp, gaoName);
            if (!Workspace.isDebug()) continue;
            System.out.println("Delete selected mapped row : gao=" + gaoName + "||sasApp=" + sasApp);
        }
        this.clear();
        this.populateModel(this.m_dataMap);
    }

    private void deleteMappedRow(String sasApp, String gaoName) {
        for (Map.Entry<GAOTemplate, List<HashMap<String, List<BasicMetadataUser>>>> pairs : this.m_dataMap.entrySet()) {
            GAOTemplate t = pairs.getKey();
            List<HashMap<String, List<BasicMetadataUser>>> mapList = pairs.getValue();
            block1: for (HashMap<String, List<BasicMetadataUser>> map : mapList) {
                if (!t.getName().equalsIgnoreCase(gaoName)) continue;
                for (Map.Entry<String, List<BasicMetadataUser>> entry : map.entrySet()) {
                    String sasAppName = entry.getKey().toString();
                    if (!sasAppName.equalsIgnoreCase(sasApp)) continue;
                    map.entrySet().remove(entry);
                    continue block1;
                }
            }
        }
    }

    public void updateGAO(String sasApp, GAOTemplate t, List<BasicMetadataUser> users, boolean isDeleted) {
        boolean update = false;
        block0: for (Map.Entry<GAOTemplate, List<HashMap<String, List<BasicMetadataUser>>>> pairs : this.m_dataMap.entrySet()) {
            List<HashMap<String, List<BasicMetadataUser>>> mapList;
            GAOTemplate gao = pairs.getKey();
            if (t.getName().equalsIgnoreCase(gao.getName())) {
                if (isDeleted && users == null) {
                    this.m_dataMap.entrySet().remove(pairs);
                    update = true;
                    if (!Workspace.isDebug()) break;
                    System.out.println("Delete GAO in updateGAO:gao=" + gao.getName());
                    break;
                }
                mapList = pairs.getValue();
                block1: for (HashMap<String, List<BasicMetadataUser>> map : mapList) {
                    Set<String> theKeys = map.keySet();
                    Iterator<String> itr = theKeys.iterator();
                    while (itr.hasNext()) {
                        if (!itr.next().equalsIgnoreCase(sasApp)) continue;
                        if (isDeleted) {
                            this.m_dataMap.entrySet().remove(map);
                            if (!Workspace.isDebug()) continue;
                            System.out.println("Delete map in updateGAO:gao=" + gao.getName() + " sasApp=" + sasApp);
                            continue;
                        }
                        map.put(sasApp, users);
                        if (Workspace.isDebug()) {
                            String userString = "";
                            for (BasicMetadataUser user : users) {
                                userString = userString + user.userName + ";";
                            }
                            System.out.println("Update existing map in the same GOS of updateGAO:" + sasApp + "gao=" + gao.getName() + " userList=" + userString);
                        }
                        update = true;
                        continue block1;
                    }
                }
                continue;
            }
            mapList = pairs.getValue();
            for (HashMap<String, List<BasicMetadataUser>> map : mapList) {
                boolean updateGAO = false;
                Set<String> theKeys = map.keySet();
                Iterator<String> itr = theKeys.iterator();
                while (itr.hasNext()) {
                    if (!itr.next().equalsIgnoreCase(sasApp)) continue;
                    updateGAO = true;
                    List<BasicMetadataUser> userList = map.get(sasApp);
                    List<BasicMetadataUser> deleteList = this.getCommonUserLists(userList, users);
                    if (deleteList == null || deleteList.size() <= 0) break;
                    userList.removeAll(deleteList);
                    if (userList != null && userList.size() > 0) {
                        map.put(sasApp, userList);
                        if (!Workspace.isDebug()) break;
                        String userString = "";
                        for (BasicMetadataUser user : userList) {
                            userString = userString + user.userName + ";";
                        }
                        System.out.println("Update existing map in different GOS of updateGAO:" + sasApp + "gao=" + gao.getName() + " userList=" + userString);
                        break;
                    }
                    map.remove(sasApp);
                    System.out.println("Delete map due to empty identity list in SAS Application \" " + sasApp + "\" and Grid options set =" + gao.getName());
                    break;
                }
                if (!updateGAO) continue;
                continue block0;
            }
        }
        if (!update && !isDeleted) {
            List<HashMap<String, List<BasicMetadataUser>>> values = this.m_dataMap.get(t);
            if (values == null) {
                values = new ArrayList<HashMap<String, List<BasicMetadataUser>>>();
            }
            HashMap<String, List<BasicMetadataUser>> newMap = new HashMap<String, List<BasicMetadataUser>>();
            newMap.put(sasApp, users);
            values.add(newMap);
            this.m_dataMap.put(t, values);
            if (Workspace.isDebug()) {
                String userString = "";
                for (BasicMetadataUser user : users) {
                    userString = userString + user.userName + ";";
                }
                System.out.println("Write new map in updateGAO:" + sasApp + " gao=" + t.getName() + " userList=" + userString);
            }
        }
        this.clear();
        this.populateModel(this.m_dataMap);
    }

    public HashMap<GAOTemplate, List<HashMap<String, List<BasicMetadataUser>>>> getDataMap() {
        return this.m_dataMap;
    }

    public List<BasicMetadataUser> getCommonUserLists(List<BasicMetadataUser> list1, List<BasicMetadataUser> list2) {
        ArrayList<BasicMetadataUser> userList = new ArrayList<BasicMetadataUser>();
        for (BasicMetadataUser user : list1) {
            for (BasicMetadataUser user2 : list2) {
                if (!user.userName.equalsIgnoreCase(user2.userName)) continue;
                userList.add(user);
            }
        }
        return userList;
    }

    public List<BasicMetadataUser> getUserListFromLocalTemplate(String gaoName, String app, HashMap<GAOTemplate, List<HashMap<String, List<BasicMetadataUser>>>> dataMap) {
        List<BasicMetadataUser> localUsers = null;
        for (Map.Entry<GAOTemplate, List<HashMap<String, List<BasicMetadataUser>>>> pairs : dataMap.entrySet()) {
            GAOTemplate t = pairs.getKey();
            if (!t.getName().equalsIgnoreCase(gaoName)) continue;
            List<HashMap<String, List<BasicMetadataUser>>> mapList = pairs.getValue();
            for (HashMap<String, List<BasicMetadataUser>> map : mapList) {
                for (Map.Entry<String, List<BasicMetadataUser>> entry : map.entrySet()) {
                    String sasAppName = entry.getKey().toString();
                    if (!sasAppName.equalsIgnoreCase(app)) continue;
                    localUsers = entry.getValue();
                    return localUsers;
                }
            }
        }
        return new ArrayList<BasicMetadataUser>();
    }

    public void updateUserBySASApp(String sasApp, GAOTemplate gao, List<BasicMetadataUser> users) {
        for (Map.Entry<GAOTemplate, List<HashMap<String, List<BasicMetadataUser>>>> pairs : this.m_dataMap.entrySet()) {
            GAOTemplate t = pairs.getKey();
            if (!t.getName().equalsIgnoreCase(gao.getName())) continue;
            List<HashMap<String, List<BasicMetadataUser>>> mapList = pairs.getValue();
            for (HashMap<String, List<BasicMetadataUser>> map : mapList) {
                Set<String> theKeys = map.keySet();
                Iterator<String> itr = theKeys.iterator();
                while (itr.hasNext()) {
                    if (!itr.next().equalsIgnoreCase(sasApp)) continue;
                    map.put(sasApp, users);
                }
            }
        }
    }

    public String getToolTipAt(int iRow, int iCol) {
        String value = this.getValueAt(iRow, iCol).toString();
        WsAbstractTableColumn col = this.getColumn(iCol);
        if (col.getName() != null && col.getName().equalsIgnoreCase(this.GOS_COLNAME)) {
            String newValue = "";
            List<GAOTemplate> gaoList = this.m_panel.getTotalGaoTemplate();
            for (GAOTemplate gAOTemplate : gaoList) {
                if (!gAOTemplate.getName().equalsIgnoreCase(value)) continue;
                String sasOptionStr = gAOTemplate.getSASOptions();
                String resourceStr = gAOTemplate.getRequiredResources();
                String gridOptionStr = gAOTemplate.getGridOptions();
                newValue = "<html>" + this.bundle.getString("GridApplicationWizard.appobjectname.label.txt") + " " + value + "<br>";
                newValue = newValue.concat(this.bundle.getString("GridApplicationEditor.sasoption.label.txt") + " " + sasOptionStr + "<br>");
                newValue = newValue.concat(this.bundle.getString("GridApplicationEditor.reqdresources.label.txt") + " " + resourceStr + "<br>");
                newValue = newValue.concat(this.bundle.getString("GridApplicationEditor.gridoption.label.txt") + " " + gridOptionStr + "<br></html>");
                return newValue;
            }
        } else if (col.getName() != null && col.getName().equalsIgnoreCase(this.IDENTITY_COLNAME)) {
            List<Object> valueList = new ArrayList();
            if (value.trim().length() > 0) {
                String listValue = "<html>";
                valueList = this.parseStringIntoList(value, ";");
                for (String string : valueList) {
                    listValue = listValue.concat(string) + "<br>";
                }
                listValue = listValue.concat("</html>");
                return listValue;
            }
        }
        return value;
    }

    private String getStringFromList(List<String> valueList, String delimiter) {
        if (valueList == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (String nextValue : valueList) {
            if (!isFirst) {
                sb.append(delimiter);
            }
            sb.append(nextValue);
            isFirst = false;
        }
        return sb.toString();
    }

    private List<String> parseStringIntoList(String propertyValue, String delimiter) {
        if (propertyValue == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(propertyValue, delimiter);
        while (st.hasMoreTokens()) {
            String nextToken = st.nextToken();
            result.add(nextToken);
        }
        return result;
    }
}

