/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals.customizers.cas;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.remote.SASLibrary;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsDescriptionWizardTab;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.mgmt.visuals.PrototypeUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class CasLibraryConnectionPanel
extends WsDescriptionWizardTab {
    private static final String CAS_STATEMENT = "CasStatement";
    SASLibrary m_connection;
    private JCheckBox m_chkGenerateCas;
    private WATextField m_txtOptions;
    private JLabel m_lblOptions;
    private static final WAdminResource bundle = WAdminResource.getBundle(CasLibraryConnectionPanel.class);
    private static final long serialVersionUID = -830524542507057977L;
    private static String PROPERTY_NAME_GENERATE_CAS_STATEMENT = "GenerateCasStatement";
    private static String PROPERTY_NAME_CAS_STATEMENT_OPTIONS = "CasStatementOptions";
    private String m_machineName = null;
    private PropertySet m_casPropertySet = null;

    public CasLibraryConnectionPanel(SASLibrary connection) {
        this.m_connection = connection;
        this.initialize();
        this.layoutWidgets();
    }

    private PropertySet findCasPropertySet(String name, SASLibrary connection) throws RemoteException, MdException {
        for (PropertySet pSet : (PropertySet[])connection.getPropertySets().toArray((Object[])new PropertySet[connection.getPropertySets().size()])) {
            if (pSet == null || !CAS_STATEMENT.equals(pSet.getPropertySetName())) continue;
            return pSet;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Property findPropertyInPropertySet(PropertySet ps, String propertyName) {
        Property p = null;
        try {
            AssociationList properties = ps.getSetProperties();
            for (int i = 0; i < properties.size(); ++i) {
                p = (Property)properties.get(i);
                if (propertyName.equals(p.getPropertyName())) {
                    Property property = p;
                    return property;
                }
                p = null;
            }
            Property property = p;
            return property;
        }
        catch (MdException e) {
            e.printStackTrace();
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        finally {
            return p;
        }
    }

    private PropertySet createPropertySet(String name, SASLibrary connection) throws RemoteException, MdException {
        MdFactory factory = Workspace.getMdFactory();
        String repos = this.m_connection.getRepositoryID();
        PropertySet prop = (PropertySet)factory.createComplexMetadataObject((MdObjectStore)this.m_connection.getObjectStore(), null, name, "PropertySet", repos, null);
        prop.setName(name);
        prop.setPropertySetName(name);
        connection.getPropertySets().add((Object)prop);
        return prop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveDataToView() throws RemoteException, MdException {
        try {
            this.m_casPropertySet = this.findCasPropertySet(CAS_STATEMENT, this.m_connection);
            if (this.m_casPropertySet == null) {
                this.m_casPropertySet = this.createPropertySet(CAS_STATEMENT, this.m_connection);
                if (this.m_connection.isNewObject()) {
                    this.m_chkGenerateCas.setSelected(true);
                    this.onEnableURI();
                } else {
                    this.onEnableURI();
                }
            } else {
                Property propGenerateCasStatement = this.findPropertyInPropertySet(this.m_casPropertySet, PROPERTY_NAME_GENERATE_CAS_STATEMENT);
                if (propGenerateCasStatement != null) {
                    this.m_chkGenerateCas.setSelected(true);
                    this.onEnableURI();
                } else {
                    if (this.m_connection.isNewObject()) {
                        this.m_chkGenerateCas.setSelected(true);
                    }
                    this.onEnableURI();
                }
                Property propCasStatementOption = this.findPropertyInPropertySet(this.m_casPropertySet, PROPERTY_NAME_CAS_STATEMENT_OPTIONS);
                if (propCasStatementOption != null) {
                    String options = propCasStatementOption.getDefaultValue();
                    this.m_txtOptions.setText(options);
                }
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    private Property createCasProperty(String propertyName, String defaultValue, String sqlType) throws MdException, RemoteException {
        if (this.m_casPropertySet == null) {
            this.m_casPropertySet = this.createPropertySet(CAS_STATEMENT, this.m_connection);
        }
        MdFactory factory = Workspace.getMdFactory();
        String repos = this.m_connection.getRepositoryID();
        Property prop = (Property)factory.createComplexMetadataObject((MdObjectStore)this.m_connection.getObjectStore(), null, propertyName, "Property", repos, null);
        prop.setName(propertyName);
        prop.setPropertyName(propertyName);
        prop.setSQLType(16);
        prop.setDefaultValue(defaultValue);
        this.m_casPropertySet.getSetProperties().add((Object)prop);
        return prop;
    }

    public void moveDataToStore() throws RemoteException {
        try {
            if (!this.m_chkGenerateCas.isSelected()) {
                if (this.m_casPropertySet != null) {
                    AssociationList properties = this.m_casPropertySet.getSetProperties();
                    for (int i = 0; i < properties.size(); ++i) {
                        Property p = (Property)properties.get(i);
                        if (!PROPERTY_NAME_GENERATE_CAS_STATEMENT.equals(p.getPropertyName())) continue;
                        this.m_connection.getProperties().remove((Object)p);
                        PrototypeUtil.deleteProperty(p);
                        break;
                    }
                }
                return;
            }
            if (this.m_casPropertySet != null) {
                boolean foundCasProperty = false;
                AssociationList properties = this.m_casPropertySet.getSetProperties();
                for (int i = 0; i < properties.size(); ++i) {
                    Property p = (Property)properties.get(i);
                    if (!PROPERTY_NAME_GENERATE_CAS_STATEMENT.equals(p.getPropertyName())) continue;
                    foundCasProperty = true;
                }
                if (!foundCasProperty) {
                    this.createCasProperty(PROPERTY_NAME_GENERATE_CAS_STATEMENT, "true", "java.sql.Types.BOOLEAN");
                }
                boolean foundStatementProperty = false;
                String strValue = this.m_txtOptions.getText();
                for (int i = 0; i < properties.size(); ++i) {
                    Property p = (Property)properties.get(i);
                    if (!PROPERTY_NAME_CAS_STATEMENT_OPTIONS.equals(p.getPropertyName())) continue;
                    if (!strValue.equalsIgnoreCase(p.getDefaultValue())) {
                        p.setDefaultValue(strValue);
                    }
                    foundStatementProperty = true;
                }
                if (!foundStatementProperty) {
                    this.createCasProperty(PROPERTY_NAME_CAS_STATEMENT_OPTIONS, strValue, "java.sql.Types.VARCHAR");
                }
            }
        }
        catch (MdException e) {
            e.printStackTrace();
        }
    }

    public boolean validateData() {
        boolean bValidated = true;
        return bValidated;
    }

    public String createFinishString() {
        String strFinish = "";
        return strFinish;
    }

    public void onNext() {
    }

    public void onBack() {
    }

    String getReposID() {
        try {
            return "A0000001." + this.m_connection.getFQID().substring(0, 8);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return null;
        }
    }

    public void initialize() {
        this.m_chkGenerateCas = new JCheckBox(bundle.getString("CASStatementPanel.GenerateCASStatement.txt"));
        this.m_chkGenerateCas.setSelected(false);
        this.m_chkGenerateCas.setToolTipText(bundle.getString("CASStatementPanel.GenerateCASStatement.tooltip.txt"));
        this.m_chkGenerateCas.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                CasLibraryConnectionPanel.this.onEnableURI();
            }
        });
        this.m_txtOptions = new WATextField();
        this.m_lblOptions = WsUIUtilities.createLabelForComponent((JComponent)this.m_txtOptions, (String)bundle.getString("CASStatementPanel.CasStatementOption.txt"));
        this.m_txtOptions.setToolTipText(bundle.getString("CASStatementPanel.CasStatementOption.tooltip.txt"));
    }

    protected void onEnableURI() {
        this.m_txtOptions.setEnabled(this.m_chkGenerateCas.isSelected());
    }

    public void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        this.add(this.m_chkGenerateCas, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 5), 0, 0));
        this.add(this.m_lblOptions, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 5), 0, 0));
        this.add((Component)this.m_txtOptions, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 0, 5), 0, 0));
    }
}

