/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals;

import com.sas.metadata.remote.AbstractProperty;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.AttributeProperty;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Connection;
import com.sas.metadata.remote.DatabaseSchema;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.DeployedDataPackage;
import com.sas.metadata.remote.Extension;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertyGroup;
import com.sas.metadata.remote.PropertyType;
import com.sas.metadata.remote.Prototype;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.ServerContext;
import com.sas.metadata.remote.ServiceType;
import com.sas.metadata.remote.TextStore;
import com.sas.metadata.remote.Transformation;
import com.sas.metadata.remote.Tree;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPropertyDialog;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsDescriptionWizardTab;
import com.sas.workspace.mgmt.visuals.DBSchema;
import com.sas.workspace.mgmt.visuals.Library;
import com.sas.workspace.mgmt.visuals.LibraryWizard;
import com.sas.workspace.mgmt.visuals.PrototypeNotFoundException;
import com.sas.workspace.mgmt.visuals.PrototypeUtil;
import com.sas.workspace.mgmt.visuals.PrototypeWizard;
import com.sas.workspace.mgmt.visuals.Server;
import com.sas.workspace.mgmt.visuals.ServerWizard;
import com.sas.workspace.visuals.PrototypeSelector;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;

public class ServerTypePropertyView
extends WsDescriptionWizardTab {
    protected Server m_server;
    protected Library m_library;
    protected DBSchema m_schema;
    protected MdObjectStore m_objectStore;
    protected String m_strContext;
    protected PrototypeSelector m_selector;
    protected JTree m_tree;
    protected JScrollPane m_treePane;
    protected Vector m_dataList;
    protected List m_prototypeList;
    protected List m_displayedPrototypeList;
    protected Prototype m_prototype;
    protected static final WAdminResource bundle = new WAdminResource(ServerTypePropertyView.class);
    private static final long serialVersionUID = -2600212107604729004L;

    public ServerTypePropertyView(Server server, MdObjectStore objectStore) throws PrototypeNotFoundException {
        super(bundle.getString("ServerTypePropertyView.WizardTitle.Server.txt"));
        this.m_server = server;
        this.m_objectStore = objectStore;
        this.m_strContext = server.getContext();
        this._initialize();
        this._initializePrototypes(null, null, null);
        this._layoutWidgets();
    }

    public ServerTypePropertyView(Server server, MdObjectStore objectStore, String[] classIDArray) throws PrototypeNotFoundException {
        super(bundle.getString("ServerTypePropertyView.WizardTitle.Server.txt"));
        this.m_server = server;
        this.m_objectStore = objectStore;
        this.m_strContext = server.getContext();
        this._initialize();
        this._initializePrototypes(classIDArray, null, null);
        this._layoutWidgets();
    }

    public ServerTypePropertyView(Library library, MdObjectStore objectStore) throws PrototypeNotFoundException {
        super(bundle.getString("ServerTypePropertyView.WizardTitle.Library.txt"));
        this.m_library = library;
        this.m_objectStore = objectStore;
        this.m_strContext = library.getContext();
        this._initialize();
        this._initializePrototypes(null, null, null);
        this._layoutWidgets();
    }

    public ServerTypePropertyView(Library library, MdObjectStore objectStore, String[] engineArray) throws PrototypeNotFoundException {
        super(bundle.getString("ServerTypePropertyView.WizardTitle.Library.txt"));
        this.m_library = library;
        this.m_objectStore = objectStore;
        this.m_strContext = library.getContext();
        this._initialize();
        this._initializePrototypes(null, engineArray, null);
        this._layoutWidgets();
    }

    public ServerTypePropertyView(DBSchema schema, MdObjectStore objectStore) throws PrototypeNotFoundException {
        super(bundle.getString("ServerTypePropertyView.WizardTitle.Schema.txt"));
        this.m_schema = schema;
        this.m_objectStore = objectStore;
        this.m_strContext = schema.getContext();
        this._initialize();
        this._initializePrototypes(null, null, null);
        this._layoutWidgets();
    }

    public ServerTypePropertyView(DBSchema schema, MdObjectStore objectStore, String[] classIDArray) throws PrototypeNotFoundException {
        super(bundle.getString("ServerTypePropertyView.WizardTitle.Schema.txt"));
        this.m_schema = schema;
        this.m_objectStore = objectStore;
        this.m_strContext = schema.getContext();
        this._initialize();
        this._initializePrototypes(null, null, classIDArray);
        this._layoutWidgets();
    }

    public boolean validateData() {
        boolean bValid = false;
        Object nodeType = this.m_tree.getLastSelectedPathComponent();
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)nodeType;
        if (node != null) {
            bValid = node.isLeaf();
        }
        if (!bValid) {
            Container parent = this.getTopLevelAncestor();
            if (this.m_library != null) {
                JOptionPane.showMessageDialog(parent, bundle.getString("ServerTypePropertyView.TypeRequired.Library.txt"), bundle.getString("Common.RequiredField.txt"), 0);
            } else if (this.m_server != null) {
                JOptionPane.showMessageDialog(parent, bundle.getString("ServerTypePropertyView.TypeRequired.Server.txt"), bundle.getString("Common.RequiredField.txt"), 0);
            }
        }
        return bValid;
    }

    public void onTreeSelectionChanged() {
        try {
            Object nodeType;
            String strServerType = "";
            if (this.m_tree.getRowCount() > 0 && (nodeType = this.m_tree.getLastSelectedPathComponent()) instanceof DefaultMutableTreeNode) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)nodeType;
                strServerType = node.toString();
            }
            Prototype prototype = null;
            for (int i = 0; i < this.m_displayedPrototypeList.size(); ++i) {
                prototype = (Prototype)this.m_displayedPrototypeList.get(i);
                String protoypeName = PrototypeUtil.getDisplayString(prototype.getName(), prototype);
                if (!strServerType.equals(protoypeName)) continue;
                this.m_prototype = prototype;
                break;
            }
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
    }

    public void onNext() {
        block61: {
            try {
                int propIndex;
                Root root;
                String strType;
                Prototype previousPrototype;
                WAWizardDialog parent = (WAWizardDialog)this.getTopLevelAncestor();
                if (this.m_server != null) {
                    previousPrototype = (Prototype)parent.getWizardData("DeployedComponentPrototype");
                    if (previousPrototype != this.m_prototype) {
                        Server childServer;
                        strType = this.m_prototype.getMetadataType();
                        root = (Root)Workspace.getMdFactory().createComplexMetadataObject(this.m_objectStore, null, bundle.getString("Server.ServerIdentifierName.Server.txt"), strType, this.m_strContext.substring(9));
                        try {
                            LogicalServer wzdLs = (LogicalServer)parent.getWizardData("LogicalServer");
                            if (wzdLs != null) {
                                Vector<LogicalServer> removeList = new Vector<LogicalServer>();
                                removeList.add(wzdLs);
                                ((MdObjectStore)root.getObjectStore()).removeObjectsFromStore(removeList);
                            }
                            PropertyGroup primaryGroup = this.m_prototype.getPrimaryPropertyGroup();
                            AssociationList propertyList = primaryGroup.getGroupedProperties();
                            for (propIndex = 0; propIndex < propertyList.size(); ++propIndex) {
                                AttributeProperty attrProperty;
                                AbstractProperty ap = (AbstractProperty)propertyList.get(propIndex);
                                if (!(ap instanceof AttributeProperty) || !(attrProperty = (AttributeProperty)ap).getPropertyName().equalsIgnoreCase("ClassIdentifier") || !attrProperty.getDefaultValue().equalsIgnoreCase("b379c9c1-89e0-4e72-ba43-6a416899b5dd") && !attrProperty.getDefaultValue().equalsIgnoreCase("e803e04b-aaf0-4c74-86a6-f7008aa702dc")) continue;
                                LogicalServer logicalServer = (LogicalServer)Workspace.getMdFactory().createComplexMetadataObject((MdObjectStore)root.getObjectStore(), null, root.getName(), "LogicalServer", this.m_server.getContext().substring(9), null);
                                if (attrProperty.getDefaultValue().equalsIgnoreCase("b379c9c1-89e0-4e72-ba43-6a416899b5dd")) {
                                    logicalServer.setName(bundle.formatString("SASAppServerTypeView.LogicalServerIdentifierName.Logical.fmt.txt", (Object)root.getName()));
                                    logicalServer.setClassIdentifier("b379c9c1-89e0-4e72-ba43-6a416899b5dd");
                                }
                                if (attrProperty.getDefaultValue().equalsIgnoreCase("e803e04b-aaf0-4c74-86a6-f7008aa702dc")) {
                                    logicalServer.setName(bundle.formatString("ServerWizard.LogicalFederationName.fmt.txt", (Object)root.getName()));
                                    logicalServer.setClassIdentifier("e803e04b-aaf0-4c74-86a6-f7008aa702dc");
                                    root.setName(bundle.formatString("ServerWizard.FederationServerName.fmt.txt", (Object)root.getName()));
                                }
                                ServiceType serviceType = (ServiceType)Workspace.getMdFactory().createComplexMetadataObject((MdObjectStore)root.getObjectStore(), null, "Logical IOM Server", "ServiceType", this.m_server.getContext().substring(9), null);
                                try {
                                    Server logServer = new Server((MdObjectStore)logicalServer.getObjectStore(), this.m_server.getContext(), (DeployedComponent)logicalServer);
                                    Prototype logPrototype = logServer.getDeployedComponentPrototype((Component)((Object)this));
                                    if (logPrototype != null) {
                                        logicalServer.setUsingPrototype((Root)logPrototype);
                                        ServerWizard.setDefaultLogicalServerProperties(logicalServer, logPrototype, this.m_server.getContext());
                                    }
                                    logicalServer.getServiceTypes().add((Object)serviceType);
                                    logicalServer.getUsingComponents().add((Object)root);
                                    parent.replaceWizardData("LogicalServer", (Object)logicalServer);
                                }
                                catch (MdException exc) {
                                    MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                                }
                                catch (RemoteException exc) {
                                    Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
                                }
                                break;
                            }
                        }
                        catch (MdException exc) {
                            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                        }
                        Vector<DeployedComponent> dcsToRemoveList = new Vector<DeployedComponent>();
                        DeployedComponent mainDc = this.m_server.getDeployedComponent();
                        if (mainDc != null) {
                            dcsToRemoveList.add(mainDc);
                        }
                        if (!(root instanceof ServerContext)) {
                            childServer = (Server)parent.getWizardData("ChildServer");
                            if (childServer != null) {
                                DeployedComponent childDc = childServer.getDeployedComponent();
                                dcsToRemoveList.add(childDc);
                            }
                        } else {
                            childServer = (Server)parent.getWizardData("ChildServer");
                            DeployedComponent childDc = childServer.getDeployedComponent();
                            Map deletedObjectsMap = ((MdObjectStore)childDc.getObjectStore()).getDeletedObjects();
                            if (deletedObjectsMap.containsKey(childDc.getFQID())) {
                                ServerComponent sc = (ServerComponent)Workspace.getMdFactory().createComplexMetadataObject((MdObjectStore)childDc.getObjectStore(), null, bundle.getString("Server.ServerIdentifierName.Server.txt"), "ServerComponent", childServer.getContext().substring(9), null);
                                childServer.setDeployedComponent((DeployedComponent)sc);
                            }
                        }
                        block20: for (int dcIndex = 0; dcIndex < dcsToRemoveList.size(); ++dcIndex) {
                            DeployedComponent dc = (DeployedComponent)dcsToRemoveList.get(dcIndex);
                            ServerComponent sc = (ServerComponent)dc;
                            try {
                                TextStore propTypeText;
                                PropertyType propType;
                                PropertyType propType2;
                                Property prop;
                                AssociationList propList;
                                Vector<Object> objectsToRemoveList = new Vector<Object>();
                                if (dc instanceof ServerContext) {
                                    objectsToRemoveList.add(dc);
                                    propList = dc.getProperties();
                                    for (int propIndex2 = 0; propIndex2 < propList.size(); ++propIndex2) {
                                        prop = (Property)propList.get(propIndex2);
                                        objectsToRemoveList.add(prop);
                                        propType2 = prop.getOwningType();
                                        if (propType2 == null) continue;
                                        objectsToRemoveList.add(propType2);
                                        TextStore propTypeText2 = (TextStore)propType2.getStoredConfiguration();
                                        if (propTypeText2 == null) continue;
                                        objectsToRemoveList.add(propTypeText2);
                                    }
                                    AssociationList dcServiceTypesList = dc.getServiceTypes();
                                    for (int sTypeIndex = 0; sTypeIndex < dcServiceTypesList.size(); ++sTypeIndex) {
                                        ServiceType sType = (ServiceType)dcServiceTypesList.get(sTypeIndex);
                                        objectsToRemoveList.add(sType);
                                    }
                                    AssociationList dcLogicalList = dc.getUsingComponents();
                                    for (int logIndex = 0; logIndex < dcLogicalList.size(); ++logIndex) {
                                        LogicalServer ls = (LogicalServer)dcLogicalList.get(logIndex);
                                        objectsToRemoveList.add(ls);
                                        AssociationList lsPropList = ls.getProperties();
                                        for (int propIndex3 = 0; propIndex3 < lsPropList.size(); ++propIndex3) {
                                            Property prop2 = (Property)lsPropList.get(propIndex3);
                                            objectsToRemoveList.add(prop2);
                                            propType = prop2.getOwningType();
                                            if (propType == null) continue;
                                            objectsToRemoveList.add(propType);
                                            propTypeText = (TextStore)propType.getStoredConfiguration();
                                            if (propTypeText == null) continue;
                                            objectsToRemoveList.add(propTypeText);
                                        }
                                        AssociationList lsServiceTypesList = ls.getServiceTypes();
                                        for (int sTypeIndex = 0; sTypeIndex < lsServiceTypesList.size(); ++sTypeIndex) {
                                            ServiceType sType = (ServiceType)lsServiceTypesList.get(sTypeIndex);
                                            objectsToRemoveList.add(sType);
                                        }
                                        AssociationList lsServerList = ls.getUsingComponents();
                                        if (lsServerList.size() <= 0) continue;
                                        sc = (ServerComponent)lsServerList.get(0);
                                    }
                                    AssociationList dataPackagesList = dc.getDataPackages();
                                    for (int dpIndex = 0; dpIndex < dataPackagesList.size(); ++dpIndex) {
                                        DeployedDataPackage ddp = (DeployedDataPackage)dataPackagesList.get(dpIndex);
                                        if (ddp.getFQID().indexOf(36) == -1) continue;
                                        objectsToRemoveList.add(ddp);
                                        AssociationList ddpPropList = ddp.getProperties();
                                        for (int propIndex4 = 0; propIndex4 < ddpPropList.size(); ++propIndex4) {
                                            Property prop3 = (Property)ddpPropList.get(propIndex4);
                                            objectsToRemoveList.add(prop3);
                                            PropertyType propType3 = prop3.getOwningType();
                                            if (propType3 == null) continue;
                                            objectsToRemoveList.add(propType3);
                                            TextStore propTypeText3 = (TextStore)propType3.getStoredConfiguration();
                                            if (propTypeText3 == null) continue;
                                            objectsToRemoveList.add(propTypeText3);
                                        }
                                    }
                                }
                                objectsToRemoveList.add(sc);
                                propList = sc.getProperties();
                                for (int propIndex5 = 0; propIndex5 < propList.size(); ++propIndex5) {
                                    prop = (Property)propList.get(propIndex5);
                                    objectsToRemoveList.add(prop);
                                    propType2 = prop.getOwningType();
                                    if (propType2 == null) continue;
                                    objectsToRemoveList.add(propType2);
                                    TextStore propTypeText4 = (TextStore)propType2.getStoredConfiguration();
                                    if (propTypeText4 == null) continue;
                                    objectsToRemoveList.add(propTypeText4);
                                }
                                AssociationList scConnList = sc.getSourceConnections();
                                for (int connIndex = 0; connIndex < scConnList.size(); ++connIndex) {
                                    Connection scConn = (Connection)scConnList.get(connIndex);
                                    objectsToRemoveList.add(scConn);
                                    AssociationList connPropList = scConn.getProperties();
                                    for (int propIndex6 = 0; propIndex6 < connPropList.size(); ++propIndex6) {
                                        Property prop4 = (Property)connPropList.get(propIndex6);
                                        objectsToRemoveList.add(prop4);
                                        PropertyType propType4 = prop4.getOwningType();
                                        if (propType4 == null) continue;
                                        objectsToRemoveList.add(propType4);
                                        TextStore propTypeText5 = (TextStore)propType4.getStoredConfiguration();
                                        if (propTypeText5 == null) continue;
                                        objectsToRemoveList.add(propTypeText5);
                                    }
                                }
                                AssociationList scInitList = sc.getInitProcesses();
                                for (int initIndex = 0; initIndex < scInitList.size(); ++initIndex) {
                                    Transformation scTransform = (Transformation)scInitList.get(initIndex);
                                    objectsToRemoveList.add(scTransform);
                                    AssociationList tranPropList = scTransform.getProperties();
                                    for (int propIndex7 = 0; propIndex7 < tranPropList.size(); ++propIndex7) {
                                        Property prop5 = (Property)tranPropList.get(propIndex7);
                                        objectsToRemoveList.add(prop5);
                                        propType = prop5.getOwningType();
                                        if (propType == null) continue;
                                        objectsToRemoveList.add(propType);
                                        propTypeText = (TextStore)propType.getStoredConfiguration();
                                        if (propTypeText == null) continue;
                                        objectsToRemoveList.add(propTypeText);
                                    }
                                }
                                AssociationList scServiceTypesList = sc.getServiceTypes();
                                for (int sTypeIndex = 0; sTypeIndex < scServiceTypesList.size(); ++sTypeIndex) {
                                    ServiceType sType = (ServiceType)scServiceTypesList.get(sTypeIndex);
                                    objectsToRemoveList.add(sType);
                                }
                                ((MdObjectStore)dc.getObjectStore()).removeObjectsFromStore(objectsToRemoveList);
                                for (int objIndex = 0; objIndex < objectsToRemoveList.size(); ++objIndex) {
                                    Root objRoot = (Root)objectsToRemoveList.get(objIndex);
                                    if (!(objRoot instanceof LogicalServer)) continue;
                                    parent.removeWizardData("LogicalServersList");
                                    continue block20;
                                }
                                continue;
                            }
                            catch (MdException exc) {
                                MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                                continue;
                            }
                            catch (RemoteException exc) {
                                Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
                            }
                        }
                        this.m_server.setDeployedComponent((DeployedComponent)root);
                        if ((DeployedComponent)root instanceof ServerContext) {
                            parent.replaceWizardData("ServerContext", (Object)root);
                        } else {
                            parent.replaceWizardData("DeployedComponent", (Object)root);
                        }
                    }
                    parent.addWizardData("ServerType", (Object)((DefaultMutableTreeNode)this.m_tree.getLastSelectedPathComponent()).toString());
                    if (this.m_prototype.getMetadataType().equals("ServerContext")) {
                        parent.addWizardData("ServerContextPrototype", (Object)this.m_prototype);
                    } else {
                        parent.addWizardData("DeployedComponentPrototype", (Object)this.m_prototype);
                    }
                }
                if (this.m_library != null) {
                    Tree tree = null;
                    Prototype previousPrototype2 = (Prototype)parent.getWizardData("DeployedDataPackagePrototype");
                    if (previousPrototype2 != this.m_prototype) {
                        String strType2 = this.m_prototype.getMetadataType();
                        Root root2 = (Root)Workspace.getMdFactory().createComplexMetadataObject(this.m_objectStore, null, bundle.getString("Library.LibraryIdentifierName.Library.txt"), strType2, this.m_strContext.substring(9));
                        DeployedDataPackage ddp = this.m_library.getDeployedDataPackage();
                        try {
                            SASLibrary lib;
                            if (ddp.getTrees().size() > 0) {
                                tree = (Tree)ddp.getTrees().get(0);
                            }
                            Vector<Object> objectsToRemoveList = new Vector<Object>();
                            objectsToRemoveList.add(ddp);
                            AssociationList propList = ddp.getProperties();
                            for (int propIndex8 = 0; propIndex8 < propList.size(); ++propIndex8) {
                                Property prop = (Property)propList.get(propIndex8);
                                objectsToRemoveList.add(prop);
                                PropertyType propType = prop.getOwningType();
                                if (propType == null) continue;
                                objectsToRemoveList.add(propType);
                                TextStore propTypeText = (TextStore)propType.getStoredConfiguration();
                                if (propTypeText == null) continue;
                                objectsToRemoveList.add(propTypeText);
                            }
                            if (ddp instanceof SASLibrary && (lib = (SASLibrary)ddp).getDefaultLogin() != null) {
                                objectsToRemoveList.add(lib.getDefaultLogin());
                            }
                            AssociationList usingPackagesList = ddp.getUsingPackages();
                            for (int i = 0; i < usingPackagesList.size(); ++i) {
                                Root packageRoot = (Root)usingPackagesList.get(i);
                                if (packageRoot.getFQID().indexOf("$") == -1) continue;
                                objectsToRemoveList.add(packageRoot);
                            }
                            ((MdObjectStore)ddp.getObjectStore()).removeObjectsFromStore(objectsToRemoveList);
                        }
                        catch (MdException exc) {
                            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                        }
                        catch (RemoteException exc) {
                            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
                        }
                        this.m_library.setDeployedDataPackage((DeployedDataPackage)root2);
                        try {
                            if (tree != null) {
                                this.m_library.getDeployedDataPackage().getTrees().add((Object)tree);
                            }
                        }
                        catch (MdException mdex) {
                            Workspace.getDefaultLogger().error((Object)mdex.getLocalizedMessage());
                        }
                        catch (RemoteException rex) {
                            Workspace.getDefaultLogger().error((Object)rex.getLocalizedMessage());
                        }
                    }
                    parent.addWizardData("LibraryType", (Object)((DefaultMutableTreeNode)this.m_tree.getLastSelectedPathComponent()).toString());
                    parent.addWizardData("DeployedDataPackagePrototype", (Object)this.m_prototype);
                }
                if (this.m_schema == null) break block61;
                previousPrototype = (Prototype)parent.getWizardData("DatabaseSchemaPrototype");
                if (previousPrototype != this.m_prototype) {
                    strType = this.m_prototype.getMetadataType();
                    root = (Root)Workspace.getMdFactory().createComplexMetadataObject(this.m_objectStore, null, bundle.getString("DBSchema.SchemaIdentifierName.Schema.txt"), strType, this.m_strContext.substring(9));
                    DatabaseSchema schema = this.m_schema.getSchema();
                    try {
                        Vector<Object> objectsToRemoveList = new Vector<Object>();
                        objectsToRemoveList.add(schema);
                        AssociationList propList = schema.getProperties();
                        for (propIndex = 0; propIndex < propList.size(); ++propIndex) {
                            Property prop = (Property)propList.get(propIndex);
                            objectsToRemoveList.add(prop);
                            PropertyType propType = prop.getOwningType();
                            if (propType == null) continue;
                            objectsToRemoveList.add(propType);
                            TextStore propTypeText = (TextStore)propType.getStoredConfiguration();
                            if (propTypeText == null) continue;
                            objectsToRemoveList.add(propTypeText);
                        }
                        ((MdObjectStore)schema.getObjectStore()).removeObjectsFromStore(objectsToRemoveList);
                    }
                    catch (MdException exc) {
                        MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                    }
                    catch (RemoteException exc) {
                        Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
                    }
                    this.m_schema.setSchema((DatabaseSchema)root);
                }
                parent.addWizardData("SchemaType", (Object)((DefaultMutableTreeNode)this.m_tree.getLastSelectedPathComponent()).toString());
                parent.addWizardData("DatabaseSchemaPrototype", (Object)this.m_prototype);
            }
            catch (RemoteException exc) {
                Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
            }
        }
    }

    public void onBack() {
        this.m_dataList.removeAllElements();
        WAWizardDialog parent = (WAWizardDialog)this.getTopLevelAncestor();
        if (this.m_server != null) {
            parent.removeWizardData("ServerType");
            if (this.m_server.getDeployedComponent() instanceof ServerContext) {
                parent.removeWizardData("ServerContextPrototype");
            } else {
                parent.removeWizardData("DeployedComponentPrototype");
            }
        }
        if (this.m_library != null) {
            parent.removeWizardData("LibraryType");
            parent.removeWizardData("DeployedDataPackagePrototype");
        }
        if (this.m_schema != null) {
            parent.removeWizardData("SchemaType");
            parent.removeWizardData("DeployedDataPackagePrototype");
        }
    }

    protected void _initializePrototypes(String[] classIDArray, String[] engineArray, String[] classIDArray2) throws PrototypeNotFoundException {
        try {
            String strTemplate = bundle.getString("Prototype.Template.Extensions.notrans");
            String strSelect = "";
            if (this.m_server != null) {
                strSelect = bundle.getString("Prototype.Select.ServerComponent.notrans");
            }
            if (this.m_library != null) {
                strSelect = bundle.getString("Prototype.Select.SASLibrary.notrans");
            }
            if (this.m_schema != null) {
                strSelect = bundle.getString("Prototype.Select.Schema.notrans");
            }
            if (classIDArray != null) {
                strSelect = this._getXMLSELECTString("PrototypeProperties", "ClassIdentifier", classIDArray);
            }
            if (engineArray != null) {
                strSelect = this._getXMLSELECTString("PrototypeProperties", bundle.getString("Prototype.Select.Engine.notrans"), engineArray);
            }
            if (classIDArray2 != null) {
                strSelect = this._getXMLSELECTString(bundle.getString("Prototype.Select.Extensions.notrans"), "ServerClassIdentifier", classIDArray);
            }
            String strOptions = strTemplate + strSelect;
            int flags = 8588;
            try {
                this.m_prototypeList = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)this.m_objectStore, this.m_strContext, "Prototype", flags, strOptions);
            }
            catch (MdException exc) {
                MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Reading");
                return;
            }
            catch (RemoteException exc) {
                Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
            }
            String strCategory = "";
            if (this.m_server != null) {
                strCategory = bundle.getString("PrototypeSelector.Category.Servers.txt");
            }
            if (this.m_library != null) {
                strCategory = bundle.getString("PrototypeSelector.Category.Libraries.txt");
            }
            if (this.m_schema != null) {
                strCategory = bundle.getString("PrototypeSelector.Category.Schemas.txt");
            }
            Vector<Prototype> defaultPrototypesList = new Vector<Prototype>();
            Locale locale = Locale.getDefault();
            for (int i = 0; i < this.m_prototypeList.size(); ++i) {
                Prototype prototype;
                boolean bPrototypeFound;
                block38: {
                    bPrototypeFound = false;
                    prototype = (Prototype)this.m_prototypeList.get(i);
                    try {
                        String localeValue;
                        Extension extension;
                        int extIndex;
                        AssociationList extensionList = prototype.getExtensions();
                        for (extIndex = 0; extIndex < extensionList.size(); ++extIndex) {
                            extension = (Extension)extensionList.get(extIndex);
                            if (!extension.getName().equals("Locale")) continue;
                            localeValue = extension.getValue();
                            if (!localeValue.equalsIgnoreCase("Generic")) break;
                            defaultPrototypesList.add(prototype);
                            bPrototypeFound = true;
                            break;
                        }
                        if (bPrototypeFound) break block38;
                        for (extIndex = 0; extIndex < extensionList.size(); ++extIndex) {
                            extension = (Extension)extensionList.get(extIndex);
                            if (!extension.getName().equals("Locale")) continue;
                            localeValue = extension.getValue();
                            if (localeValue.equalsIgnoreCase("Generic")) {
                                bPrototypeFound = true;
                            }
                            break;
                        }
                    }
                    catch (MdException exc) {
                        MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                        return;
                    }
                    catch (RemoteException exc) {
                        Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
                    }
                }
                if (!bPrototypeFound) continue;
                this.m_dataList.add(PrototypeUtil.getDisplayString(prototype.getName(), prototype));
                this.m_displayedPrototypeList.add(prototype);
                this._addPrototypeToTree(prototype, strCategory);
            }
            if (this.m_dataList.isEmpty() && !locale.equals(PrototypeUtil.getLocale("en_US"))) {
                for (int dpIndex = 0; dpIndex < defaultPrototypesList.size(); ++dpIndex) {
                    Prototype dPrototype = (Prototype)defaultPrototypesList.get(dpIndex);
                    this.m_dataList.add(PrototypeUtil.getDisplayString(dPrototype.getName(), dPrototype));
                    this.m_displayedPrototypeList.add(dPrototype);
                    this._addPrototypeToTree(dPrototype, strCategory);
                }
            }
            if (this.m_dataList.isEmpty()) {
                int returnValue;
                String strMessage = "";
                String strTitle = "";
                String strCannotDefineMessage = "";
                Component parentComp = this.getTopLevelAncestor();
                if (this.m_server != null) {
                    strMessage = bundle.getString("ServerTypePropertyView.NoResourceTemplatesInstalled.Server.txt");
                    strTitle = bundle.getString("ServerTypePropertyView.NoResourceTemplates.Server.txt");
                    strCannotDefineMessage = bundle.getString("ServerTypePropertyView.CannotDefine.Server.txt");
                    if (parentComp == null) {
                        parentComp = this.m_server.getParentComponent();
                    }
                }
                if (this.m_library != null) {
                    strMessage = bundle.getString("ServerTypePropertyView.NoResourceTemplatesInstalled.Library.txt");
                    strTitle = bundle.getString("ServerTypePropertyView.NoResourceTemplates.Library.txt");
                    strCannotDefineMessage = bundle.getString("ServerTypePropertyView.CannotDefine.Library.txt");
                    if (parentComp == null) {
                        parentComp = this.m_library.getParentComponent();
                    }
                }
                if (this.m_schema != null) {
                    strMessage = bundle.getString("ServerTypePropertyView.NoResourceTemplatesInstalled.Schema.txt");
                    strTitle = bundle.getString("ServerTypePropertyView.NoResourceTemplates.Schema.txt");
                    strCannotDefineMessage = bundle.getString("ServerTypePropertyView.CannotDefine.Schema.txt");
                    if (parentComp == null) {
                        parentComp = this.m_schema.getParentComponent();
                    }
                }
                if ((returnValue = MessageUtil.displayMessage((String)strMessage, (String)strTitle, (int)2, (int)0)) == 0) {
                    PrototypeWizard wizard = null;
                    if (parentComp instanceof Frame) {
                        wizard = new PrototypeWizard((Frame)parentComp, this.m_strContext);
                    } else if (parentComp instanceof Dialog) {
                        wizard = new PrototypeWizard((Dialog)parentComp, this.m_strContext);
                    }
                    wizard.show();
                    if (wizard.getReturnValue() == 2) {
                        MessageUtil.displayMessage((String)strCannotDefineMessage, (String)bundle.getString("Common.Information.txt"), (int)1);
                        throw new PrototypeNotFoundException();
                    }
                    this._initializePrototypes(classIDArray, engineArray, classIDArray2);
                } else {
                    MessageUtil.displayMessage((String)strCannotDefineMessage, (String)bundle.getString("Common.Information.txt"), (int)1);
                    throw new PrototypeNotFoundException();
                }
            }
            int rowCount = 0;
            while (rowCount != this.m_tree.getRowCount()) {
                for (int i = 0; i < this.m_tree.getRowCount(); ++i) {
                    this.m_tree.expandRow(i);
                }
                rowCount = this.m_tree.getRowCount();
            }
            this.m_tree.setSelectionRow(0);
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
    }

    protected void _addPrototypeToTree(Prototype prototype, String strCategory) {
        String strSubCategory = "";
        try {
            AssociationList extensionsList = prototype.getExtensions();
            for (int j = 0; j < extensionsList.size(); ++j) {
                Extension extension = (Extension)extensionsList.get(j);
                if (!extension.getName().equalsIgnoreCase("UITreeCategory")) continue;
                strSubCategory = PrototypeUtil.getDisplayString(extension.getValue());
                break;
            }
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Reading");
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
        try {
            AssociationList propertiesList = prototype.getPrototypeProperties();
            boolean bPropertyFound = false;
            for (int j = 0; j < propertiesList.size(); ++j) {
                CMetadata root;
                DeployedDataPackage ddp;
                AbstractProperty property = (AbstractProperty)propertiesList.get(j);
                if (!(property instanceof AttributeProperty)) continue;
                AttributeProperty ap = (AttributeProperty)property;
                if (ap.getPropertyName().equals("ClassIdentifier")) {
                    ArrayList plugins;
                    if (ap.getDefaultValue().equalsIgnoreCase("440196d4-90f0-11d0-9f41-00a024bb830c") || ap.getDefaultValue().equalsIgnoreCase("15931e31-667f-11d5-8804-00c04f35ac8c") || ap.getDefaultValue().equalsIgnoreCase("0217e202-b560-11db-ad91-001083ff6836") || ap.getDefaultValue().equalsIgnoreCase("f3f46472-1e31-11d5-87c2-00c04f38f9f6") || ap.getDefaultValue().equalsIgnoreCase("028e4060-d545-11d5-880d-aa0004006d06") || ap.getDefaultValue().equalsIgnoreCase("D7E796B4-654C-4ab3-B690-657EE79309FB") || ap.getDefaultValue().equalsIgnoreCase("d6644527-7a09-4fe2-8bac-1caca2f6a46c") || ap.getDefaultValue().equalsIgnoreCase("e20e54b3-e5f4-47ed-b21d-03109bf9a4b8") || ap.getDefaultValue().equalsIgnoreCase("0069e914-b58c-4094-a686-a87df433ec4b") || ap.getDefaultValue().equalsIgnoreCase("a1ff485f-9e44-4c82-90b5-062916cfa9b9") || ap.getDefaultValue().equalsIgnoreCase("620963ee-32bf-4128-bf5f-4b0df8ff90eb") || ap.getDefaultValue().equalsIgnoreCase("510A5F10-8E07-44AC-942B-EFB5A4782A39") || ap.getDefaultValue().equalsIgnoreCase("94D98CD0-56C5-40A3-A140-49D21D17BDCE")) {
                        bPropertyFound = true;
                        break;
                    }
                    if ((ap.getDefaultValue().equalsIgnoreCase("5C498B69-E34F-4e89-9B6A-C4744DF115EC") || ap.getDefaultValue().equalsIgnoreCase("7BE029B7-95DF-41e6-A0C9-E05BC15D6704")) && (plugins = Workspace.getWorkspace().getPluginLoader().getPlugins("com.sas.rdm.plugins.rtdmgr.RDMPlugin")).size() == 0) {
                        bPropertyFound = true;
                        break;
                    }
                }
                if (this.m_library == null) continue;
                Component parent = this.m_library.getParentComponent();
                SASLibrary library = null;
                if (parent instanceof LibraryWizard && (ddp = ((LibraryWizard)((Object)parent)).m_library.getDeployedDataPackage()) instanceof SASLibrary) {
                    library = (SASLibrary)ddp;
                }
                if (parent instanceof WAPropertyDialog && (root = ((WAPropertyDialog)parent).getMetadataObject()) instanceof SASLibrary) {
                    library = (SASLibrary)root;
                }
                if (library == null || !library.getEngine().startsWith("REMOTE") || !ap.getPropertyName().equals("Engine") || !ap.getDefaultValue().startsWith("REMOTE")) continue;
                bPropertyFound = true;
                break;
            }
            AssociationList extensionsList = prototype.getExtensions();
            for (int extIndex = 0; extIndex < extensionsList.size(); ++extIndex) {
                Extension extension = (Extension)extensionsList.get(extIndex);
                if (!extension.getName().equals("ServerClassIdentifier") || !extension.getValue().equalsIgnoreCase("0217e202-b560-11db-ad91-001083ff6836")) continue;
                bPropertyFound = true;
                break;
            }
            if (bPropertyFound) {
                return;
            }
            String strName = PrototypeUtil.getDisplayString(prototype.getName(), prototype);
            String strDesc = PrototypeUtil.getDisplayString(prototype.getDesc(), prototype);
            if (strName.startsWith("Missing resource")) {
                return;
            }
            strName = strCategory + "." + strSubCategory + "." + strName;
            this.m_selector.buildTree(strName, strDesc);
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
    }

    protected String _getXMLSELECTString(String strAssociation, String strAttribute, String[] array) {
        String strNameAttribute = bundle.getString("Prototype.Select.Name.notrans");
        String strValueAttribute = bundle.getString("Prototype.Select.Value.notrans");
        if (strAssociation.equalsIgnoreCase("PrototypeProperties")) {
            strNameAttribute = bundle.getString("Prototype.Select.Property.notrans") + strNameAttribute;
            strValueAttribute = bundle.getString("Prototype.Select.Default.notrans") + strValueAttribute;
        }
        String strSelect = "<XMLSELECT search=\"*";
        if (strAttribute.equalsIgnoreCase("ClassIdentifier")) {
            strSelect = strSelect + "[@MetadataType='ServerContext' OR @MetadataType='ServerComponent']";
        }
        strSelect = strSelect + "[" + strAssociation + "/*[@" + strNameAttribute + "='" + strAttribute + "' AND (@" + strValueAttribute + "='" + array[0] + "'";
        for (int i = 1; array.length > 1 && i < array.length; ++i) {
            strSelect = strSelect + " OR @" + strValueAttribute + "='" + array[i] + "'";
        }
        strSelect = strSelect + ")]]\"/>";
        return strSelect;
    }

    protected void _initialize() {
        if (this.m_server != null) {
            this.setHelpProduct("newserver");
            this.setHelpTopic("servwiz_1");
        }
        if (this.m_library != null) {
            this.setHelpProduct("newlibrary");
            this.setHelpTopic("libwiz_2");
        }
        if (this.m_schema != null) {
            this.setHelpProduct("newschema");
            this.setHelpTopic("dbwiz_1");
        }
        this.m_dataList = new Vector();
        this.m_displayedPrototypeList = new Vector();
        this.m_selector = new PrototypeSelector(bundle.getString("PrototypeSelector.Category.ResourceTemplates.txt"), this.m_objectStore);
        this.m_tree = this.m_selector.getTree();
        this.m_tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent event) {
                ServerTypePropertyView.this.onTreeSelectionChanged();
            }
        });
        this.m_treePane = new JScrollPane(this.m_tree, 20, 30);
        this.m_treePane.setBorder(BorderFactory.createLoweredBevelBorder());
        this.m_treePane.setMinimumSize(new Dimension(400, 350));
        this.m_treePane.setPreferredSize(new Dimension(400, 350));
    }

    protected void _layoutWidgets() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        int gridy = 0;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(12, 12, 0, 12);
        gridBagLayout.setConstraints(this.m_treePane, gbc);
        this.add(this.m_treePane);
    }
}

