/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Extension;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PropertyGroup;
import com.sas.metadata.remote.Prototype;
import com.sas.metadata.remote.Root;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsDescriptionWizardTab;
import com.sas.workspace.mgmt.visuals.DBSchema;
import com.sas.workspace.mgmt.visuals.PropertiesPropertyView;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SchemaPropertyView
extends WsDescriptionWizardTab {
    private static final long serialVersionUID = 1L;
    protected DBSchema m_schema;
    protected Prototype m_schemaPrototype;
    protected int m_type;
    protected JPanel m_view;
    private static final WAdminResource bundle = WAdminResource.getBundle(SchemaPropertyView.class);

    public SchemaPropertyView(DBSchema schema, int type) {
        super(bundle.getString("SchemaPropertyView.WizardTitle.txt"));
        this.m_schema = schema;
        this.m_type = type;
        this._initialize();
        this._layoutWidgets(false);
    }

    public boolean doDataExchange(boolean bSaveToModel) {
        if (bSaveToModel) {
            this.moveDataToStore();
        } else {
            this.populateStore();
            this.moveDataToView();
        }
        return false;
    }

    public void moveDataToStore() {
        if (this.m_type == 1 && this.m_view instanceof PropertiesPropertyView) {
            this._setViewProperties();
        }
    }

    public void populateStore() {
        if (this.m_type == 1) {
            try {
                if (this.m_schemaPrototype == null) {
                    this.m_schemaPrototype = this.m_schema.getDatabaseSchemaPrototype(this.getTopLevelAncestor());
                }
            }
            catch (MdException e) {
                e.printStackTrace();
            }
            catch (RemoteException re) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
            }
        }
    }

    public void moveDataToView() {
        this.getTopLevelAncestor().setCursor(Cursor.getPredefinedCursor(3));
        if (this.m_type == 0) {
            WAWizardDialog parent = (WAWizardDialog)this.getTopLevelAncestor();
            this.m_schemaPrototype = (Prototype)parent.getWizardData("DatabaseSchemaPrototype");
        }
        if (this.m_type == 1) {
            try {
                if (this.m_schemaPrototype == null) {
                    this.m_schemaPrototype = this.m_schema.getDatabaseSchemaPrototype(this.getTopLevelAncestor(), true);
                }
            }
            catch (MdException e) {
                e.printStackTrace();
            }
            catch (RemoteException re) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
            }
        }
        this.removeAll();
        this._layoutWidgets(true);
        this.revalidate();
        if (this.m_view instanceof PropertiesPropertyView) {
            ((PropertiesPropertyView)((Object)this.m_view)).doDataExchange(false);
        }
        this.getTopLevelAncestor().setCursor(Cursor.getPredefinedCursor(0));
    }

    public boolean validateData() {
        if (this.m_view instanceof PropertiesPropertyView) {
            return ((PropertiesPropertyView)((Object)this.m_view)).validateData();
        }
        return true;
    }

    protected void _setViewProperties() {
        try {
            ((PropertiesPropertyView)((Object)this.m_view)).setViewProperties();
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
        }
    }

    public void onNext() {
        try {
            if (this.m_view instanceof PropertiesPropertyView) {
                ((PropertiesPropertyView)((Object)this.m_view)).onNext();
            }
            this.m_schema.getSchema().setUsingPrototype((Root)this.m_schemaPrototype);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    public void onBack() {
        if (this.m_view instanceof PropertiesPropertyView) {
            ((PropertiesPropertyView)((Object)this.m_view)).onBack();
        }
    }

    public String createFinishString() {
        String strFinish = "";
        if (this.m_view instanceof PropertiesPropertyView) {
            strFinish = strFinish + ((PropertiesPropertyView)((Object)this.m_view)).createFinishString();
        }
        return strFinish;
    }

    public Component getDefaultFocusComponent() {
        Component comp = null;
        if (this.m_view instanceof PropertiesPropertyView) {
            comp = ((PropertiesPropertyView)((Object)this.m_view)).getDefaultFocusComponent();
        }
        return comp;
    }

    public void saveSettingsAndCleanUp() {
        if (this.m_view instanceof PropertiesPropertyView) {
            ((PropertiesPropertyView)((Object)this.m_view)).saveSettingsAndCleanUp();
        }
    }

    protected void _initialize() {
        this.setName(bundle.getString("SchemaPropertyView.TabName.txt"));
    }

    protected void _layoutWidgets(boolean bShowErrorMessage) {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        int gridy = 0;
        PropertyGroup group = null;
        try {
            if (this.m_schemaPrototype != null) {
                group = this.m_schemaPrototype.getPrimaryPropertyGroup();
            }
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
        }
        if (group != null) {
            Hashtable propertiesTable = null;
            if (this.m_type == 0) {
                WAWizardDialog parent = (WAWizardDialog)this.getTopLevelAncestor();
                propertiesTable = (Hashtable)parent.getWizardData("Properties");
            }
            this.m_view = new PropertiesPropertyView((Root)this.m_schema.getSchema(), group, this.m_type, propertiesTable, this.m_schemaPrototype);
            try {
                AssociationList extensionList = group.getExtensions();
                for (int extIndex = 0; extIndex < extensionList.size(); ++extIndex) {
                    Extension extension = (Extension)extensionList.get(extIndex);
                    if (extension.getName().equalsIgnoreCase("HelpSet")) {
                        String strHelpSet = extension.getValue();
                        this.setHelpProduct(strHelpSet);
                    }
                    if (!extension.getName().equalsIgnoreCase("HelpTopicSimple")) continue;
                    String strHelpTopic = extension.getValue();
                    this.setHelpTopic(strHelpTopic);
                }
            }
            catch (MdException exc) {
                MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
            }
            catch (RemoteException re) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
            }
        } else {
            this.m_view = new JPanel();
            this.m_view.setPreferredSize(new Dimension(475, 300));
            if (bShowErrorMessage) {
                this.m_view.add(new JLabel(bundle.getString("Common.UnableToShowProperties.txt")));
            }
        }
        if (this.m_view instanceof PropertiesPropertyView) {
            ((PropertiesPropertyView)((Object)this.m_view)).setMinimumViewHeight(250);
        }
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.gridwidth = 0;
        gbc.insets = new Insets(12, 0, 0, 12);
        gridBagLayout.setConstraints(this.m_view, gbc);
        this.add(this.m_view);
    }
}

