/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals;

import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.ServerContext;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.OpRequestUI;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WATransitionWizardModel;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAWizardModel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.mgmt.visuals.ConnectionPropertyView;
import com.sas.workspace.mgmt.visuals.ConnectionTypeView;
import com.sas.workspace.mgmt.visuals.GeneralPropertyView;
import com.sas.workspace.mgmt.visuals.OLAPSchemaView;
import com.sas.workspace.mgmt.visuals.SASAppServerTypeView;
import com.sas.workspace.mgmt.visuals.Server;
import com.sas.workspace.mgmt.visuals.ServerConfigView;
import com.sas.workspace.mgmt.visuals.ServerPropertyView;
import com.sas.workspace.visuals.WizardFinishTab;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.rmi.RemoteException;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JFrame;

public class SASAppServerComponentWizard
extends WAWizardDialog {
    private static final long serialVersionUID = 1L;
    protected Server m_server;
    protected Server m_childServer;
    protected LogicalServer m_logicalServer;
    protected ServerContext m_serverContext;
    protected JFrame m_frame;
    protected Dialog m_dialog;
    protected Component m_component;
    protected String m_strContext;
    protected String m_strTitle;
    protected MdObjectStore m_objectStore = null;
    protected SASAppServerTypeView m_appTab;
    protected boolean m_bShowWizard = true;
    private static final WAdminResource bundle = WAdminResource.getBundle(SASAppServerComponentWizard.class);

    public SASAppServerComponentWizard(JFrame frame, String strContext, ServerContext serverContext) {
        super((Frame)frame, true);
        try {
            String strTitle;
            ServerContext tempServerContext;
            this.setHelpProduct("newserver");
            Object storedata = this.getWizardData("OBJECTSTORE");
            Boolean bDisposeStore = false;
            this.replaceWizardData("DisposeStore", bDisposeStore);
            if (storedata instanceof MdObjectStore) {
                this.m_objectStore = (MdObjectStore)storedata;
                this.m_objectStore.setIsObjectCopiedFromParentOnCreation(false);
            }
            this.m_serverContext = tempServerContext = (ServerContext)Workspace.getMdFactory().createComplexMetadataObject(this.m_objectStore, null, serverContext.getName(), serverContext.getCMetadataType(), serverContext.getId(), null);
            this.m_server = new Server(this.m_objectStore, strContext, (DeployedComponent)tempServerContext);
            this.m_server.setParentComponent(frame);
            this.m_childServer = new Server(this.m_objectStore, strContext);
            this.m_childServer.setParentComponent(frame);
            this.m_component = frame;
            this.m_strContext = strContext;
            this.m_strTitle = strTitle = bundle.getString("SASAppServerComponentWizard.Title.txt");
            WATransitionWizardModel model = new WATransitionWizardModel();
            this.setWizardModel((WAWizardModel)model);
            this.addWizardTabs(model, strTitle);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    public Root getMetadataObject() {
        return (Root)this.getWizardData("DeployedComponent");
    }

    public String getTitle() {
        return this.m_strTitle;
    }

    public void setPreferredSize(Dimension dimension) {
        this.getMainPanel().setPreferredSize(dimension);
    }

    public void show() {
        boolean bl = this.m_bShowWizard = !this.m_server.getLogicalServerComponentPrototypes(this.m_component).isEmpty();
        if (this.m_bShowWizard) {
            super.show();
        } else {
            MessageUtil.displayMessage((String)bundle.getString("SASAppServerComponentWizard.NoComponentsToAdd.txt"), (String)bundle.getString("Common.Information.txt"), (int)1);
        }
    }

    protected void addWizardTabs(WATransitionWizardModel model, String strTitle) {
        this.setTitle(strTitle);
        this.m_appTab = new SASAppServerTypeView(this.m_server, 0);
        this.addTab(strTitle, "SASAppServer", (WAPropertyTab)this.m_appTab, bundle.getString("ServerWizard.ServerTypeImage.image"), bundle.getImageIcon("ServerWizard.ServerTypeImage.image"));
        ServerConfigView configTab = new ServerConfigView(this.m_server);
        this.addTab(strTitle, "ServerConfig", (WAPropertyTab)configTab, bundle.getString("Common.NameDescriptionTab.image"), bundle.getImageIcon("Common.NameDescriptionTab.image"));
        GeneralPropertyView generalTab = new GeneralPropertyView(this.m_childServer, 0);
        this.addTab(strTitle, "General", (WAPropertyTab)generalTab, bundle.getString("Common.NameDescriptionTab.image"), bundle.getImageIcon("Common.NameDescriptionTab.image"));
        ServerPropertyView propertyTab = new ServerPropertyView(this.m_childServer, 0);
        this.addTab(strTitle, "Server", (WAPropertyTab)propertyTab, bundle.getString("Common.PropertiesTab.image"), bundle.getImageIcon("Common.PropertiesTab.image"));
        ConnectionTypeView connTypeTab = new ConnectionTypeView();
        this.addTab(strTitle, "ConnectionType", (WAPropertyTab)connTypeTab, bundle.getString("ServerWizard.ConnectionInfoImage.image"), bundle.getImageIcon("ServerWizard.ConnectionInfoImage.image"));
        ConnectionPropertyView connectionTab = new ConnectionPropertyView(0);
        this.addTab(strTitle, "Connection", (WAPropertyTab)connectionTab, bundle.getString("ServerWizard.ConnectionInfoImage.image"), bundle.getImageIcon("ServerWizard.ConnectionInfoImage.image"));
        OLAPSchemaView olapTab = new OLAPSchemaView(this.m_server, 0);
        this.addTab(strTitle, "OLAPSchema", (WAPropertyTab)olapTab, bundle.getString("Common.PropertiesTab.image"), bundle.getImageIcon("Common.PropertiesTab.image"));
        WizardFinishTab finishTab = new WizardFinishTab(bundle.getString("ServerWizard.DefinitionSuccess.txt"));
        finishTab.setHelpProduct("newserver");
        finishTab.setHelpTopic("servwiz_6");
        this.addTab(strTitle, "Completion", (WAPropertyTab)finishTab, bundle.getString("Common.FinishTab.image"), bundle.getImageIcon("Common.FinishTab.image"));
        String[][] transitions = new String[][]{{"SASAppServer", "NEXT", "ServerConfig"}, {"SASAppServer", "BATCH", "General"}, {"ServerConfig", "NEXT", "Completion"}, {"ServerConfig", "CUSTOM", "General"}, {"General", "NEXT", "Connection"}, {"General", "SERVER", "Server"}, {"Server", "NEXT", "Completion"}, {"Server", "CONNECTION", "Connection"}, {"Server", "CONNECTIONTYPE", "ConnectionType"}, {"ConnectionType", "NEXT", "Connection"}, {"Connection", "NEXT", "Completion"}, {"Connection", "OLAPSCHEMA", "OLAPSchema"}, {"OLAPSchema", "NEXT", "Completion"}};
        model.addTransitions(transitions);
        this.addWizardData("Server", this.m_server);
        this.addWizardData("ChildServer", this.m_childServer);
        this.addWizardData("ServerContext", this.m_serverContext);
        this.addWizardData("DeployedComponent", this.m_childServer.getDeployedComponent());
        try {
            this.addWizardData("ServerContextPrototype", this.m_server.getDeployedComponentPrototype((Component)((Object)this)));
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
        }
    }

    public boolean onCompletion() {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            List requestList = (List)this.getWizardData("MetadataRequestList");
            List logicalServerList = (List)this.getWizardData("LogicalServersList");
            if (requestList != null) {
                for (int i = 0; i < requestList.size(); ++i) {
                    LogicalServer logicalServer;
                    block12: {
                        String strRequest = (String)requestList.get(i);
                        logicalServer = (LogicalServer)logicalServerList.get(i);
                        try {
                            String strStart = "<Metadata>";
                            String strEnd = "</Metadata>";
                            String strXML = strRequest.substring(strRequest.indexOf(strStart), strRequest.indexOf(strEnd) + strEnd.length());
                            Workspace.getMdFactory().getOMIUtil().populateStoreFromString(this.m_server.getDeployedComponent().getObjectStore(), strXML, 1, true);
                        }
                        catch (Exception exc) {
                            String strMessage = exc.getMessage();
                            if (!(exc instanceof MdException)) break block12;
                            MessageUtil.displayMessage((String)strMessage, (int)0);
                        }
                    }
                    List changeList = this.m_server.getDeployedComponent().getObjectStore().getChangedObjects();
                    for (int changeIndex = 0; changeIndex < changeList.size(); ++changeIndex) {
                        Root changeRoot = (Root)changeList.get(changeIndex);
                        if (!changeRoot.getCMetadataType().equals("ServerComponent") || !((ServerComponent)changeRoot).getClassIdentifier().equals(logicalServer.getClassIdentifier())) continue;
                        try {
                            logicalServer.getUsingComponents().add((Object)changeRoot);
                            continue;
                        }
                        catch (MdException exc) {
                            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                            continue;
                        }
                        catch (RemoteException re) {
                            Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
                        }
                    }
                }
            }
            try {
                this.m_server.persist();
            }
            catch (MdException exc) {
                MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Writing");
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
            return super.onFinish();
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return false;
        }
    }

    protected boolean onFinish() {
        this.dispose();
        OpRequestUI request = new OpRequestUI((JDialog)((Object)this), bundle.getString("WriteMetadataProgressIndicator.Msg.Message.txt"), bundle.getString("WriteMetadataProgressIndicator.Msg.Title"));
        cOnCompletionRunnable ocr = this.createOnCompletionRunnable();
        request.execute((Runnable)ocr);
        return ocr.getReturnValue();
    }

    protected cOnCompletionRunnable createOnCompletionRunnable() {
        return new cOnCompletionRunnable();
    }

    protected class cOnCompletionRunnable
    implements Runnable {
        boolean returnValue = false;

        @Override
        public synchronized void run() {
            this.returnValue = SASAppServerComponentWizard.this.onCompletion();
        }

        public synchronized boolean getReturnValue() {
            return this.returnValue;
        }
    }
}

