/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals;

import com.sas.meta.SASOMI.IOMI;
import com.sas.metadata.remote.Identity;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Person;
import com.sas.svcs.metadata.mgmt.client.MetadataRepositoryService;
import com.sas.svcs.metadata.mgmt.client.Repository;
import com.sas.visuals.Resources;
import com.sas.workspace.ListDescriptionInterface;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.mgmt.IdentityReposPair;
import com.sas.workspace.mgmt.RepositoryUtil;
import com.sas.workspace.mgmt.visuals.ListDescriptionPanel;
import java.awt.Component;
import java.awt.SystemColor;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class NewReposIdentityListPanel
extends ListDescriptionPanel {
    private static final long serialVersionUID = 1L;
    private static final WAdminResource bundle = WAdminResource.getBundle(NewReposIdentityListPanel.class);
    private List m_ownerIDs = new ArrayList();
    private MetadataRepositoryService repositoryService = null;

    public NewReposIdentityListPanel(ListDescriptionInterface info, MetadataRepositoryService repositoryService) {
        super(info);
        this.m_list.setCellRenderer(new IdentityListCellRenderer());
        this.repositoryService = repositoryService;
    }

    @Override
    public boolean doDataExchange(boolean bSaveToModel) {
        WAWizardDialog wizard = (WAWizardDialog)this.getTopLevelAncestor();
        if (!bSaveToModel) {
            this.m_ownerIDs.clear();
            this.m_dataList = this._createListData();
            if (this.m_dataList.size() <= 0) {
                MessageUtil.displayMessage((String)bundle.getString("NewReposWizard.IdentityPanel.Error.txt"), (int)0);
            }
            this.m_list.setListData(this.m_dataList);
            if ((IdentityReposPair)wizard.getWizardData("IdentityForProject") != null) {
                IdentityReposPair projUser = (IdentityReposPair)wizard.getWizardData("IdentityForProject");
                Identity owner = projUser.getOwner();
                try {
                    int ind = this.m_ownerIDs.indexOf(owner.getFQID());
                    if (ind != -1) {
                        this.m_list.setSelectedIndex(ind);
                    }
                }
                catch (RemoteException ex) {
                    Workspace.handleRemoteException((RemoteException)ex);
                }
            }
        }
        return true;
    }

    public void onBack() {
        WAWizardDialog wizard = (WAWizardDialog)this.getTopLevelAncestor();
        Object selItem = this.getSelectedItem();
        if (selItem != null) {
            wizard.replaceWizardData(this.m_wizardDataTag, selItem);
        }
    }

    @Override
    public boolean validateData() {
        if (this.m_dataList.size() <= 0) {
            MessageUtil.displayMessage((String)bundle.getString("NewReposWizard.IdentityPanel.Error.txt"), (int)0);
            return false;
        }
        Object owner = this.getSelectedItem();
        if (owner == null) {
            MessageUtil.displayMessage((String)bundle.getString("NewReposWizard.IdentityPanel.MustChoose.txt"), (int)0);
            return false;
        }
        IdentityReposPair idPairObj = (IdentityReposPair)owner;
        Identity ident = idPairObj.getOwner();
        try {
            boolean allowed = RepositoryUtil.isConnectedUserAuthorizedOnIdentity(Workspace.getMdFactory(), ident);
            if (!allowed) {
                MessageUtil.displayMessage((String)bundle.getString("NewReposWizard.IdentityPanel.NotAuthorized.txt"), (int)0);
                return false;
            }
        }
        catch (Exception e) {
            MessageUtil.displayMessage((String)e.getMessage(), (int)0);
            return false;
        }
        this.setConditionState("NEXT");
        return true;
    }

    protected Vector _createListData() {
        try {
            WAWizardDialog wizard = (WAWizardDialog)this.getTopLevelAncestor();
            IOMI connection = (IOMI)wizard.getWizardData("Connection");
            Vector<IdentityReposPair> identityList = new Vector<IdentityReposPair>(0);
            MdObjectStore store = (MdObjectStore)wizard.getWizardData("OBJECTSTORE");
            if (store == null) {
                store = Workspace.getMdFactory().createObjectStore(null, "NewReposWizard Store");
                wizard.addWizardData("OBJECTSTORE", (Object)store);
            }
            try {
                Repository foundation = null;
                foundation = this.repositoryService.getFoundationRepository();
                Vector tempIdList = RepositoryUtil.getIdentityObjects(store, Workspace.getMdFactory(), foundation.getId());
                for (int j = 0; j < tempIdList.size(); ++j) {
                    IdentityReposPair obj = (IdentityReposPair)tempIdList.get(j);
                    Identity cmObj = obj.getOwner();
                    if (!(cmObj instanceof Person) || identityList.contains(obj)) continue;
                    identityList.add(obj);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Collections.sort(identityList, new IdComparator());
            for (int j = 0; j < identityList.size(); ++j) {
                IdentityReposPair obj = (IdentityReposPair)identityList.get(j);
                this.m_ownerIDs.add(obj.getOwner().getFQID());
            }
            return identityList;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return new Vector(0);
        }
    }

    public String createFinishString() {
        try {
            WAWizardDialog wizard = (WAWizardDialog)this.getTopLevelAncestor();
            StringBuffer finishString = new StringBuffer("");
            finishString.append(bundle.getString("NewReposWizard.ProjectCreatedFor.txt") + "\n   ");
            IdentityReposPair ownerObj = (IdentityReposPair)wizard.getWizardData("IdentityForProject");
            Identity owner = ownerObj.getOwner();
            finishString.append(owner.getName());
            finishString.append("\n\n");
            return finishString.toString();
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return null;
        }
    }

    static /* synthetic */ WAdminResource access$000() {
        return bundle;
    }

    class IdentityListCellRenderer
    implements ListCellRenderer {
        WAdminResource m_bundle = NewReposIdentityListPanel.access$000();
        public final ImageIcon m_userIcon = Resources.getImageIcon((String)this.m_bundle.getString("Images.User.image"), (int)16);

        IdentityListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            try {
                JLabel label = new JLabel();
                IdentityReposPair idPairObj = (IdentityReposPair)value;
                Identity idObj = idPairObj.getOwner();
                if (idObj instanceof Person) {
                    Person per = (Person)idObj;
                    label.setText(per.getName());
                    label.setIcon(this.m_userIcon);
                }
                label.setOpaque(true);
                if (isSelected) {
                    label.setBackground(SystemColor.textHighlight);
                    label.setForeground(SystemColor.textHighlightText);
                } else {
                    label.setBackground(SystemColor.window);
                    label.setForeground(SystemColor.textText);
                }
                return label;
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
                return null;
            }
        }
    }

    class IdComparator
    implements Comparator {
        IdComparator() {
        }

        public int compare(Object obj1, Object obj2) {
            try {
                IdentityReposPair idObj1 = (IdentityReposPair)obj1;
                IdentityReposPair idObj2 = (IdentityReposPair)obj2;
                Identity id1 = idObj1.getOwner();
                Identity id2 = idObj2.getOwner();
                return id1.getName().compareToIgnoreCase(id2.getName());
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
                return -1;
            }
        }
    }
}

