/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals;

import com.sas.workspace.ListDescriptionInterface;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WsDescriptionWizardTab;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ListDescriptionPanel
extends WsDescriptionWizardTab {
    private static final long serialVersionUID = 1L;
    protected JLabel m_panelTitle;
    protected JSeparator m_separator;
    protected JList m_list;
    protected JScrollPane m_listPane;
    protected WATextArea m_descText;
    protected String m_panelTitleText;
    protected Vector m_dataList;
    protected Vector m_descriptionList;
    protected String m_wizardDataTag;

    public ListDescriptionPanel(ListDescriptionInterface info) {
        super(info.getListTitle());
        this.m_dataList = info.getDataList();
        this.m_descriptionList = info.getDescriptionList();
        this.m_wizardDataTag = info.getWizardDataTag();
        this._initialize();
        this._layoutWidgets();
    }

    public Object getSelectedItem() {
        return this.m_list.getSelectedValue();
    }

    protected void _setDescription(String description) {
        if (this.m_descText != null) {
            this.m_descText.setText(description);
        }
    }

    public boolean doDataExchange(boolean bSaveToModel) {
        return true;
    }

    public boolean validateData() {
        this.setConditionState("NEXT");
        return true;
    }

    public void onListSelectionChanged(int selectedIndex) {
        if (this.m_descriptionList != null) {
            this._setDescription((String)this.m_descriptionList.get(selectedIndex));
        }
    }

    public void onNext() {
        WAWizardDialog wizard = (WAWizardDialog)this.getTopLevelAncestor();
        Object selItem = this.getSelectedItem();
        if (selItem != null) {
            wizard.replaceWizardData(this.m_wizardDataTag, selItem);
        }
    }

    protected void _initialize() {
        this.m_list = new JList();
        if (this.m_dataList != null) {
            this.m_list.setListData(this.m_dataList);
        }
        this.m_list.setSelectionMode(0);
        this.m_list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                ListDescriptionPanel.this.onListSelectionChanged(ListDescriptionPanel.this.m_list.getSelectedIndex());
            }
        });
        this.m_listPane = new JScrollPane(this.m_list, 22, 30);
        this.m_listPane.setBorder(BorderFactory.createLoweredBevelBorder());
        this.m_listPane.setMinimumSize(new Dimension(50, 50));
        if (this.m_descriptionList != null) {
            this.m_descText = new WATextArea();
            this.m_descText.setEditable(false);
            this.m_descText.setLineWrap(true);
            this.m_descText.setWrapStyleWord(true);
            this.m_descText.setBorder(null);
            this.m_descText.setBackground(this.getBackground());
        }
        if (this.m_dataList != null) {
            this.m_list.setSelectedIndex(0);
        }
    }

    protected void _layoutWidgets() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        int gridy = 0;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.weightx = 1.0;
        if (this.m_descText == null) {
            gbc.weighty = 1.0;
        }
        gbc.fill = 1;
        gbc.insets = new Insets(12, 12, 0, 12);
        gridBagLayout.setConstraints(this.m_listPane, gbc);
        this.add(this.m_listPane);
        ++gridy;
        if (this.m_descText != null) {
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = gridy;
            gbc.weightx = 0.1;
            gbc.fill = 2;
            gbc.anchor = 17;
            gbc.insets = new Insets(12, 12, 0, 12);
            gridBagLayout.setConstraints((Component)this.m_descText, gbc);
            this.add((Component)this.m_descText);
        }
    }
}

