/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals;

import com.sas.metadata.logical.UtilMetadata;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.DeployedDataPackage;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertyType;
import com.sas.metadata.remote.Prototype;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.TextStore;
import com.sas.metadata.remote.Tree;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.OpRequestUI;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WATransitionWizardModel;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAWizardModel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.mgmt.visuals.AssignLibraryView;
import com.sas.workspace.mgmt.visuals.AuthorizationView;
import com.sas.workspace.mgmt.visuals.DBMSLibnamePropertyView;
import com.sas.workspace.mgmt.visuals.GeneralPropertyView;
import com.sas.workspace.mgmt.visuals.Library;
import com.sas.workspace.mgmt.visuals.LibraryPropertyView;
import com.sas.workspace.mgmt.visuals.PrototypeNotFoundException;
import com.sas.workspace.mgmt.visuals.ServerTypePropertyView;
import com.sas.workspace.mgmt.visuals.ServerWizard;
import com.sas.workspace.visuals.WizardFinishTab;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JFrame;

public class LibraryWizard
extends WAWizardDialog {
    private static final long serialVersionUID = 1L;
    protected Library m_library;
    protected boolean m_bShowWizard = true;
    private AuthorizationView m_authTab = null;
    private static final WAdminResource bundle = WAdminResource.getBundle(LibraryWizard.class);

    public LibraryWizard(JFrame frame, String strContext) {
        this(frame, strContext, null, (MdObjectStore)null);
    }

    public LibraryWizard(JFrame frame, String strContext, String strTitle) {
        this(frame, strContext, strTitle, (MdObjectStore)null);
    }

    public LibraryWizard(JFrame frame, String strContext, String strTitle, MdObjectStore objectStore) {
        this(frame, strContext, strTitle, (String[])null, objectStore);
    }

    public LibraryWizard(JFrame frame, String strContext, String strTitle, String strEngine) {
        this(frame, strContext, strTitle, strEngine, null);
    }

    public LibraryWizard(JFrame frame, String strContext, String strTitle, String strEngine, MdObjectStore objectStore) {
        this(frame, strContext, strTitle, new String[]{strEngine}, objectStore);
    }

    public LibraryWizard(JFrame frame, String strContext, String strTitle, String[] engineArray) {
        this(frame, strContext, strTitle, engineArray, null);
    }

    public LibraryWizard(JFrame frame, String strContext, String strTitle, String[] engineArray, MdObjectStore objectStore) {
        this(frame, strContext, strTitle, engineArray, objectStore, null);
    }

    public LibraryWizard(JFrame frame, String strContext, String strTitle, String[] engineArray, MdObjectStore objectStore, Hashtable propertiesTable) {
        this(frame, strContext, strTitle, engineArray, objectStore, propertiesTable, null);
    }

    public LibraryWizard(JFrame frame, String strContext, String strTitle, String[] engineArray, MdObjectStore objectStore, Hashtable propertiesTable, Tree tree) {
        super((Frame)frame, true, objectStore);
        this._init(frame, strContext, strTitle, engineArray, propertiesTable, tree);
    }

    public LibraryWizard(Dialog dialog, String strContext) {
        this(dialog, strContext, null, (MdObjectStore)null);
    }

    public LibraryWizard(Dialog dialog, String strContext, String strTitle) {
        this(dialog, strContext, strTitle, (MdObjectStore)null);
    }

    public LibraryWizard(Dialog dialog, String strContext, String strTitle, MdObjectStore objectStore) {
        this(dialog, strContext, strTitle, (String[])null, objectStore);
    }

    public LibraryWizard(Dialog dialog, String strContext, String strTitle, String strEngine) {
        this(dialog, strContext, strTitle, strEngine, null);
    }

    public LibraryWizard(Dialog dialog, String strContext, String strTitle, String strEngine, MdObjectStore objectStore) {
        this(dialog, strContext, strTitle, new String[]{strEngine}, objectStore);
    }

    public LibraryWizard(Dialog dialog, String strContext, String strTitle, String[] engineArray) {
        this(dialog, strContext, strTitle, engineArray, null);
    }

    public LibraryWizard(Dialog dialog, String strContext, String strTitle, String[] engineArray, MdObjectStore objectStore) {
        this(dialog, strContext, strTitle, engineArray, objectStore, null);
    }

    public LibraryWizard(Dialog dialog, String strContext, String strTitle, String[] engineArray, MdObjectStore objectStore, Hashtable propertiesTable) {
        this(dialog, strContext, strTitle, engineArray, objectStore, propertiesTable, null);
    }

    public LibraryWizard(Dialog dialog, String strContext, String strTitle, String[] engineArray, MdObjectStore objectStore, Hashtable propertiesTable, Tree tree) {
        super(dialog, true, objectStore);
        this._init(dialog, strContext, strTitle, engineArray, propertiesTable, tree);
    }

    protected void _init(Component component, String strContext, String strTitle, String[] engineArray, Hashtable propertiesTable, Tree tree) {
        try {
            String strEngine;
            int i;
            this.setHelpProduct("newlibrary");
            if (strTitle == null || strTitle.length() == 0) {
                strTitle = bundle.getString("LibraryWizard.Title.txt");
            }
            MdObjectStore objectStore = (MdObjectStore)this.getWizardData("OBJECTSTORE");
            Boolean bDisposeStore = new Boolean(false);
            this.replaceWizardData("DisposeStore", bDisposeStore);
            DeployedDataPackage ddPackage = null;
            if (propertiesTable != null) {
                Enumeration e = propertiesTable.keys();
                while (e.hasMoreElements()) {
                    Root elementRoot = (Root)e.nextElement();
                    if (!elementRoot.getCMetadataType().equalsIgnoreCase("DeployedDataPackage") && !elementRoot.getCMetadataType().equalsIgnoreCase("SASLibrary")) continue;
                    ddPackage = (DeployedDataPackage)elementRoot;
                    break;
                }
            }
            this.m_library = ddPackage != null ? new Library(strContext, ddPackage, objectStore) : new Library(strContext, objectStore);
            try {
                if (tree != null) {
                    this.m_library.getDeployedDataPackage().getTrees().add((Object)tree);
                }
            }
            catch (MdException mdex) {
                Workspace.getDefaultLogger().error((Object)mdex.getLocalizedMessage());
            }
            catch (RemoteException rex) {
                Workspace.getDefaultLogger().error((Object)rex.getLocalizedMessage());
            }
            this.m_library.setParentComponent(component);
            WATransitionWizardModel model = new WATransitionWizardModel();
            this.setWizardModel((WAWizardModel)model);
            if (propertiesTable != null) {
                this.replaceWizardData("Properties", propertiesTable);
            }
            for (int i2 = 0; engineArray != null && i2 < engineArray.length; ++i2) {
                String strEngine2 = engineArray[i2];
                if (!strEngine2.equalsIgnoreCase("SAS") && !strEngine2.equalsIgnoreCase("V7") && !strEngine2.equalsIgnoreCase("V701") && !strEngine2.equalsIgnoreCase("V8") && !strEngine2.equalsIgnoreCase("V9")) continue;
                engineArray[i2] = "BASE";
            }
            boolean bFoundDB2UNXPC = false;
            boolean bFoundDB2OS390 = false;
            for (i = 0; engineArray != null && i < engineArray.length; ++i) {
                strEngine = engineArray[i];
                if (strEngine.equalsIgnoreCase("DB2UNXPC")) {
                    bFoundDB2UNXPC = true;
                }
                if (!strEngine.equalsIgnoreCase("DB2OS390")) continue;
                bFoundDB2OS390 = true;
            }
            if (engineArray != null && engineArray.length == 1) {
                Prototype prototype;
                String strAssociation = "PrototypeProperties";
                String strAttribute = "Engine";
                if (bFoundDB2UNXPC || bFoundDB2OS390) {
                    strAssociation = "Extensions";
                    strAttribute = "ServerClassIdentifier";
                }
                boolean bl = this.m_bShowWizard = (prototype = ServerWizard.getPrototype(strAssociation, strAttribute, engineArray[0], strContext, objectStore, component, this, "DeployedDataPackagePrototype")) != null;
                if (prototype != null) {
                    String strType = prototype.getMetadataType();
                    Root root = (Root)Workspace.getMdFactory().createComplexMetadataObject(objectStore, null, bundle.getString("Library.LibraryIdentifierName.Library.txt"), strType, strContext.substring(9));
                    DeployedDataPackage ddp = this.m_library.getDeployedDataPackage();
                    try {
                        Vector<Object> objectsToRemoveList = new Vector<Object>();
                        objectsToRemoveList.add(ddp);
                        AssociationList propList = ddp.getProperties();
                        for (int propIndex = 0; propIndex < propList.size(); ++propIndex) {
                            Property prop = (Property)propList.get(propIndex);
                            objectsToRemoveList.add(prop);
                            PropertyType propType = prop.getOwningType();
                            if (propType == null) continue;
                            objectsToRemoveList.add(propType);
                            TextStore propTypeText = (TextStore)propType.getStoredConfiguration();
                            if (propTypeText == null) continue;
                            objectsToRemoveList.add(propTypeText);
                        }
                        if (ddp instanceof SASLibrary) {
                            SASLibrary lib = (SASLibrary)ddp;
                            objectsToRemoveList.add(lib.getDefaultLogin());
                        }
                        ((MdObjectStore)ddp.getObjectStore()).removeObjectsFromStore(objectsToRemoveList);
                        if (propertiesTable != null) {
                            propertiesTable.put(root, propertiesTable.remove(ddp));
                            this.replaceWizardData("Properties", propertiesTable);
                        }
                    }
                    catch (MdException exc) {
                        MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                    }
                    catch (RemoteException re) {
                        Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
                    }
                    this.m_library.setDeployedDataPackage((DeployedDataPackage)root);
                    try {
                        if (tree != null) {
                            this.m_library.getDeployedDataPackage().getTrees().add((Object)tree);
                        }
                    }
                    catch (MdException mdex) {
                        Workspace.getDefaultLogger().error((Object)mdex.getLocalizedMessage());
                    }
                    catch (RemoteException rex) {
                        Workspace.getDefaultLogger().error((Object)rex.getLocalizedMessage());
                    }
                }
            } else {
                try {
                    for (i = 0; engineArray != null && i < engineArray.length; ++i) {
                        strEngine = engineArray[i];
                        if (!strEngine.equalsIgnoreCase("DB2UNXPC") && !strEngine.equalsIgnoreCase("DB2OS390")) continue;
                        engineArray[i] = "DB2";
                    }
                    ServerTypePropertyView libraryTypeTab = new ServerTypePropertyView(this.m_library, objectStore, engineArray);
                    this.addTab(strTitle, "ServerType", (WAPropertyTab)libraryTypeTab, bundle.getString("Common.NameDescriptionTab.image"), bundle.getImageIcon("Common.NameDescriptionTab.image"));
                    String[][] transition = new String[][]{{"ServerType", "NEXT", "General"}};
                    model.addTransitions(transition);
                }
                catch (PrototypeNotFoundException exc) {
                    this.m_bShowWizard = false;
                }
            }
            this.addWizardTabs(model, strTitle);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    public void setPreferredSize(Dimension dimension) {
        this.getMainPanel().setPreferredSize(dimension);
    }

    public void show() {
        if (this.m_bShowWizard) {
            super.show();
        }
    }

    public boolean onCompletion() {
        block4: {
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                SASLibrary library;
                this.m_library.persist();
                if (!(this.m_library.getDeployedDataPackage() instanceof SASLibrary) || !(library = (SASLibrary)this.m_library.getDeployedDataPackage()).getEngine().equalsIgnoreCase("SASIOLA")) break block4;
                MdStore store = library.getObjectStore();
                String strReposID = this.m_library.getContext();
                String strSelect = "<XMLSELECT search=\"*[@Name='" + library.getName() + "']\" />";
                int flags = 8600;
                List lstLibraries = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset(store, strReposID, "SASLibrary", flags, strSelect);
                int index = 0;
                while (index < lstLibraries.size()) {
                    SASLibrary lib = (SASLibrary)lstLibraries.get(index);
                    String strPath = (String)this.getWizardData("FolderLocation");
                    if (strPath == null || !UtilMetadata.getPath((Tree)((Tree)lib.getTrees().get(0)), (boolean)true).equalsIgnoreCase(strPath)) continue;
                    this.m_authTab.setAdministerPermission(lib.getFQID());
                    break;
                }
            }
            catch (MdException exc) {
                MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Writing");
            }
            catch (RemoteException exc) {
                Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
            }
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
        return super.doCleanup();
    }

    protected boolean onFinish() {
        int iRC;
        Workspace workspace = Workspace.getWorkspace();
        if (workspace.isServerStatusCheckEnabled() && workspace.getCMRHandle() != null && ((iRC = workspace.checkMetadataServerStatus(true)) == Workspace.SERVERSTATUS_ERROR || iRC == Workspace.SERVERSTATUS_PAUSED)) {
            return false;
        }
        this.dispose();
        OpRequestUI request = new OpRequestUI((JDialog)((Object)this), bundle.getString("WriteMetadataProgressIndicator.Msg.Message.txt"), bundle.getString("WriteMetadataProgressIndicator.Msg.Title"));
        request.setProgressShownOnStatusBar(false);
        cOnCompletionRunnable ocr = this.createOnCompletionRunnable();
        request.execute((Runnable)ocr);
        return ocr.getReturnValue();
    }

    protected void addWizardTabs(WATransitionWizardModel model, String title) {
        this.setTitle(title);
        GeneralPropertyView generalTab = new GeneralPropertyView(this.m_library, 0);
        this.addTab(title, "General", (WAPropertyTab)generalTab, bundle.getString("Common.NameDescriptionTab.image"), bundle.getImageIcon("Common.NameDescriptionTab.image"));
        LibraryPropertyView propertyTab = new LibraryPropertyView(this.m_library, 0);
        this.addTab(title, "Library", (WAPropertyTab)propertyTab, bundle.getString("Common.PropertiesTab.image"), bundle.getImageIcon("Common.PropertiesTab.image"));
        DBMSLibnamePropertyView dbmsTab = new DBMSLibnamePropertyView(this.m_library, 0);
        this.addTab(title, "DBMSLibname", (WAPropertyTab)dbmsTab, bundle.getString("Common.NameDescriptionTab.image"), bundle.getImageIcon("Common.NameDescriptionTab.image"));
        AssignLibraryView assignTab = new AssignLibraryView(this.m_library, 0);
        this.addTab(title, "AssignLibrary", (WAPropertyTab)assignTab, bundle.getString("LibraryWizard.assignTab.image"), bundle.getImageIcon("LibraryWizard.assignTab.image"));
        this.m_authTab = new AuthorizationView(this.m_library);
        this.addTab(title, "Authorization", (WAPropertyTab)this.m_authTab, bundle.getString("Common.PropertiesTab.image"), bundle.getImageIcon("Common.PropertiesTab.image"));
        WizardFinishTab finishTab = new WizardFinishTab(bundle.getString("LibraryWizard.DefinitionSuccess.txt"));
        finishTab.setHelpProduct("newlibrary");
        finishTab.setHelpTopic("libwiz_6");
        this.addTab(title, "Completion", (WAPropertyTab)finishTab, bundle.getString("Common.FinishTab.image"), bundle.getImageIcon("Common.FinishTab.image"));
        String[][] transitions = new String[][]{{"General", "NEXT", "AssignLibrary"}, {"AssignLibrary", "NEXT", "Library"}, {"Library", "NEXT", "Completion"}, {"Library", "ISDBMSLIBNAME", "DBMSLibname"}, {"DBMSLibname", "NEXT", "Completion"}, {"DBMSLibname", "AUTHORIZATION", "Authorization"}, {"Authorization", "NEXT", "Completion"}};
        model.addTransitions(transitions);
        this.addWizardData("Library", this.m_library);
    }

    protected cOnCompletionRunnable createOnCompletionRunnable() {
        return new cOnCompletionRunnable();
    }

    protected class cOnCompletionRunnable
    implements Runnable {
        boolean returnValue = false;

        @Override
        public synchronized void run() {
            this.returnValue = LibraryWizard.this.onCompletion();
        }

        public synchronized boolean getReturnValue() {
            return this.returnValue;
        }
    }
}

