/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals;

import com.sas.metadata.remote.DeployedDataPackage;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.SASLibrary;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsDescriptionWizardTab;
import com.sas.workspace.mgmt.visuals.Library;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class LibraryAliasForView
extends WsDescriptionWizardTab {
    private static final long serialVersionUID = 1L;
    protected Library m_library;
    protected int m_type;
    protected JList m_list;
    protected JScrollPane m_listPane;
    protected Vector m_dataList;
    protected WATextArea m_descText;
    protected List m_librariesList;
    private static final WAdminResource bundle = WAdminResource.getBundle(LibraryAliasForView.class);

    public LibraryAliasForView(Library library, int type) {
        super(bundle.getString("LibraryAliasForView.Title.txt"));
        this.m_library = library;
        this.m_type = type;
        this.setHelpTopic("libwiz_1a");
        this._initialize();
        this._layoutWidgets();
    }

    public boolean doDataExchange(boolean bSaveToModel) {
        if (!bSaveToModel) {
            String strLibraryTemplate = bundle.formatString("LibraryAliasForView.DeployedDataPackage.Template.fmt.notrans", (Object)"SASLibrary");
            int flags = 8460;
            try {
                this.m_librariesList = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)this.m_library.getStore(), this.m_library.getContext(), "SASLibrary", flags, strLibraryTemplate);
                for (int i = 0; i < this.m_librariesList.size(); ++i) {
                    SASLibrary sasLib = (SASLibrary)this.m_librariesList.get(i);
                    this.m_dataList.add(sasLib.getName());
                }
            }
            catch (MdException exc) {
                MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Reading");
            }
            catch (RemoteException re) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
            }
            this.m_list.setListData(this.m_dataList);
            if (!this.m_dataList.isEmpty()) {
                this.m_list.setSelectedIndex(0);
            }
        }
        return false;
    }

    public boolean validateData() {
        return true;
    }

    public void onListSelectionChanged() {
        try {
            String strServer = "";
            if (this.m_list.getModel().getSize() > 0) {
                strServer = (String)this.m_list.getSelectedValue();
            }
            SASLibrary sasLib = null;
            for (int i = 0; i < this.m_librariesList.size() && !(sasLib = (SASLibrary)this.m_librariesList.get(i)).getName().equals(strServer); ++i) {
            }
            this.m_descText.setText(sasLib != null ? sasLib.getDesc() : "");
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    public void onNext() {
        try {
            WAWizardDialog parent = (WAWizardDialog)this.getTopLevelAncestor();
            Object[] selectedValuesArray = this.m_list.getSelectedValues();
            block2: for (int i = 0; i < selectedValuesArray.length; ++i) {
                String strServer = (String)selectedValuesArray[i];
                for (int j = 0; j < this.m_librariesList.size(); ++j) {
                    SASLibrary sasLib = (SASLibrary)this.m_librariesList.get(j);
                    if (!sasLib.getName().equals(strServer)) continue;
                    this.m_library.aliasFor((DeployedDataPackage)sasLib);
                    continue block2;
                }
            }
            parent.replaceWizardData("DeployedDataPackage", (Object)this.m_library.getDeployedDataPackage());
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    public void onBack() {
        this.m_dataList.removeAllElements();
    }

    public void onFinish() {
    }

    protected void _initialize() {
        this.setHelpProduct("newlibrary");
        this.setHelpTopic("libwiz_1a");
        this.m_dataList = new Vector();
        this.m_list = new JList(this.m_dataList);
        this.m_list.setToolTipText(bundle.getString("LibraryAliasForView.List.Tooltip"));
        this.m_list.setSelectionMode(0);
        this.m_list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                LibraryAliasForView.this.onListSelectionChanged();
            }
        });
        this.m_listPane = new JScrollPane(this.m_list, 22, 30);
        this.m_listPane.setBorder(BorderFactory.createLoweredBevelBorder());
        this.m_listPane.setMinimumSize(new Dimension(400, 350));
        this.m_listPane.setPreferredSize(new Dimension(400, 350));
        this.m_descText = new WATextArea();
        this.m_descText.setEditable(false);
        this.m_descText.setLineWrap(true);
        this.m_descText.setWrapStyleWord(true);
        this.m_descText.setBorder(null);
        this.m_descText.setBackground(this.getBackground());
    }

    protected void _layoutWidgets() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        int gridy = 0;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 0, 0, 0);
        gridBagLayout.setConstraints(this.m_listPane, gbc);
        this.add(this.m_listPane);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 5, 0, 0);
        gridBagLayout.setConstraints((Component)this.m_descText, gbc);
        this.add((Component)this.m_descText);
        JPanel eaterPanel = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gridBagLayout.setConstraints(eaterPanel, gbc);
        this.add(eaterPanel);
    }
}

