/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals;

import com.sas.meta.SASOMI.IOMI;
import com.sas.services.util.Names;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsDescriptionWizardTab;
import com.sas.workspace.mgmt.MnemonicModel;
import com.sas.workspace.mgmt.RepositoryUtil;
import com.sas.workspace.visuals.WAGeneralPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public class GeneralRepositoryPropertyView
extends WsDescriptionWizardTab {
    private static final long serialVersionUID = 1L;
    protected int m_type;
    protected WATextArea m_titleText;
    protected JLabel m_iconLabel;
    protected JLabel m_nameLabel;
    protected JTextField m_nameText;
    protected JLabel m_descLabel;
    protected WATextArea m_descText;
    protected JScrollPane m_descPane;
    protected JSeparator m_separator;
    protected WAGeneralPanel m_panel;
    protected IOMI m_omiConnection;
    private static final WAdminResource bundle = WAdminResource.getBundle(GeneralRepositoryPropertyView.class);

    public GeneralRepositoryPropertyView(IOMI omiConnection, int type) {
        super(bundle.getString("NewReposWizard.GeneralRepositoryPropertyView.Help.txt"));
        this.m_type = type;
        this.m_omiConnection = omiConnection;
        this._initialize();
        this._layoutWidgets();
    }

    public boolean doDataExchange(boolean bSaveToModel) {
        if (!bSaveToModel && this.m_type == 0) {
            WAWizardDialog wizard = (WAWizardDialog)this.getTopLevelAncestor();
            String reposType = (String)wizard.getWizardData("Type");
            JTextComponent nameField = this.m_panel.getNameComponent();
            String name = nameField.getText();
            if (reposType.equalsIgnoreCase("Foundation") && (name.length() == 0 || name == null)) {
                nameField.setText(bundle.getString("NewReposWizard.NewReposTypeTab.Foundation.defaultvalue.txt"));
            } else if (!reposType.equalsIgnoreCase("Foundation") && name.equals(bundle.getString("NewReposWizard.NewReposTypeTab.Foundation.defaultvalue.txt"))) {
                nameField.setText("");
            }
        }
        return true;
    }

    public boolean validateData() {
        String name = this.m_panel.getNameComponent().getText();
        if (name == null || name.trim().length() == 0) {
            MessageUtil.displayMessage((String)bundle.getString("NewReposWizard.GeneralRepositoryPropertyView.Error.NoName.txt"), (String)bundle.getString("NewReposWizard.ValidationError.Title.txt"), (int)0);
            return false;
        }
        try {
            Names.validateOMRObjectName((String)name, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage(), (String)bundle.getString("NewReposWizard.ValidationError.Title.txt"), (int)0);
            return false;
        }
        WAWizardDialog wizard = (WAWizardDialog)this.getTopLevelAncestor();
        String reposType = (String)wizard.getWizardData("Type");
        boolean valid = RepositoryUtil.validateRepositoryName(Workspace.getMdFactory(), name, reposType);
        if (!valid) {
            MessageUtil.displayMessage((String)bundle.formatString("NewReposWizard.GeneralRepositoryPropertyView.Error.NonUniqueName.txt", (Object)name), (String)bundle.getString("NewReposWizard.ValidationError.Title.txt"), (int)0);
            return false;
        }
        this.setConditionState("NEXT");
        return true;
    }

    public void onNext() {
        WAWizardDialog wizard = (WAWizardDialog)this.getTopLevelAncestor();
        wizard.replaceWizardData("Name", (Object)this.m_panel.getNameComponent().getText().trim());
        wizard.replaceWizardData("Description", (Object)this.m_panel.getDescriptionComponent().getText());
    }

    protected void _initialize() {
        this.setName(bundle.getString("GeneralPropertyView.TabName.txt"));
        this.m_panel = new WAGeneralPanel(null, false, false, false);
        this.m_panel.getNameComponent().setToolTipText(bundle.getString("NewReposWizard.GeneralRepositoryPropertyView.Name.tooltip.txt"));
        this.m_panel.getDescriptionComponent().setToolTipText(bundle.getString("NewReposWizard.GeneralRepositoryPropertyView.Desc.tooltip.txt"));
    }

    public String createFinishString() {
        WAWizardDialog wizard = (WAWizardDialog)this.getTopLevelAncestor();
        StringBuffer finishString = new StringBuffer("");
        finishString.append(bundle.getString("NewReposWizard.Type.txt") + "\n   ");
        String reposType = (String)wizard.getWizardData("Type");
        if (reposType.equalsIgnoreCase("Foundation")) {
            finishString.append(MnemonicModel.getDisplayLabel(bundle.getString("NewReposWizard.NewReposTypeTab.Foundation.txt")));
        } else if (reposType.equalsIgnoreCase("Custom")) {
            finishString.append(MnemonicModel.getDisplayLabel(bundle.getString("NewReposWizard.NewReposTypeTab.Custom.txt")));
        } else if (reposType.equalsIgnoreCase("Project")) {
            finishString.append(MnemonicModel.getDisplayLabel(bundle.getString("NewReposWizard.NewReposTypeTab.Project.txt")));
        }
        finishString.append("\n\n");
        finishString.append(bundle.getString("NewReposWizard.RepositoryName.txt") + "\n   ");
        finishString.append((String)wizard.getWizardData("Name"));
        finishString.append("\n\n");
        String description = (String)wizard.getWizardData("Description");
        if (description != null) {
            finishString.append(bundle.getString("NewReposWizard.Description.txt") + "\n   ");
            finishString.append(description);
            finishString.append("\n\n");
        }
        return finishString.toString();
    }

    protected void _layoutWidgets() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 1;
        gbc.anchor = 12;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gridBagLayout.setConstraints((Component)this.m_panel, gbc);
        this.add((Component)this.m_panel);
    }
}

