/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals;

import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.PrimaryType;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Tree;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsRepositoryUtil;
import com.sas.workspace.visuals.WAGeneralPanel;
import java.rmi.RemoteException;

public class FolderUtil {
    public static void setPanelLocationRepositoryFilter(WAGeneralPanel panel, Root root) {
        try {
            String rootRepositoryID = Workspace.getMdFactory().getOMIUtil().getReposIdFromMetadataObject((CMetadata)root);
            if (WsRepositoryUtil.getRepositoryType((MdFactory)Workspace.getMdFactory(), (String)rootRepositoryID).equalsIgnoreCase("PROJECT")) {
                String lockedBy = root.getLockedBy();
                if (!lockedBy.equals("")) {
                    if (root.getTrees().size() > 0) {
                        Tree rootFolder = (Tree)root.getTrees().get(0);
                        String folderRepositoryID = Workspace.getMdFactory().getOMIUtil().getReposIdFromMetadataObject((CMetadata)rootFolder);
                        panel.setLocationFilterRepositoryID(folderRepositoryID);
                    } else {
                        panel.setLocationFilterRepositoryID(rootRepositoryID);
                    }
                }
            } else {
                panel.setLocationFilterRepositoryID(rootRepositoryID);
            }
        }
        catch (MdException mdex) {
            Workspace.getDefaultLogger().error((Object)mdex.getLocalizedMessage());
            MessageUtil.displayMetadataExceptionMessage((MdException)mdex, (String)"Reading");
            Workspace.getDefaultLogger().warn((Object)("Folder repository filter not properly set for '" + root + "'."));
        }
        catch (RemoteException re) {
            String msg = re.getLocalizedMessage();
            Workspace.getDefaultLogger().error((Object)msg);
            MessageUtil.displayMessage((String)msg, (int)0);
            Workspace.getDefaultLogger().warn((Object)("Folder repository filter not properly set for '" + root + "'."));
        }
    }

    public static String getDisplayPathFromTree(Tree tree) {
        String path = "";
        try {
            if (tree != null) {
                path = Workspace.getMdFactory().getOMIUtil().getObjectPath((MdObjectStore)tree.getObjectStore(), (PrimaryType)tree, false);
            }
        }
        catch (RemoteException re) {
            Workspace.getDefaultLogger().error((Object)re.getLocalizedMessage());
        }
        catch (MdException mde) {
            MessageUtil.displayMetadataExceptionMessage((MdException)mde, (String)"Reading");
        }
        return path;
    }
}

