/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertyType;
import com.sas.metadata.remote.ServerComponent;
import com.sas.swing.visuals.util.Util;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsDescriptionWizardTab;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FileNavigationView
extends WsDescriptionWizardTab {
    private static final long serialVersionUID = 1L;
    protected ServerComponent m_serverComponent;
    private ButtonGroup m_radioGroup;
    private JRadioButton m_systemRadio;
    private JRadioButton m_userRadio;
    private JRadioButton m_pathRadio;
    private JTextField m_pathText;
    private static final WAdminResource bundle = WAdminResource.getBundle(FileNavigationView.class);

    public FileNavigationView(ServerComponent serverComponent) {
        this.m_serverComponent = serverComponent;
        this._initialize();
        this._layoutWidgets();
    }

    public void moveDataToStore() {
        String strRootValue = "";
        if (this.m_systemRadio.isSelected()) {
            strRootValue = "$";
        } else if (this.m_userRadio.isSelected()) {
            strRootValue = ".";
        } else if (this.m_pathRadio.isSelected()) {
            strRootValue = this.m_pathText.getText().trim();
        }
        try {
            boolean bPropertySet = false;
            AssociationList propertyList = this.m_serverComponent.getProperties();
            for (int propIndex = 0; propIndex < propertyList.size(); ++propIndex) {
                Property property = (Property)propertyList.get(propIndex);
                if (!property.getPropertyName().equalsIgnoreCase("FileNavigation")) continue;
                String strValue = property.getDefaultValue();
                if (strValue.equalsIgnoreCase(strRootValue)) {
                    return;
                }
                property.setDefaultValue(strRootValue, 1);
                bPropertySet = true;
            }
            if (!bPropertySet) {
                Property property = (Property)Workspace.getMdFactory().createComplexMetadataObject((MdObjectStore)this.m_serverComponent.getObjectStore(), null, "Property", "Property", this.m_serverComponent.getRepositoryID());
                property.setName(bundle.getString("FileNavigationView.PropertyName.txt"), 1);
                property.setPropertyName("FileNavigation", 1);
                property.setDefaultValue(strRootValue, 1);
                PropertyType type = (PropertyType)Workspace.getMdFactory().createComplexMetadataObject((MdObjectStore)this.m_serverComponent.getObjectStore(), null, "PropertyType", "PropertyType", this.m_serverComponent.getRepositoryID());
                type.setName("String", 1);
                type.setSQLType("12", 1);
                property.setOwningType(type);
                propertyList.add(property);
            }
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
        }
    }

    public void populateStore() {
    }

    public void moveDataToView() {
        try {
            AssociationList propertyList = this.m_serverComponent.getProperties();
            for (int propIndex = 0; propIndex < propertyList.size(); ++propIndex) {
                Property property = (Property)propertyList.get(propIndex);
                if (!property.getPropertyName().equalsIgnoreCase("FileNavigation")) continue;
                String strRootValue = property.getDefaultValue();
                if (strRootValue.length() == 0) {
                    this.m_userRadio.setSelected(true);
                    continue;
                }
                if (strRootValue.equalsIgnoreCase("$")) {
                    this.m_systemRadio.setSelected(true);
                    continue;
                }
                if (strRootValue.equalsIgnoreCase(".")) {
                    this.m_userRadio.setSelected(true);
                    continue;
                }
                this.m_pathRadio.setSelected(true);
                this.m_pathText.setText(strRootValue);
            }
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
        }
    }

    public boolean validateData() {
        boolean bValidated = true;
        if (this.m_pathRadio.isSelected() && this.m_pathText.getText().trim().length() == 0) {
            String strMessage = bundle.getString("FileNavigationView.SpecifyPath.txt");
            String strTitle = bundle.getString("Common.Error.txt");
            MessageUtil.displayMessage((String)strMessage, (String)strTitle, (int)0);
            bValidated = false;
        }
        return bValidated;
    }

    public void onPathRadioChanged() {
        this.m_pathText.setEnabled(this.m_pathRadio.isSelected());
    }

    public String createFinishString() {
        String strFinish = bundle.getString("FileNavigationView.PropertyName.txt") + ":\n";
        if (this.m_systemRadio.isSelected()) {
            strFinish = strFinish + "\t" + bundle.getString("FileNavigationView.SystemRadioLabel.txt") + "\n";
        } else if (this.m_userRadio.isSelected()) {
            strFinish = strFinish + "\t" + bundle.getString("FileNavigationView.UserRadioLabel.txt") + "\n";
        } else if (this.m_pathRadio.isSelected()) {
            strFinish = strFinish + "\t" + bundle.getString("FileNavigationView.PathRadioLabel.txt") + " " + this.m_pathText.getText().trim() + "\n";
        }
        return strFinish;
    }

    protected void _initialize() {
        this.setName(bundle.getString("FileNavigationView.TabName.txt"));
        this.setHelpProduct("templatedata");
        this.setHelpTopic("ws_navtab");
        String name = bundle.getString("FileNavigationView.UserRadioLabel.txt");
        this.m_userRadio = new JRadioButton(Util.getLabelWithoutMnemonic((String)name), true);
        this.m_userRadio.setMnemonic(Util.getDisplayedMnemonic((String)name));
        this.m_userRadio.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex((String)name));
        name = bundle.getString("FileNavigationView.SystemRadioLabel.txt");
        this.m_systemRadio = new JRadioButton(Util.getLabelWithoutMnemonic((String)name));
        this.m_systemRadio.setMnemonic(Util.getDisplayedMnemonic((String)name));
        this.m_systemRadio.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex((String)name));
        name = bundle.getString("FileNavigationView.PathRadioLabel.txt");
        this.m_pathRadio = new JRadioButton(Util.getLabelWithoutMnemonic((String)name));
        this.m_pathRadio.setMnemonic(Util.getDisplayedMnemonic((String)name));
        this.m_pathRadio.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex((String)name));
        this.m_pathRadio.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                FileNavigationView.this.onPathRadioChanged();
            }
        });
        this.m_pathText = new JTextField(30);
        this.m_radioGroup = new ButtonGroup();
        this.m_radioGroup.add(this.m_userRadio);
        this.m_radioGroup.add(this.m_systemRadio);
        this.m_radioGroup.add(this.m_pathRadio);
    }

    protected void _layoutWidgets() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        int gridy = 0;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy++;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 12, 0, 0);
        gridBagLayout.setConstraints(this.m_userRadio, gbc);
        this.add(this.m_userRadio);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy++;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 12, 0, 0);
        gridBagLayout.setConstraints(this.m_systemRadio, gbc);
        this.add(this.m_systemRadio);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 12, 0, 0);
        gridBagLayout.setConstraints(this.m_pathRadio, gbc);
        this.add(this.m_pathRadio);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 12, 0, 12);
        gridBagLayout.setConstraints(this.m_pathText, gbc);
        this.add(this.m_pathText);
        JPanel eaterPanel = new JPanel();
        eaterPanel.setPreferredSize(new Dimension(350, 150));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.gridwidth = 0;
        gbc.gridheight = 0;
        gridBagLayout.setConstraints(eaterPanel, gbc);
        this.add(eaterPanel);
    }
}

