/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.DatabaseSchema;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.Extension;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Prototype;
import com.sas.metadata.remote.Root;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.mgmt.visuals.PrototypeUtil;
import com.sas.workspace.mgmt.visuals.Server;
import com.sas.workspace.mgmt.visuals.ServerWizard;
import java.awt.Component;
import java.rmi.RemoteException;
import java.util.Locale;
import java.util.Vector;

public class DBSchema {
    protected DatabaseSchema m_schema;
    protected String m_reposID;
    protected Component m_parentComponent;
    protected MdObjectStore m_objectStore = null;
    private static final WAdminResource bundle = WAdminResource.getBundle(DBSchema.class);

    public DBSchema(String reposID, MdObjectStore ObjectStore) {
        try {
            this.m_reposID = reposID;
            this.m_objectStore = ObjectStore;
            this.m_schema = (DatabaseSchema)Workspace.getMdFactory().createComplexMetadataObject(this.m_objectStore, null, "DatabaseSchema", "DatabaseSchema", reposID.substring(9));
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    public DBSchema(String reposID, DatabaseSchema schema) {
        this.m_reposID = reposID;
        this.m_schema = schema;
    }

    public DBSchema(String reposID, DatabaseSchema schema, MdObjectStore store) {
        this.m_reposID = reposID;
        this.m_schema = schema;
        this.m_objectStore = store;
    }

    public MdObjectStore getStore() {
        return this.m_objectStore;
    }

    public DatabaseSchema getSchema() {
        return this.m_schema;
    }

    public void setSchema(DatabaseSchema schema) {
        this.m_schema = schema;
    }

    public Component getParentComponent() {
        return this.m_parentComponent;
    }

    public void setParentComponent(Component component) {
        this.m_parentComponent = component;
    }

    public Prototype getDatabaseSchemaPrototype(Component parent) throws MdException, RemoteException {
        return this.getDatabaseSchemaPrototype(parent, false);
    }

    public Prototype getDatabaseSchemaPrototype(Component parent, boolean bShowPrototypeSelector) throws MdException, RemoteException {
        Prototype prototype = (Prototype)this.getSchema().getUsingPrototype();
        if (prototype != null) {
            String strTemplate = bundle.getString("Prototype.Template.All.notrans");
            int flags = 268;
            prototype = (Prototype)Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)prototype, new Vector(), new Vector(), strTemplate, flags);
        }
        if (prototype != null) {
            AssociationList extensionList = PrototypeUtil.getParentPrototype(prototype, this.m_reposID).getExtensions();
            for (int extIndex = 0; extIndex < extensionList.size(); ++extIndex) {
                Extension extension = (Extension)extensionList.get(extIndex);
                if (!extension.getName().equals("Locale")) continue;
                String localeValue = extension.getValue();
                if (!localeValue.equalsIgnoreCase("Generic")) break;
                return prototype;
            }
        }
        Locale locale = Locale.getDefault();
        if (prototype != null) {
            AssociationList extensionList = PrototypeUtil.getParentPrototype(prototype, this.m_reposID).getExtensions();
            boolean bLocaleExtensionFound = false;
            for (int extIndex = 0; extIndex < extensionList.size(); ++extIndex) {
                Extension extension = (Extension)extensionList.get(extIndex);
                if (!extension.getName().equals("Locale")) continue;
                if (!PrototypeUtil.getLocale(extension.getValue()).equals(locale)) {
                    prototype = null;
                }
                bLocaleExtensionFound = true;
                break;
            }
            if (!bLocaleExtensionFound && !PrototypeUtil.getLocale("en_US").equals(locale)) {
                prototype = null;
            }
        }
        if (prototype == null) {
            int returnValue;
            AssociationList dcList = this.getSchema().getDeployedComponents();
            if (!dcList.isEmpty()) {
                int returnValue2;
                DeployedComponent dc = (DeployedComponent)dcList.get(0);
                String strClassID = dc.getClassIdentifier();
                prototype = ServerWizard.getPrototype("Extensions", "ServerClassIdentifier", strClassID, this.getContext(), this.getStore(), parent, "DatabaseSchema");
                if (prototype != null) {
                    this.getSchema().setUsingPrototype((Root)prototype);
                } else if (bShowPrototypeSelector && (returnValue2 = MessageUtil.displayMessage((String)bundle.getString("ServerWizard.NoAssociatedResourceTemplate.Schema.txt"), (String)bundle.getString("Common.Warning.txt"), (int)2, (int)0)) == 0) {
                    prototype = Server.getPrototypeViaSelector(parent, "DatabaseSchema", this.m_reposID, this.m_objectStore);
                    this.getSchema().setUsingPrototype((Root)prototype);
                }
            } else if (bShowPrototypeSelector && (returnValue = MessageUtil.displayMessage((String)bundle.getString("ServerWizard.NoAssociatedResourceTemplate.Schema.txt"), (String)bundle.getString("Common.Warning.txt"), (int)2, (int)0)) == 0) {
                prototype = Server.getPrototypeViaSelector(parent, "DatabaseSchema", this.m_reposID, this.m_objectStore);
                this.getSchema().setUsingPrototype((Root)prototype);
            }
        }
        return prototype;
    }

    public String getContext() {
        return this.m_reposID;
    }

    public void persist() {
        try {
            Workspace.getDefaultLogger().debug((Object)"Starting write");
            this.m_schema.updateMetadataAll();
            Workspace.getDefaultLogger().debug((Object)"Finished write");
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Writing");
        }
        catch (RemoteException re) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
        }
    }

    public void assignToServer(DeployedComponent deployedComponent) {
        try {
            this.getSchema().getDeployedComponents().add((Object)deployedComponent);
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
        }
    }
}

