/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.AuthenticationDomain;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Connection;
import com.sas.metadata.remote.DatabaseSchema;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.Extension;
import com.sas.metadata.remote.Login;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdFactoryEvent;
import com.sas.metadata.remote.MdFactoryListener;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Prototype;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASClientConnection;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.ServerComponent;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsDescriptionWizardTab;
import com.sas.workspace.WsRepositoryUtil;
import com.sas.workspace.mgmt.LoginSearchModel;
import com.sas.workspace.mgmt.MnemonicModel;
import com.sas.workspace.mgmt.SortUtil;
import com.sas.workspace.mgmt.visuals.ConnectionWizard;
import com.sas.workspace.mgmt.visuals.Library;
import com.sas.workspace.mgmt.visuals.LibraryWizard;
import com.sas.workspace.mgmt.visuals.LoginSearchPanel;
import com.sas.workspace.mgmt.visuals.MetadataObjectCellRenderer;
import com.sas.workspace.mgmt.visuals.ServerWizard;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class DBMSLibnamePropertyView
extends WsDescriptionWizardTab {
    private static final long serialVersionUID = 1L;
    protected Library m_library;
    protected int m_type;
    protected DeployedComponent m_selectedServer;
    protected SASClientConnection m_selectedConnection;
    protected AuthenticationDomain m_currentDomain;
    protected List m_serversList;
    protected List m_connectionsList;
    protected List m_loginsList;
    protected List m_remoteLibrariesList;
    private Login m_currentLogin;
    private Login m_selectedLogin;
    protected WATextArea m_descriptionText;
    protected JPanel m_dataServerDetailsPanel;
    protected JLabel m_serverLabel;
    protected JComboBox m_serverChoice;
    protected JButton m_serverButton;
    protected JLabel m_remoteLibraryLabel;
    protected JComboBox m_remoteLibraryChoice;
    protected JButton m_remoteLibraryButton;
    protected JLabel m_schemaNameAttrLabel;
    protected WATextField m_schemaNameAttrText;
    protected JPanel m_connectionDetailsPanel;
    protected JLabel m_connectionLabel;
    protected JComboBox m_connectionChoice;
    protected JButton m_connectionButton;
    protected JLabel m_loginLabel;
    protected JComboBox m_loginChoice;
    protected boolean m_bShareServer;
    protected boolean m_bSPDServer;
    private boolean m_bShowSchema;
    private static final String EMPTY_ITEM = "";
    private static final WAdminResource bundle = WAdminResource.getBundle(DBMSLibnamePropertyView.class);
    private static final Set<String> DBMS_SCHEMA_UNSUPPORTED = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("SASHDAT", "SASIOLA", "CAS", "SASIOSLF", "SASIOMGO")));
    private static final Set<String> SCHEMA_GRAYED_OUT = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("MYSQL", "EXCEL", "SASIOSR3", "SASIOPI")));
    private static final Set<String> SCHEMA_OPTIONAL = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("OLEDB", "ODBC", "ACCESS", "FEDSVR", "NEOVIEW", "NETEZZA", "ASTER", "TERADATA", "SYBASEIQ", "SYBASE", "DB2", "ORACLE", "SQLSVR", "GREENPLM", "SASIOHWQ", "HADOOP", "POSTGRES", "VERTICA", "SASIOHNA", "SASIOIMP", "SASIOAF", "SASIORST", "REDSHIFT", "SASIOJDB", "SASIOSNF", "SASIOYLB")));

    public DBMSLibnamePropertyView(Library library, int type) {
        this.m_library = library;
        this.m_type = type;
        this.m_bShowSchema = true;
        this._initialize();
        this._layoutWidgets();
    }

    public boolean doDataExchange(boolean bSaveToModel) {
        if (bSaveToModel) {
            this.moveDataToStore();
        } else {
            this.populateStore();
            this.moveDataToView();
        }
        return false;
    }

    public void moveDataToStore() {
        if (this.m_type == 1) {
            this._setViewProperties();
        }
    }

    public void populateStore() {
    }

    public void moveDataToView() {
        try {
            if (this.m_library != null && ((SASLibrary)this.m_library.getDeployedDataPackage()).getEngine().startsWith("REMOTE")) {
                this.setName(bundle.getString("DBMSLibname.ShareServerTabName.txt"));
                this.setHelpTopic("libwiz_4a_share");
            } else if (this.m_library != null && ((SASLibrary)this.m_library.getDeployedDataPackage()).getEngine().startsWith("SASSPDS")) {
                this.setName(bundle.getString("DBMSLibname.TabName.txt"));
                this.setHelpTopic("libwiz_5_spds");
            } else if (this.m_library != null && ((SASLibrary)this.m_library.getDeployedDataPackage()).getEngine().startsWith("CAS")) {
                this.setName(bundle.getString("DBMSLibname.TabName.txt"));
                this.setHelpTopic("libwiz_5_cas");
            } else {
                this.setName(bundle.getString("DBMSLibname.TabName.txt"));
                this.setHelpTopic("libwiz_4a");
            }
            String strType = "ServerComponent";
            String strTemplate = "<TEMPLATES><ServerComponent Name=\"\"><SourceConnections/><DataPackages/></ServerComponent><SASClientConnection><Domain/></SASClientConnection><AuthenticationDomain Name=\"\"></AuthenticationDomain><DatabaseSchema Name=\"\" /></TEMPLATES>";
            String strClassID = this._getClassID(this.m_library, true);
            String strClassIdentifier = this.m_bShareServer ? "SHARE" : strClassID;
            String strSelect = "<XMLSELECT search=\"*[@ClassIdentifier='" + strClassIdentifier + "']\"/>";
            if (strClassIdentifier.equalsIgnoreCase("Postgres")) {
                strSelect = "<XMLSELECT search=\"*[@ClassIdentifier='" + strClassIdentifier + "' OR @ClassIdentifier='" + "SASInfrastructureData" + "']\"/>";
            }
            String strOptions = strTemplate + strSelect;
            int flags = 8588;
            try {
                this.m_serversList = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset(this.m_library.getDeployedDataPackage().getObjectStore(), this.m_library.getContext(), strType, flags, strOptions);
            }
            catch (MdException exc) {
                MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Reading");
                return;
            }
            catch (RemoteException exc) {
                Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
            }
            if (this.m_bShareServer) {
                this.m_remoteLibraryLabel.setVisible(true);
                this.m_remoteLibraryChoice.setVisible(true);
                this.m_remoteLibraryButton.setVisible(true);
                this.m_schemaNameAttrLabel.setVisible(false);
                this.m_schemaNameAttrText.setVisible(false);
                MnemonicModel.setLabelTextAndMnemonic(this.m_serverLabel, bundle.getString("DBMSLibname.ShareServerLabel.withMnemonic.txt"));
                MnemonicModel.setLabelTextAndMnemonic(this.m_remoteLibraryLabel, bundle.getString("DBMSLibname.RemoteLibraryLabel.withMnemonic.txt"));
            } else if (this.m_bSPDServer) {
                this.m_remoteLibraryLabel.setVisible(false);
                this.m_remoteLibraryChoice.setVisible(false);
                this.m_remoteLibraryButton.setVisible(false);
                this.m_schemaNameAttrLabel.setVisible(true);
                this.m_schemaNameAttrText.setVisible(true);
                MnemonicModel.setLabelTextAndMnemonic(this.m_serverLabel, bundle.getString("DBMSLibname.SPDServerLabel.withMnemonic.txt"));
                MnemonicModel.setLabelTextAndMnemonic(this.m_schemaNameAttrLabel, bundle.getString("DBMSLibname.SPDSchemaLabel.withMnemonic.txt"));
            } else {
                this.m_remoteLibraryLabel.setVisible(false);
                this.m_remoteLibraryChoice.setVisible(false);
                this.m_remoteLibraryButton.setVisible(false);
                this.m_schemaNameAttrLabel.setVisible(this.m_bShowSchema);
                this.m_schemaNameAttrText.setVisible(this.m_bShowSchema);
                MnemonicModel.setLabelTextAndMnemonic(this.m_serverLabel, bundle.getString("DBMSLibname.ServerLabel.withMnemonic.txt"));
                MnemonicModel.setLabelTextAndMnemonic(this.m_schemaNameAttrLabel, bundle.getString("DBMSLibname.DBSchemaNameAttrLabel.withMnemonic.txt"));
            }
            this.m_serverChoice.removeAllItems();
            if (this.m_serversList != null) {
                for (int i = 0; i < this.m_serversList.size(); ++i) {
                    DeployedComponent dc = (DeployedComponent)this.m_serversList.get(i);
                    this.m_serverChoice.addItem(dc);
                }
            }
            try {
                SASLibrary library = (SASLibrary)this.m_library.getDeployedDataPackage();
                if (library != null) {
                    AssociationList schemaList;
                    SASClientConnection libraryConnection = library.getLibraryConnection();
                    if (libraryConnection != null) {
                        DeployedComponent libraryServer = libraryConnection.getSource();
                        if (this.m_serversList != null) {
                            if (this.m_serversList.contains(libraryServer)) {
                                this.m_serverChoice.setSelectedItem(libraryServer);
                            } else if (this.m_serversList.size() > 0) {
                                this.m_serverChoice.insertItemAt(EMPTY_ITEM, 0);
                                this.m_serverChoice.setSelectedItem(EMPTY_ITEM);
                            }
                        }
                    }
                    this.onServerChanged();
                    if (!this.m_bShareServer && (schemaList = library.getUsingPackages()).size() > 0) {
                        DatabaseSchema schema = (DatabaseSchema)library.getUsingPackages().get(0);
                        this.m_schemaNameAttrText.setText(schema.getSchemaName());
                    }
                } else if (WsRepositoryUtil.getRepositoryType((MdFactory)Workspace.getMdFactory(), (String)this.m_library.getContext()).equalsIgnoreCase("PROJECT")) {
                    this.m_serverButton.setEnabled(false);
                    this.m_connectionButton.setEnabled(false);
                }
            }
            catch (MdException exc) {
                MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
            }
            catch (RemoteException exc) {
                Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
            }
            this.invalidate();
            this.revalidate();
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
    }

    public boolean validateData() {
        try {
            boolean bValid = true;
            if (!this.isEditable()) {
                return bValid;
            }
            if (this.m_serverChoice.getSelectedItem() == null || !(this.m_serverChoice.getSelectedItem() instanceof DeployedComponent)) {
                if (this.m_bShareServer) {
                    JOptionPane.showMessageDialog(this.getTopLevelAncestor(), bundle.getString("DBMSLibname.NoShareServerError.txt"), bundle.getString("Common.Error.txt"), 0);
                } else if (this.m_bSPDServer) {
                    JOptionPane.showMessageDialog(this.getTopLevelAncestor(), bundle.getString("DBMSLibname.NoSPDServerError.txt"), bundle.getString("Common.Error.txt"), 0);
                } else {
                    JOptionPane.showMessageDialog(this.getTopLevelAncestor(), bundle.getString("DBMSLibname.NoServerError.txt"), bundle.getString("Common.Error.txt"), 0);
                }
                this.m_serverChoice.requestFocusInWindow();
                bValid = false;
                return bValid;
            }
            if (this.m_connectionChoice.getSelectedItem() == null || !(this.m_connectionChoice.getSelectedItem() instanceof SASClientConnection)) {
                JOptionPane.showMessageDialog(this.getTopLevelAncestor(), bundle.getString("DBMSLibname.NoConnectionError.txt"), bundle.getString("Common.Error.txt"), 0);
                this.m_connectionChoice.requestFocusInWindow();
                bValid = false;
                return bValid;
            }
            String engineName = ((SASLibrary)this.m_library.getDeployedDataPackage()).getEngine().toUpperCase();
            if (SCHEMA_OPTIONAL.contains(engineName) || DBMS_SCHEMA_UNSUPPORTED.contains(engineName) || SCHEMA_GRAYED_OUT.contains(engineName)) {
                return bValid;
            }
            if (this.m_bShareServer && (this.m_remoteLibraryChoice.getSelectedItem() == null || !(this.m_remoteLibraryChoice.getSelectedItem() instanceof SASLibrary))) {
                JOptionPane.showMessageDialog(this.getTopLevelAncestor(), bundle.getString("DBMSLibname.NoRemoteLibraryError.txt"), bundle.getString("Common.Error.txt"), 0);
                this.m_remoteLibraryChoice.requestFocusInWindow();
                bValid = false;
                return bValid;
            }
            if (!this.m_bShareServer && this.m_schemaNameAttrText.getText().trim().length() == 0) {
                if (this.m_bSPDServer) {
                    JOptionPane.showMessageDialog(this.getTopLevelAncestor(), bundle.getString("DBMSLibname.NoDomainError.txt"), bundle.getString("Common.Error.txt"), 0);
                } else {
                    JOptionPane.showMessageDialog(this.getTopLevelAncestor(), bundle.getString("DBMSLibname.NoSchemaNameAttrError.txt"), bundle.getString("Common.Error.txt"), 0);
                }
                this.m_schemaNameAttrText.requestFocusInWindow();
                bValid = false;
                return bValid;
            }
            return bValid;
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
            return false;
        }
    }

    public void onServerChanged() {
        try {
            Container parent = this.getTopLevelAncestor();
            parent.setCursor(Cursor.getPredefinedCursor(3));
            boolean bServerExists = this.m_serverChoice.getItemCount() > 0;
            String engine = ((SASLibrary)this.m_library.getDeployedDataPackage()).getEngine().toUpperCase();
            boolean bEnableSchema = !SCHEMA_GRAYED_OUT.contains(engine);
            boolean bEditable = this.isEditable();
            this.m_connectionChoice.setEnabled(bEditable && bServerExists);
            this.m_connectionButton.setEnabled(bEditable && bServerExists);
            this.m_remoteLibraryChoice.setEnabled(bEditable && bServerExists && bEnableSchema);
            this.m_remoteLibraryButton.setEnabled(bEditable && bServerExists && bEnableSchema);
            this.m_schemaNameAttrText.setEnabled(bEditable && bServerExists && bEnableSchema);
            if (WsRepositoryUtil.getRepositoryType((MdFactory)Workspace.getMdFactory(), (String)this.m_library.getContext()).equalsIgnoreCase("PROJECT")) {
                this.m_serverButton.setEnabled(false);
                this.m_connectionButton.setEnabled(false);
            }
            this.m_connectionsList = null;
            this.m_remoteLibrariesList = null;
            this.m_connectionChoice.removeAllItems();
            this.m_remoteLibraryChoice.removeAllItems();
            if (this.m_serverChoice.getItemCount() == 0) {
                parent.setCursor(Cursor.getPredefinedCursor(0));
                return;
            }
            this.m_selectedServer = this.m_serverChoice.getSelectedItem() instanceof DeployedComponent ? (DeployedComponent)this.m_serverChoice.getSelectedItem() : null;
            if (this.m_selectedServer != null) {
                SASClientConnection conn;
                String strSelect;
                String strType = "SASClientConnection";
                String strOptions = strSelect = "<XMLSELECT search=\"*[Source/ServerComponent[@Name='" + this.m_selectedServer.getName() + "']]\"/>";
                int flags = 8584;
                try {
                    this.m_connectionsList = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset(this.m_library.getDeployedDataPackage().getObjectStore(), this.m_library.getContext(), strType, flags, strOptions);
                }
                catch (MdException exc) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Reading");
                    parent.setCursor(Cursor.getPredefinedCursor(0));
                    return;
                }
                catch (RemoteException exc) {
                    Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
                }
                if (this.m_connectionsList != null) {
                    for (int i = 0; i < this.m_connectionsList.size(); ++i) {
                        conn = (SASClientConnection)this.m_connectionsList.get(i);
                        this.m_connectionChoice.addItem(conn);
                    }
                }
                try {
                    if (this.m_selectedServer.getProductName().equalsIgnoreCase("ODBCEXCEL") || this.m_selectedServer.getProductName().equalsIgnoreCase("OLEDBEXCEL") || this.m_selectedServer.getProductName().equalsIgnoreCase("OLEDBACCESS") || this.m_selectedServer.getProductName().equalsIgnoreCase("ODBCACCESS")) {
                        this.m_remoteLibraryChoice.setEnabled(false);
                        this.m_remoteLibraryButton.setEnabled(false);
                        this.m_schemaNameAttrText.setEnabled(false);
                    }
                }
                catch (Exception i) {
                    // empty catch block
                }
                if (this.m_bShareServer) {
                    strType = "SASLibrary";
                    strOptions = strSelect = "<XMLSELECT search=\"*[DeployedComponents/ServerComponent[@Name='" + this.m_selectedServer.getName() + "']]\"/>";
                    flags = 8584;
                    try {
                        this.m_remoteLibrariesList = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset(this.m_library.getDeployedDataPackage().getObjectStore(), this.m_library.getContext(), strType, flags, strOptions);
                    }
                    catch (MdException exc) {
                        MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Reading");
                        parent.setCursor(Cursor.getPredefinedCursor(0));
                        return;
                    }
                    catch (RemoteException exc) {
                        Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
                    }
                    if (this.m_remoteLibrariesList != null) {
                        for (int i = 0; i < this.m_remoteLibrariesList.size(); ++i) {
                            SASLibrary sharLib = (SASLibrary)this.m_remoteLibrariesList.get(i);
                            if (sharLib.getEngine().startsWith("REMOTE")) continue;
                            this.m_remoteLibraryChoice.addItem(sharLib);
                        }
                    }
                }
                if (this.m_selectedServer.getFQID().indexOf("$") != -1) {
                    this._updateDependentComboBoxes(this.m_selectedServer);
                }
                try {
                    AssociationList sharelibList;
                    SASLibrary library = (SASLibrary)this.m_library.getDeployedDataPackage();
                    if (library != null) {
                        conn = library.getLibraryConnection();
                        AssociationList selectedServerSourceConnections = this.m_selectedServer.getSourceConnections();
                        if (selectedServerSourceConnections != null && !selectedServerSourceConnections.contains(conn)) {
                            conn = null;
                        }
                        if (conn != null && this.m_connectionsList != null) {
                            if (this.m_connectionsList.contains(conn)) {
                                this.m_connectionChoice.setSelectedItem(conn);
                            } else if (this.m_connectionsList.size() > 0) {
                                this.m_connectionChoice.insertItemAt(EMPTY_ITEM, 0);
                                this.m_connectionChoice.setSelectedItem(EMPTY_ITEM);
                            }
                        }
                    }
                    if (this.m_bShareServer && library != null && (sharelibList = library.getUsingPackages()).size() > 0) {
                        SASLibrary sharelib = (SASLibrary)library.getUsingPackages().get(0);
                        AssociationList selectedServerDataPackages = this.m_selectedServer.getDataPackages();
                        if ((selectedServerDataPackages == null || selectedServerDataPackages.contains(sharelib)) && this.m_remoteLibrariesList != null) {
                            if (this.m_remoteLibrariesList.contains(sharelib)) {
                                this.m_remoteLibraryChoice.setSelectedItem(sharelib);
                            } else if (this.m_remoteLibrariesList.size() > 0) {
                                this.m_remoteLibraryChoice.insertItemAt(EMPTY_ITEM, 0);
                                this.m_remoteLibraryChoice.setSelectedItem(EMPTY_ITEM);
                            }
                        }
                    }
                }
                catch (MdException exc) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                }
                catch (RemoteException exc) {
                    Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
                }
                this._hideDisabledComboBoxEntries();
                this.invalidate();
                this.revalidate();
            }
            parent.setCursor(Cursor.getPredefinedCursor(0));
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
    }

    public void onConnectionChanged() {
        try {
            boolean bEditable;
            boolean bServerExists;
            Container parent = this.getTopLevelAncestor();
            parent.setCursor(Cursor.getPredefinedCursor(3));
            boolean bl = bServerExists = this.m_serverChoice.getItemCount() > 0;
            if (((SASLibrary)this.m_library.getDeployedDataPackage()).getEngine().equalsIgnoreCase("EXCEL") || ((SASLibrary)this.m_library.getDeployedDataPackage()).getEngine().equalsIgnoreCase("SASIOSR3")) {
                bServerExists = false;
            }
            this.m_loginChoice.setEnabled((bEditable = this.isEditable()) && bServerExists);
            this.m_loginsList = new Vector();
            this.m_loginChoice.removeAllItems();
            if (this.m_connectionChoice.getItemCount() == 0) {
                parent.setCursor(Cursor.getPredefinedCursor(0));
                return;
            }
            this.m_selectedConnection = this.m_connectionChoice.getSelectedItem() instanceof SASClientConnection ? (SASClientConnection)this.m_connectionChoice.getSelectedItem() : null;
            AuthenticationDomain serverDomain = null;
            try {
                this.m_currentDomain = this.m_selectedConnection != null ? (serverDomain = this.m_selectedConnection.getDomain()) : null;
                this.m_loginChoice.setEnabled(bEditable && bServerExists && this.m_currentDomain != null);
            }
            catch (MdException exc) {
                MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Reading");
                parent.setCursor(Cursor.getPredefinedCursor(0));
                return;
            }
            catch (RemoteException exc) {
                Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
            }
            ArrayList<String> mruList = new ArrayList<String>();
            for (int index = 1; index < 4; ++index) {
                String strMruDomain = Workspace.getWorkspace().getWorkspaceFile().getPropertyString("DBMSLibname.MRU.Domain." + String.valueOf(index));
                String strMruLogin = Workspace.getWorkspace().getWorkspaceFile().getPropertyString("DBMSLibname.MRU.Login." + String.valueOf(index));
                if (strMruDomain.length() <= 0 || strMruLogin.length() <= 0 || this.m_currentDomain == null || !strMruDomain.equalsIgnoreCase(this.m_currentDomain.getName())) continue;
                mruList.add(strMruDomain);
                mruList.add(strMruLogin);
            }
            String strTemplate = "<TEMPLATES><Login><Domain/></Login></TEMPLATES>";
            for (int mruIndex = 0; mruIndex < mruList.size(); mruIndex += 2) {
                String strDomain = ((String)mruList.get(mruIndex)).trim();
                String strLogin = (String)mruList.get(mruIndex + 1);
                String strXMLSelect = "<XMLSELECT search=\"Login[@UserId='" + Workspace.getMdFactory().getOMIUtil().cleanStringForXML(strLogin) + "'][Domain/AuthenticationDomain[@Name='" + Workspace.getMdFactory().getOMIUtil().cleanStringForXML(strDomain) + "']]\" />";
                if (strDomain.length() == 0) {
                    strXMLSelect = "<XMLSELECT search=\"Login[@UserId='" + Workspace.getMdFactory().getOMIUtil().cleanStringForXML(strLogin) + "']\" />";
                }
                int flags = 8604;
                String strOptions = strTemplate + strXMLSelect;
                try {
                    List loginList = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset(this.m_library.getDeployedDataPackage().getObjectStore(), this.m_library.getContext(), "Login", flags, strOptions);
                    for (int loginIndex = 0; loginIndex < loginList.size(); ++loginIndex) {
                        Login login = (Login)loginList.get(loginIndex);
                        if (this.m_loginsList.contains(login)) continue;
                        this.m_loginsList.add(login);
                    }
                    continue;
                }
                catch (MdException exc) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Reading");
                    continue;
                }
                catch (RemoteException exc) {
                    Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
                }
            }
            this.populateLogins();
            if (this.m_selectedConnection != null && this.m_selectedConnection.getFQID().indexOf("$") != -1) {
                this._updateDependentComboBoxes(this.m_selectedConnection);
            }
            try {
                Login login;
                SASLibrary library = (SASLibrary)this.m_library.getDeployedDataPackage();
                if (library != null && (login = library.getDefaultLogin()) != null && this.m_currentDomain != null && login.getDomain() == this.m_currentDomain) {
                    if (!this.m_loginsList.contains(login)) {
                        this.m_loginsList.add(login);
                        this.populateLogins();
                    }
                    this.m_loginChoice.setSelectedItem(login);
                }
                this.m_currentLogin = null;
                if (this.m_loginChoice.getSelectedItem() instanceof Login) {
                    this.m_currentLogin = (Login)this.m_loginChoice.getSelectedItem();
                }
            }
            catch (MdException exc) {
                MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
            }
            catch (RemoteException exc) {
                Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
            }
            this._hideDisabledComboBoxEntries();
            this.invalidate();
            this.revalidate();
            parent.setCursor(Cursor.getPredefinedCursor(0));
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
    }

    protected void onMoreLogins(ItemEvent evt) {
        try {
            String strObj;
            if (evt.getStateChange() != 1) {
                return;
            }
            Object obj = evt.getItem();
            if (obj instanceof String && (strObj = (String)obj).equalsIgnoreCase(bundle.getString("LoginSearchPanel.MoreLogins.txt"))) {
                LoginSearchModel model = new LoginSearchModel(Workspace.getWorkspace().getCMRHandle(), (MdObjectStore)this.m_library.getDeployedDataPackage().getObjectStore(), this.m_library.getContext());
                if (this.m_currentDomain != null) {
                    model.setAuthDomain(this.m_currentDomain);
                }
                if (this.m_currentLogin != null) {
                    model.setUserID(this.m_currentLogin.getUserID());
                }
                LoginSearchPanel panel = new LoginSearchPanel(model);
                Container parent = this.getTopLevelAncestor();
                WAStandardDialog dialog = null;
                if (parent instanceof JFrame) {
                    dialog = new WAStandardDialog((Frame)((JFrame)parent));
                }
                if (parent instanceof Dialog) {
                    dialog = new WAStandardDialog((Dialog)parent);
                }
                dialog.setModal(true);
                dialog.setTitle(bundle.getString("LoginSearchPanel.Title.txt"));
                dialog.setMainPanel((WAPanel)panel);
                dialog.show();
                if (dialog.getReturnValue() == 1) {
                    List resultsList = model.getResults();
                    if (resultsList.size() > 0) {
                        Login resultLogin = (Login)resultsList.get(0);
                        if (resultLogin != this.m_currentLogin && !this.m_loginsList.contains(resultLogin)) {
                            this.m_loginsList.add(resultLogin);
                            this.populateLogins();
                        }
                        this.m_loginChoice.setSelectedItem(resultLogin);
                    }
                } else if (this.m_currentLogin != null) {
                    this.m_loginChoice.setSelectedItem(this.m_currentLogin);
                } else {
                    this.m_loginChoice.setSelectedIndex(0);
                }
                model.dispose();
                model = null;
            }
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
    }

    private void populateLogins() {
        this.m_loginChoice.removeAllItems();
        this.m_loginChoice.addItem("None");
        this.m_loginsList = SortUtil.sortAscending(this.m_loginsList);
        if (this.m_loginsList != null) {
            for (int i = 0; i < this.m_loginsList.size(); ++i) {
                Login login = (Login)this.m_loginsList.get(i);
                this.m_loginChoice.addItem(login);
            }
        }
        this.m_loginChoice.addItem(bundle.getString("LoginSearchPanel.MoreLogins.txt"));
    }

    public void onNewServer() {
        try {
            MdObjectStore oStore = Workspace.getMdFactory().createObjectStore();
            ViewListener viewListener = new ViewListener(this.m_serverChoice, "ServerComponent", oStore);
            Workspace.getMdFactory().addMdFactoryListener((MdFactoryListener)viewListener);
            String strClassID = this._getClassID(this.m_library, true);
            Container parent = this.getTopLevelAncestor();
            ServerWizard wizard = null;
            if (strClassID != null && strClassID.equalsIgnoreCase("0217e202-b560-11db-ad91-001083ff6836")) {
                strClassID = "SAS Application Server";
            }
            String[] aryClassIDs = new String[]{strClassID};
            if (strClassID.equalsIgnoreCase("Postgres")) {
                aryClassIDs = new String[]{strClassID, "SASInfrastructureData"};
            }
            String serverWizardTitle = bundle.getString("ServerWizard.Title.txt");
            if (strClassID == null) {
                if (parent instanceof JFrame) {
                    wizard = new ServerWizard((JFrame)parent, this.m_library.getContext(), serverWizardTitle, oStore);
                } else if (parent instanceof Dialog) {
                    wizard = new ServerWizard((Dialog)parent, oStore, this.m_library.getContext(), serverWizardTitle);
                }
            } else if (parent instanceof JFrame) {
                wizard = new ServerWizard((JFrame)parent, this.m_library.getContext(), serverWizardTitle, aryClassIDs, oStore);
            } else if (parent instanceof Dialog) {
                wizard = new ServerWizard((Dialog)parent, oStore, this.m_library.getContext(), serverWizardTitle, aryClassIDs);
            }
            wizard.show();
            if (wizard.getReturnValue() == 2) {
                Workspace.getMdFactory().removeMdFactoryListener((MdFactoryListener)viewListener);
            }
            if (oStore != null) {
                oStore.dispose();
            }
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
    }

    public void onNewConnection() {
        try {
            MdObjectStore oStore = Workspace.getMdFactory().createObjectStore();
            ViewListener viewListener = new ViewListener(this.m_connectionChoice, "SASClientConnection", oStore);
            Workspace.getMdFactory().addMdFactoryListener((MdFactoryListener)viewListener);
            Container parent = this.getTopLevelAncestor();
            ConnectionWizard wizard = null;
            if (parent instanceof JFrame) {
                wizard = new ConnectionWizard((JFrame)parent, this.m_library.getContext(), (ServerComponent)this.m_selectedServer, oStore);
            } else if (parent instanceof Dialog) {
                wizard = new ConnectionWizard((Dialog)parent, this.m_library.getContext(), (ServerComponent)this.m_selectedServer, oStore);
            }
            wizard.show();
            if (wizard.getReturnValue() == 2) {
                Workspace.getMdFactory().removeMdFactoryListener((MdFactoryListener)viewListener);
            }
            if (oStore != null) {
                oStore.dispose();
            }
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
    }

    public void onNewUsingPackage() {
        try {
            MdObjectStore oStore = Workspace.getMdFactory().createObjectStore();
            String strClassID = this.m_selectedServer.getClassIdentifier();
            if (strClassID.equalsIgnoreCase("SHARE")) {
                ViewListener viewListener = new ViewListener(this.m_remoteLibraryChoice, "SASLibrary", oStore);
                Workspace.getMdFactory().addMdFactoryListener((MdFactoryListener)viewListener);
                Container parent = this.getTopLevelAncestor();
                LibraryWizard wizard = null;
                SASLibrary sasLibrary = (SASLibrary)Workspace.getMdFactory().createComplexMetadataObject(oStore, null, "Library", "SASLibrary", this.m_library.getContext().substring(9));
                Hashtable<SASLibrary, Hashtable[]> propertiesTable = new Hashtable<SASLibrary, Hashtable[]>();
                Hashtable<String, String> valueTable = new Hashtable<String, String>();
                valueTable.put("AssociationName", "DeployedComponents");
                valueTable.put("MetadataType", "ServerComponent");
                valueTable.put("DefaultValue", (String)this.m_selectedServer);
                Hashtable[] tableArray = new Hashtable[]{valueTable};
                propertiesTable.put(sasLibrary, tableArray);
                if (parent instanceof JFrame) {
                    wizard = new LibraryWizard((JFrame)parent, this.m_library.getContext(), bundle.getString("DBMSLibname.RemoteLibraryWizard.Title.txt"), null, oStore, propertiesTable);
                } else if (parent instanceof Dialog) {
                    wizard = new LibraryWizard((Dialog)parent, this.m_library.getContext(), bundle.getString("DBMSLibname.RemoteLibraryWizard.Title.txt"), null, oStore, propertiesTable);
                }
                wizard.show();
                if (wizard.getReturnValue() == 2) {
                    Workspace.getMdFactory().removeMdFactoryListener((MdFactoryListener)viewListener);
                }
            }
            if (oStore != null) {
                oStore.dispose();
            }
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
    }

    protected void _setViewProperties() {
        try {
            if (!this.isEditable()) {
                return;
            }
            SASLibrary library = (SASLibrary)this.m_library.getDeployedDataPackage();
            if (this.m_connectionChoice.getSelectedItem() != null && this.m_connectionChoice.getSelectedItem() instanceof SASClientConnection) {
                SASClientConnection connection = (SASClientConnection)this.m_connectionChoice.getSelectedItem();
                if (library.getLibraryConnection() != connection) {
                    library.setLibraryConnection(connection);
                }
            }
            Login login = null;
            if (this.m_loginChoice.getSelectedItem() instanceof Login) {
                this.m_selectedLogin = login = (Login)this.m_loginChoice.getSelectedItem();
            }
            if (login == null && library.getDefaultLogins().size() > 0) {
                library.getDefaultLogins().removeAllElements();
            }
            if (login != null && library.getDefaultLogin() != login) {
                library.setDefaultLogin(login);
            }
            if (!this.m_bShareServer) {
                DatabaseSchema schema = null;
                if (library.getUsingPackages().size() > 0) {
                    for (int count = 0; count < library.getUsingPackages().size(); ++count) {
                        Root root = (Root)library.getUsingPackages().get(count);
                        if (!(root instanceof DatabaseSchema)) continue;
                        schema = (DatabaseSchema)root;
                        break;
                    }
                    if (schema != null && !schema.getName().equals(library.getName())) {
                        schema.setName(library.getName());
                    }
                }
                if (schema == null) {
                    schema = (DatabaseSchema)Workspace.getMdFactory().createComplexMetadataObject(this.m_library.getStore(), null, library.getName(), "DatabaseSchema", this.m_library.getContext().substring(9), null);
                    Workspace.getDefaultLogger().debug((Object)("Created new DatabaseSchema '" + schema.getName() + "'"));
                }
                String schemaName = this.m_schemaNameAttrText.getText().trim();
                if (!schema.getSchemaName().equals(schemaName)) {
                    schema.setSchemaName(schemaName);
                    Workspace.getDefaultLogger().debug((Object)("setSchemaName '" + schemaName + "' performed on DatabaseSchema '" + schema.getName() + "'"));
                }
                if (!library.getUsingPackages().contains(schema)) {
                    library.getUsingPackages().add((Object)schema);
                    Workspace.getDefaultLogger().debug((Object)("Associated DatabaseSchema '" + schema.getName() + "' (schema name attribute: '" + schema.getSchemaName() + "') to SASLibrary '" + library.getName() + "'"));
                }
                if (this.m_selectedServer != null && !schema.getDeployedComponents().contains((Object)this.m_selectedServer)) {
                    AssociationList schemaDeployedComponentsList = schema.getDeployedComponents();
                    schemaDeployedComponentsList.clear();
                    schemaDeployedComponentsList.add(this.m_selectedServer);
                    Workspace.getDefaultLogger().debug((Object)("Associated DatabaseSchema '" + schema.getName() + "' (schema name attribute: '" + schema.getSchemaName() + "') to Database Server '" + this.m_selectedServer.getName() + "'"));
                }
            } else {
                SASLibrary saslibrary = null;
                if (this.m_remoteLibraryChoice.getSelectedItem() instanceof SASLibrary) {
                    saslibrary = (SASLibrary)this.m_remoteLibraryChoice.getSelectedItem();
                }
                if (saslibrary == null && library.getUsingPackages().size() > 0) {
                    library.getUsingPackages().removeAllElements();
                }
                if (saslibrary != null && !library.getUsingPackages().contains((Object)saslibrary)) {
                    library.getUsingPackages().removeAllElements();
                    library.getUsingPackages().add((Object)saslibrary);
                    Workspace.getDefaultLogger().debug((Object)("Associated remote SASLibrary '" + saslibrary.getName() + "' to SAS/Share Library '" + library.getName() + "'"));
                }
                if (saslibrary != null && this.m_selectedServer != null && !this.m_selectedServer.getDataPackages().contains((Object)saslibrary)) {
                    this.m_selectedServer.getDataPackages().add((Object)saslibrary);
                    Workspace.getDefaultLogger().debug((Object)("Associated remote SASLibrary '" + saslibrary.getName() + "' to SAS/Share Server '" + this.m_selectedServer.getName() + "'"));
                }
            }
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
    }

    public void onNext() {
        if (this.m_serverChoice.getItemCount() == 0) {
            return;
        }
        this._setViewProperties();
        try {
            if (((SASLibrary)this.m_library.getDeployedDataPackage()).getEngine().equalsIgnoreCase("SASIOLA")) {
                this.setConditionState("AUTHORIZATION");
            }
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
    }

    public void onBack() {
        this._setViewProperties();
    }

    public String createFinishString() {
        String serverName = MetadataObjectCellRenderer.getDisplayName((Root)this.m_selectedServer);
        String schemaName = this.m_schemaNameAttrText.getText().trim();
        String strFinish = new String();
        if (this.m_bShareServer) {
            strFinish = strFinish + bundle.getString("DBMSLibname.ShareServerLabel.txt") + "\n\t" + serverName + "\n";
            strFinish = strFinish + bundle.getString("DBMSLibname.RemoteLibraryLabel.txt") + "\n\t" + MetadataObjectCellRenderer.getDisplayName((Root)this.m_remoteLibraryChoice.getSelectedItem()) + "\n";
        } else if (this.m_bSPDServer) {
            strFinish = strFinish + bundle.getString("DBMSLibname.SPDServerLabel.txt") + "\n\t" + serverName + "\n";
            strFinish = strFinish + bundle.getString("DBMSLibname.SPDSchemaLabel.txt") + "\n\t" + schemaName + "\n";
        } else {
            strFinish = strFinish + bundle.getString("DBMSLibname.ServerLabel.txt") + "\n\t" + serverName + "\n";
            if (schemaName.length() > 0) {
                strFinish = strFinish + bundle.getString("DBMSLibname.DBSchemaNameAttrLabel.txt") + "\n\t" + schemaName + "\n";
            }
        }
        if (this.m_connectionChoice.getSelectedItem() instanceof Root) {
            strFinish = strFinish + bundle.getString("DBMSLibname.ConnectionLabel.txt") + "\n\t" + MetadataObjectCellRenderer.getDisplayName((Root)this.m_connectionChoice.getSelectedItem()) + "\n";
        }
        if (this.m_loginChoice.getSelectedItem() instanceof Root) {
            strFinish = strFinish + bundle.getString("DBMSLibname.LoginLabel.txt") + "\n\t" + MetadataObjectCellRenderer.getDisplayName((Root)this.m_loginChoice.getSelectedItem()) + "\n";
        }
        return strFinish;
    }

    protected String _getClassID(Library library) {
        return this._getClassID(library, false);
    }

    protected String _getClassID(Library library, boolean bShowPrototypeSelector) {
        try {
            this.m_bShareServer = false;
            this.m_bSPDServer = false;
            this.m_bShowSchema = true;
            String strClassID = ((SASLibrary)library.getDeployedDataPackage()).getEngine();
            String libClassID = ((SASLibrary)library.getDeployedDataPackage()).getEngine();
            if (libClassID != null) {
                libClassID = libClassID.toUpperCase();
            }
            if (strClassID.equalsIgnoreCase("DB2") || "SASHDAT".equalsIgnoreCase(libClassID)) {
                try {
                    Prototype prototype = library.getDeployedDataPackagePrototype(this.getTopLevelAncestor(), bShowPrototypeSelector);
                    if (prototype == null) {
                        return strClassID;
                    }
                    AssociationList extensionsList = prototype.getExtensions();
                    for (int i = 0; i < extensionsList.size(); ++i) {
                        Extension extension = (Extension)extensionsList.get(i);
                        if (!extension.getName().equals("ServerClassIdentifier")) continue;
                        strClassID = extension.getValue();
                        break;
                    }
                }
                catch (MdException exc) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Reading");
                    return strClassID;
                }
                catch (RemoteException exc) {
                    Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
                }
            }
            if (strClassID.startsWith("REMOTE")) {
                strClassID = "SHARE";
                this.m_bShareServer = true;
            } else if (DBMS_SCHEMA_UNSUPPORTED.contains(libClassID)) {
                this.m_bShowSchema = false;
            }
            if (strClassID.equalsIgnoreCase("FEDSVR")) {
                strClassID = "e803e04b-aaf0-4c74-86a6-f7008aa702dc";
            }
            if (strClassID.startsWith("SASSPDS")) {
                this.m_bSPDServer = true;
            }
            return strClassID;
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
            return null;
        }
    }

    protected void _updateDependentComboBoxes(DeployedComponent dc) {
        try {
            AssociationList connectionsList = dc.getSourceConnections();
            for (int connIndex = 0; connIndex < connectionsList.size(); ++connIndex) {
                Connection conn = (Connection)connectionsList.get(connIndex);
                if (!(conn instanceof SASClientConnection)) continue;
                AssociationList loginList = ((SASClientConnection)conn).getDomain().getLogins();
                for (int i = 0; i < loginList.size(); ++i) {
                    Login login = (Login)loginList.get(i);
                    if (this.m_loginsList.contains(login)) continue;
                    this.m_loginsList.add(login);
                    this.populateLogins();
                }
            }
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Reading");
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
    }

    protected void _updateDependentComboBoxes(SASClientConnection conn) {
        try {
            AssociationList loginList = conn.getDomain().getLogins();
            for (int i = 0; i < loginList.size(); ++i) {
                Login login = (Login)loginList.get(i);
                if (this.m_loginsList.contains(login)) continue;
                this.m_loginsList.add(login);
                this.populateLogins();
            }
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Reading");
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
    }

    protected void _hideDisabledComboBoxEntries() {
        try {
            boolean bHide = false;
            if (((SASLibrary)this.m_library.getDeployedDataPackage()).getEngine().equalsIgnoreCase("EXCEL") || ((SASLibrary)this.m_library.getDeployedDataPackage()).getEngine().equalsIgnoreCase("ACCESS") || ((SASLibrary)this.m_library.getDeployedDataPackage()).getEngine().equalsIgnoreCase("SASIOSR3") || this.m_selectedServer.getProductName().equalsIgnoreCase("ODBCEXCEL") || this.m_selectedServer.getProductName().equalsIgnoreCase("OLEDBEXCEL") || this.m_selectedServer.getProductName().equalsIgnoreCase("OLEDBACCESS") || this.m_selectedServer.getProductName().equalsIgnoreCase("ODBCACCESS")) {
                bHide = true;
            }
            this.m_loginChoice.getRenderer();
            if (!this.m_loginChoice.isEnabled() && bHide) {
                this.m_loginChoice.setRenderer(new DefaultListCellRenderer(){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                        Component comp = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                        ((JLabel)comp).setText(" ");
                        return comp;
                    }
                });
            } else {
                this.m_loginChoice.setRenderer(new MetadataObjectCellRenderer());
            }
            this.m_loginChoice.invalidate();
            this.m_loginChoice.revalidate();
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
    }

    public void setEditable(boolean bEditable) {
        try {
            String engine;
            boolean bServerExists;
            super.setEditable(bEditable);
            this.m_serverChoice.setEnabled(bEditable);
            this.m_serverButton.setEnabled(bEditable);
            boolean bl = bServerExists = this.m_serverChoice.getItemCount() > 0;
            if (((SASLibrary)this.m_library.getDeployedDataPackage()).getEngine().equalsIgnoreCase("EXCEL") || ((SASLibrary)this.m_library.getDeployedDataPackage()).getEngine().equalsIgnoreCase("SASIOSR3")) {
                bServerExists = false;
            }
            boolean bEnableSchema = !SCHEMA_GRAYED_OUT.contains(engine = ((SASLibrary)this.m_library.getDeployedDataPackage()).getEngine().toUpperCase());
            this.m_loginChoice.setEnabled(bEditable && bServerExists);
            this.m_remoteLibraryChoice.setEnabled(bEditable && bServerExists && bEnableSchema);
            this.m_remoteLibraryButton.setEnabled(bEditable && bServerExists && bEnableSchema);
            this.m_schemaNameAttrText.setEnabled(bEditable && bServerExists && bEnableSchema);
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
    }

    public void saveSettingsAndCleanUp() {
        if (this.m_selectedLogin == null || this.m_currentLogin == this.m_selectedLogin) {
            return;
        }
        Workspace.getWorkspace().getWorkspaceFile().removeProperty("DBMSLibname.MRU.Domain.3");
        Workspace.getWorkspace().getWorkspaceFile().removeProperty("DBMSLibname.MRU.Login.3");
        String strDomainMRU2 = Workspace.getWorkspace().getWorkspaceFile().getPropertyString("DBMSLibname.MRU.Domain.2");
        String strLoginMRU2 = Workspace.getWorkspace().getWorkspaceFile().getPropertyString("DBMSLibname.MRU.Login.2");
        if (strDomainMRU2.length() > 0 && strLoginMRU2.length() > 0) {
            Workspace.getWorkspace().getWorkspaceFile().setPropertyString("DBMSLibname.MRU.Domain.3", strDomainMRU2);
            Workspace.getWorkspace().getWorkspaceFile().setPropertyString("DBMSLibname.MRU.Login.3", strLoginMRU2);
        }
        String strDomainMRU1 = Workspace.getWorkspace().getWorkspaceFile().getPropertyString("DBMSLibname.MRU.Domain.1");
        String strLoginMRU1 = Workspace.getWorkspace().getWorkspaceFile().getPropertyString("DBMSLibname.MRU.Login.1");
        if (strDomainMRU1.length() > 0 && strLoginMRU1.length() > 0) {
            Workspace.getWorkspace().getWorkspaceFile().setPropertyString("DBMSLibname.MRU.Domain.2", strDomainMRU1);
            Workspace.getWorkspace().getWorkspaceFile().setPropertyString("DBMSLibname.MRU.Login.2", strLoginMRU1);
        }
        try {
            if (this.m_selectedLogin.getDomain() != null) {
                Workspace.getWorkspace().getWorkspaceFile().setPropertyString("DBMSLibname.MRU.Domain.1", this.m_selectedLogin.getDomain().getName());
            } else {
                Workspace.getWorkspace().getWorkspaceFile().setPropertyString("DBMSLibname.MRU.Domain.1", " ");
            }
            Workspace.getWorkspace().getWorkspaceFile().setPropertyString("DBMSLibname.MRU.Login.1", this.m_selectedLogin.getUserID());
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
        Workspace.getWorkspace().getWorkspaceFile().saveExisting();
    }

    protected void _initialize() {
        this.setHelpProduct("newlibrary");
        this.setHelpTopic("libwiz_4a");
        this.setDescription(bundle.getString("DBMSLibname.TabDesc.txt"));
        this.m_descriptionText = new WATextArea();
        this.m_descriptionText.setText(bundle.getString("DBMSLibname.TabDesc.txt"));
        this.m_descriptionText.setEditable(false);
        this.m_descriptionText.setLineWrap(true);
        this.m_descriptionText.setWrapStyleWord(true);
        this.m_descriptionText.setBorder(null);
        this.m_descriptionText.setBackground(this.getBackground());
        this.m_dataServerDetailsPanel = new JPanel();
        this.m_dataServerDetailsPanel.setBorder(new TitledBorder(bundle.getString("DBMSLibname.DataServerDetailsTitle.txt")));
        this.m_serverLabel = new JLabel();
        MnemonicModel.setLabelTextAndMnemonic(this.m_serverLabel, bundle.getString("DBMSLibname.ServerLabel.withMnemonic.txt"));
        this.m_serverChoice = new JComboBox();
        this.m_serverLabel.setLabelFor(this.m_serverChoice);
        this.m_serverChoice.getAccessibleContext().setAccessibleName(bundle.getString("DBMSLibname.ServerLabel.notrans"));
        this.m_serverChoice.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                DBMSLibnamePropertyView.this.onServerChanged();
            }
        });
        this.m_serverButton = new JButton();
        MnemonicModel.setButtonTextAndMnemonic(this.m_serverButton, bundle.getString("DBMSLibname.ServerButton.txt"));
        this.m_serverButton.getAccessibleContext().setAccessibleName(bundle.getString("DBMSLibname.ServerButton.notrans"));
        this.m_serverButton.setMargin(new Insets(0, 4, 0, 4));
        this.m_serverButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DBMSLibnamePropertyView.this.onNewServer();
            }
        });
        this.m_remoteLibraryLabel = new JLabel();
        MnemonicModel.setLabelTextAndMnemonic(this.m_remoteLibraryLabel, bundle.getString("DBMSLibname.RemoteLibraryLabel.withMnemonic.txt"));
        this.m_remoteLibraryLabel.setVisible(false);
        this.m_remoteLibraryChoice = new JComboBox();
        this.m_remoteLibraryLabel.setLabelFor(this.m_remoteLibraryChoice);
        this.m_remoteLibraryChoice.setRenderer(new MetadataObjectCellRenderer());
        this.m_remoteLibraryChoice.getAccessibleContext().setAccessibleName(bundle.getString("DBMSLibname.RemoteLibraryLabel.notrans"));
        this.m_remoteLibraryChoice.setVisible(false);
        this.m_remoteLibraryButton = new JButton();
        MnemonicModel.setButtonTextAndMnemonic(this.m_remoteLibraryButton, bundle.getString("DBMSLibname.RemoteLibraryButton.txt"));
        this.m_remoteLibraryButton.getAccessibleContext().setAccessibleName(bundle.getString("DBMSLibname.RemoteLibraryButton.notrans"));
        this.m_remoteLibraryButton.setVisible(false);
        this.m_remoteLibraryButton.setMargin(new Insets(0, 4, 0, 4));
        this.m_remoteLibraryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DBMSLibnamePropertyView.this.onNewUsingPackage();
            }
        });
        this.m_schemaNameAttrLabel = new JLabel();
        MnemonicModel.setLabelTextAndMnemonic(this.m_schemaNameAttrLabel, bundle.getString("DBMSLibname.DBSchemaNameAttrLabel.withMnemonic.txt"));
        this.m_schemaNameAttrText = new WATextField();
        this.m_schemaNameAttrLabel.setLabelFor((Component)this.m_schemaNameAttrText);
        this.m_schemaNameAttrText.getAccessibleContext().setAccessibleName(bundle.getString("DBMSLibname.DBSchemaNameAttrLabel.notrans"));
        this.m_connectionDetailsPanel = new JPanel();
        this.m_connectionDetailsPanel.setBorder(new TitledBorder(bundle.getString("DBMSLibname.ConnectionDetailsTitle.txt")));
        this.m_connectionLabel = new JLabel();
        MnemonicModel.setLabelTextAndMnemonic(this.m_connectionLabel, bundle.getString("DBMSLibname.ConnectionLabel.withMnemonic.txt"));
        this.m_connectionChoice = new JComboBox();
        this.m_connectionLabel.setLabelFor(this.m_connectionChoice);
        this.m_connectionChoice.getAccessibleContext().setAccessibleName(bundle.getString("DBMSLibname.ConnectionLabel.notrans"));
        this.m_connectionChoice.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                DBMSLibnamePropertyView.this.onConnectionChanged();
            }
        });
        this.m_connectionButton = new JButton();
        MnemonicModel.setButtonTextAndMnemonic(this.m_connectionButton, bundle.getString("DBMSLibname.ConnectionButton.txt"));
        this.m_connectionButton.getAccessibleContext().setAccessibleName(bundle.getString("DBMSLibname.ConnectionButton.notrans"));
        this.m_connectionButton.setMargin(new Insets(0, 4, 0, 4));
        this.m_connectionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DBMSLibnamePropertyView.this.onNewConnection();
            }
        });
        this.m_loginLabel = new JLabel();
        MnemonicModel.setLabelTextAndMnemonic(this.m_loginLabel, bundle.getString("DBMSLibname.LoginLabel.withMnemonic.txt"));
        this.m_loginChoice = new JComboBox();
        this.m_loginLabel.setLabelFor(this.m_loginChoice);
        this.m_loginChoice.setRenderer(new MetadataObjectCellRenderer());
        this.m_loginChoice.setEnabled(false);
        this.m_loginChoice.getAccessibleContext().setAccessibleName(bundle.getString("DBMSLibname.LoginLabel.notrans"));
        this.m_loginChoice.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                DBMSLibnamePropertyView.this.onMoreLogins(evt);
            }
        });
    }

    protected void _layoutWidgets() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagLayout gbl = new GridBagLayout();
        int gy = 0;
        this.m_dataServerDetailsPanel.setLayout(gbl);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gy;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 12, 0, 0);
        gbl.setConstraints(this.m_serverLabel, gbc);
        this.m_dataServerDetailsPanel.add(this.m_serverLabel);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gy;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 12, 0, 0);
        gbl.setConstraints(this.m_serverChoice, gbc);
        this.m_dataServerDetailsPanel.add(this.m_serverChoice);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = gy++;
        gbc.insets = new Insets(12, 12, 0, 12);
        gbl.setConstraints(this.m_serverButton, gbc);
        this.m_dataServerDetailsPanel.add(this.m_serverButton);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gy;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 12, 12, 0);
        gbl.setConstraints(this.m_schemaNameAttrLabel, gbc);
        this.m_dataServerDetailsPanel.add(this.m_schemaNameAttrLabel);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gy++;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 12, 12, 0);
        gbl.setConstraints((Component)this.m_schemaNameAttrText, gbc);
        this.m_dataServerDetailsPanel.add((Component)this.m_schemaNameAttrText);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gy;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 12, 12, 0);
        gbl.setConstraints(this.m_remoteLibraryLabel, gbc);
        this.m_dataServerDetailsPanel.add(this.m_remoteLibraryLabel);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gy;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 12, 12, 0);
        gbl.setConstraints(this.m_remoteLibraryChoice, gbc);
        this.m_dataServerDetailsPanel.add(this.m_remoteLibraryChoice);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = gy;
        gbc.insets = new Insets(12, 12, 12, 12);
        gbl.setConstraints(this.m_remoteLibraryButton, gbc);
        this.m_dataServerDetailsPanel.add(this.m_remoteLibraryButton);
        gbl = new GridBagLayout();
        gy = 0;
        this.m_connectionDetailsPanel.setLayout(gbl);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gy;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 12, 0, 0);
        gbl.setConstraints(this.m_connectionLabel, gbc);
        this.m_connectionDetailsPanel.add(this.m_connectionLabel);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gy;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 12, 0, 0);
        gbl.setConstraints(this.m_connectionChoice, gbc);
        this.m_connectionDetailsPanel.add(this.m_connectionChoice);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = gy++;
        gbc.insets = new Insets(12, 12, 0, 12);
        gbl.setConstraints(this.m_connectionButton, gbc);
        this.m_connectionDetailsPanel.add(this.m_connectionButton);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gy;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 12, 12, 0);
        gbl.setConstraints(this.m_loginLabel, gbc);
        this.m_connectionDetailsPanel.add(this.m_loginLabel);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gy;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 12, 12, 0);
        gbl.setConstraints(this.m_loginChoice, gbc);
        this.m_connectionDetailsPanel.add(this.m_loginChoice);
        int gridy = 0;
        if (this.m_type == 1) {
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = gridy++;
            gbc.weightx = 1.0;
            gbc.fill = 2;
            gbc.gridwidth = 0;
            gbc.anchor = 17;
            gbc.insets = new Insets(12, 12, 0, 12);
            gridBagLayout.setConstraints((Component)this.m_descriptionText, gbc);
            this.add((Component)this.m_descriptionText);
        }
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.gridwidth = 0;
        gbc.insets = new Insets(12, 12, 12, 12);
        gridBagLayout.setConstraints(this.m_dataServerDetailsPanel, gbc);
        this.add(this.m_dataServerDetailsPanel);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.gridwidth = 0;
        gbc.insets = new Insets(12, 12, 12, 12);
        gridBagLayout.setConstraints(this.m_connectionDetailsPanel, gbc);
        this.add(this.m_connectionDetailsPanel);
        JPanel eaterPanel = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.gridwidth = 0;
        gbc.gridheight = 0;
        gridBagLayout.setConstraints(eaterPanel, gbc);
        this.add(eaterPanel);
    }

    protected class ViewListener
    implements MdFactoryListener {
        protected JComboBox m_choice;
        protected String m_strMetadataType;
        protected MdObjectStore m_store;

        public ViewListener(JComboBox choice, String strMetadataType, MdObjectStore store) {
            this.m_choice = choice;
            this.m_strMetadataType = strMetadataType;
            this.m_store = store;
        }

        public void MdObjectsCreated(MdFactoryEvent e) {
            try {
                boolean bProcessed = false;
                Object[] ids = e.getObjectMap().keySet().toArray();
                for (int i = 0; i < ids.length; ++i) {
                    String strFQID;
                    String strID = (String)ids[i];
                    CMetadata meta = this.m_store.getObject(strID);
                    if (meta == null || !meta.getCMetadataType().equals(this.m_strMetadataType)) continue;
                    Root root = (Root)meta;
                    this.m_choice.removeAllItems();
                    List itemsList = null;
                    String strType = this.m_strMetadataType;
                    String strTemplate = DBMSLibnamePropertyView.EMPTY_ITEM;
                    String strSelect = DBMSLibnamePropertyView.EMPTY_ITEM;
                    if (this.m_strMetadataType.equals("ServerComponent")) {
                        strTemplate = "<TEMPLATES><ServerComponent><SourceConnections/><DataPackages/></ServerComponent><SASClientConnection><Domain/></SASClientConnection><AuthenticationDomain/><DatabaseSchema/></TEMPLATES>";
                        String strClassID = DBMSLibnamePropertyView.this._getClassID(DBMSLibnamePropertyView.this.m_library);
                        if (strClassID != null) {
                            strSelect = "<XMLSELECT search=\"*[@ClassIdentifier='" + strClassID + "']\"/>";
                            if (strClassID.equalsIgnoreCase("Postgres")) {
                                strSelect = "<XMLSELECT search=\"*[@ClassIdentifier='" + strClassID + "' OR @ClassIdentifier='" + "SASInfrastructureData" + "']\"/>";
                            }
                        }
                    }
                    if (this.m_strMetadataType.equals("SASClientConnection")) {
                        strTemplate = "<TEMPLATES><SASClientConnection><Domain/></SASClientConnection><AuthenticationDomain/></TEMPLATES>";
                        strFQID = DBMSLibnamePropertyView.this.m_selectedServer.getFQID();
                        strSelect = "<XMLSELECT search=\"*[Source/ServerComponent[@Id='" + strFQID + "']]\"/>";
                    }
                    if (this.m_strMetadataType.equals("SASLibrary")) {
                        strTemplate = "<TEMPLATES><SASLibrary><DeployedComponents/></SASLibrary></TEMPLATES>";
                        strFQID = DBMSLibnamePropertyView.this.m_selectedServer.getFQID();
                        strSelect = "<XMLSELECT search=\"*[DeployedComponents/*[@Id='" + strFQID + "']]\"/>";
                    }
                    String strOptions = strTemplate + strSelect;
                    int flags = 8588;
                    try {
                        itemsList = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset(DBMSLibnamePropertyView.this.m_library.getDeployedDataPackage().getObjectStore(), DBMSLibnamePropertyView.this.m_library.getContext(), strType, flags, strOptions);
                    }
                    catch (MdException exc) {
                        MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Reading");
                        return;
                    }
                    catch (RemoteException exc) {
                        Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
                    }
                    for (int j = 0; itemsList != null && j < itemsList.size(); ++j) {
                        Root itemRoot = (Root)itemsList.get(j);
                        this.m_choice.addItem(itemRoot);
                        if (!itemRoot.getFQID().equals(root.getFQID())) continue;
                        this.m_choice.setSelectedItem(itemRoot);
                        bProcessed = true;
                    }
                }
                if (bProcessed) {
                    Workspace.getMdFactory().removeMdFactoryListener((MdFactoryListener)this);
                }
            }
            catch (RemoteException exc) {
                Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
            }
        }

        public void MdObjectsModified(MdFactoryEvent e) {
        }

        public void MdObjectsDeleted(MdFactoryEvent e) {
        }
    }
}

