/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals;

import com.sas.workspace.WAPanel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.mgmt.MnemonicModel;
import com.sas.workspace.visuals.LogonView;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;

public class CredentialsPanel
extends WAPanel {
    private static final long serialVersionUID = 1L;
    public static int CRED_USERPW = 1;
    public static int CRED_ACQUIRE = 2;
    private int m_credentialType = CRED_USERPW;
    protected JRadioButton m_rdoEnterCred;
    protected JRadioButton m_rdoAcquireCred;
    private LogonView m_logonView;
    protected static WAdminResource bundle = new WAdminResource(CredentialsPanel.class);

    public CredentialsPanel() {
        this.initialize();
        this.layoutWidgets();
    }

    public String getUserID() {
        return this.m_logonView.getUserName();
    }

    public String getPassword() {
        return this.m_logonView.getPassword();
    }

    public int getCredentialType() {
        return this.m_credentialType;
    }

    protected void onEnterCredentials() {
        this.m_logonView.setEditable(true);
        this.m_credentialType = CRED_USERPW;
    }

    protected void onAcquireCredentials() {
        this.m_logonView.setEditable(false);
        this.m_credentialType = CRED_ACQUIRE;
    }

    protected void initialize() {
        String strEnterCred = bundle.getString("CredentialsPanel.EnterCred.txt");
        this.m_rdoEnterCred = new JRadioButton(MnemonicModel.getLabelWithoutMnemonic(strEnterCred));
        MnemonicModel.setButtonTextAndMnemonic(this.m_rdoEnterCred, strEnterCred);
        this.m_rdoEnterCred.setSelected(true);
        this.m_rdoEnterCred.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (CredentialsPanel.this.m_rdoEnterCred.isSelected()) {
                    CredentialsPanel.this.onEnterCredentials();
                }
            }
        });
        String strAcquireCred = bundle.getString("CredentialsPanel.AcquireCred.txt");
        this.m_rdoAcquireCred = new JRadioButton(MnemonicModel.getLabelWithoutMnemonic(strAcquireCred));
        MnemonicModel.setButtonTextAndMnemonic(this.m_rdoAcquireCred, strAcquireCred);
        this.m_rdoAcquireCred.setSelected(false);
        this.m_rdoAcquireCred.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (CredentialsPanel.this.m_rdoAcquireCred.isSelected()) {
                    CredentialsPanel.this.onAcquireCredentials();
                }
            }
        });
        ButtonGroup group = new ButtonGroup();
        group.add(this.m_rdoEnterCred);
        group.add(this.m_rdoAcquireCred);
        this.m_logonView = new LogonView();
        this.m_logonView.requestFocus();
    }

    protected void layoutWidgets() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        int gridy = 0;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy++;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 12, 0, 0);
        gridBagLayout.setConstraints(this.m_rdoEnterCred, gbc);
        this.add(this.m_rdoEnterCred);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(6, 18, 0, 0);
        gridBagLayout.setConstraints((Component)this.m_logonView, gbc);
        this.add((Component)this.m_logonView);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 12, 0, 0);
        gridBagLayout.setConstraints(this.m_rdoAcquireCred, gbc);
        this.add(this.m_rdoAcquireCred);
    }
}

