/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals;

import com.sas.workspace.WAdminResource;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.layout.PatternLayout;

public class ActionLogger {
    protected static WAdminResource bundle = new WAdminResource(ActionLogger.class);
    private String prefix;
    private Collection<Logger> loggers;
    private boolean consoleEnabled = false;
    private boolean timestampsEnabled = false;
    private boolean debug = false;
    private Level level = Level.INFO;
    private Appender fileAppender;
    private Appender consoleAppender;
    private String logFileName;
    private String logFileOption;

    public ActionLogger(String prefix, Collection<Logger> loggers) {
        this.prefix = prefix;
        this.loggers = loggers;
    }

    public void setConsoleEnabled(boolean consoleEnabled) {
        this.consoleEnabled = consoleEnabled;
    }

    public void setTimestampsEnabled(boolean timestampsEnabled) {
        this.timestampsEnabled = timestampsEnabled;
    }

    public void setLogLevel(Level level) {
        this.level = level;
        if (Level.DEBUG.equals((Object)level)) {
            this.debug = true;
        }
    }

    public String getLogFileName() {
        return this.logFileName;
    }

    public void open() throws IOException {
        if (this.loggers == null || this.loggers.isEmpty()) {
            return;
        }
        LoggerContext lc = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = lc.getConfiguration();
        PatternLayout layout = PatternLayout.newBuilder().withConfiguration(config).withPattern((this.timestampsEnabled ? bundle.getString("ActionLogger.LogPatternTimePrefix.txt") + " " : "") + (this.debug ? bundle.getString("ActionLogger.LogPatternDebug.txt") : bundle.getString("ActionLogger.LogPattern.txt"))).build();
        if (this.consoleEnabled) {
            this.consoleAppender = ((ConsoleAppender.Builder)((ConsoleAppender.Builder)((ConsoleAppender.Builder)ConsoleAppender.newBuilder().setName("SASConsoleAppender")).setLayout((Layout)layout)).setConfiguration(config)).build();
            this.consoleAppender.start();
            config.addAppender(this.consoleAppender);
        }
        this.makeLogFileAppender(layout, config);
        for (Logger logger : this.loggers) {
            config.getLoggerConfig(logger.getName()).setLevel(this.level);
            config.getLoggerConfig(logger.getName()).setAdditive(false);
            if (this.consoleAppender != null) {
                lc.getLogger(logger.getName()).addAppender(config.getAppender(this.consoleAppender.getName()));
            }
            if (this.fileAppender == null) continue;
            lc.getLogger(logger.getName()).addAppender(config.getAppender(this.fileAppender.getName()));
        }
        lc.updateLoggers();
    }

    public void close() {
        if (this.loggers == null || this.loggers.isEmpty()) {
            return;
        }
        LoggerContext lc = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = lc.getConfiguration();
        for (Logger logger : this.loggers) {
            LoggerConfig loggerConfig = config.getLoggerConfig(logger.getName());
            if (this.consoleAppender != null) {
                loggerConfig.removeAppender(this.consoleAppender.getName());
            }
            if (this.fileAppender == null) continue;
            loggerConfig.removeAppender(this.fileAppender.getName());
        }
        lc.updateLoggers();
    }

    protected void makeLogFileAppender(PatternLayout layout, Configuration config) throws IOException {
        this.fileAppender = null;
        String logDirectory = null;
        this.logFileName = null;
        if (this.logFileOption == null) {
            logDirectory = ActionLogger.getDefaultLogDirectory(null, null);
            if (logDirectory == null) {
                return;
            }
        } else {
            File testLogFile = new File(this.logFileOption);
            if (testLogFile.isDirectory()) {
                logDirectory = this.logFileOption;
            } else {
                this.logFileName = this.logFileOption;
            }
        }
        if (this.logFileName == null) {
            String fileSep = File.separator;
            if (logDirectory.endsWith(fileSep)) {
                fileSep = "";
            }
            SimpleDateFormat sdf = new SimpleDateFormat("_yyMMddHHmmss'.log'");
            String suffix = sdf.format(new Date());
            this.logFileName = logDirectory + fileSep + this.prefix + suffix;
        }
        this.fileAppender = ((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)FileAppender.newBuilder().setName("SASFileAppender")).withFileName(this.logFileName).setLayout((Layout)layout)).setConfiguration(config)).build();
        this.fileAppender.start();
        config.addAppender(this.fileAppender);
    }

    public static String getDefaultLogDirectory(String application, String version) {
        File dirFile;
        String appData = ActionLogger.getAppDataPath();
        String separator = File.separator;
        String dirPath = appData + separator + "SAS";
        if (application != null) {
            dirPath = dirPath + separator + application;
        }
        if (version != null) {
            dirPath = dirPath + separator + version;
        }
        if (!(dirFile = new File(dirPath = dirPath + separator + "Logs")).exists() && !dirFile.mkdirs()) {
            System.err.println(bundle.formatString("ActionLogger.UnableToCreateLogDir.fmt.txt", (Object)dirPath));
            dirPath = null;
        }
        return dirPath;
    }

    public static String getAppDataPath() {
        String appData = null;
        appData = System.getProperty("sas.appdatapath");
        if (appData != null) {
            File appDataFile = new File(appData);
            if (!appDataFile.exists() || !appDataFile.isDirectory()) {
                appData = null;
            } else {
                return appData;
            }
        }
        try {
            appData = System.getenv("APPDATA");
        }
        catch (SecurityException ex) {
            System.err.println(ex.getMessage());
        }
        if (appData == null) {
            appData = System.getProperty("user.home");
        }
        return appData;
    }

    public boolean deleteLogFile() {
        File tempFile = new File(this.logFileName);
        return tempFile.delete();
    }
}

