/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.sasjfs.utilities;

import com.sas.grid.representations.ResourceNames;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SGMGConfigurationUtilities {
    private static List<String> sgmgQueues = new ArrayList<String>();
    private static List<String> sgmgLimits = new ArrayList<String>();
    private static List<String> sgmgTags = new ArrayList<String>();
    private static List<String> sgmgConResources = new ArrayList<String>();
    private static List<String> sgmgReqResources = new ArrayList<String>();

    public String toSerializedForm(ResourceNames rsrcNames) {
        StringBuffer configBuffer = new StringBuffer();
        configBuffer.append(rsrcNames.getAvailableLimits().toString());
        configBuffer.append("_;_");
        configBuffer.append(rsrcNames.getAvailableTags().toString());
        configBuffer.append("_;_");
        configBuffer.append(rsrcNames.getAvailableConsumableResources().toString());
        configBuffer.append("_;_");
        configBuffer.append(rsrcNames.getAvailableRequiredResources().toString());
        configBuffer.append("_;_");
        configBuffer.append(rsrcNames.getAvailableQueues().toString());
        return configBuffer.toString();
    }

    public boolean createFromData(String configString) {
        String[] configObjects;
        boolean isCreated = false;
        if (configString.contains("_;_") && (configObjects = configString.split("_;_")).length == 5) {
            sgmgLimits = Arrays.asList(configObjects[0].replace("[", "").replace("]", "").split(","));
            sgmgTags = Arrays.asList(configObjects[1].replace("[", "").replace("]", "").split(","));
            sgmgConResources = Arrays.asList(configObjects[2].replace("[", "").replace("]", "").split(","));
            sgmgReqResources = Arrays.asList(configObjects[3].replace("[", "").replace("]", "").split(","));
            sgmgQueues = Arrays.asList(configObjects[4].replace("[", "").replace("]", "").split(","));
            isCreated = true;
        }
        return isCreated;
    }

    public List<String> getSGMGQueues() {
        return sgmgQueues;
    }

    public List<String> getSGMGLimits() {
        return sgmgLimits;
    }

    public List<String> getSGMGTags() {
        return sgmgTags;
    }

    public List<String> getSGMGConResources() {
        return sgmgConResources;
    }

    public List<String> getSGMGReqResources() {
        return sgmgReqResources;
    }
}

