/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.sasjfs.trigger.serviceinterface;

import com.sas.net.crypto.SealedString;
import com.sas.scheduler.api.servers.ip.engine.mq.client.NullOutputStream;
import com.sas.scheduler.api.servers.sasjfs.SASJFScheduler;
import com.sas.scheduler.api.servers.sasjfs.trigger.OSTrigger;
import com.sas.scheduler.api.servers.sasjfs.trigger.serviceinterface.AbstractTaskScheduler;
import com.sas.scheduler.api.servers.sasjfs.trigger.serviceinterface.ITaskScheduler;
import com.sas.scheduler.api.servers.sasjfs.trigger.serviceinterface.SchtasksExe;
import com.sas.scheduler.api.servers.sasjfs.trigger.serviceinterface.SchtasksExeOperations;
import com.sas.scheduler.api.servers.sasjfs.trigger.xml.CalendarTriggerType;
import com.sas.scheduler.api.servers.sasjfs.trigger.xml.DailyScheduleType;
import com.sas.scheduler.api.servers.sasjfs.trigger.xml.DaysOfWeekType;
import com.sas.scheduler.api.servers.sasjfs.trigger.xml.ExecType;
import com.sas.scheduler.api.servers.sasjfs.trigger.xml.IdleSettingsType;
import com.sas.scheduler.api.servers.sasjfs.trigger.xml.LogonType;
import com.sas.scheduler.api.servers.sasjfs.trigger.xml.MonthlyScheduleType;
import com.sas.scheduler.api.servers.sasjfs.trigger.xml.MonthsType;
import com.sas.scheduler.api.servers.sasjfs.trigger.xml.MultipleInstancesPolicyType;
import com.sas.scheduler.api.servers.sasjfs.trigger.xml.PrincipalType;
import com.sas.scheduler.api.servers.sasjfs.trigger.xml.RegistrationInfoType;
import com.sas.scheduler.api.servers.sasjfs.trigger.xml.RepetitionType;
import com.sas.scheduler.api.servers.sasjfs.trigger.xml.RunLevelType;
import com.sas.scheduler.api.servers.sasjfs.trigger.xml.SettingsType;
import com.sas.scheduler.api.servers.sasjfs.trigger.xml.TaskType;
import com.sas.scheduler.api.servers.sasjfs.trigger.xml.TimeTriggerType;
import com.sas.scheduler.api.servers.sasjfs.trigger.xml.WeeklyScheduleType;
import com.sas.scheduler.api.servers.sasjfs.utilities.OSCommand;
import com.sas.scheduler.model.AbstractRecurrence;
import com.sas.scheduler.model.DailyRecurrence;
import com.sas.scheduler.model.DateList;
import com.sas.scheduler.model.IRecurrenceInfo;
import com.sas.scheduler.model.MonthlyRecurrence;
import com.sas.scheduler.model.TimeEventInfo;
import com.sas.scheduler.model.WeeklyRecurrence;
import com.sas.scheduler.model.YearlyRecurrence;
import com.sas.util.SasPasswordEncodingException;
import com.sas.util.SasPasswordString;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;

public class WindowsTaskScheduler
extends AbstractTaskScheduler
implements ITaskScheduler {
    private static String _systemRoot = System.getenv("SystemRoot");
    private static String _schtasksExeBinary = _systemRoot + "\\System32\\schtasks.exe";
    private static JAXBContext _jaxbContext;
    private static String _userName;
    private static SealedString _password;
    private static String _wtsSasFolder;
    private static String _taskName;

    public WindowsTaskScheduler(List<TimeEventInfo> triggers, String command, String flowId, String userName, SealedString password) {
        super(_schtasksExeBinary, flowId);
        this._triggers = triggers;
        this._command = command;
        _userName = userName;
        _password = password;
        _taskName = _wtsSasFolder + this._flowId;
    }

    @Override
    public String scheduleTask() {
        OSTrigger.LOGGER.debug("Performing schedule task");
        String retval = null;
        TaskType task = new TaskType();
        SchtasksExe schtasks = new SchtasksExe(SchtasksExeOperations.CREATE.toString(), _taskName, _schtasksExeBinary);
        RegistrationInfoType regInfo = new RegistrationInfoType();
        regInfo.setAuthor(_userName);
        regInfo.setDescription("Task for Flow ID " + this._flowId);
        task.setRegistrationInfo(regInfo);
        for (TimeEventInfo tei : this._triggers) {
            IRecurrenceInfo ir = tei.getRecurrence();
            if (!(ir instanceof DateList)) {
                CalendarTriggerType ct = this.createCalendarTrigger(tei);
                if (ct == null) {
                    OSTrigger.LOGGER.error("Could not create CalendarTrigger element from TimeEventInfo named: " + tei.getName() + " ...ignoring.");
                    continue;
                }
                task.getTriggers().getTriggerGroup().add(ct);
                continue;
            }
            List<TimeTriggerType> ttList = this.createTimeTriggerList(tei);
            if (CollectionUtils.isEmpty(ttList)) {
                OSTrigger.LOGGER.error("Could not create TimeTrigger list from TimeEventInfo named: " + tei.getName());
                continue;
            }
            for (TimeTriggerType tt : ttList) {
                task.getTriggers().getTriggerGroup().add(tt);
            }
        }
        if (CollectionUtils.isEmpty(task.getTriggers().getTriggerGroup())) {
            OSTrigger.LOGGER.error("Could not create any Trigger items for the given list of Trigger Events.");
            return null;
        }
        SealedString decodedPassword = this.getDecodedPassword(_password);
        if (decodedPassword == null) {
            OSTrigger.LOGGER.error("Cannot proceed with decoded password of null");
            return null;
        }
        schtasks.setRunAsCredentials(_userName, decodedPassword);
        PrincipalType principal = this.createPrincipal();
        task.getPrincipals().setPrincipal(principal);
        SettingsType st = this.createSettings();
        IdleSettingsType is = this.createIdleSettings();
        st.setIdleSettings(is);
        task.setSettings(st);
        task.getActions().setContext(task.getPrincipals().getPrincipal());
        ExecType et = new ExecType();
        et.setCommand("cmd.exe");
        et.setArguments("/c " + this._command);
        task.getActions().getActionGroup().add(et);
        String xmlTaskFile = this.writeTaskToXmlFile(task);
        schtasks.setXmlFileName(xmlTaskFile);
        String schtasksCommand = schtasks.createSchtasksExeScheduleCommandLine();
        String schtasksCommandClean = schtasks.createSchtasksExeScheduleCommandLine(true);
        OSCommand command = new OSCommand(schtasksCommand, SASJFScheduler.getLogger());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream errorStream = new PrintStream(baos);
        PrintStream outputStream = new PrintStream(baos);
        int rc = 0;
        try {
            rc = command.runJob(outputStream, errorStream);
        }
        catch (InterruptedException ie) {
            OSTrigger.LOGGER.error(ie.getMessage());
        }
        if (rc != 0) {
            OSTrigger.LOGGER.error("Call to schtasks.exe resulted in non-zero exit code: " + rc);
            OSTrigger.LOGGER.debug("schtasks.exe command line:");
            OSTrigger.LOGGER.debug(">>> " + schtasksCommandClean);
            OSTrigger.LOGGER.error(">>>>>Command output: " + baos);
            OSTrigger.LOGGER.debug("Task was NOT scheduled, returning null to SAS Job Flow Scheduler");
            File tempFile = new File(xmlTaskFile);
            try {
                tempFile.delete();
            }
            catch (Exception e) {
                OSTrigger.LOGGER.error("Failed to delete temp file: " + xmlTaskFile);
            }
            return null;
        }
        File tempFile = new File(xmlTaskFile);
        try {
            tempFile.delete();
        }
        catch (Exception e) {
            OSTrigger.LOGGER.error("Failed to delete temp file: " + xmlTaskFile);
        }
        retval = this.genTriggerId();
        OSTrigger.LOGGER.debug("schedule task completed successfully");
        return retval;
    }

    private List<TimeTriggerType> createTimeTriggerList(TimeEventInfo tei) {
        IRecurrenceInfo ir = tei.getRecurrence();
        String minutes = tei.getMinutes();
        String hours = tei.getHours();
        if (ir == null || !(ir instanceof DateList)) {
            OSTrigger.LOGGER.debug("Could not recurrence from the time event info: " + tei.getName());
            return null;
        }
        ArrayList<TimeTriggerType> retval = new ArrayList<TimeTriggerType>();
        DateList dl = (DateList)ir;
        List runDates = dl.getDatesToRun();
        for (Calendar runDate : runDates) {
            runDate.set(11, Integer.parseInt(hours));
            runDate.set(12, Integer.parseInt(minutes));
            runDate.set(13, 0);
            XMLGregorianCalendar ttStartBoundary = this.getXMLGregorianCalendar(runDate);
            if (ttStartBoundary == null) {
                OSTrigger.LOGGER.error("Could not get XMLGregorianCalendar for run date: " + runDate.toString() + " ...ignoring.");
                continue;
            }
            TimeTriggerType tt = new TimeTriggerType();
            tt.setStartBoundary(ttStartBoundary);
            tt.setEnabled(Boolean.TRUE);
            retval.add(tt);
        }
        return retval;
    }

    private PrincipalType createPrincipal() {
        PrincipalType retval = new PrincipalType();
        retval.setId("Author");
        retval.setLogonType(LogonType.PASSWORD);
        retval.setRunLevel(RunLevelType.LEAST_PRIVILEGE);
        retval.setUserId(_userName);
        return retval;
    }

    private SettingsType createSettings() {
        SettingsType retval = new SettingsType();
        retval.setMultipleInstancesPolicy(MultipleInstancesPolicyType.IGNORE_NEW);
        retval.setDisallowStartIfOnBatteries(Boolean.TRUE);
        retval.setStopIfGoingOnBatteries(Boolean.TRUE);
        retval.setAllowHardTerminate(Boolean.TRUE);
        retval.setStartWhenAvailable(Boolean.FALSE);
        retval.setRunOnlyIfNetworkAvailable(Boolean.FALSE);
        retval.setAllowStartOnDemand(Boolean.TRUE);
        retval.setEnabled(Boolean.TRUE);
        retval.setHidden(Boolean.FALSE);
        retval.setRunOnlyIfIdle(Boolean.FALSE);
        retval.setWakeToRun(Boolean.FALSE);
        try {
            retval.setExecutionTimeLimit(DatatypeFactory.newInstance().newDuration("P12D"));
        }
        catch (DatatypeConfigurationException dte) {
            dte.printStackTrace();
        }
        catch (Exception e) {
            OSTrigger.LOGGER.error("Error trying to create newDuration for ExecutionTimeLimit setting.");
            OSTrigger.LOGGER.error(e.getMessage());
        }
        byte priority = 7;
        retval.setPriority(priority);
        return retval;
    }

    private IdleSettingsType createIdleSettings() {
        IdleSettingsType retval = new IdleSettingsType();
        try {
            retval.setDuration(DatatypeFactory.newInstance().newDuration("PT10M"));
            retval.setWaitTimeout(DatatypeFactory.newInstance().newDuration("PT1H"));
            retval.setStopOnIdleEnd(Boolean.TRUE);
            retval.setRestartOnIdle(Boolean.FALSE);
        }
        catch (DatatypeConfigurationException e) {
            e.printStackTrace();
        }
        return retval;
    }

    private CalendarTriggerType createCalendarTrigger(TimeEventInfo tei) {
        IRecurrenceInfo ir = tei.getRecurrence();
        if (ir == null) {
            return null;
        }
        CalendarTriggerType retval = new CalendarTriggerType();
        Calendar startDateCalendar = ((AbstractRecurrence)ir).getStartDate();
        if (startDateCalendar == null) {
            startDateCalendar = Calendar.getInstance();
        }
        String hours = tei.getHours();
        String minutes = tei.getMinutes();
        String[] tokens = hours.split(",");
        startDateCalendar.set(11, Integer.parseInt(tokens[0]));
        tokens = minutes.split(",");
        startDateCalendar.set(12, Integer.parseInt(tokens[0]));
        startDateCalendar.set(13, 0);
        XMLGregorianCalendar startDateXMLGregorian = this.getXMLGregorianCalendar(startDateCalendar);
        if (startDateXMLGregorian == null) {
            OSTrigger.LOGGER.error("Could not obtain XMLGregorianCalendar object for start date.");
            return null;
        }
        retval.setStartBoundary(startDateXMLGregorian);
        Calendar endDateCalendar = ((AbstractRecurrence)ir).getEndDate();
        if (endDateCalendar != null) {
            XMLGregorianCalendar endDateXMLGregorian = this.getXMLGregorianCalendar(endDateCalendar);
            if (endDateXMLGregorian == null) {
                OSTrigger.LOGGER.error("Could not obtain XMLGregorianCalendar object for end date.");
            }
            retval.setEndBoundary(endDateXMLGregorian);
        }
        if (ir instanceof YearlyRecurrence) {
            YearlyRecurrence yr = (YearlyRecurrence)ir;
            MonthlyScheduleType mst = new MonthlyScheduleType();
            mst.getDaysOfMonth().getDay().add(String.valueOf(yr.getDay()));
            MonthsType mt = new MonthsType();
            switch (yr.getMonth()) {
                case 1: {
                    mst.getMonths().setJanuary(mt);
                    break;
                }
                case 2: {
                    mst.getMonths().setFebruary(mt);
                    break;
                }
                case 3: {
                    mst.getMonths().setMarch(mt);
                    break;
                }
                case 4: {
                    mst.getMonths().setApril(mt);
                    break;
                }
                case 5: {
                    mst.getMonths().setMay(mt);
                    break;
                }
                case 6: {
                    mst.getMonths().setJune(mt);
                    break;
                }
                case 7: {
                    mst.getMonths().setJuly(mt);
                    break;
                }
                case 8: {
                    mst.getMonths().setAugust(mt);
                    break;
                }
                case 9: {
                    mst.getMonths().setSeptember(mt);
                    break;
                }
                case 10: {
                    mst.getMonths().setOctober(mt);
                    break;
                }
                case 11: {
                    mst.getMonths().setNovember(mt);
                    break;
                }
                case 12: {
                    mst.getMonths().setDecember(mt);
                    break;
                }
                default: {
                    String message = "Invalid month number in yearly occurrence.";
                    OSTrigger.LOGGER.error(message);
                    throw new IllegalArgumentException(message);
                }
            }
            retval.setScheduleByMonth(mst);
        } else if (ir instanceof MonthlyRecurrence) {
            MonthlyRecurrence mr = (MonthlyRecurrence)ir;
            MonthlyScheduleType mst = new MonthlyScheduleType();
            mst.getDaysOfMonth().getDay().add(String.valueOf(mr.getDayOfMonth()));
            MonthsType mt = new MonthsType();
            mst.getMonths().setJanuary(mt);
            mst.getMonths().setFebruary(mt);
            mst.getMonths().setMarch(mt);
            mst.getMonths().setApril(mt);
            mst.getMonths().setMay(mt);
            mst.getMonths().setJune(mt);
            mst.getMonths().setJuly(mt);
            mst.getMonths().setAugust(mt);
            mst.getMonths().setSeptember(mt);
            mst.getMonths().setOctober(mt);
            mst.getMonths().setNovember(mt);
            mst.getMonths().setDecember(mt);
            retval.setScheduleByMonth(mst);
        } else if (ir instanceof WeeklyRecurrence) {
            WeeklyRecurrence wr = (WeeklyRecurrence)ir;
            WeeklyScheduleType wst = new WeeklyScheduleType();
            short weeksInterval = (short)wr.getSkipCount() <= 52 ? (short)wr.getSkipCount() : (short)52;
            wst.setWeeksInterval(weeksInterval);
            DaysOfWeekType dowt = new DaysOfWeekType();
            int daysOfWeekToRun = wr.getDaysToRun();
            if ((daysOfWeekToRun & 1) == 1) {
                wst.getDaysOfWeek().setMonday(dowt);
            }
            if ((daysOfWeekToRun & 2) == 2) {
                wst.getDaysOfWeek().setTuesday(dowt);
            }
            if ((daysOfWeekToRun & 4) == 4) {
                wst.getDaysOfWeek().setWednesday(dowt);
            }
            if ((daysOfWeekToRun & 8) == 8) {
                wst.getDaysOfWeek().setThursday(dowt);
            }
            if ((daysOfWeekToRun & 0x10) == 16) {
                wst.getDaysOfWeek().setFriday(dowt);
            }
            if ((daysOfWeekToRun & 0x20) == 32) {
                wst.getDaysOfWeek().setSaturday(dowt);
            }
            if ((daysOfWeekToRun & 0x40) == 64) {
                wst.getDaysOfWeek().setSunday(dowt);
            }
            retval.setScheduleByWeek(wst);
        } else if (ir instanceof DailyRecurrence) {
            DailyRecurrence dr = (DailyRecurrence)ir;
            Calendar startDate = dr.getStartDate();
            Calendar endDate = dr.getEndDate();
            String hourlyIndicator = dr.getHourly();
            if (hourlyIndicator == null) {
                if (dr.isWeekDays()) {
                    WeeklyScheduleType wst = new WeeklyScheduleType();
                    DaysOfWeekType dowt = new DaysOfWeekType();
                    wst.getDaysOfWeek().setMonday(dowt);
                    wst.getDaysOfWeek().setTuesday(dowt);
                    wst.getDaysOfWeek().setWednesday(dowt);
                    wst.getDaysOfWeek().setThursday(dowt);
                    wst.getDaysOfWeek().setFriday(dowt);
                    retval.setScheduleByWeek(wst);
                } else {
                    DailyScheduleType dst = new DailyScheduleType();
                    long daysInterval = ((DailyRecurrence)ir).getSkipCount();
                    dst.setDaysInterval(daysInterval);
                    retval.setScheduleByDay(dst);
                }
            } else {
                Duration skipCountRepetition;
                int offset;
                int skipCount;
                String[] hourlyParts = hourlyIndicator.split(":");
                try {
                    skipCount = Integer.parseInt(hourlyParts[0]);
                }
                catch (NumberFormatException nfe) {
                    OSTrigger.LOGGER.error("Could not parse int from skipCount: " + hourlyParts[0]);
                    return null;
                }
                try {
                    offset = Integer.parseInt(hourlyParts[1]);
                }
                catch (NumberFormatException nfe) {
                    OSTrigger.LOGGER.error("Could not parse int from offset: " + hourlyParts[1]);
                    return null;
                }
                GregorianCalendar calendar = new GregorianCalendar(Locale.getDefault());
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(14, 0);
                ((Calendar)calendar).add(11, offset);
                DailyScheduleType dst = new DailyScheduleType();
                dst.setDaysInterval(1L);
                try {
                    skipCountRepetition = DatatypeFactory.newInstance().newDuration(String.format("PT%dH", skipCount));
                }
                catch (DatatypeConfigurationException e) {
                    OSTrigger.LOGGER.error("Could not create skipCount Duration for the Repetition XML entry. Please ensure that skipCount is valid.");
                    return null;
                }
                RepetitionType rt = new RepetitionType();
                rt.setInterval(skipCountRepetition);
                rt.setStopAtDurationEnd(Boolean.FALSE);
                retval.setRepetition(rt);
                retval.setScheduleByDay(dst);
            }
        } else if (ir instanceof DateList) {
            DateList dl = (DateList)ir;
            for (Calendar date : dl.getDatesToRun()) {
                MonthlyScheduleType mst = new MonthlyScheduleType();
                int day = date.get(5);
                int month = date.get(2);
                mst.getDaysOfMonth().getDay().add(String.valueOf(day));
                MonthsType mt = new MonthsType();
                switch (month) {
                    case 1: {
                        mst.getMonths().setJanuary(mt);
                        break;
                    }
                    case 2: {
                        mst.getMonths().setFebruary(mt);
                        break;
                    }
                    case 3: {
                        mst.getMonths().setMarch(mt);
                        break;
                    }
                    case 4: {
                        mst.getMonths().setApril(mt);
                        break;
                    }
                    case 5: {
                        mst.getMonths().setMay(mt);
                        break;
                    }
                    case 6: {
                        mst.getMonths().setJune(mt);
                        break;
                    }
                    case 7: {
                        mst.getMonths().setJuly(mt);
                        break;
                    }
                    case 8: {
                        mst.getMonths().setAugust(mt);
                        break;
                    }
                    case 9: {
                        mst.getMonths().setSeptember(mt);
                        break;
                    }
                    case 10: {
                        mst.getMonths().setOctober(mt);
                        break;
                    }
                    case 11: {
                        mst.getMonths().setNovember(mt);
                        break;
                    }
                    case 12: {
                        mst.getMonths().setDecember(mt);
                        break;
                    }
                    default: {
                        String message = "Invalid month number in yearly occurrence.";
                        OSTrigger.LOGGER.error(message);
                        throw new IllegalArgumentException(message);
                    }
                }
                retval.setScheduleByMonth(mst);
                try {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                    String dateStr = sdf.format(date);
                    XMLGregorianCalendar value = DatatypeFactory.newInstance().newXMLGregorianCalendar(dateStr);
                    retval.setStartBoundary(value);
                    retval.setEndBoundary(value);
                }
                catch (DatatypeConfigurationException e) {
                    throw new IllegalArgumentException("Date not processed correctly.");
                }
            }
        }
        return retval;
    }

    private XMLGregorianCalendar getXMLGregorianCalendar(Calendar calendar) {
        XMLGregorianCalendar retval = null;
        try {
            String dateString = this.buildDateString(calendar);
            retval = DatatypeFactory.newInstance().newXMLGregorianCalendar(dateString);
        }
        catch (DatatypeConfigurationException e) {
            return null;
        }
        return retval;
    }

    private String buildDateString(Calendar calendar) {
        StringBuilder sb = new StringBuilder();
        sb.append(calendar.get(1));
        sb.append("-");
        sb.append(String.format("%02d", calendar.get(2) + 1));
        sb.append("-");
        sb.append(String.format("%02d", calendar.get(5)));
        sb.append("T");
        sb.append(String.format("%02d", calendar.get(11)));
        sb.append(":");
        sb.append(String.format("%02d", calendar.get(12)));
        sb.append(":");
        sb.append(String.format("%02d", calendar.get(13)));
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String writeTaskToXmlFile(TaskType task) {
        String retval = null;
        Marshaller m = null;
        File tempFile = null;
        Writer outFile = null;
        Writer sw = null;
        try {
            _jaxbContext = JAXBContext.newInstance((Class[])new Class[]{TaskType.class});
            m = _jaxbContext.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            m.setProperty("jaxb.encoding", (Object)"UTF-16");
            tempFile = File.createTempFile("sasjfs-", "-ostrigger-schtasks.xml");
            outFile = new OutputStreamWriter((OutputStream)new FileOutputStream(tempFile), "UTF-16LE");
            sw = new StringWriter();
            sw.append('\ufeff');
            m.marshal((Object)task, sw);
            sw.flush();
            String xmlString = sw.toString();
            sw.close();
            outFile.write(xmlString);
            outFile.flush();
            outFile.close();
            retval = tempFile.getAbsolutePath();
        }
        catch (JAXBException jaxbEx) {
            OSTrigger.LOGGER.error("JAXBException ocurred while trying to marshal the Task to disk.");
            OSTrigger.LOGGER.error(jaxbEx.getLinkedException().getMessage());
        }
        catch (IOException ioe) {
            OSTrigger.LOGGER.error(ioe.getMessage());
        }
        catch (Exception e) {
            OSTrigger.LOGGER.error(e.getMessage());
        }
        finally {
            if (sw != null) {
                try {
                    sw.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (outFile != null) {
                try {
                    outFile.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return retval;
    }

    @Override
    public String updateTask() {
        OSTrigger.LOGGER.debug("Performing update task");
        String retval = null;
        this.deleteTask();
        retval = this.scheduleTask();
        if (retval == null) {
            OSTrigger.LOGGER.debug("update task failed");
        } else {
            OSTrigger.LOGGER.debug("update task completed successfully");
        }
        return retval;
    }

    @Override
    public boolean deleteTask() {
        OSTrigger.LOGGER.debug("Performing delete task");
        boolean retval = false;
        SchtasksExe schtasks = new SchtasksExe(SchtasksExeOperations.DELETE.toString(), _taskName, _schtasksExeBinary);
        String schtasksCommand = schtasks.createSchtasksExeDeleteCommandLine(_taskName);
        OSCommand command = new OSCommand(schtasksCommand, SASJFScheduler.getLogger());
        PrintStream errorStream = new PrintStream(new NullOutputStream());
        PrintStream outputStream = new PrintStream(new NullOutputStream());
        int rc = 0;
        try {
            rc = command.runJob(outputStream, errorStream);
        }
        catch (InterruptedException ie) {
            OSTrigger.LOGGER.error(ie.getMessage());
        }
        if (rc == 0) {
            retval = true;
        }
        OSTrigger.LOGGER.debug("delete task completed successfully");
        return retval;
    }

    public boolean updatePassword() {
        OSTrigger.LOGGER.debug("Performing update password");
        boolean retval = false;
        SchtasksExe schtasksExeQuery = new SchtasksExe(SchtasksExeOperations.QUERY.toString(), _taskName, _schtasksExeBinary);
        String schtasksQueryCommand = schtasksExeQuery.createSchtasksExeQueryCommandLine();
        String queryFilePath = this.runSchtasksQueryCommand(schtasksQueryCommand);
        List<String> queryFileContents = this.readQueryFileIntoList(queryFilePath);
        File queryTempFile = new File(queryFilePath);
        boolean deleteResult = queryTempFile.delete();
        OSTrigger.LOGGER.debug(String.format("Result of deleting the query output temp file: %s", deleteResult));
        List<String> osTriggerFolderContents = this.getOSTriggerFolderContents(queryFileContents);
        Map<String, List<String>> userToTasksMap = this.getAllTasksForUser(_userName, osTriggerFolderContents);
        HashSet uniqueTasks = new HashSet(userToTasksMap.get(_userName));
        for (String task : uniqueTasks) {
            SchtasksExe schtasksExeChange = new SchtasksExe(SchtasksExeOperations.CHANGE.toString(), task, _schtasksExeBinary);
            SealedString decodedPassword = this.getDecodedPassword(_password);
            if (decodedPassword == null) {
                OSTrigger.LOGGER.error("Cannot proceed with decoded password of null");
                return false;
            }
            schtasksExeChange.setRunAsCredentials(_userName, decodedPassword);
            String schtasksChangeCommand = schtasksExeChange.createSchtasksExeChangeCommandLine();
            OSCommand command = new OSCommand(schtasksChangeCommand, SASJFScheduler.getLogger());
            PrintStream errorStream = new PrintStream(new NullOutputStream());
            PrintStream outputStream = new PrintStream(new NullOutputStream());
            int rc = 0;
            try {
                rc = command.runJob(outputStream, errorStream);
            }
            catch (InterruptedException ie) {
                OSTrigger.LOGGER.error(ie.getMessage());
            }
            if (rc == 0) continue;
            OSTrigger.LOGGER.error(String.format("Unable to update password for user %s", _userName));
            OSTrigger.LOGGER.error(String.format("schtasks.exe returned code: %d", rc));
            return false;
        }
        retval = true;
        OSTrigger.LOGGER.debug("update password completed successfully");
        return retval;
    }

    private Map<String, List<String>> getAllTasksForUser(String userName, List<String> contents) {
        HashMap<String, List<String>> retval = new HashMap<String, List<String>>();
        ArrayList<String> tasksForUser = new ArrayList<String>();
        boolean taskNameFound = false;
        String taskName = "";
        String taskUserName = "";
        for (int i = 0; i < contents.size(); ++i) {
            String lineOfInterest = contents.get(i);
            if (lineOfInterest.startsWith("TaskName:")) {
                taskName = this.getValueFromLine(lineOfInterest);
                taskNameFound = true;
            }
            if (!lineOfInterest.startsWith("Run As User:") || !(taskUserName = this.getValueFromLine(lineOfInterest)).equals(userName) || !taskNameFound) continue;
            tasksForUser.add(taskName);
        }
        retval.put(userName, tasksForUser);
        return retval;
    }

    private String getValueFromLine(String lineOfInterest) {
        String retval = "";
        String[] lineParts = lineOfInterest.split(":");
        retval = lineParts[1].trim();
        return retval;
    }

    private List<String> getOSTriggerFolderContents(List<String> queryFileLines) {
        ArrayList<String> retval = new ArrayList<String>();
        block0: for (int i = 0; i < queryFileLines.size(); ++i) {
            String queryFileLine = queryFileLines.get(i);
            if (!queryFileLine.startsWith("Folder: \\SAS-OSTrigger")) continue;
            retval.add(queryFileLine);
            queryFileLine = queryFileLines.get(++i);
            while (i <= queryFileLines.size() && !queryFileLine.startsWith("Folder:")) {
                retval.add(queryFileLine);
                if (++i == queryFileLines.size()) continue block0;
                queryFileLine = queryFileLines.get(i);
            }
        }
        return retval;
    }

    private List<String> readQueryFileIntoList(String queryFilePath) {
        ArrayList<String> retval = new ArrayList();
        try {
            retval = FileUtils.readLines((File)new File(queryFilePath));
        }
        catch (IOException e) {
            OSTrigger.LOGGER.error("IOException while trying to read: " + queryFilePath);
            OSTrigger.LOGGER.error("Message: " + e.getMessage());
            return null;
        }
        return retval;
    }

    private String runSchtasksQueryCommand(String schtasksQueryCommand) {
        String retval = null;
        File tempFile = null;
        try {
            tempFile = File.createTempFile("sas-ostrigger-", "-schtasks-query");
        }
        catch (IOException e) {
            OSTrigger.LOGGER.error("Unable to create temp file to produce schtasks query contents.");
            OSTrigger.LOGGER.error("Message: " + e.getMessage());
            return null;
        }
        String tempFilePath = tempFile.getAbsolutePath();
        String schtasksQueryOutputCommand = schtasksQueryCommand + " >" + tempFilePath;
        OSCommand command = new OSCommand(schtasksQueryOutputCommand, SASJFScheduler.getLogger());
        PrintStream errorStream = new PrintStream(new NullOutputStream());
        PrintStream outputStream = new PrintStream(new NullOutputStream());
        int rc = 0;
        try {
            rc = command.runJob(outputStream, errorStream);
        }
        catch (InterruptedException ie) {
            OSTrigger.LOGGER.error(ie.getMessage());
        }
        if (rc != 0) {
            return null;
        }
        retval = tempFilePath;
        return retval;
    }

    private SealedString getDecodedPassword(SealedString s) {
        SealedString retval = null;
        try {
            retval = s != null ? new SealedString(SasPasswordString.decodeChars((char[])s.getCharacters())) : null;
        }
        catch (SasPasswordEncodingException e) {
            OSTrigger.LOGGER.error("Could not decrypt provided password");
        }
        return retval;
    }

    private String genTriggerId() {
        OSTrigger.LOGGER.debug("Generating trigger ID");
        String triggerId = UUID.randomUUID().toString();
        OSTrigger.LOGGER.debug("generated trigger ID: " + triggerId);
        return triggerId;
    }

    static {
        _wtsSasFolder = "SAS-OSTrigger\\";
    }
}

