/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.sasjfs.trigger.serviceinterface;

import com.sas.net.crypto.SealedString;
import java.util.HashMap;
import java.util.Map;

public class SchtasksExe {
    private Map<String, String> _schtasksCommand = new HashMap<String, String>();
    private String _schtasksBinary;

    public SchtasksExe(String operation, String taskName, String schtasksBinary) {
        this._schtasksBinary = schtasksBinary;
        this._schtasksCommand.put("operation", operation);
        this._schtasksCommand.put("/RU", "");
        this._schtasksCommand.put("/RP", "");
        this._schtasksCommand.put("/TN", taskName);
        this._schtasksCommand.put("/XML", "");
    }

    public void setXmlFileName(String xmlFilePath) {
        this._schtasksCommand.put("/XML", xmlFilePath);
    }

    public String getXmlFilePath() {
        return this._schtasksCommand.get("/XML");
    }

    @Deprecated
    public void setRunAsCredentials(String userName, String password) {
        this._schtasksCommand.put("/RU", userName);
        this._schtasksCommand.put("/RP", password);
    }

    public void setRunAsCredentials(String userName, SealedString password) {
        this._schtasksCommand.put("/RU", userName);
        this._schtasksCommand.put("/RP", password != null ? String.valueOf(password.getCharacters()) : null);
    }

    public String createSchtasksExeScheduleCommandLine() {
        return this.createSchtasksExeScheduleCommandLine(false);
    }

    public String createSchtasksExeScheduleCommandLine(boolean maskPassword) {
        String retval = null;
        StringBuilder sb = new StringBuilder();
        sb.append(this._schtasksBinary + " ");
        sb.append("/" + this._schtasksCommand.get("operation") + " ");
        sb.append("/TN \"" + this._schtasksCommand.get("/TN") + "\" ");
        sb.append("/RU " + this._schtasksCommand.get("/RU") + " ");
        sb.append("/RP \"" + (maskPassword ? "<MASKED>" : this._schtasksCommand.get("/RP")) + "\" ");
        sb.append("/XML " + this._schtasksCommand.get("/XML"));
        retval = sb.toString();
        return retval;
    }

    public String createSchtasksExeChangeCommandLine() {
        String retval = null;
        StringBuilder sb = new StringBuilder();
        sb.append(this._schtasksBinary + " ");
        sb.append("/" + this._schtasksCommand.get("operation") + " ");
        sb.append("/TN \"" + this._schtasksCommand.get("/TN") + "\" ");
        sb.append("/RU " + this._schtasksCommand.get("/RU") + " ");
        sb.append("/RP \"" + this._schtasksCommand.get("/RP") + "\"");
        retval = sb.toString();
        return retval;
    }

    public String createSchtasksExeDeleteCommandLine(String taskName) {
        String retval = "";
        StringBuilder sb = new StringBuilder();
        sb.append(this._schtasksBinary + " ");
        sb.append("/" + this._schtasksCommand.get("operation") + " ");
        sb.append("/TN \"" + this._schtasksCommand.get("/TN") + "\" ");
        sb.append("/F");
        retval = sb.toString();
        return retval;
    }

    public String createSchtasksExeQueryCommandLine() {
        String retval = "";
        StringBuilder sb = new StringBuilder();
        sb.append(this._schtasksBinary + " ");
        sb.append("/" + this._schtasksCommand.get("operation") + " ");
        sb.append("/FO LIST /V");
        retval = sb.toString();
        return retval;
    }
}

