/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.sasjfs.trigger;

import com.sas.net.crypto.SealedString;
import com.sas.scheduler.api.servers.sasjfs.mq.JMSClientSupport;
import com.sas.scheduler.api.servers.sasjfs.trigger.OSTriggerClient;
import com.sas.scheduler.api.servers.sasjfs.trigger.serviceinterface.AbstractTaskScheduler;
import com.sas.scheduler.api.servers.sasjfs.trigger.serviceinterface.ITaskScheduler;
import com.sas.scheduler.api.servers.sasjfs.trigger.serviceinterface.LinuxTaskScheduler;
import com.sas.scheduler.api.servers.sasjfs.trigger.serviceinterface.SunTaskScheduler;
import com.sas.scheduler.api.servers.sasjfs.trigger.serviceinterface.UnixTaskScheduler;
import com.sas.scheduler.api.servers.sasjfs.trigger.serviceinterface.WindowsTaskScheduler;
import com.sas.scheduler.model.AbstractEventInfo;
import com.sas.scheduler.model.FileEventInfo;
import com.sas.scheduler.model.FlowInfo;
import com.sas.scheduler.model.GroupingEventInfo;
import com.sas.scheduler.model.SchedulerServerInfo;
import com.sas.scheduler.model.TimeEventInfo;
import com.sas.scheduler.model.TriggerEventInfo;
import java.io.File;
import java.net.PasswordAuthentication;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.Logger;

public class OSTriggerUtilities {
    public static final String EXECUTESTR = " -execute ";
    public static final int COMMAND_UPDATE_PASSWORD = 0;
    public static final int COMMAND_SCHEDULE = 1;
    public static final int COMMAND_RESCHEDULE = 2;
    public static final int COMMAND_UNSCHEDULE = 3;
    public static final int COMMAND_EXECUTE = 4;
    public static final int COMMAND_SYNC_PASSWORD = 5;
    public static final int COMMAND_START = 10;
    public static final int COMMAND_STOP = 11;
    public static final int COMMAND_STATUS = 12;
    public static final int COMMAND_CLEAR_JMS_QUEUE = 13;
    public static final int COMMAND_RESTART = 14;
    private static final int TargetOS_Windows = 0;
    private static final int TargetOS_Linux = 1;
    private static final int TargetOS_Sun = 2;
    private static final int TargetOS_HP = 3;
    private static final int TargetOS_AIX = 4;

    public static String buildFlowOrchestratorCommand(int cmdType, String flowOrchCmd, String flowId, String jmsUrl, String jmsClass) {
        StringBuffer buf = new StringBuffer();
        buf.append(flowOrchCmd);
        switch (cmdType) {
            case 4: {
                buf.append(" -runNow");
            }
            case 1: 
            case 2: {
                buf.append(EXECUTESTR + flowId);
                buf.append(" -jmsUrl " + jmsUrl);
                if (jmsClass == null) break;
                buf.append(" -jmsContextFactory " + jmsClass);
                break;
            }
        }
        return buf.toString();
    }

    public static String buildOSTriggerCommand(int cmdType, String flowid, String osTriggerCmd, String jmsUrl, String jmsClass, String command, String oscommand) {
        StringBuffer buf = new StringBuffer();
        buf.append(osTriggerCmd);
        switch (cmdType) {
            case 4: {
                buf.append(" -runNow");
            }
            case 1: {
                buf.append(" -schedule " + flowid);
                buf.append(" -command \"" + command.replace("\"", "\"\"") + "\"");
                buf.append(" -jmsUrl " + jmsUrl);
                if (oscommand != null && !oscommand.isEmpty() && !oscommand.equals("null")) {
                    buf.append(" -osCommand " + oscommand);
                }
                if (jmsClass == null) break;
                buf.append(" -jmsContextFactory " + jmsClass);
                break;
            }
            case 2: {
                buf.append(" -reschedule " + flowid);
                buf.append(" -command \"" + command.replace("\"", "\"\"") + "\"");
                buf.append(" -jmsUrl " + jmsUrl);
                if (oscommand != null && !oscommand.isEmpty() && !oscommand.equals("null")) {
                    buf.append(" -osCommand " + oscommand);
                }
                if (jmsClass == null) break;
                buf.append(" -jmsContextFactory " + jmsClass);
                break;
            }
            case 3: {
                buf.append(" -unschedule " + flowid);
                buf.append(" -jmsUrl " + jmsUrl);
                if (oscommand != null && !oscommand.isEmpty() && !oscommand.equals("null")) {
                    buf.append(" -osCommand " + oscommand);
                }
                if (jmsClass == null) break;
                buf.append(" -jmsContextFactory " + jmsClass);
                break;
            }
        }
        return buf.toString();
    }

    public static ITaskScheduler initScheduler(List<TimeEventInfo> triggers, String command, String osCommandPath, String flowId, String user, SealedString key, Logger logger) {
        AbstractTaskScheduler sch = null;
        int osType = -1;
        osType = SystemUtils.IS_OS_WINDOWS ? 0 : (SystemUtils.IS_OS_LINUX ? 1 : (SystemUtils.IS_OS_SUN_OS ? 2 : (SystemUtils.IS_OS_HP_UX ? 3 : (SystemUtils.IS_OS_AIX ? 4 : (File.separatorChar == '/' ? 1 : 0)))));
        switch (osType) {
            case 0: {
                sch = new WindowsTaskScheduler(triggers, command, flowId, user, key);
                break;
            }
            case 1: {
                sch = new LinuxTaskScheduler(triggers, command, flowId, logger);
                if (osCommandPath != null) {
                    sch = new LinuxTaskScheduler(osCommandPath, triggers, command, flowId, logger);
                    break;
                }
                sch = new LinuxTaskScheduler(triggers, command, flowId, logger);
                break;
            }
            case 2: {
                if (osCommandPath != null) {
                    sch = new SunTaskScheduler(osCommandPath, triggers, command, flowId, logger);
                    break;
                }
                sch = new SunTaskScheduler(triggers, command, flowId, logger);
                break;
            }
            default: {
                sch = osCommandPath != null ? new UnixTaskScheduler(osCommandPath, triggers, command, flowId, logger) : new UnixTaskScheduler(triggers, command, flowId, logger);
            }
        }
        return sch;
    }

    public static char[] retrievePassword(String host, String tuser, OSTriggerClient client) {
        List<PasswordAuthentication> creds;
        SchedulerServerInfo ssi = new SchedulerServerInfo();
        ssi.setJobExecutionProvider("Launcher");
        ssi.setRestApiPath("https://" + host + "/pathIsNotUsedHere");
        FlowInfo flowInfo = new FlowInfo();
        flowInfo.setScheduler(ssi);
        String user = tuser;
        if (user == null || user.isEmpty()) {
            user = System.getProperty("user.name");
        }
        if ((creds = JMSClientSupport.getAuthorizationToken(flowInfo, user, client)).size() > 0) {
            PasswordAuthentication pa = creds.get(0);
            return pa.getPassword();
        }
        return null;
    }

    public static List<TimeEventInfo> getTimeEventTriggers(List<TriggerEventInfo> triggers) {
        ArrayList<TimeEventInfo> list = new ArrayList<TimeEventInfo>();
        if (triggers != null) {
            for (TriggerEventInfo trigger : triggers) {
                List<TimeEventInfo> l = OSTriggerUtilities.getTimeEventTriggers(trigger);
                if (l == null) continue;
                list.addAll(l);
            }
        }
        return list;
    }

    public static List<TimeEventInfo> getTimeEventTriggers(TriggerEventInfo trigger) {
        ArrayList<TimeEventInfo> list = new ArrayList<TimeEventInfo>();
        AbstractEventInfo event = trigger.getEvent();
        if (event instanceof FileEventInfo) {
            return null;
        }
        if (event instanceof TimeEventInfo) {
            list.add((TimeEventInfo)event);
            return list;
        }
        if (event instanceof GroupingEventInfo) {
            GroupingEventInfo gate = (GroupingEventInfo)event;
            List<AbstractEventInfo>[] lists = OSTriggerUtilities.parseTriggerTypes(gate);
            if (gate.getEventType() == 1) {
                List<AbstractEventInfo> time = lists[1];
                for (TimeEventInfo timeEventInfo : time) {
                    list.add(timeEventInfo);
                }
            } else {
                System.err.println("All time events true is not supported.");
            }
        }
        return list;
    }

    public static List<AbstractEventInfo>[] parseTriggerTypes(GroupingEventInfo gate) {
        List[] list = new ArrayList[2];
        ArrayList<AbstractEventInfo> file = new ArrayList<AbstractEventInfo>();
        ArrayList<AbstractEventInfo> time = new ArrayList<AbstractEventInfo>();
        list[0] = file;
        list[1] = time;
        List triggers = gate.getDependencies2();
        int numTriggers = triggers.size();
        for (int x = 0; x < numTriggers; ++x) {
            AbstractEventInfo t = (AbstractEventInfo)triggers.get(x);
            if (t instanceof TimeEventInfo) {
                time.add(t);
                continue;
            }
            if (!(t instanceof FileEventInfo)) continue;
            file.add(t);
        }
        return list;
    }
}

