/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.sasjfs.ssl;

import com.sas.net.crypto.SealedString;
import com.sas.scheduler.api.servers.sasjfs.ssl.ServerSocketFactoryFactory;
import com.sas.scheduler.api.servers.sasjfs.ssl.client.SSLServerSocketFactoryBuilder;
import java.io.IOException;
import java.net.ServerSocket;
import javax.net.ssl.SSLServerSocketFactory;

public class ServerSocketFactory {
    private static final String SSL_PROTOCOL_PROPERTY = "sas.schedule.floworch.client.ssl.protocol";
    private static final String SSL_PROTOCOL_DEFAULT = "TLSv1.2";
    private static final String SSL_KEY_MANAGER_ALGORITHM_PROPERTY = "sas.schedule.floworch.client.ssl.key-manager-algorithm";
    private static final String SSL_KEY_MANAGER_ALGORITHM_DEFAULT = "PKIX";
    private static final String SSL_KEY_STORE_TYPE_PROPERTY = "sas.schedule.floworch.client.ssl.key-store-type";
    private static final String SSL_KEY_STORE_TYPE_DEFAULT = "JKS";
    private static final String SSL_KEY_STORE_PROPERTY = "sas.schedule.floworch.client.ssl.key-store";
    private static final String SSL_KEY_STORE_PROPERTY_DEFAULT = "javax.net.ssl.keyStore";
    private static final String SSL_KEY_STORE_PASSWORD_PROPERTY = "sas.schedule.floworch.client.ssl.key-store-password";
    private static final String SSL_KEY_STORE_PASSWORD_PROPERTY_DEFAULT = "javax.net.ssl.keyStorePassword";
    private final javax.net.ServerSocketFactory serverSocketFactory;
    private final SSLServerSocketFactory sslSocketFactory;

    public ServerSocketFactory(boolean isSSLEnabled) throws Exception {
        if (!isSSLEnabled) {
            ServerSocketFactoryFactory socketFactoryFactory = new ServerSocketFactoryFactory();
            this.serverSocketFactory = socketFactoryFactory.getInstance();
            this.sslSocketFactory = null;
        } else {
            SSLServerSocketFactoryBuilder sslServerSocketFactoryBuilder = new SSLServerSocketFactoryBuilder();
            try {
                String sslProtocol = System.getProperty(SSL_PROTOCOL_PROPERTY) != null ? System.getProperty(SSL_PROTOCOL_PROPERTY) : SSL_PROTOCOL_DEFAULT;
                String sslKeyManagerAlgorithm = System.getProperty(SSL_KEY_MANAGER_ALGORITHM_PROPERTY) != null ? System.getProperty(SSL_KEY_MANAGER_ALGORITHM_PROPERTY) : SSL_KEY_MANAGER_ALGORITHM_DEFAULT;
                String sslKeyStoreType = System.getProperty(SSL_KEY_STORE_TYPE_PROPERTY) != null ? System.getProperty(SSL_KEY_STORE_TYPE_PROPERTY) : SSL_KEY_STORE_TYPE_DEFAULT;
                String sslKeyStorePath = System.getProperty(SSL_KEY_STORE_PROPERTY) != null ? System.getProperty(SSL_KEY_STORE_PROPERTY) : SSL_KEY_STORE_PROPERTY_DEFAULT;
                SealedString sslKeyStorePassword = new SealedString(System.getProperty(SSL_KEY_STORE_PASSWORD_PROPERTY) != null ? System.getProperty(SSL_KEY_STORE_PASSWORD_PROPERTY) : SSL_KEY_STORE_PASSWORD_PROPERTY_DEFAULT);
                this.sslSocketFactory = sslServerSocketFactoryBuilder.getInstance().sslProtocol(sslProtocol).sslKeyManagerAlgorithm(sslKeyManagerAlgorithm).sslKeyStoreType(sslKeyStoreType).sslKeyStorePath(sslKeyStorePath).sslKeyStorePassword(sslKeyStorePassword).build();
            }
            catch (Exception cause) {
                throw new Exception(cause);
            }
            this.serverSocketFactory = null;
        }
    }

    public ServerSocket createSocket(int port, Boolean sslEnabled) throws IOException {
        if (!sslEnabled.booleanValue()) {
            return this.serverSocketFactory.createServerSocket(port);
        }
        return this.sslSocketFactory.createServerSocket(port);
    }
}

