/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.sasjfs.mq;

import com.sas.scheduler.api.oma.MetaUtilities;
import com.sas.scheduler.api.servers.sasjfs.mq.JMSClientSupport;
import com.sas.util.BASE64;
import com.sas.util.SasPasswordEncodingException;
import com.sas.util.SasPasswordString;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Queue;
import jakarta.jms.QueueBrowser;
import jakarta.jms.Session;
import jakarta.jms.StreamMessage;
import jakarta.jms.TextMessage;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.jms.connection.UserCredentialsConnectionFactoryAdapter;
import org.springframework.jms.core.BrowserCallback;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessagePostProcessor;

public class JMSUtilities {
    public static final String Queue_Bytes = "jms/scheduler.sasjfs.bytesQueue";
    public static final String Queue_Check = "jms/scheduler.sasjfs.checkQueue";
    public static final String Queue_String = "jms/scheduler.sasjfs.stringQueue";
    public static final String Queue_Trigger = "jms/scheduler.sasjfs.triggerQueue";
    public static final String Queue_Instances = "jms/scheduler.sasjfs.instancesQueue";
    public static final String Queue_Instance = "jms/scheduler.sasjfs.instanceQueue";
    public static final String Queue_MidtierRequest = "jms/scheduler.sasjfs.scheduleManagementQueue";
    public static final String Queue_SchedulerRequest = "jms/scheduler.sasjfs.schedulerRequestQueue";
    public static final String Queue_SchedulerResults = "jms/scheduler.sasjfs.schedulerResultsQueue";
    public static final String Config_JMSSecurity_Userid = "JMSSecurityUserid";
    public static final String Config_JMSSecurity_Passwd = "JMSSecurityPasswd";
    protected JmsTemplate m_bytesQueue;
    protected JmsTemplate m_checkQueue;
    protected JmsTemplate m_stringQueue;
    protected JmsTemplate m_instanceListQueue;
    protected JmsTemplate m_instanceQueue;
    protected JmsTemplate m_midtierRequestQueue;
    protected JmsTemplate m_schedulerRequestQueue;
    protected JmsTemplate m_schedulerResultsQueue;
    protected ConnectionFactory m_queueFactory;
    protected static final String jndiPrefix = "java:comp/env/";
    protected static final String SASPhysicalQueuePrefix = "sas.jms.";
    protected static final String SASPhysicalQueuePrefixProperty = "sas.sasjfs.jms.queuePrefix";
    protected static long TIMEOUT = 100000L;

    protected InitialContext initJMSContext(Properties configProperties) throws NamingException {
        InitialContext jmsContext = JMSUtilities.initializeJMSContext(configProperties);
        this.m_queueFactory = JMSUtilities.getFactory(jmsContext, Queue_MidtierRequest, JMSUtilities.getLastSegment(Queue_MidtierRequest));
        if (JMSUtilities.areCredentialsProvided(configProperties)) {
            this.m_queueFactory = JMSUtilities.configureSecurity(this.m_queueFactory, configProperties);
        }
        return jmsContext;
    }

    /*
     * Unable to fully structure code
     */
    public static InitialContext initializeJMSContext(Properties schedProps) {
        env = new Properties();
        providerURLs = new ArrayList<String>();
        if (schedProps != null) {
            try {
                value = schedProps.getProperty("java.naming.factory.initial");
                if (value != null) {
                    env.setProperty("java.naming.factory.initial", value);
                }
                if ((value = schedProps.getProperty("java.naming.provider.url")) == null) ** GOTO lbl28
                if (value.toLowerCase().contains("failover:")) {
                    start = value.indexOf(40);
                    finish = value.indexOf(41);
                    tmp = value.substring(start + 1, finish);
                    for (String url : urls = tmp.split("[,;]")) {
                        providerURLs.add(url.trim());
                    }
                }
                providerURLs.add(value);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to initialize JMS initial context.", e);
            }
        } else {
            env.put("java.naming.provider.url", "");
            env.put("java.naming.factory.initial", "");
        }
lbl28:
        // 4 sources

        e = null;
        for (String p : providerURLs) {
            try {
                env.setProperty("java.naming.provider.url", p);
                jndi = new InitialContext(env);
                queueFactory = JMSUtilities.getFactory(jndi, "jms/scheduler.sasjfs.scheduleManagementQueue", JMSUtilities.getLastSegment("jms/scheduler.sasjfs.scheduleManagementQueue"));
                testConnection = queueFactory.createConnection(schedProps.getProperty("JMSSecurityUserid"), schedProps.getProperty("JMSSecurityPasswd"));
                testConnection.close();
                return jndi;
            }
            catch (Exception ex) {
                e = ex;
            }
        }
        throw new RuntimeException("Failed to initialize JMS initial context.", e);
    }

    public static void configureQueue(InitialContext jmsContext, JmsTemplate queueTemplate, String queueName, Logger logger) {
        try {
            queueTemplate.setDefaultDestination((Destination)((Queue)jmsContext.lookup(queueName)));
        }
        catch (NamingException e) {
            logger.debug("Retrying JMS Queue lookup using TC Server style, called from: " + JMSUtilities.findCallingMethod(e, "configureQueue"));
            try {
                queueTemplate.setDefaultDestination((Destination)((Queue)jmsContext.lookup(jndiPrefix + queueName)));
            }
            catch (NamingException e2) {
                logger.debug((Object)e2);
                logger.warn("Unable to lookup JMS queue using either appserver jndi lookup name (okay if running outside an appserver): " + queueName + " OR " + jndiPrefix + queueName);
                String queuePrefix = System.getProperty(SASPhysicalQueuePrefixProperty, SASPhysicalQueuePrefix);
                logger.info("Creating dynamic queue with name: " + queuePrefix + JMSUtilities.getLastSegment(queueName));
                queueTemplate.setDefaultDestinationName(queuePrefix + JMSUtilities.getLastSegment(queueName));
            }
        }
    }

    public static String generatePrimaryId() {
        String hostname = "";
        try {
            InetAddress addr = InetAddress.getLocalHost();
            hostname = addr.getHostName();
            return JMSUtilities.generatePrimaryId(hostname);
        }
        catch (UnknownHostException e) {
            hostname = System.getenv("HOSTNAME");
            if (hostname == null) {
                return null;
            }
            return JMSUtilities.generatePrimaryId(hostname);
        }
    }

    public static String generatePrimaryId(String hostname) {
        try {
            return BASE64.encode((byte[])hostname.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            return BASE64.encode((byte[])hostname.getBytes());
        }
    }

    public String getServiceId(String id) {
        block4: {
            String authRequestString = "getServiceId_;_";
            this.sendRequestToServer(authRequestString, id, "getServiceId");
            try {
                Message msg = this.receiveRequestFromServer(this.m_stringQueue, id, "getServiceId");
                if (msg != null) {
                    if (msg instanceof TextMessage) {
                        return ((TextMessage)msg).getText();
                    }
                    return msg.toString();
                }
            }
            catch (JMSException e) {
                if (!MetaUtilities.isDebug()) break block4;
                e.printStackTrace();
            }
        }
        return null;
    }

    protected void sendRequestToServer(Object requestString, final String id, final String property) {
        block2: {
            try {
                this.m_midtierRequestQueue.convertAndSend(requestString, new MessagePostProcessor(){

                    public Message postProcessMessage(Message arg0) throws JMSException {
                        arg0.setStringProperty("ID", id);
                        arg0.setStringProperty("CALLER", property);
                        return arg0;
                    }
                });
            }
            catch (Exception ex) {
                if (!MetaUtilities.isDebug()) break block2;
                ex.printStackTrace();
            }
        }
    }

    protected Message receiveRequestFromServer(JmsTemplate queue, String id, String property) {
        return this.receiveRequestFromServer(queue, id, property, TIMEOUT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Message receiveRequestFromServer(final JmsTemplate queue, final String id, final String property, long timeout) {
        if (id == null || property == null) {
            return null;
        }
        long startTime = System.currentTimeMillis();
        long currentTime = System.currentTimeMillis();
        while (startTime > currentTime - timeout) {
            JmsTemplate jmsTemplate = queue;
            synchronized (jmsTemplate) {
                currentTime = System.currentTimeMillis();
                Message message = (Message)queue.browse((BrowserCallback)new BrowserCallback<Message>(){

                    public Message doInJms(Session arg0, QueueBrowser arg1) throws JMSException {
                        long oldmsgtimeout = 600000L;
                        Enumeration items = arg1.getEnumeration();
                        while (items.hasMoreElements()) {
                            Object o = items.nextElement();
                            if (!(o instanceof Message)) continue;
                            try {
                                Message msg = (Message)o;
                                String callerId = msg.getStringProperty("ID");
                                String callerName = msg.getStringProperty("CALLER");
                                if (id.equals(callerId) && property.equals(callerName)) {
                                    String messageSelector = "(ID = '" + id + "') AND (CALLER = '" + property + "')";
                                    Message msg2 = queue.receiveSelected(messageSelector);
                                    return msg2;
                                }
                                long dtc = msg.getJMSTimestamp();
                                if (dtc + oldmsgtimeout >= System.currentTimeMillis()) continue;
                                String messageSelector = "(ID = '" + callerId + "') AND (CALLER = '" + callerName + "')";
                                queue.receiveSelected(messageSelector);
                            }
                            catch (JMSException jMSException) {}
                        }
                        return null;
                    }
                });
                if (message != null) {
                    return message;
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    protected List<Object> browseQueue(JmsTemplate queue, final String id) {
        final ArrayList<Object> messages = new ArrayList<Object>();
        queue.browse((BrowserCallback)new BrowserCallback<Message>(){

            public Message doInJms(Session arg0, QueueBrowser arg1) throws JMSException {
                Enumeration items = arg1.getEnumeration();
                while (items.hasMoreElements()) {
                    Object o = items.nextElement();
                    if (!(o instanceof Message)) continue;
                    try {
                        Message msg = (Message)o;
                        String callerId = msg.getStringProperty("ID");
                        if (id != null && id.length() != 0 && !id.equals(callerId)) continue;
                        messages.add(msg);
                    }
                    catch (JMSException jMSException) {}
                }
                return null;
            }
        });
        return messages;
    }

    private static String findCallingMethod(Exception e, String childMethodName) {
        try {
            StackTraceElement[] stack = e.getStackTrace();
            boolean foundItem = false;
            for (StackTraceElement stackTraceElement : stack) {
                if (foundItem) {
                    return stackTraceElement.getClassName() + ":" + stackTraceElement.getMethodName();
                }
                if (!stackTraceElement.getMethodName().equals(childMethodName)) continue;
                foundItem = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "Unknown caller";
    }

    public static ConnectionFactory getFactory(InitialContext jmsContext, String factoryName, String simpleFactoryNames) throws NamingException {
        try {
            Object obj = jmsContext.lookup(factoryName);
            if (obj instanceof ConnectionFactory) {
                return (ConnectionFactory)obj;
            }
            throw new NamingException("wrong type");
        }
        catch (NamingException e) {
            try {
                Object obj = jmsContext.lookup(jndiPrefix + factoryName);
                if (obj instanceof ConnectionFactory) {
                    return (ConnectionFactory)obj;
                }
                throw new NamingException("wrong type");
            }
            catch (NamingException e2) {
                try {
                    return (ConnectionFactory)jmsContext.lookup("QueueConnectionFactory");
                }
                catch (NamingException e3) {
                    try {
                        return (ConnectionFactory)jmsContext.lookup("ConnectionFactory");
                    }
                    catch (NamingException e4) {
                        throw e;
                    }
                }
            }
        }
    }

    public static UserCredentialsConnectionFactoryAdapter configureSecurity(ConnectionFactory factory, Properties configuration) {
        String jmsSecurityUserid = configuration.getProperty(Config_JMSSecurity_Userid);
        String jmsSecurityPasswd = configuration.getProperty(Config_JMSSecurity_Passwd);
        if (jmsSecurityUserid != null && jmsSecurityUserid.length() > 0 && jmsSecurityPasswd != null && jmsSecurityPasswd.length() > 0) {
            if (SasPasswordString.isEncoded((String)jmsSecurityPasswd)) {
                try {
                    jmsSecurityPasswd = SasPasswordString.decode((String)jmsSecurityPasswd);
                }
                catch (SasPasswordEncodingException sasPasswordEncodingException) {
                    // empty catch block
                }
            }
            UserCredentialsConnectionFactoryAdapter secureQueueFactory = new UserCredentialsConnectionFactoryAdapter();
            secureQueueFactory.setTargetConnectionFactory(factory);
            secureQueueFactory.setUsername(jmsSecurityUserid);
            secureQueueFactory.setPassword(jmsSecurityPasswd);
            return secureQueueFactory;
        }
        return null;
    }

    public static boolean areCredentialsProvided(Properties configuration) {
        String jmsSecurityUserid = configuration.getProperty(Config_JMSSecurity_Userid);
        String jmsSecurityPasswd = configuration.getProperty(Config_JMSSecurity_Passwd);
        return jmsSecurityUserid != null && jmsSecurityUserid.length() > 0 && jmsSecurityPasswd != null && jmsSecurityPasswd.length() > 0;
    }

    protected synchronized void cleanupJMSObjects() {
        this.m_bytesQueue = null;
        this.m_checkQueue = null;
        this.m_stringQueue = null;
        this.m_instanceListQueue = null;
        this.m_instanceQueue = null;
        this.m_midtierRequestQueue = null;
        this.m_schedulerRequestQueue = null;
        this.m_schedulerResultsQueue = null;
        this.m_queueFactory = null;
    }

    public static String createStringFromArray(String[] items) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(Integer.toString(items.length));
        buffer.append("|");
        for (String itemData : items) {
            buffer.append(Integer.toString(itemData.length()));
            buffer.append("|");
            buffer.append(itemData);
            buffer.append("|");
        }
        return buffer.toString();
    }

    public static Long[] getLongArrayFromEncodedString(String data) {
        int lastSepIndex = data.indexOf(124);
        ArrayList<Long> results = new ArrayList<Long>();
        try {
            int nextSepIndex;
            while ((nextSepIndex = data.indexOf(124, lastSepIndex + 1)) >= 0) {
                int dataSize = Integer.parseInt(data.substring(lastSepIndex + 1, nextSepIndex));
                String item = data.substring(nextSepIndex + 1, nextSepIndex + 1 + dataSize);
                long dataItem = Long.parseLong(item);
                results.add(dataItem);
                lastSepIndex = nextSepIndex + 1 + dataSize;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return results.toArray(new Long[0]);
    }

    public static String createStringFromMap(Map<String, String> map) {
        StringBuffer buffer = new StringBuffer();
        if (map == null) {
            map = new HashMap<String, String>();
        }
        buffer.append(Integer.toString(map.size()));
        buffer.append("|");
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            buffer.append(Integer.toString(key.length()));
            buffer.append("|");
            buffer.append(key);
            buffer.append("|");
            buffer.append(Integer.toString(value.length()));
            buffer.append("|");
            buffer.append(value);
            buffer.append("|");
        }
        return buffer.toString();
    }

    public static String[] getArrayFromEncodedString(String data) {
        int lastSepIndex = data.indexOf(124);
        ArrayList<String> results = new ArrayList<String>();
        try {
            int nextSepIndex;
            while ((nextSepIndex = data.indexOf(124, lastSepIndex + 1)) >= 0) {
                int dataSize = Integer.parseInt(data.substring(lastSepIndex + 1, nextSepIndex));
                String item = data.substring(nextSepIndex + 1, nextSepIndex + 1 + dataSize);
                results.add(item);
                lastSepIndex = nextSepIndex + 1 + dataSize;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return results.toArray(new String[0]);
    }

    public static Map<String, String> getMapFromEncodedString(String data) {
        HashMap<String, String> results = new HashMap<String, String>();
        if (data != null) {
            int lastSepIndex = data.indexOf(124);
            try {
                int nextSepIndex;
                while ((nextSepIndex = data.indexOf(124, lastSepIndex + 1)) >= 0) {
                    int dataSize = Integer.parseInt(data.substring(lastSepIndex + 1, nextSepIndex));
                    String key = data.substring(nextSepIndex + 1, nextSepIndex + 1 + dataSize);
                    int anotherIndex = data.indexOf(124, nextSepIndex + dataSize + 1);
                    if (anotherIndex >= 0) {
                        nextSepIndex = data.indexOf(124, anotherIndex + 1);
                        dataSize = Integer.parseInt(data.substring(anotherIndex + 1, nextSepIndex));
                        String value = data.substring(nextSepIndex + 1, nextSepIndex + 1 + dataSize);
                        results.put(key, value);
                        lastSepIndex = nextSepIndex + 1 + dataSize;
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return results;
    }

    public static String createStringFromArray(Long[] items) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(Integer.toString(items.length));
        buffer.append("|");
        for (Long itemData : items) {
            String numberString = Long.toString(itemData);
            buffer.append(Integer.toString(numberString.length()));
            buffer.append("|");
            buffer.append(numberString);
            buffer.append("|");
        }
        return buffer.toString();
    }

    protected static String getLastSegment(String jmsName) {
        int lastSlash = jmsName.lastIndexOf(47);
        if (lastSlash >= 0) {
            return jmsName.substring(lastSlash + 1);
        }
        return jmsName;
    }

    public void sendResponseToClient(JmsTemplate outputQueue, final Object response, final String id, final String property) {
        if (response == null) {
            System.err.println("Empty response: " + property);
        }
        outputQueue.convertAndSend(response, new MessagePostProcessor(){

            public Message postProcessMessage(Message arg0) throws JMSException {
                arg0.setStringProperty("ID", id);
                arg0.setStringProperty("CALLER", property);
                arg0.setStringProperty("VALUE", response.toString());
                return arg0;
            }
        });
    }

    public static int getInt(Message msg) throws JMSException {
        if (msg != null) {
            if (msg instanceof StreamMessage) {
                return ((StreamMessage)msg).readInt();
            }
            if (msg instanceof ObjectMessage) {
                return (Integer)((ObjectMessage)msg).getObject();
            }
            try {
                return Integer.valueOf(msg.getStringProperty("VALUE"));
            }
            catch (RuntimeException r) {
                try {
                    return Integer.valueOf(msg.toString());
                }
                catch (RuntimeException rte) {
                    try {
                        throw new JMSException(rte.toString()).initCause((Throwable)rte);
                    }
                    catch (Throwable e) {
                        Logger LOGGER = LogManager.getLogger(JMSClientSupport.class);
                        LOGGER.debug(e.getMessage());
                    }
                }
            }
        }
        return -1;
    }

    public JmsTemplate getBytesQueue() {
        return this.m_bytesQueue;
    }

    public JmsTemplate getCheckQueue() {
        return this.m_checkQueue;
    }

    public JmsTemplate getStringQueue() {
        return this.m_stringQueue;
    }

    public JmsTemplate getInstanceListQueue() {
        return this.m_instanceListQueue;
    }

    public JmsTemplate getInstanceQueue() {
        return this.m_instanceQueue;
    }

    public JmsTemplate getMidtierRequestQueue() {
        return this.m_midtierRequestQueue;
    }

    public JmsTemplate getSchedulerRequestQueue() {
        return this.m_schedulerRequestQueue;
    }

    public JmsTemplate getSchedulerResultsQueue() {
        return this.m_schedulerResultsQueue;
    }

    public ConnectionFactory getQueueFactory() {
        return this.m_queueFactory;
    }
}

