/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.sasjfs.floworchestration;

import com.sas.scheduler.api.servers.sasjfs.sgmg.AuthenticationException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class RestCall {
    private static final List<Integer> _goodHttpCodes = Arrays.asList(200, 201, 202, 203, 204, 205, 206, 207);
    private static final Integer _authExceptionHttpCode = 401;
    private static final List<String> _httpVerbs = Arrays.asList("DELETE", "HEAD", "GET", "POST");
    private URL _restEndpoint;
    private String _httpVerb;
    private HttpURLConnection _conn;
    public int httpReturnCode;
    public String response;

    public RestCall(URL url, String verb, Map<String, String> reqProps, String reqBody, String contentType, int readTimeOut, int connTimeOut) throws AuthenticationException {
        if (!_httpVerbs.contains(verb)) {
            throw new RuntimeException("HTTP verb: " + verb + " is not supported at this time.");
        }
        this._httpVerb = verb;
        this._restEndpoint = url;
        try {
            this._conn = (HttpURLConnection)this._restEndpoint.openConnection();
            this._conn.setRequestMethod(this._httpVerb);
            for (Map.Entry<String, String> pair : reqProps.entrySet()) {
                this._conn.setRequestProperty(pair.getKey().toString(), pair.getValue().toString());
            }
            if (reqBody != null) {
                this._conn.setDoOutput(true);
                this._conn.setRequestProperty("Content-Type", contentType);
                this._conn.setRequestProperty("Content-Length", Integer.toString(reqBody.length()));
                this._conn.setConnectTimeout(connTimeOut);
                this._conn.setReadTimeout(readTimeOut);
                this._conn.getOutputStream().write(reqBody.getBytes());
            }
            this.httpReturnCode = this._conn.getResponseCode();
            if (!this.goodResponseCode(this.httpReturnCode)) {
                if (this.httpReturnCode == _authExceptionHttpCode) {
                    throw new AuthenticationException("Connection to REST endpoint failed due to Authentication. HTTP status is: " + this.httpReturnCode);
                }
                throw new RuntimeException("Connection to REST endpoint failed. HTTP status is: " + this.httpReturnCode + ", Message:" + this._conn.getResponseMessage());
            }
            this.response = this.getResponseBodyAsString(this._conn.getInputStream());
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this._conn.disconnect();
    }

    private boolean goodResponseCode(int code) {
        return _goodHttpCodes.contains(code);
    }

    private String getResponseBodyAsString(InputStream inputStream) throws IOException {
        String retval = null;
        String brLine = null;
        StringBuilder sb = new StringBuilder();
        BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));
        while ((brLine = br.readLine()) != null) {
            sb.append(brLine);
        }
        br.close();
        retval = sb.toString();
        return retval;
    }
}

