/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.sasjfs.floworchestration;

import com.sas.grid.representations.Job;
import com.sas.scheduler.api.servers.sasjfs.engine.SASJFSProperties;
import com.sas.scheduler.api.servers.sasjfs.floworchestration.AbstractFlowRunnable;
import com.sas.scheduler.api.servers.sasjfs.floworchestration.ExecutionItem;
import com.sas.scheduler.api.servers.sasjfs.floworchestration.FlowOrchestrator;
import com.sas.scheduler.api.servers.sasjfs.floworchestration.FlowRunner;
import com.sas.scheduler.api.servers.sasjfs.floworchestration.GridService;
import com.sas.scheduler.api.servers.sasjfs.sgmg.AuthenticationException;
import com.sas.scheduler.model.JobInfo;
import com.sas.util.SasPasswordEncodingException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GridRunnable
extends AbstractFlowRunnable {
    private static final Logger LOGGER = LogManager.getLogger(FlowOrchestrator.class);
    private GridService _service;
    private String _queue;
    private int _statusCheckTimeoutMs;

    public GridRunnable(GridService service, ExecutionItem item, SASJFSProperties props, List<PasswordAuthentication> authTokenList, String queue, FlowRunner.FlowRunnerCallback cb) {
        super(item, props, authTokenList, cb);
        this._service = service;
        this._queue = queue;
        try {
            this._statusCheckTimeoutMs = Integer.parseInt(System.getProperty("sas.sasjfs.status.timeout"));
        }
        catch (Exception e) {
            this._statusCheckTimeoutMs = 0;
        }
    }

    @Override
    public void run() {
        String processJson = this.createProcessJsonString(this._service.getGridProcessJsonTemplate(this._queue), (JobInfo)this._executionItem._info, this._queue);
        boolean gridCallComplete = false;
        int gridCallAttempt = 0;
        PasswordAuthentication pa = null;
        Job gridJob = null;
        while (!gridCallComplete && this._authTokenList.size() - gridCallAttempt >= 0) {
            pa = this._authTokenList.size() == gridCallAttempt ? null : (PasswordAuthentication)this._authTokenList.get(gridCallAttempt);
            try {
                gridJob = this._service.launchProcess(processJson, pa, this._executionItem);
                if (gridJob != null) {
                    this._executionItem._jobId = gridJob.getId();
                    gridCallComplete = true;
                    this._flowRunnerCallback.callbackJobRunning(this._executionItem);
                }
            }
            catch (AuthenticationException e) {
                LOGGER.info("Attempt number:" + gridCallAttempt + ", failed due to non authorized password." + e.toString());
            }
            catch (IOException e) {
                LOGGER.error("Failed grid job: " + gridCallAttempt + "Error: " + e.toString());
                this._executionItem._sasJFSJobInfo.setCompletionCode(6);
            }
            catch (SasPasswordEncodingException e) {
                LOGGER.error("Authentication Error for grid with:" + gridCallAttempt + "Error: " + e.toString());
                this._executionItem._sasJFSJobInfo.setCompletionCode(6);
            }
            catch (RuntimeException e) {
                LOGGER.error("Grid Running Error: " + e.toString());
                this._executionItem._sasJFSJobInfo.setCompletionCode(6);
            }
            ++gridCallAttempt;
        }
        if (gridJob != null) {
            int jobId = this._executionItem._jobId;
            if (pa != null) {
                this._executionItem._sasJFSJobInfo.setUserName(pa.getUserName());
            }
            this._executionItem._sasJFSJobInfo.setId(jobId);
            int statusCheckTimeoutMs = this._statusCheckTimeoutMs;
            if (statusCheckTimeoutMs == 0) {
                statusCheckTimeoutMs = 950400000;
            }
            int statusCheckSleepMs = 60000;
            int statusCheckDurationMs = 0;
            String procStatusUrl = GridService.getGridProcessesUrl() + "/" + jobId;
            LOGGER.info(String.format("Beginning status check for Job named: %s", this._executionItem._info.getName()));
            boolean procComplete = false;
            Job job = null;
            block24: while (!procComplete) {
                int i;
                statusCheckSleepMs = 60000;
                for (i = 1; i <= 60; ++i) {
                    try {
                        job = this._service.getJobStatus(procStatusUrl, pa, SASJFSProperties.getReadTimeOut(), SASJFSProperties.getConnTimeOut());
                        String jobStatus = job.getProcessingInfo().getState();
                        if (job.getProcessingInfo().getStartTime() != null) {
                            this._executionItem._sasJFSJobInfo.setStartTime(job.getProcessingInfo().getStartTime());
                        }
                        LOGGER.info("Job status check for Job named:" + this._executionItem._info.getName() + " for grid job id:" + jobId + ":  " + jobStatus);
                        procComplete = this.isJobComplete(jobStatus);
                    }
                    catch (AuthenticationException e) {
                        LOGGER.info("Attempt number:" + gridCallAttempt + ", failed due to non authorized password." + e.toString());
                    }
                    catch (UnsupportedEncodingException e) {
                        LOGGER.error("Failed grid job: " + gridCallAttempt + "Error: " + e.toString());
                    }
                    catch (MalformedURLException e) {
                        LOGGER.error("Failed grid job: " + gridCallAttempt + "Error: " + e.toString());
                    }
                    if (procComplete) {
                        LOGGER.info("process completed within the 1 hour window");
                        break;
                    }
                    this.logLoopStatus(statusCheckTimeoutMs, statusCheckSleepMs, statusCheckDurationMs += statusCheckSleepMs);
                    if (statusCheckDurationMs > statusCheckTimeoutMs) {
                        this._executionItem._sasJFSJobInfo.setCompletionCode(-1);
                        LOGGER.info(String.format("Job %s timed out", this._executionItem._info.getName()));
                        procComplete = true;
                        break;
                    }
                    try {
                        Thread.sleep(statusCheckSleepMs);
                        continue;
                    }
                    catch (InterruptedException e) {
                        this.logSleepInterruption(e);
                        procComplete = true;
                    }
                }
                if (!procComplete) {
                    statusCheckSleepMs = 300000;
                    for (i = 0; i <= 276; ++i) {
                        try {
                            ExecutionItem executionItem = this._executionItem;
                            ExecutionItem executionItem2 = this._executionItem;
                            job = this._service.getJobStatus(procStatusUrl, pa, executionItem._sasJFSProp.getReadTimeOut(), executionItem2._sasJFSProp.getConnTimeOut());
                            if (job.getProcessingInfo().getStartTime() != null) {
                                this._executionItem._sasJFSJobInfo.setStartTime(job.getProcessingInfo().getStartTime());
                            }
                            procComplete = this.isJobComplete(job.getProcessingInfo().getState());
                        }
                        catch (AuthenticationException e) {
                            LOGGER.info("Attempt number:" + gridCallAttempt + ", failed due to non authorized password." + e.toString());
                        }
                        catch (UnsupportedEncodingException e) {
                            LOGGER.error("Failed grid job: " + gridCallAttempt + "Error: " + e.toString());
                        }
                        catch (MalformedURLException e) {
                            LOGGER.error("Failed grid job: " + gridCallAttempt + "Error: " + e.toString());
                        }
                        if (procComplete) {
                            LOGGER.info("process completed within the 24 hour window");
                            break;
                        }
                        this.logLoopStatus(statusCheckTimeoutMs, statusCheckSleepMs, statusCheckDurationMs += statusCheckSleepMs);
                        if (statusCheckDurationMs > statusCheckTimeoutMs) {
                            this._executionItem._sasJFSJobInfo.setCompletionCode(1);
                            LOGGER.info(String.format("Job %s timed out", this._executionItem._info.getName()));
                            procComplete = true;
                            break;
                        }
                        try {
                            Thread.sleep(5 * statusCheckSleepMs);
                            continue;
                        }
                        catch (InterruptedException e) {
                            this.logSleepInterruption(e);
                            procComplete = true;
                        }
                    }
                }
                if (procComplete) continue;
                LOGGER.info(String.format("Process status check entering long term check mode - checking every 15 minutes for 10 days.", new Object[0]));
                statusCheckSleepMs = 900000;
                for (i = 0; i <= 960; ++i) {
                    try {
                        ExecutionItem executionItem = this._executionItem;
                        ExecutionItem executionItem3 = this._executionItem;
                        job = this._service.getJobStatus(procStatusUrl, pa, executionItem._sasJFSProp.getReadTimeOut(), executionItem3._sasJFSProp.getConnTimeOut());
                        if (job.getProcessingInfo().getStartTime() != null) {
                            this._executionItem._sasJFSJobInfo.setStartTime(job.getProcessingInfo().getStartTime());
                        }
                        procComplete = this.isJobComplete(job.getProcessingInfo().getState());
                    }
                    catch (AuthenticationException e) {
                        LOGGER.info("Attempt number:" + gridCallAttempt + ", failed due to non authorized password." + e.toString());
                    }
                    catch (UnsupportedEncodingException e) {
                        LOGGER.error("Failed grid job: " + gridCallAttempt + "Error: " + e.toString());
                    }
                    catch (MalformedURLException e) {
                        LOGGER.error("Failed grid job: " + gridCallAttempt + "Error: " + e.toString());
                    }
                    if (procComplete) {
                        LOGGER.info("process completed within the 11 day window");
                        continue block24;
                    }
                    this.logLoopStatus(statusCheckTimeoutMs, statusCheckSleepMs, statusCheckDurationMs += statusCheckSleepMs);
                    if (statusCheckDurationMs > statusCheckTimeoutMs) {
                        this._executionItem._sasJFSJobInfo.setCompletionCode(1);
                        LOGGER.info(String.format("Job %s timed out", this._executionItem._info.getName()));
                        procComplete = true;
                        continue block24;
                    }
                    try {
                        Thread.sleep(15 * statusCheckSleepMs);
                        continue;
                    }
                    catch (InterruptedException e) {
                        this.logSleepInterruption(e);
                        procComplete = true;
                    }
                }
            }
            String jobState = job.getProcessingInfo().getState();
            if (this._executionItem._sasJFSJobInfo.getExitCodeTranslationMap().containsKey(jobState)) {
                LOGGER.info(String.format("The exit code is being translated for Job State %s", jobState));
                this._executionItem._sasJFSJobInfo.setCompletionCode(this._executionItem._sasJFSJobInfo.getExitCodeTranslationMap().get(jobState));
            } else {
                this._executionItem._sasJFSJobInfo.setCompletionCode(job.getProcessingInfo().getExitCode());
            }
            this._executionItem._sasJFSJobInfo.setFinishTime(job.getProcessingInfo().getEndTime());
            this._executionItem._sasJFSJobInfo.setName(job.getRequest().getName());
        } else {
            this._executionItem._sasJFSJobInfo.setJfsErrCode(-1);
        }
        this._flowRunnerCallback.callbackJobCompleted(this._executionItem);
    }

    private void logSleepInterruption(InterruptedException e) {
        LOGGER.error("Thread sleep interrupted while checking for process status.");
        LOGGER.error("", (Throwable)e);
    }

    private void logLoopStatus(int statusCheckTimeoutMs, int statusCheckSleepMs, int statusCheckDurationMs) {
        LOGGER.info(String.format("Duration(ms): %d  Total(ms): %d  Timeout(ms): %d", statusCheckSleepMs, statusCheckDurationMs, statusCheckTimeoutMs));
    }

    private boolean isJobComplete(String statusString) {
        Boolean retval = false;
        if (statusString != null) {
            retval = GridService.getStatusCompleteList().contains(statusString);
        }
        return retval;
    }

    private String createProcessJsonString(String template, JobInfo job, String queue) {
        String retval = template;
        retval = retval.replace("{{ver_num}}", "1");
        retval = retval.replace("{{command}}", job.getCommandLine() == null ? "" : job.getCommandLine().replace("\\", "\\\\").replace("\"", "\\\""));
        if ((retval = retval.replace("{{name}}", job.getNameDataBinding() == null ? "" : job.getNameDataBinding() + "_" + job.getId())).contains("queue")) {
            retval = retval.replace("{{queue}}", queue.trim());
        }
        return retval;
    }
}

