/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.sasjfs.engine;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;

public class SASJFSProperties
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static int maxHistories = 9999;
    private static int maxFlowHistories = 25;
    private static int quantumDurationSeconds = 10;
    private static int statusCheckTimeoutMs = 10;
    private static int readTimeOut = 60000;
    private static int connTimeOut = 60000;
    private static final String PropertySeparator = "_;_";
    private static final String MaxHistory_Tag = "_;_MaxHistory=";
    private static final String MaxFlowHistory_Tag = "_;_MaxFlowHistory=";
    private static final String StatusCheckTimeout_Tag = "_;_StatusCheckTimeout=";
    private static final String QuantumDurationSeconds_Tag = "_;_QuantumDurationSec=";
    private static final String SGMGGridReadTimeoutSeconds_Tag = "_;_SGMGGridReadTimeoutSec=";
    private static final String SGMGGridConnTimeoutSeconds_Tag = "_;_SGMGGridConnTimeoutSec=";

    public int getMaxHistories() {
        return maxHistories;
    }

    public void setMaxHistories(int maxHistories) {
        SASJFSProperties.maxHistories = maxHistories;
    }

    public int getMaxFlowHistories() {
        return maxFlowHistories;
    }

    public void setMaxFlowHistories(int maxFlowHistories) {
        SASJFSProperties.maxFlowHistories = maxFlowHistories;
    }

    public static int getQuantumDurationSeconds() {
        return quantumDurationSeconds;
    }

    public static void setQuantumDurationSeconds(int quantumDurationSeconds) {
        SASJFSProperties.quantumDurationSeconds = quantumDurationSeconds;
    }

    public static int getStatusCheckTimeoutMs() {
        return statusCheckTimeoutMs;
    }

    public static void setStatusCheckTimeoutMs(int statusCheckTimeoutMs) {
        SASJFSProperties.statusCheckTimeoutMs = statusCheckTimeoutMs;
    }

    public static int getReadTimeOut() {
        return readTimeOut;
    }

    public static void setReadTimeOut(int readTimeOut) {
        SASJFSProperties.readTimeOut = readTimeOut;
    }

    public static int getConnTimeOut() {
        return connTimeOut;
    }

    public static void setConnTimeOut(int connTimeOut) {
        SASJFSProperties.connTimeOut = connTimeOut;
    }

    public static SASJFSProperties getPropertiesFromString(String data) {
        BufferedReader reader = new BufferedReader(new StringReader(data));
        SASJFSProperties properties = new SASJFSProperties();
        try {
            String flowLine = reader.readLine();
            properties.createFromData(flowLine, reader);
            reader.close();
            return properties;
        }
        catch (NullPointerException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    protected void createFromData(String flowLine, BufferedReader reader) {
        maxHistories = SASJFSProperties.getIntegerParameterFromHistoryLine(flowLine, MaxHistory_Tag);
        maxFlowHistories = SASJFSProperties.getIntegerParameterFromHistoryLine(flowLine, MaxFlowHistory_Tag);
        statusCheckTimeoutMs = SASJFSProperties.getIntegerParameterFromHistoryLine(flowLine, StatusCheckTimeout_Tag);
        quantumDurationSeconds = SASJFSProperties.getIntegerParameterFromHistoryLine(flowLine, QuantumDurationSeconds_Tag);
        readTimeOut = SASJFSProperties.getIntegerParameterFromHistoryLine(flowLine, SGMGGridReadTimeoutSeconds_Tag);
        connTimeOut = SASJFSProperties.getIntegerParameterFromHistoryLine(flowLine, SGMGGridConnTimeoutSeconds_Tag);
    }

    public static String toSerializedForm() {
        StringBuffer buffer = new StringBuffer();
        return SASJFSProperties.toSerializedForm(buffer).toString();
    }

    protected static StringBuffer toSerializedForm(StringBuffer buffer) {
        buffer.append("SASJFS Properties");
        buffer.append(MaxHistory_Tag);
        buffer.append(maxHistories);
        buffer.append(MaxFlowHistory_Tag);
        buffer.append(maxFlowHistories);
        buffer.append(StatusCheckTimeout_Tag);
        buffer.append(statusCheckTimeoutMs);
        buffer.append(QuantumDurationSeconds_Tag);
        buffer.append(quantumDurationSeconds);
        buffer.append(SGMGGridReadTimeoutSeconds_Tag);
        buffer.append(readTimeOut);
        buffer.append(SGMGGridConnTimeoutSeconds_Tag);
        buffer.append(connTimeOut);
        return buffer;
    }

    public static String getStringParameterFromHistoryLine(String historyLine, String parmName) {
        int index = historyLine.indexOf(parmName);
        if (index < 0) {
            return "";
        }
        int separatorIndex = historyLine.indexOf(PropertySeparator, index + parmName.length());
        if (separatorIndex < 0) {
            separatorIndex = historyLine.length();
        }
        String dataString = historyLine.substring(index + parmName.length(), separatorIndex);
        return dataString;
    }

    public static int getIntegerParameterFromHistoryLine(String historyLine, String parmName) {
        int index = historyLine.indexOf(parmName);
        if (index < 0) {
            return -1;
        }
        int separatorIndex = historyLine.indexOf(PropertySeparator, index + parmName.length());
        if (separatorIndex < 0) {
            separatorIndex = historyLine.length();
        }
        String dataString = historyLine.substring(index + parmName.length(), separatorIndex);
        return new Integer(dataString);
    }
}

