/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.oozie.job;

import com.sas.scheduler.api.servers.oozie.job.AbstractOozieJob;
import com.sas.scheduler.api.servers.oozie.job.OozieException;
import com.sas.scheduler.model.FlowInfo;
import com.sas.scheduler.model.SchedulerServerInfo;
import java.io.IOException;

public class OozieDeployJob
extends AbstractOozieJob {
    public OozieDeployJob(FlowInfo flow, SchedulerServerInfo server) {
        super(flow, server);
    }

    public void deploy(String path, String data) throws OozieException {
        String fullPath = this.getJobPath(path);
        try {
            AbstractOozieJob.HttpResponse resp = this.hdfsCreate(fullPath, data, "application/octet-stream", true);
            if (resp.code != 201) {
                throw new OozieException(resp.getException());
            }
        }
        catch (IOException e) {
            throw new OozieException(e);
        }
    }

    protected String getJobPath(String path) {
        return this.nameNode + "/webhdfs/v1" + path;
    }
}

