/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.ip.engine.mq.client;

import com.sas.scheduler.api.servers.ip.engine.ClientLogger;
import com.sas.scheduler.api.servers.ip.engine.FlowManager;
import com.sas.scheduler.api.servers.ip.engine.IPUtilities;
import com.sas.scheduler.api.servers.ip.engine.mq.client.CommandLineJobRunner;
import com.sas.scheduler.api.servers.ip.engine.mq.client.DefaultLoadBalancer;
import com.sas.scheduler.api.servers.ip.engine.mq.client.JMSClientSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class CommandLineJobServer {
    public static final String Config_MaxSimultaneousJobs = "MaxJobs";
    public static final String Config_MaxJobsWithNoWait = "JobCountBeforeWait";
    public static final String Config_BaseWait = "BaseWaitTimeMS";
    public static final String Config_MaxWait = "MaxWaitTimeMS";
    public static final String Config_HardKillAllowed = "sas.dip.commandLine.hardKillAllowed";
    public static final String Config_ServerID = "sas.dip.commandLine.jobRunnerID";
    public static final String Config_HandledApplicationIDs = "sas.dip.commandLine.handledApplicationIDs";
    public static final String Config_AlternateCommandShell = "sas.dip.commandLine.alternateCommandShell";
    public static final String Config_LogLevel = "sas.dip.commandLine.logLevel";
    public static final String Config_LogFilePath = "sas.dip.commandLine.logFilePath";
    public static final String Property_ConfigLocation = "sas.dip.commandLine.propertyFile";
    public static final String Property_ConfigServerID = "sas.dip.commandLine.jobRunnerID";
    public static final String Config_UnixRunAsMode = "sas.dip.commandLine.unix.runAsMode";
    private FileHandler mLogFileHandler;
    private Logger mLogFileLogger;
    private ConsoleHandler mConsoleLogger;
    private ClientLogger mLogger = null;
    protected Level mLogLevel = Level.INFO;

    public static void main(String[] args) throws Exception {
        System.out.println("DIP - Command-Line Job Runner");
        JMSClientSupport support = new CommandLineJobServer().createJobRunner(args);
        if (support != null) {
            System.out.println("Started DIP Job Runner with ID: " + support.getRenderer().getID());
        }
    }

    protected ClientLogger getLogger() {
        if (this.mLogger == null) {
            this.mLogger = new ClientLogger(){

                @Override
                public void logMessage(Level l, Throwable t) {
                    if (l.intValue() >= CommandLineJobServer.this.mLogLevel.intValue()) {
                        if (CommandLineJobServer.this.mLogFileLogger != null) {
                            CommandLineJobServer.this.mLogFileLogger.log(l, t.getMessage(), t);
                        } else {
                            t.printStackTrace();
                        }
                    }
                }

                @Override
                public void logMessage(Level l, String message) {
                    if (l.intValue() >= CommandLineJobServer.this.mLogLevel.intValue()) {
                        if (CommandLineJobServer.this.mLogFileLogger != null) {
                            CommandLineJobServer.this.mLogFileLogger.log(l, message);
                        } else {
                            System.out.println(message);
                        }
                    }
                }
            };
        }
        return this.mLogger;
    }

    protected Properties getProperties(String[] args) throws IOException {
        String logFilePath;
        File f;
        this.mLogFileLogger = Logger.getLogger("DIPJobRunner");
        this.mConsoleLogger = new ConsoleHandler();
        this.mConsoleLogger.setFormatter(new SimpleFormatter());
        this.mConsoleLogger.setLevel(Level.ALL);
        this.mLogFileLogger.addHandler(this.mConsoleLogger);
        this.mLogFileLogger.setLevel(Level.ALL);
        String propertyFileLocation = null;
        if (args.length > 0) {
            propertyFileLocation = args[0];
        }
        if ((propertyFileLocation = System.getProperty(Property_ConfigLocation, propertyFileLocation)) == null) {
            System.err.println("No properties file location supplied");
            this.showHelp();
            return null;
        }
        if (args.length >= 1 && (args[0].toLowerCase().indexOf("help") >= 0 || args[0].toLowerCase().indexOf("?") >= 0)) {
            this.showHelp();
            return null;
        }
        File allPropsFile = new File(propertyFileLocation);
        if (!allPropsFile.exists()) {
            System.err.println("Properties file doesn't exist or cannot be read: " + allPropsFile.getAbsolutePath());
            this.showHelp();
            return null;
        }
        Properties clientProperties = new Properties();
        FileInputStream inStream = new FileInputStream(allPropsFile);
        clientProperties.load(inStream);
        ((InputStream)inStream).close();
        if (clientProperties.containsKey(Config_LogLevel)) {
            String logLevel = clientProperties.getProperty(Config_LogLevel, "INFO").toUpperCase();
            if (logLevel.equals("INFO")) {
                this.mLogLevel = Level.INFO;
            } else if (logLevel.equals("WARN")) {
                this.mLogLevel = Level.WARNING;
            } else if (logLevel.equals("ERROR")) {
                this.mLogLevel = Level.SEVERE;
            } else if (logLevel.equals("DEBUG")) {
                this.mLogLevel = Level.FINEST;
            }
        }
        if (clientProperties.containsKey(Config_LogFilePath) && (f = new File(logFilePath = clientProperties.getProperty(Config_LogFilePath, ""))).getParentFile().exists()) {
            String logPath = f.getAbsolutePath().replace('\\', '/');
            this.mLogFileHandler = new FileHandler(logPath);
            this.mLogFileHandler.setFormatter(new SimpleFormatter());
            this.mLogFileLogger.addHandler(this.mLogFileHandler);
            this.mLogFileLogger.setLevel(Level.ALL);
        }
        return clientProperties;
    }

    protected JMSClientSupport createJobRunner(String[] args) throws Exception {
        Properties clientProperties = this.getProperties(args);
        if (clientProperties == null) {
            return null;
        }
        String rendererID = System.getProperty("sas.dip.commandLine.jobRunnerID", null);
        if (rendererID != null) {
            clientProperties.setProperty("sas.dip.commandLine.jobRunnerID", rendererID);
        }
        if ((rendererID = clientProperties.getProperty("sas.dip.commandLine.jobRunnerID", "")).length() == 0) {
            System.err.println("Property missing: sas.dip.commandLine.jobRunnerID");
            this.showHelp();
            return null;
        }
        JMSClientSupport support = this.constructJobRunner(clientProperties);
        return support;
    }

    protected JMSClientSupport constructJobRunner(Properties clientProperties) {
        String[] parts;
        String altShell;
        FlowManager.setDefaultLogLevel(Level.FINEST);
        String rendererID = clientProperties.getProperty("sas.dip.commandLine.jobRunnerID", "");
        if (rendererID == "") {
            throw new IllegalArgumentException("No renderer ID supplied");
        }
        CommandLineJobRunner renderer = new CommandLineJobRunner(rendererID, this.getLogger());
        boolean hardKillAllowed = IPUtilities.getBooleanValue(clientProperties, Config_HardKillAllowed, true, this.getLogger());
        renderer.setHardKillAllowed(hardKillAllowed);
        String runAsMode = clientProperties.getProperty(Config_UnixRunAsMode, null);
        renderer.setRunAsMode(runAsMode);
        ArrayList<String> appIDs = new ArrayList<String>();
        String idString = clientProperties.getProperty(Config_HandledApplicationIDs, "").trim();
        if (idString.length() > 0) {
            String[] splitIDs;
            for (String id : splitIDs = idString.split(",")) {
                if (id.trim().length() <= 0) continue;
                appIDs.add(id.trim());
            }
        }
        if (appIDs.size() > 0) {
            renderer.setApplicationIDs(appIDs);
        }
        if ((altShell = clientProperties.getProperty(Config_AlternateCommandShell, "").trim()).length() > 0 && (parts = altShell.split(";")).length == 2 && parts[0].length() > 0 && parts[1].length() > 0) {
            renderer.addShellCommand(parts[0], parts[1]);
        }
        int maxJobs = IPUtilities.getIntegerValue(clientProperties, Config_MaxSimultaneousJobs, 10, this.getLogger());
        int maxJobsBeforeDelay = IPUtilities.getIntegerValue(clientProperties, Config_MaxJobsWithNoWait, 2, this.getLogger());
        long baseWait = IPUtilities.getLongValue(clientProperties, Config_BaseWait, 2000L, this.getLogger());
        long maxWait = IPUtilities.getLongValue(clientProperties, Config_MaxWait, 20000L, this.getLogger());
        JMSClientSupport support = new JMSClientSupport(clientProperties, this.getLogger(), renderer, new DefaultLoadBalancer(maxJobs, baseWait, maxWait, maxJobsBeforeDelay));
        return support;
    }

    protected void showHelp() {
        System.out.println("Usage: ");
        System.out.println("\tjava [-Dsas.dip.commandLine.propertyFile=<file path>] [-Dsas.dip.commandLine.jobRunnerID=<id>] CommandLineJobServer [<property file path>]");
        System.out.println("Arguments in the properties file (supply required values and any that are non-default):");
        System.out.println("\t [Required*] sas.dip.commandLine.jobRunnerID-unique ID to use for this server (for logs, etc).  You must supply this value either here or using the property.  The property works as an override.");
        System.out.println("\t [Required] java.naming.factory.initial-JMS factory class. ex. org.apache.activemq.jndi.ActiveMQInitialContextFactory");
        System.out.println("\t [Required] java.naming.provider.url-JMS URL.  ex. tcp://myMachine.mydomain.com:61616");
        System.out.println("\t [Required*] JMSSecurityUserid-The JMS user id.  Don't include if no security");
        System.out.println("\t [Required*] JMSSecurityPasswd-The JMS password.  Don't include if no security");
        System.out.println();
        System.out.println("\tMaxJobs-The maximum number of jobs that the server can run at the same time.  Default is 10.");
        System.out.println("\tJobCountBeforeWait-The maximum number of jobs that the server can run before it will delay before accepting new work.  Default is 2.");
        System.out.println("\tBaseWaitTimeMS-The base wait time used by the default load balancer algorithm.  Default is 2000 (2 second)");
        System.out.println("\tMaxWaitTimeMS-The maximum wait time used by the default load balancer algorithm.  Default is 20000 (20 seconds)");
        System.out.println("\tPIP.OutputLimit-The max number of bytes captured for a job's stdout or stderr, in bytes.  Default is 50000.");
        System.out.println("\tPIP.JobPollFrequency-The number of milliseconds before the job runner checks for work again.  Default is 10000.");
        System.out.println();
        System.out.println("\tsas.dip.commandLine.hardKillAllowed-if 'true', a Process destroy will be used to terminate processes that have overrun their allotted time.  Otherwise, only a soft kill will be attempted.");
        System.out.println("\tsas.dip.commandLine.handledApplicationIDs-A comma-separated list of application IDs.  If not supplied, the default command-line ID is used.");
        System.out.println("\tsas.dip.commandLine.alternateCommandShell-Set the command shell.  <command shell>;<shell exit command>.  Ex. 'cmd;exit'");
        System.out.println("\tsas.dip.commandLine.logLevel-Set the log level.  INFO/WARN/ERROR/DEBUG.  Default is INFO");
        System.out.println("\tsas.dip.commandLine.logFilePath-Set the log file path.  This should be a fully qualified file path including the log file name.");
        System.out.println();
        System.out.println("Ctrl-C to shut down the job server gracefully.  Jobs already accepted will be completed first, but no new work will be grabbed.");
    }
}

