/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.ip.engine.mq;

import com.sas.scheduler.api.servers.ip.engine.IJobRoutingNode;
import com.sas.scheduler.api.servers.ip.engine.mq.JobRoutingBooleanNode;
import com.sas.scheduler.api.servers.ip.engine.mq.JobRoutingExpression;
import com.sas.scheduler.api.servers.ip.engine.mq.JobRoutingOperationNode;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class RendererRoutingRules {
    public static final String JobRoutingTags_RoutingRules = "Rules";
    public static final String JobRoutingTags_RoutingRule = "Rule";
    public static final String JobRoutingAttrs_queueID = "queue";
    public static final String JobRoutingTags_AndRule = "And";
    public static final String JobRoutingTags_OrRule = "Or";
    public static final String JobRoutingTags_Condition = "Condition";
    public static final String JobRoutingAttrs_operation = "operation";
    public static final String JobRoutingAttrs_data = "data";
    public static final String JobRoutingAttrs_caseSensitive = "caseSensitive";
    public static final String JobRoutingAttrs_selector = "selector";
    public static final String JobRoutingOperator_contains = "contains";
    public static final String JobRoutingOperator_notContains = "notContains";
    public static final String JobRoutingOperator_startsWith = "startsWith";
    public static final String JobRoutingOperator_endsWith = "endsWith";
    public static final String JobRoutingOperator_equals = "equals";
    private List<JobRoutingExpression> mRoutingRules = null;
    private String mJobRoutingXML = null;

    private RendererRoutingRules() {
    }

    public static RendererRoutingRules fromXML(String rulesXML) throws Exception {
        RendererRoutingRules rules = new RendererRoutingRules();
        rules.mJobRoutingXML = rulesXML.trim();
        rules.mRoutingRules = rules.mJobRoutingXML.length() == 0 ? new ArrayList<JobRoutingExpression>() : RendererRoutingRules.parseJobRoutingExpressions(rules.mJobRoutingXML);
        return rules;
    }

    public List<JobRoutingExpression> getRules() {
        return this.mRoutingRules;
    }

    public String getXMLString() {
        return this.mJobRoutingXML;
    }

    public static List<JobRoutingExpression> parseJobRoutingExpressions(String xml) throws Exception {
        ArrayList<JobRoutingExpression> routingExpressions = new ArrayList<JobRoutingExpression>();
        BufferedReader xmlReader = new BufferedReader(new StringReader(xml));
        InputSource source = new InputSource(xmlReader);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        Document doc = dbf.newDocumentBuilder().parse(source);
        NodeList nl = doc.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (!node.getNodeName().equals(JobRoutingTags_RoutingRules)) continue;
            NodeList childNodes = node.getChildNodes();
            for (int k = 0; k < childNodes.getLength(); ++k) {
                JobRoutingExpression expr;
                node = childNodes.item(k);
                if (!node.getNodeName().equals(JobRoutingTags_RoutingRule) || (expr = RendererRoutingRules.processRuleTag(node)) == null) continue;
                routingExpressions.add(expr);
            }
        }
        return routingExpressions;
    }

    private static JobRoutingExpression processRuleTag(Node ruleNode) {
        NamedNodeMap attributes = ruleNode.getAttributes();
        Node targetQueueNode = attributes.getNamedItem(JobRoutingAttrs_queueID);
        if (targetQueueNode == null) {
            return null;
        }
        String targetQueue = targetQueueNode.getNodeValue();
        IJobRoutingNode expression = null;
        NodeList nl = ruleNode.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node expressionNode = nl.item(i);
            if (!expressionNode.getNodeName().equals(JobRoutingTags_AndRule) && !expressionNode.getNodeName().equals(JobRoutingTags_OrRule) && !expressionNode.getNodeName().equals(JobRoutingTags_Condition)) continue;
            expression = RendererRoutingRules.processExpression(expressionNode);
            break;
        }
        if (expression == null) {
            return null;
        }
        JobRoutingExpression expr = new JobRoutingExpression(expression, targetQueue);
        return expr;
    }

    private static IJobRoutingNode processExpression(Node expressionNode) {
        if (expressionNode.getNodeName().equals(JobRoutingTags_Condition)) {
            NamedNodeMap attrs = expressionNode.getAttributes();
            Node opNode = attrs.getNamedItem(JobRoutingAttrs_operation);
            Node dataNode = attrs.getNamedItem(JobRoutingAttrs_data);
            Node selectorNode = attrs.getNamedItem(JobRoutingAttrs_selector);
            if (opNode == null || dataNode == null || selectorNode == null) {
                return null;
            }
            boolean caseSensitive = true;
            Node caseSensitiveNode = attrs.getNamedItem(JobRoutingAttrs_caseSensitive);
            if (caseSensitiveNode != null) {
                caseSensitive = Boolean.parseBoolean(caseSensitiveNode.getNodeValue());
            }
            return new JobRoutingOperationNode(opNode.getNodeValue(), selectorNode.getNodeValue(), dataNode.getNodeValue(), caseSensitive);
        }
        boolean anded = expressionNode.getNodeName().equals(JobRoutingTags_AndRule);
        JobRoutingBooleanNode boolNode = new JobRoutingBooleanNode(anded);
        NodeList nl = expressionNode.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node childNode = nl.item(i);
            IJobRoutingNode childExpression = RendererRoutingRules.processExpression(childNode);
            if (childExpression == null) continue;
            boolNode.addChild(childExpression);
        }
        return boolNode;
    }

    public String toString() {
        List<JobRoutingExpression> rules = this.getRules();
        StringBuffer buffer = new StringBuffer();
        for (JobRoutingExpression jobRoutingExpression : rules) {
            buffer.append(jobRoutingExpression.toString());
            buffer.append('\n');
        }
        return buffer.toString();
    }
}

