/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.ip.engine.mq;

import com.sas.scheduler.api.servers.ip.engine.IJobRoutingNode;
import com.sas.scheduler.api.servers.ip.engine.Job;

public class JobRoutingOperationNode
implements IJobRoutingNode {
    public static final String JobTag_JobName = "JobName";
    public static final String JobTag_FlowName = "FlowName";
    public static final String JobTag_Description = "Description";
    public static final String JobTag_Command = "Command";
    public static final String JobTag_UserName = "UserID";
    public static final String JobTag_Queue = "Queue";
    private String mOperation;
    private String mSelector;
    private String mData;
    private boolean mCaseSensitive;

    public JobRoutingOperationNode(String op, String selector, String data, boolean caseSensitive) throws IllegalArgumentException {
        this.mOperation = op;
        this.mSelector = selector;
        this.mData = data;
        this.mCaseSensitive = caseSensitive;
        if (!this.isValidOperation(this.mOperation)) {
            throw new IllegalArgumentException("Invalid operation: " + this.mOperation);
        }
        if (!this.isValidSelector(this.mSelector)) {
            throw new IllegalArgumentException("Invalid selector: " + this.mSelector);
        }
    }

    protected boolean isValidOperation(String op) {
        if (op == null) {
            return false;
        }
        return op.equals("equals") || op.equals("contains") || op.equals("endsWith") || op.equals("notContains") || op.equals("startsWith");
    }

    protected boolean isValidSelector(String sel) {
        if (sel == null) {
            return false;
        }
        return sel.equals(JobTag_Command) || sel.equals(JobTag_Description) || sel.equals(JobTag_JobName) || sel.equals(JobTag_UserName) || sel.equals(JobTag_Queue);
    }

    @Override
    public boolean evaluate(Job j) {
        if (this.mSelector == null || this.mData == null || this.mOperation == null) {
            return false;
        }
        String selectorData = null;
        if (this.mSelector.equals(JobTag_Command)) {
            selectorData = j.getCommand();
        } else if (this.mSelector.equals(JobTag_Description)) {
            selectorData = j.getDescription();
        } else if (this.mSelector.equals(JobTag_JobName)) {
            selectorData = j.getName();
        } else if (this.mSelector.equals(JobTag_UserName)) {
            selectorData = j.getUserName();
        } else if (this.mSelector.equals(JobTag_Queue)) {
            selectorData = j.getExecutionQueue();
        }
        if (selectorData == null) {
            return false;
        }
        String data = this.mData;
        if (!this.mCaseSensitive) {
            data = data.toLowerCase();
            selectorData = selectorData.toLowerCase();
        }
        if (this.mOperation.equals("equals")) {
            return selectorData.equals(data);
        }
        if (this.mOperation.equals("contains")) {
            return selectorData.indexOf(data) >= 0;
        }
        if (this.mOperation.equals("notContains")) {
            return selectorData.indexOf(data) < 0;
        }
        if (this.mOperation.equals("startsWith")) {
            return selectorData.startsWith(data);
        }
        if (this.mOperation.equals("endsWith")) {
            return selectorData.endsWith(data);
        }
        return false;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("(");
        buffer.append(this.mSelector);
        buffer.append(" ");
        buffer.append(this.mOperation);
        buffer.append(" ");
        buffer.append(this.mData);
        buffer.append(")");
        return buffer.toString();
    }
}

