/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.ip.engine;

import com.sas.scheduler.api.servers.ip.engine.ClientLogger;
import com.sas.scheduler.api.servers.ip.engine.ExecutionItem;
import com.sas.scheduler.api.servers.ip.engine.JobResourceRequirements;
import com.sas.scheduler.api.servers.ip.engine.RetryCondition;
import com.sas.scheduler.model.SchedulerException;
import java.io.BufferedReader;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Job
extends ExecutionItem {
    private String mCommand = "";
    private String mOSCommand = "";
    private String mInputFilePath = "";
    private boolean mCaptureOutputStream = false;
    private boolean mCaptureErrorStream = false;
    private String mExecutionQueue = "";
    private JobResourceRequirements mJobResourceRequirements = new JobResourceRequirements();
    private int mMaxRetryAttempts = 0;
    private RetryCondition mRetryCondition = new RetryCondition(null);
    public static final String XML_Job_Tag = "Job";
    public static final String XML_Command_Tag = "Command";
    public static final String XML_OSCommand_Tag = "OSCommand";
    public static final String XML_ExecutionQueue_Tag = "queue";
    public static final String XML_JobResourceRequirements_Tag = "JobResources";
    public static final String XML_CaptureOutput_Tag = "CaptureOutput";
    public static final String XML_CaptureError_Tag = "CaptureError";
    public static final String XML_InputPath_Tag = "InputFilePath";

    public Job(ClientLogger logger) {
        super(logger);
    }

    public JobResourceRequirements getJobResourceRequirements() {
        return this.mJobResourceRequirements;
    }

    public void setJobResourceRequirements(JobResourceRequirements jobResourceRequirements) {
        if (jobResourceRequirements == null) {
            jobResourceRequirements = new JobResourceRequirements();
        }
        this.mJobResourceRequirements = jobResourceRequirements;
    }

    public String getCommand() {
        return this.mCommand;
    }

    public void setCommand(String command) {
        if (command != null) {
            this.mCommand = command;
        }
    }

    public Job copy() {
        Job obj = new Job(this.mLogger);
        obj.copyFrom(this);
        return obj;
    }

    public void copyFrom(Job source) {
        super.copyFrom(source);
        this.mCommand = source.mCommand;
        this.mOSCommand = source.mOSCommand;
        this.mCaptureErrorStream = source.mCaptureErrorStream;
        this.mCaptureOutputStream = source.mCaptureOutputStream;
        this.mInputFilePath = source.mInputFilePath;
        this.mExecutionQueue = source.mExecutionQueue;
        this.mJobResourceRequirements = source.mJobResourceRequirements.copy();
        this.mMaxRetryAttempts = source.mMaxRetryAttempts;
        this.mRetryCondition = source.mRetryCondition.copy();
    }

    public String getExecutionQueue() {
        return this.mExecutionQueue;
    }

    public void setExecutionQueue(String executionQueue) {
        this.mExecutionQueue = executionQueue;
    }

    public boolean isCaptureErrorStream() {
        return this.mCaptureErrorStream;
    }

    public void setCaptureErrorStream(boolean captureErrorStream) {
        this.mCaptureErrorStream = captureErrorStream;
    }

    public boolean isCaptureOutputStream() {
        return this.mCaptureOutputStream;
    }

    public void setCaptureOutputStream(boolean captureOutputStream) {
        this.mCaptureOutputStream = captureOutputStream;
    }

    public String getInputFilePath() {
        return this.mInputFilePath;
    }

    public void setInputFilePath(String inputFilePath) {
        if (inputFilePath != null) {
            this.mInputFilePath = inputFilePath;
        }
    }

    @Override
    protected void injectXML(Document doc, Element job) {
        super.injectXML(doc, job);
        if (this.getInputFilePath() != null && this.getInputFilePath().length() > 0) {
            Element pathTag = doc.createElement(XML_InputPath_Tag);
            CDATASection cdata = doc.createCDATASection(this.getInputFilePath());
            job.appendChild(pathTag);
            pathTag.appendChild(cdata);
        }
        job.setAttribute(XML_CaptureOutput_Tag, Boolean.toString(this.mCaptureOutputStream));
        job.setAttribute(XML_CaptureError_Tag, Boolean.toString(this.mCaptureErrorStream));
        job.setAttribute("maxRetries", Integer.toString(this.mMaxRetryAttempts));
        Element commandTag = doc.createElement(XML_Command_Tag);
        job.appendChild(commandTag);
        CDATASection commandSection = doc.createCDATASection(this.mCommand);
        commandTag.appendChild(commandSection);
        Element osCommandTag = doc.createElement(XML_OSCommand_Tag);
        job.appendChild(osCommandTag);
        CDATASection osCommandSection = doc.createCDATASection(this.mOSCommand);
        osCommandTag.appendChild(osCommandSection);
        Element queueTag = doc.createElement(XML_ExecutionQueue_Tag);
        job.appendChild(queueTag);
        CDATASection queueSection = doc.createCDATASection(this.mExecutionQueue);
        queueTag.appendChild(queueSection);
        Element resourceTag = doc.createElement(XML_JobResourceRequirements_Tag);
        job.appendChild(resourceTag);
        CDATASection reqSection = doc.createCDATASection(this.mJobResourceRequirements.toSerializedForm());
        resourceTag.appendChild(reqSection);
        if (this.mRetryCondition != null) {
            Element conditions = doc.createElement("RetryConditions");
            job.appendChild(conditions);
            this.mRetryCondition.serialize(doc, conditions);
        }
    }

    @Override
    public void serialize(Document doc, Node parent) {
        Element jobElement = doc.createElement(XML_Job_Tag);
        parent.appendChild(jobElement);
        this.injectXML(doc, jobElement);
    }

    public static Job createFromXML(BufferedReader xmlReader, ClientLogger logger) throws SchedulerException {
        InputSource source = new InputSource(xmlReader);
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(source);
            NodeList nl = doc.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                Node node = nl.item(i);
                if (!node.getNodeName().equals(XML_Job_Tag)) continue;
                Job job = new Job(logger);
                Job.processJobTag(job, node);
                return job;
            }
        }
        catch (SAXException doc) {
        }
        catch (IOException e) {
            SchedulerException se = new SchedulerException();
            se.initCause((Throwable)e);
            throw se;
        }
        catch (ParserConfigurationException e) {
            SchedulerException se = new SchedulerException();
            se.initCause((Throwable)e);
            throw se;
        }
        catch (FactoryConfigurationError e) {
            SchedulerException se = new SchedulerException();
            se.initCause((Throwable)e);
            throw se;
        }
        return null;
    }

    static void processJobTag(Job job, Node node) {
        Node maxRetriesNode;
        Node captureOutputNode;
        ExecutionItem.processExecutionItemTag(job, node);
        NamedNodeMap attributes = node.getAttributes();
        Node captureErrorNode = attributes.getNamedItem(XML_CaptureError_Tag);
        if (captureErrorNode != null) {
            job.setCaptureErrorStream(Boolean.valueOf(captureErrorNode.getNodeValue()));
        }
        if ((captureOutputNode = attributes.getNamedItem(XML_CaptureOutput_Tag)) != null) {
            job.setCaptureOutputStream(Boolean.valueOf(captureOutputNode.getNodeValue()));
        }
        if ((maxRetriesNode = attributes.getNamedItem("maxRetries")) != null) {
            job.setMaxRetryCount(Integer.valueOf(maxRetriesNode.getNodeValue()));
        }
        NodeList children = node.getChildNodes();
        int listLength = children.getLength();
        for (int i = 0; i < listLength; ++i) {
            String tagValue;
            Node child = children.item(i);
            String tagName = child.getNodeName();
            if (tagName.equals(XML_Command_Tag)) {
                tagValue = ExecutionItem.getCData(child);
                job.setCommand(tagValue);
                continue;
            }
            if (tagName.equals(XML_OSCommand_Tag)) {
                tagValue = ExecutionItem.getCData(child);
                job.setOSCommand(tagValue);
                continue;
            }
            if (tagName.equals(XML_ExecutionQueue_Tag)) {
                tagValue = ExecutionItem.getCData(child);
                job.setExecutionQueue(tagValue);
                continue;
            }
            if (tagName.equals(XML_InputPath_Tag)) {
                tagValue = ExecutionItem.getCData(child);
                job.setInputFilePath(tagValue);
                continue;
            }
            if (tagName.equals(XML_JobResourceRequirements_Tag)) {
                tagValue = ExecutionItem.getCData(child);
                JobResourceRequirements resourceRequirements = JobResourceRequirements.createFromSerializedForm(tagValue);
                job.setJobResourceRequirements(resourceRequirements);
                continue;
            }
            if (!tagName.equals("RetryConditions")) continue;
            RetryCondition condition = RetryCondition.processXML(child, job.getLogger());
            job.setRetryCondition(condition);
        }
    }

    public String getOSCommand() {
        return this.mOSCommand;
    }

    public void setOSCommand(String osCommand) {
        if (osCommand != null) {
            this.mOSCommand = osCommand;
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Defintion of Job: " + this.getName());
        buffer.append('\n');
        buffer.append("Command line: " + this.getCommand());
        buffer.append('\n');
        buffer.append("OS Command line: " + this.getOSCommand());
        buffer.append('\n');
        buffer.append("Max runtime (minutes): " + this.getMaximumRunTime());
        buffer.append('\n');
        buffer.append("User : " + this.getUserName());
        buffer.append('\n');
        buffer.append("Unique Job ID: " + this.getUniqueID());
        buffer.append('\n');
        buffer.append("Execution queue: " + this.getExecutionQueue());
        buffer.append('\n');
        buffer.append(this.getRunConditions().toString());
        buffer.append('\n');
        return buffer.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Job)) {
            return false;
        }
        Job other = (Job)obj;
        if (other.mCaptureErrorStream != this.mCaptureErrorStream) {
            return false;
        }
        if (other.mCaptureOutputStream != this.mCaptureOutputStream) {
            return false;
        }
        if (!other.mCommand.equals(this.mCommand)) {
            return false;
        }
        if (!other.mOSCommand.equals(this.mOSCommand)) {
            return false;
        }
        if (!other.mExecutionQueue.equals(this.mExecutionQueue)) {
            return false;
        }
        if (!other.mInputFilePath.equals(this.mInputFilePath)) {
            return false;
        }
        if (other.mMaxRetryAttempts != this.mMaxRetryAttempts) {
            return false;
        }
        if (!other.mRetryCondition.equals(this.mRetryCondition)) {
            return false;
        }
        if (!other.mJobResourceRequirements.equals(this.mJobResourceRequirements)) {
            return false;
        }
        return super.equals(obj);
    }

    public int getMaxRetryCount() {
        return this.mMaxRetryAttempts;
    }

    public void setMaxRetryCount(int value) {
        if (value < 0) {
            return;
        }
        this.mMaxRetryAttempts = value;
    }

    public void setRetryCondition(RetryCondition conditions) {
        if (conditions != null) {
            this.mRetryCondition = conditions;
        }
    }

    public RetryCondition getRetryCondition() {
        return this.mRetryCondition;
    }
}

