/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.ip.engine;

import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;

public class HistorySearchOptions {
    private Set<String> mFlowIDs = new HashSet<String>();
    private String mOwner = "";
    private int mCompletionStatusMask = 0;
    private Calendar mStartTime = null;
    private Calendar mEndTime = null;
    private int mCountPerFlow = 0;
    private int mMaxCount = 200;
    private static final String Separator = "|";
    private static final String StatusMaskTag = "StatusMask=";
    private static final String MaxCountTag = "MaxResults=";

    public void addFlowID(String flowID) {
        this.mFlowIDs.add(flowID);
    }

    public Set<String> getFlowIDs() {
        return this.mFlowIDs;
    }

    public int getCompletionStatusMask() {
        return this.mCompletionStatusMask;
    }

    public void setCompletionStatusMask(int completionStatusMask) {
        if (completionStatusMask >= 0) {
            this.mCompletionStatusMask = completionStatusMask;
        }
    }

    public Calendar getEndTime() {
        return this.mEndTime;
    }

    public void setEndTime(Calendar endTime) {
        this.mEndTime = endTime;
    }

    public String getOwner() {
        return this.mOwner;
    }

    public void setOwner(String owner) {
        if (owner != null) {
            this.mOwner = owner;
        }
    }

    public Calendar getStartTime() {
        return this.mStartTime;
    }

    public void setStartTime(Calendar startTime) {
        this.mStartTime = startTime;
    }

    public String toSerializedForm() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(StatusMaskTag);
        buffer.append(this.mCompletionStatusMask);
        buffer.append(Separator);
        buffer.append(MaxCountTag);
        buffer.append(Integer.toString(this.mMaxCount));
        buffer.append(Separator);
        return buffer.toString();
    }

    public static HistorySearchOptions createFromSerializedForm(String serializedForm) {
        HistorySearchOptions options = new HistorySearchOptions();
        String statusMask = HistorySearchOptions.GetParameterFromHistoryLine(serializedForm, StatusMaskTag);
        try {
            options.mCompletionStatusMask = Integer.parseInt(statusMask);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        String maxCount = HistorySearchOptions.GetParameterFromHistoryLine(serializedForm, MaxCountTag);
        try {
            options.mMaxCount = Integer.parseInt(maxCount);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return options;
    }

    protected static String GetParameterFromHistoryLine(String historyLine, String parmName) {
        int index = historyLine.indexOf(parmName);
        if (index < 0) {
            return "";
        }
        int separatorIndex = historyLine.indexOf(Separator, index + parmName.length());
        String dataString = historyLine.substring(index + parmName.length(), separatorIndex);
        return dataString;
    }

    public void setCountPerFlow(int count) {
        if (count >= 0) {
            this.mCountPerFlow = count;
        }
    }

    public int getCountPerFlow() {
        return this.mCountPerFlow;
    }

    public int getMaxCount() {
        return this.mMaxCount;
    }

    public void setMaxCount(int maxCount) {
        this.mMaxCount = maxCount;
    }
}

