/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.ip.engine;

import com.sas.scheduler.api.servers.ip.engine.ClientLogger;
import com.sas.scheduler.api.servers.ip.engine.IPersistenceProvider;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

public class FilePersistence
implements IPersistenceProvider {
    private File mRoot;
    private ClientLogger mLogger;
    protected FileLock mVMLock;
    protected FileChannel mLockChannel;
    protected static final String LockFile = ".lock";
    private static volatile boolean mLockedInThisProcess = false;

    public FilePersistence(File root, ClientLogger logger) {
        this.mRoot = root;
        this.mLogger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addData(String baseDir, String fileName, byte[] data) {
        File f = this.mRoot;
        if (baseDir.length() > 0) {
            f = new File(f, baseDir);
        }
        File outputFile = f = new File(f, fileName);
        outputFile.getParentFile().mkdirs();
        FileOutputStream output = null;
        try {
            output = new FileOutputStream(outputFile, true);
            output.write(data);
        }
        catch (FileNotFoundException e) {
            this.mLogger.logMessage(Level.WARNING, e);
        }
        catch (IOException e) {
            this.mLogger.logMessage(Level.WARNING, e);
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException e) {
                    this.mLogger.logMessage(Level.WARNING, e);
                }
            }
        }
    }

    @Override
    public boolean delete(String dir, String fileName) {
        File f = this.mRoot;
        if (dir.length() > 0) {
            f = new File(f, dir);
        }
        if ((f = new File(f, fileName)).exists()) {
            return f.delete();
        }
        return true;
    }

    @Override
    public void deleteDir(String startDir, String subDir) {
        File f = new File(this.mRoot, startDir);
        f = new File(f, subDir);
        this.deleteTree(f);
        f.delete();
    }

    private void deleteTree(File file) {
        if (file.isFile()) {
            file.delete();
            return;
        }
        File[] children = file.listFiles();
        if (children != null) {
            for (File f : children) {
                this.deleteTree(f);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getData(String relativePath, String fileName, long fileIndex, int maxChars, StringBuffer outputBuffer) {
        File f = this.mRoot;
        if (relativePath.length() > 0) {
            f = new File(f, relativePath);
        }
        if (!(f = new File(f, fileName)).exists() || !f.isFile()) {
            return -1;
        }
        BufferedReader br = null;
        try {
            FileInputStream fis = new FileInputStream(f);
            br = new BufferedReader(new InputStreamReader((InputStream)fis, "UTF-8"));
            br.skip(fileIndex);
            CharBuffer target = CharBuffer.allocate(maxChars);
            int charsRead = br.read(target);
            target.flip();
            outputBuffer.append(target.toString());
            int n = charsRead;
            return n;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return -1;
    }

    @Override
    public String getPath() {
        return this.mRoot.getAbsolutePath();
    }

    @Override
    public Reader getReader(String dir, String fileName) {
        File f = this.mRoot;
        if (dir.length() > 0) {
            f = new File(f, dir);
        }
        f = new File(f, fileName);
        return this.getSafeReader(f);
    }

    @Override
    public Writer getWriter(String dir, String fileName, boolean append) {
        File f = this.mRoot;
        if (dir.length() > 0) {
            f = new File(f, dir);
        }
        f = new File(f, fileName);
        return this.getSafeWriter(f, append);
    }

    public Reader getSafeReader(File f) {
        try {
            if (f.exists()) {
                FileInputStream fis = new FileInputStream(f);
                InputStreamReader isr = new InputStreamReader((InputStream)fis, "UTF-8");
                return new BufferedReader(isr);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return null;
    }

    public Writer getSafeWriter(File f, boolean append) {
        f.getParentFile().mkdirs();
        try {
            FileOutputStream fos = new FileOutputStream(f, append);
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)fos, "UTF-8");
            return new BufferedWriter(out);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public List<String> listFiles(String startDir, String subDir, FilenameFilter nameFilter) {
        File f = this.mRoot;
        if (startDir.length() > 0) {
            f = new File(f, startDir);
        }
        if (subDir.length() > 0) {
            f = new File(f, subDir);
        }
        String[] names = f.list(nameFilter);
        ArrayList<String> results = new ArrayList<String>();
        if (names != null) {
            for (String name : names) {
                results.add(name);
            }
        }
        return results;
    }

    @Override
    public boolean rename(String startDir, String fileName, String newFileName) {
        File initialLocation = this.mRoot;
        if (startDir.length() > 0) {
            initialLocation = new File(initialLocation, startDir);
        }
        File initialFile = new File(initialLocation, fileName);
        File targetFile = new File(initialLocation, newFileName);
        return initialFile.renameTo(targetFile);
    }

    @Override
    public void acquireLock() {
        if (this.mVMLock == null && !mLockedInThisProcess) {
            File file = new File(this.mRoot, LockFile);
            file.getParentFile().mkdirs();
            try {
                this.mLockChannel = new RandomAccessFile(file, "rw").getChannel();
                try {
                    this.mVMLock = this.mLockChannel.tryLock();
                    if (this.mVMLock == null) {
                        throw new IllegalArgumentException("Lock file in use by another master server: " + file.getAbsolutePath());
                    }
                    mLockedInThisProcess = true;
                }
                catch (OverlappingFileLockException e) {
                    throw new IllegalArgumentException("Can't acquire lock file on persistence area: " + file.getAbsolutePath());
                }
            }
            catch (Exception e) {
                this.mLogger.logMessage(Level.INFO, e);
                throw new IllegalArgumentException("Can't acquire lock file on persistence area: " + file.getAbsolutePath());
            }
        }
    }

    @Override
    public boolean hasLock() {
        return this.mVMLock != null;
    }

    @Override
    public void releaseLock() {
        try {
            if (this.mVMLock != null) {
                this.mVMLock.release();
                this.mVMLock = null;
                mLockedInThisProcess = false;
            }
            if (this.mLockChannel != null) {
                this.mLockChannel.close();
                this.mLockChannel = null;
            }
        }
        catch (IOException e) {
            this.mLogger.logMessage(Level.WARNING, e);
        }
    }

    @Override
    public boolean isAppendSupported() {
        return true;
    }
}

