/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.ip.engine;

import com.sas.net.crypto.SealedString;
import com.sas.scheduler.api.servers.ip.engine.AbstractUserSession;
import com.sas.scheduler.api.servers.ip.engine.AccessException;
import com.sas.scheduler.api.servers.ip.engine.ClientLogger;
import com.sas.scheduler.api.servers.ip.engine.ClusterSupport;
import com.sas.scheduler.api.servers.ip.engine.ExecutionCallback;
import com.sas.scheduler.api.servers.ip.engine.ExecutionContext;
import com.sas.scheduler.api.servers.ip.engine.ExecutionProvider;
import com.sas.scheduler.api.servers.ip.engine.Flow;
import com.sas.scheduler.api.servers.ip.engine.FlowHistory;
import com.sas.scheduler.api.servers.ip.engine.FlowInstance;
import com.sas.scheduler.api.servers.ip.engine.FlowManager;
import com.sas.scheduler.api.servers.ip.engine.Job;
import com.sas.scheduler.api.servers.ip.engine.JobRendererInfo;
import com.sas.scheduler.api.servers.ip.engine.PersistenceAction;
import com.sas.scheduler.api.servers.ip.engine.PredefinedCalendar;
import com.sas.scheduler.api.servers.ip.engine.RunHistory;
import com.sas.scheduler.api.servers.ip.engine.RunningFlow;
import com.sas.scheduler.api.servers.ip.engine.RunningJob;
import com.sas.scheduler.api.servers.ip.engine.ShutdownException;
import com.sas.scheduler.api.servers.ip.engine.SyncManager;
import com.sas.scheduler.api.servers.ip.engine.TopLevelFlow;
import com.sas.scheduler.api.servers.ip.engine.UserInfo;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;

public abstract class ExecutionProviderBase
implements ExecutionProvider,
ExecutionContext {
    protected long mLastAssignedInstanceID = 0L;
    protected ClientLogger mLogger;
    protected FlowManager mFlowManager;
    protected Map<String, UserInfo> mUserMap;
    protected Map<String, AbstractUserSession> mSessionMap;
    protected Map<String, UserInfo> mSessionUserMap;
    protected Map<String, AbstractUserSession> mUserSessionMap;
    protected ClusterSupport mClusterSupport;
    protected static final String SyncKey_UsedTimesFile = "UsedTimesFile";
    protected static final String SyncKey_InstanceFile = "InstanceDataFile";
    protected BlockingQueue<PersistenceAction> mAsyncQueue;
    protected Thread mAsyncThread;
    protected static final String EQ = "=";

    public ExecutionProviderBase(ClientLogger logger, ClusterSupport clusterSupport) {
        this.mLogger = logger;
        this.mUserMap = new HashMap<String, UserInfo>();
        this.mSessionMap = new HashMap<String, AbstractUserSession>();
        this.mSessionUserMap = new HashMap<String, UserInfo>();
        this.mUserSessionMap = new HashMap<String, AbstractUserSession>();
        this.mClusterSupport = clusterSupport;
        this.mAsyncQueue = new LinkedBlockingQueue<PersistenceAction>();
        this.mAsyncThread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            PersistenceAction nextAction;
                            if ((nextAction = ExecutionProviderBase.this.mAsyncQueue.take()) == null) {
                                continue;
                            }
                            nextAction.execute();
                        }
                    }
                    catch (ShutdownException e) {
                        ExecutionProviderBase.this.mLogger.logMessage(Level.FINE, e.getMessage());
                    }
                    catch (Throwable t) {
                        ExecutionProviderBase.this.mLogger.logMessage(Level.WARNING, t);
                        continue;
                    }
                    break;
                }
            }
        }, "IP - Execution provider async queue");
        this.mAsyncThread.start();
    }

    @Override
    public boolean deleteFlow(TopLevelFlow flow) {
        this.removeFlowHistoryRecords(flow);
        this.removeUsedFlowTimes(flow);
        return true;
    }

    protected Object getGlobalSynchronizationObject() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeFlowHistoryRecords(TopLevelFlow flow) {
        block21: {
            try (BufferedReader reader = null;){
                Reader aReader = this.getFlowHistoryReader(flow);
                List<Object> historyRecords = new ArrayList();
                if (aReader != null) {
                    reader = new BufferedReader(aReader);
                    historyRecords = FlowHistory.GetHistoriesOfFlow(reader, null, 0, this.mLogger);
                    reader.close();
                    reader = null;
                }
                if (historyRecords.size() == 0) {
                    return;
                }
                int i = 0;
                while (i < historyRecords.size()) {
                    FlowHistory record = (FlowHistory)historyRecords.get(i);
                    if (record.getFlowID().equals(flow.getID())) {
                        historyRecords.remove(i);
                        continue;
                    }
                    ++i;
                }
                if (historyRecords.size() == 0) {
                    this.deleteFlowHistoryStore(flow);
                    break block21;
                }
                try (BufferedWriter writer = null;){
                    Writer aWriter = this.getFlowHistoryWriter(flow);
                    if (aWriter != null) {
                        writer = new BufferedWriter(aWriter);
                        for (FlowHistory flowHistory : historyRecords) {
                            String historyString = flowHistory.toSerializedForm();
                            writer.write(historyString);
                        }
                    } else {
                        this.getClientLog().logMessage(Level.WARNING, FlowManager.generateLogString("Add History", flow, "Unable to create history writer for flow."));
                    }
                }
            }
            catch (IOException e) {
                this.mLogger.logMessage(Level.WARNING, e);
            }
        }
    }

    public boolean canAcceptJob(RunningJob rj) {
        return true;
    }

    @Override
    public ExecutionContext assignExecutionContext(RunningJob rj) {
        if (this.isJobDirectClusteringServer()) {
            return this.mClusterSupport.assignExecutionContext(rj);
        }
        if (this.canAcceptJob(rj)) {
            return this;
        }
        return null;
    }

    @Override
    public final boolean execute(Job j, String flowID, String flowInstanceID, String jobInstanceCode, UserInfo userInfo) {
        return this.executeJob(j, new ExecutionCallback(this, flowID, flowInstanceID, jobInstanceCode), userInfo);
    }

    public abstract boolean executeJob(Job var1, ExecutionCallback var2, UserInfo var3);

    @Override
    public List<TopLevelFlow> getPersistedFlows() {
        return Collections.emptyList();
    }

    protected void deleteFlowHistoryStore(TopLevelFlow flow) {
        throw new UnsupportedOperationException();
    }

    protected Reader getFlowHistoryReader(TopLevelFlow flow) {
        throw new UnsupportedOperationException();
    }

    protected Writer getFlowHistoryWriter(TopLevelFlow flow) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FlowHistory> getFlowHistory(Map<TopLevelFlow, Integer> historyRequestMap, UserInfo userInfo) {
        ArrayList<FlowHistory> results = new ArrayList<FlowHistory>();
        try {
            for (Map.Entry<TopLevelFlow, Integer> entry : historyRequestMap.entrySet()) {
                int count;
                TopLevelFlow flow = entry.getKey();
                int workingCount = count = entry.getValue().intValue();
                Object sync = SyncManager.getInstance().getSyncObject(flow.getID());
                try {
                    Object object = sync;
                    synchronized (object) {
                        Reader aReader = this.getFlowHistoryReader(flow);
                        if (aReader != null) {
                            BufferedReader reader = new BufferedReader(aReader);
                            try {
                                List<FlowHistory> tempResultHistories = FlowHistory.GetHistoriesOfFlow(reader, flow.getID(), 0, this.mLogger);
                                Iterator<FlowHistory> iterator = tempResultHistories.iterator();
                                while (iterator.hasNext()) {
                                    if (count > 0 && workingCount <= 0) {
                                    }
                                    FlowHistory history = iterator.next();
                                    if (!FlowManager.canSeeHistoryRecord(userInfo, history)) continue;
                                    results.add(history);
                                    --workingCount;
                                }
                            }
                            catch (Exception e) {
                                this.mLogger.logMessage(Level.WARNING, e);
                            }
                            finally {
                                try {
                                    reader.close();
                                }
                                catch (IOException e) {
                                    this.mLogger.logMessage(Level.WARNING, e);
                                }
                            }
                        } else {
                            this.mLogger.logMessage(Level.FINE, FlowManager.generateLogString("Get History", flow, "No reader found for flow."));
                        }
                    }
                }
                finally {
                    SyncManager.getInstance().releaseSyncObject(flow.getID());
                }
            }
        }
        catch (Exception e) {
            this.mLogger.logMessage(Level.WARNING, e);
        }
        return results;
    }

    @Override
    public FlowInstance getFlowInstance(String flowInstanceID) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getNewFlowInstanceID(Flow flow) {
        Object object = this.getGlobalSynchronizationObject();
        synchronized (object) {
            long newInstanceID = System.currentTimeMillis();
            if (newInstanceID <= this.mLastAssignedInstanceID) {
                newInstanceID = this.mLastAssignedInstanceID + 1L;
            }
            this.mLastAssignedInstanceID = newInstanceID;
            return new Long(this.mLastAssignedInstanceID).toString();
        }
    }

    @Override
    public String getNextCalendarID() {
        return null;
    }

    @Override
    public List<PredefinedCalendar> getPredefinedCalendars() {
        return Collections.emptyList();
    }

    public abstract void killJob(String var1);

    @Override
    public void killJob(String rendevousID, boolean force) {
        this.killJob(rendevousID);
    }

    @Override
    public void clusterKillJob(RunningJob rj, boolean force) {
        if (this.isJobDirectClusteringServer()) {
            this.mClusterSupport.killJob(rj, force);
        } else {
            this.killJob(rj.getUniqueInstanceID(), force);
        }
    }

    @Override
    public void saveUsedTimes(String flowID, Map<String, Long> usedTimes) {
        this.saveUsedTimesImpl(flowID, usedTimes);
    }

    protected String writeUsedTimesRecord(String flowID, Map<String, Long> usedTimes) {
        return RunHistory.getEscapedString(flowID) + RunHistory.HistorySeparator + this.persistUsedTimeMap(usedTimes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void saveUsedTimesImpl(String flowID, Map<String, Long> usedTimes) {
        block20: {
            Object o = SyncManager.getInstance().getSyncObject(SyncKey_UsedTimesFile);
            try {
                Object object = o;
                // MONITORENTER : object
                Writer writer = this.getUsedTimesWriter(true);
                if (writer != null) {
                    BufferedWriter bw = new BufferedWriter(writer);
                    try {
                        bw.write(this.writeUsedTimesRecord(flowID, usedTimes));
                        bw.newLine();
                    }
                    catch (Exception e) {
                        this.getFlowManager().getLogger().logMessage(Level.WARNING, e);
                    }
                    finally {
                        try {
                            bw.close();
                        }
                        catch (IOException e) {
                            this.getFlowManager().getLogger().logMessage(Level.WARNING, e);
                        }
                    }
                    // MONITOREXIT : object
                    SyncManager.getInstance().releaseSyncObject(SyncKey_UsedTimesFile);
                    return;
                }
                if (!this.isClusteringServer()) break block20;
                this.getClusteringServer().saveUsedTimesImpl(flowID, usedTimes);
            }
            catch (Throwable throwable) {
                SyncManager.getInstance().releaseSyncObject(SyncKey_UsedTimesFile);
                throw throwable;
            }
            SyncManager.getInstance().releaseSyncObject(SyncKey_UsedTimesFile);
            return;
        }
        SyncManager.getInstance().releaseSyncObject(SyncKey_UsedTimesFile);
    }

    protected Writer getUsedTimesWriter(boolean append) {
        return null;
    }

    protected Reader getUsedTimesReader() {
        return null;
    }

    protected String persistUsedTimeMap(Map<String, Long> usedTimes) {
        StringBuffer buffer = new StringBuffer();
        for (Map.Entry<String, Long> entry : usedTimes.entrySet()) {
            buffer.append(entry.getKey());
            buffer.append(EQ);
            buffer.append(entry.getValue().toString());
            buffer.append(RunHistory.HistorySeparator);
        }
        return buffer.toString();
    }

    protected void removeUsedFlowTimes(TopLevelFlow flow) {
        this.saveUsedTimes(flow.getID(), new HashMap<String, Long>());
    }

    protected Map<String, Long> restoreUsedTimeMap(String timeData) {
        String[] conditions;
        HashMap<String, Long> condMap = new HashMap<String, Long>();
        if (timeData.length() == 0) {
            return condMap;
        }
        for (String condString : conditions = timeData.split("\\" + RunHistory.HistorySeparator)) {
            String[] parts = condString.split(EQ);
            if (parts.length == 2) {
                try {
                    condMap.put(parts[0], Long.valueOf(parts[1]));
                }
                catch (Exception e) {
                    this.getFlowManager().getLogger().logMessage(Level.WARNING, e);
                }
                continue;
            }
            this.getFlowManager().getLogger().logMessage(Level.WARNING, "Error parsing used time string to restore trigger info: '" + condString + "'");
        }
        return condMap;
    }

    @Override
    public void performOnTheFlyPersistedDataCleanup() {
        this.mAsyncQueue.add(new MaintenanceAction(this));
    }

    @Override
    public void performDataCleanup() {
        MaintenanceAction mntAct = new MaintenanceAction(this);
        mntAct.execute();
    }

    @Override
    public Map<String, Map<String, Long>> getUsedTimes() {
        return this.getUsedTimesImpl();
    }

    public boolean isUsingJournaling() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, Map<String, Long>> getUsedTimesImpl() {
        o = SyncManager.getInstance().getSyncObject("UsedTimesFile");
        var2_2 = o;
        synchronized (var2_2) {
            startTime = System.currentTimeMillis();
            this.mLogger.logMessage(Level.INFO, "Retrieving/compacting used time data (Start)");
            linesProcessed = 0;
            try {
                reader = this.getUsedTimesReader();
                if (reader != null) {
                    result = new HashMap<String, Map<String, Long>>();
                    br = new BufferedReader(reader);
                    try {
                        while ((line = br.readLine()) != null) {
                            sep = line.indexOf(RunHistory.HistorySeparator);
                            if (sep < 0) continue;
                            ++linesProcessed;
                            flowID = RunHistory.getUnescapedString(line.substring(0, sep));
                            result.remove(flowID);
                            var12_25 = this.restoreUsedTimeMap(line.substring(sep + 1));
                            if (var12_25.size() <= 0) continue;
                            result.put(flowID, var12_25);
                        }
                    }
                    catch (Exception e) {
                        this.getFlowManager().getLogger().logMessage(Level.WARNING, e);
                    }
                    finally {
                        try {
                            br.close();
                        }
                        catch (IOException e) {
                            this.getFlowManager().getLogger().logMessage(Level.WARNING, e);
                        }
                    }
                    writer = this.getUsedTimesWriter(false);
                    if (writer != null) {
                        bw = new BufferedWriter(writer);
                        try {
                            for (Map.Entry var12_27 : result.entrySet()) {
                                bw.write(this.writeUsedTimesRecord((String)var12_27.getKey(), (Map)var12_27.getValue()));
                                bw.newLine();
                            }
                        }
                        catch (Exception e) {
                            this.getFlowManager().getLogger().logMessage(Level.WARNING, e);
                        }
                        finally {
                            try {
                                bw.close();
                            }
                            catch (IOException e) {
                                this.getFlowManager().getLogger().logMessage(Level.WARNING, e);
                            }
                        }
                    }
                    var10_19 = result;
                    // MONITOREXIT @DISABLED, blocks:[0, 18, 2, 39] lbl59 : MonitorExitStatement: MONITOREXIT : var2_2
                    SyncManager.getInstance().releaseSyncObject("UsedTimesFile");
                    return var10_19;
                }
                if (!this.isClusteringServer()) ** break block42
                var7_10 = this.getClusteringServer().getUsedTimesImpl();
            }
            catch (Exception e) {
                this.getFlowManager().getLogger().logMessage(Level.WARNING, e);
                break block44;
            }
            finally {
                endTime = System.currentTimeMillis();
                this.mLogger.logMessage(Level.INFO, "Retrieving/compacting used time list (End).  Time (ms): " + (endTime - startTime) + " Lines processed=" + linesProcessed);
            }
        }
        SyncManager.getInstance().releaseSyncObject("UsedTimesFile");
        return var7_10;
        {
            block44: {
                ** try [egrp 15[TRYBLOCK] [26 : 634->829)] { 
lbl79:
                // 1 sources

                endTime = System.currentTimeMillis();
                this.mLogger.logMessage(Level.INFO, "Retrieving/compacting used time list (End).  Time (ms): " + (endTime - startTime) + " Lines processed=" + linesProcessed);
            }
            return new HashMap<String, Map<String, Long>>();
lbl83:
            // 1 sources

            finally {
                SyncManager.getInstance().releaseSyncObject("UsedTimesFile");
            }
        }
    }

    @Override
    public boolean saveFlowDefinition(TopLevelFlow newFlow) {
        return true;
    }

    protected void removeDeadFlowPersistence(Set<String> validFlowIDs) {
    }

    protected void updatePersistedFlowDefinitions(List<TopLevelFlow> allFlows) {
    }

    protected void updateUsedTimes(Map<String, Map<String, Long>> usedTimes) {
        this.getUsedTimes();
    }

    protected void updateRunningFlowInstances(Collection<FlowInstance> flowInstances) {
        this.getRunningFlowInstances();
    }

    protected void miscellanousMaintenance() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addFlowHistoryItem(TopLevelFlow flow, FlowHistory history) {
        long startTime = System.currentTimeMillis();
        try (BufferedReader reader = null;){
            Reader aReader = this.getFlowHistoryReader(flow);
            List<Object> historyRecords = new ArrayList<FlowHistory>();
            if (aReader != null) {
                reader = new BufferedReader(aReader);
                historyRecords = FlowHistory.GetHistoriesOfFlow(reader, null, 0, this.mLogger);
                reader.close();
                reader = null;
            }
            historyRecords.add(0, history);
            HashSet instanceSet = new HashSet();
            int count = 0;
            int i = 0;
            while (i < historyRecords.size()) {
                FlowHistory record = (FlowHistory)historyRecords.get(i);
                if (instanceSet.contains(record.getID())) {
                    this.mLogger.logMessage(Level.FINE, "Duplicate history record found");
                }
                if (record.getFlowID().equals(history.getFlowID()) && ++count > this.getMaxHistoriesPerFlow()) {
                    historyRecords.remove(i);
                    final FlowHistory finalHistory = record;
                    this.addToAsyncQueue(new PersistenceAction(this){

                        @Override
                        public void execute() throws ShutdownException {
                            ExecutionProviderBase.this.removeOtherHistoryData(finalHistory);
                        }
                    });
                    continue;
                }
                ++i;
            }
            try (BufferedWriter writer = null;){
                Writer aWriter = this.getFlowHistoryWriter(flow);
                if (aWriter != null) {
                    writer = new BufferedWriter(aWriter);
                    for (FlowHistory flowHistory : historyRecords) {
                        String historyString = flowHistory.toSerializedForm();
                        writer.write(historyString);
                    }
                } else {
                    this.getClientLog().logMessage(Level.WARNING, FlowManager.generateLogString("Add History", flow, "Unable to create history writer for flow."));
                }
            }
        }
        catch (Exception e) {
            this.mLogger.logMessage(Level.WARNING, e);
        }
        long endTime = System.currentTimeMillis();
        this.mLogger.logMessage(Level.FINER, "Adding flow history record for: " + flow.getID() + " (" + (endTime - startTime) + "ms)");
    }

    protected void removeOtherHistoryData(FlowHistory history) {
    }

    @Override
    public void saveFlowInstance(FlowInstance instance) {
    }

    @Override
    public void saveCalendar(PredefinedCalendar newSchedule) {
    }

    @Override
    public void removeRunningFlowInstance(String flowInstanceID) {
        this.saveRunningFlowInstanceHelper(null, flowInstanceID);
    }

    @Override
    public FlowInstance[] getRunningFlowInstances() {
        return this.getRunningFlowInstances(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FlowInstance[] getRunningFlowInstances(boolean returnValues) {
        Object o = SyncManager.getInstance().getSyncObject(SyncKey_InstanceFile);
        try {
            Object object = o;
            synchronized (object) {
                long startTime = System.currentTimeMillis();
                this.mLogger.logMessage(Level.INFO, "Retrieving/compacting running flow instance data (Start)");
                int linesProcessed = 0;
                try {
                    Reader reader = this.getRunningFlowInstanceReader();
                    if (reader == null) return new FlowInstance[0];
                    HashMap<String, String> temp = new HashMap<String, String>();
                    BufferedReader br = new BufferedReader(reader);
                    try {
                        String line;
                        while ((line = br.readLine()) != null) {
                            int sep = line.indexOf(RunHistory.HistorySeparator);
                            if (sep < 0) continue;
                            ++linesProcessed;
                            String instanceID = RunHistory.getUnescapedString(line.substring(0, sep));
                            temp.remove(instanceID);
                            String restOfData = line.substring(sep + 1).trim();
                            if (restOfData.length() <= 0) continue;
                            temp.put(instanceID, restOfData);
                        }
                    }
                    catch (Exception e) {
                        this.getFlowManager().getLogger().logMessage(Level.WARNING, e);
                    }
                    finally {
                        try {
                            br.close();
                        }
                        catch (IOException e) {
                            this.getFlowManager().getLogger().logMessage(Level.WARNING, e);
                        }
                    }
                    Writer writer = this.getRunningFlowInstanceWriter(false);
                    if (writer == null) return new FlowInstance[0];
                    ArrayList<FlowInstance> result = new ArrayList<FlowInstance>();
                    BufferedWriter bw = new BufferedWriter(writer);
                    try {
                        for (String instanceData : temp.values()) {
                            try {
                                FlowInstance flowInstance = FlowInstance.createFromXML(new BufferedReader(new StringReader(FlowInstance.getUnescapeData(instanceData))), this.getFlowManager().getLogger());
                                if (flowInstance == null) continue;
                                if (flowInstance.getFlow() instanceof TopLevelFlow && ((TopLevelFlow)flowInstance.getFlow()).getID().isEmpty()) {
                                    this.mLogger.logMessage(Level.FINE, "Reading in flow instance without Flow ID; discarding");
                                    continue;
                                }
                                bw.write(RunHistory.getEscapedString(flowInstance.getFlowHistory().getID()) + RunHistory.HistorySeparator + instanceData);
                                bw.newLine();
                                result.add(flowInstance);
                            }
                            catch (Exception e) {
                                this.getFlowManager().getLogger().logMessage(Level.WARNING, e);
                            }
                        }
                    }
                    catch (Exception e) {
                        this.getFlowManager().getLogger().logMessage(Level.WARNING, e);
                    }
                    finally {
                        try {
                            bw.close();
                        }
                        catch (IOException e) {
                            this.getFlowManager().getLogger().logMessage(Level.WARNING, e);
                        }
                    }
                    FlowInstance[] flowInstanceArray = result.toArray(new FlowInstance[0]);
                    return flowInstanceArray;
                }
                catch (Exception e) {
                    this.getFlowManager().getLogger().logMessage(Level.WARNING, e);
                }
                finally {
                    long endTime = System.currentTimeMillis();
                    this.mLogger.logMessage(Level.INFO, "Retrieving/compacting running flow instance data (End).  Time (ms): " + (endTime - startTime) + " Data lines=" + linesProcessed);
                }
                return new FlowInstance[0];
            }
        }
        finally {
            SyncManager.getInstance().releaseSyncObject(SyncKey_InstanceFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveRunningFlowInstanceHelper(FlowInstance flowInstance, String instanceID) {
        Object o = SyncManager.getInstance().getSyncObject(SyncKey_InstanceFile);
        try {
            Object object = o;
            synchronized (object) {
                Writer writer = this.getRunningFlowInstanceWriter(true);
                if (writer != null) {
                    BufferedWriter bw = new BufferedWriter(writer);
                    try {
                        String itemInstanceID = null;
                        itemInstanceID = instanceID != null ? instanceID : flowInstance.getFlowHistory().getID();
                        String instanceData = "";
                        if (flowInstance != null) {
                            instanceData = flowInstance.toSerializedForm();
                            instanceData = FlowInstance.getEscapedData(instanceData);
                        }
                        bw.write(RunHistory.getEscapedString(itemInstanceID) + RunHistory.HistorySeparator + instanceData);
                        bw.newLine();
                    }
                    catch (Exception e) {
                        this.getFlowManager().getLogger().logMessage(Level.WARNING, e);
                    }
                    finally {
                        try {
                            bw.close();
                        }
                        catch (IOException e) {
                            this.getFlowManager().getLogger().logMessage(Level.WARNING, e);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            this.getFlowManager().getLogger().logMessage(Level.WARNING, e);
        }
        finally {
            SyncManager.getInstance().releaseSyncObject(SyncKey_InstanceFile);
        }
    }

    @Override
    public void saveRunningFlowInstance(FlowInstance flowInstance) {
        this.saveRunningFlowInstanceHelper(flowInstance, null);
    }

    protected Writer getRunningFlowInstanceWriter(boolean append) {
        return null;
    }

    protected Reader getRunningFlowInstanceReader() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String createNewSessionID() {
        Object object = this.getGlobalSynchronizationObject();
        synchronized (object) {
            SecureRandom ranGen;
            double randomNum;
            String sessionID = null;
            while (this.mSessionMap.get(sessionID = Double.toString(randomNum = (ranGen = new SecureRandom()).nextDouble())) != null) {
            }
            return sessionID;
        }
    }

    @Deprecated
    protected boolean validateUser(String userID, String password) {
        return this.validateUserSealedString(userID, password != null ? new SealedString(password) : null);
    }

    protected boolean validateUserSealedString(String userID, SealedString password) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserInfo getUserForSession(FlowManager manager, String sessionID) {
        Object object = this.getGlobalSynchronizationObject();
        synchronized (object) {
            AbstractUserSession session = this.mSessionMap.get(sessionID);
            if (session == null) {
                this.mLogger.logMessage(Level.WARNING, FlowManager.generateLogString("Validate Session", "Invalid session ID:" + sessionID + " ; Access rejected"));
                throw new AccessException("Invalid session");
            }
            UserInfo userInfo = this.mSessionUserMap.get(session.getID());
            if (userInfo == null) {
                this.mLogger.logMessage(Level.WARNING, FlowManager.generateLogString("Validate User Session", "Good session ID, but no associated user.  Unknown state."));
                throw new AccessException("No user for session");
            }
            session.updateUsedTime();
            return userInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserInfo getUserInfoForID(String userID) {
        Object object = this.getGlobalSynchronizationObject();
        synchronized (object) {
            return this.mUserMap.get(userID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetUserAndSessionMaps(Map<String, UserInfo> userMap, Map<String, AbstractUserSession> sessionMap) {
        Object object = this.getGlobalSynchronizationObject();
        synchronized (object) {
            this.mUserMap.clear();
            this.mSessionMap.clear();
            this.mUserSessionMap.clear();
            this.mSessionUserMap.clear();
            for (UserInfo userInfo : userMap.values()) {
                this.mUserMap.put(userInfo.getUserID(), userInfo);
            }
            for (AbstractUserSession session : sessionMap.values()) {
                this.mSessionMap.put(session.getSessionID(), session);
                if (this.limitToOneSessionPerUser()) {
                    this.mUserSessionMap.put(session.getUserID(), session);
                }
                UserInfo user = this.mUserMap.get(session.getUserID());
                this.mSessionUserMap.put(session.getSessionID(), user);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AbstractUserSession createSession(FlowManager manager, UserInfo user) {
        Object object = this.getGlobalSynchronizationObject();
        synchronized (object) {
            AbstractUserSession session;
            boolean onePerUser = false;
            if (this.limitToOneSessionPerUser()) {
                onePerUser = true;
                AbstractUserSession existingSession = this.mUserSessionMap.get(user.getUserID());
                if (existingSession != null) {
                    return existingSession;
                }
            }
            if ((session = this.createNewSession(manager, user)) == null) {
                this.mLogger.logMessage(Level.WARNING, FlowManager.generateLogString("Create Session", "User failed to create session: " + user.getUserID()));
                return null;
            }
            this.mSessionUserMap.put(session.getSessionID(), user);
            this.mSessionMap.put(session.getSessionID(), session);
            if (onePerUser) {
                this.mUserSessionMap.put(user.getUserID(), session);
            }
            if (this.isClusteringServer()) {
                this.mClusterSupport.persistSessionHook(user, session);
            }
            this.mLogger.logMessage(Level.INFO, FlowManager.generateLogString("Create Session", "User logged on: " + user.getUserID()));
            return session;
        }
    }

    protected boolean limitToOneSessionPerUser() {
        return true;
    }

    protected abstract AbstractUserSession createNewSession(FlowManager var1, UserInfo var2);

    protected boolean canRemoveSession(AbstractUserSession session) {
        return !this.limitToOneSessionPerUser();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean terminateSession(FlowManager manager, String sessionID) {
        Object object = this.getGlobalSynchronizationObject();
        synchronized (object) {
            AbstractUserSession session = this.mSessionMap.get(sessionID);
            if (session != null) {
                if (!this.canRemoveSession(session)) {
                    return true;
                }
                this.mSessionMap.remove(sessionID);
                UserInfo info = this.mSessionUserMap.get(sessionID);
                if (info != null) {
                    this.mSessionUserMap.remove(sessionID);
                    boolean stillInUse = false;
                    for (UserInfo userInfo : this.mSessionUserMap.values()) {
                        if (!userInfo.getUserID().equals(info.getUserID())) continue;
                        stillInUse = true;
                    }
                    if (!stillInUse) {
                        this.notifyUnusedUser(info);
                    }
                    this.mLogger.logMessage(Level.INFO, FlowManager.generateLogString("Terminate Session", "User logged off: " + sessionID + ":" + info.getUserID()));
                    return true;
                }
                this.mLogger.logMessage(Level.WARNING, FlowManager.generateLogString("Terminate Session", "Missing User info for session: " + sessionID));
            }
            return false;
        }
    }

    @Override
    @Deprecated
    public UserInfo getUser(String userID, String password) {
        return this.getUserSealedString(userID, password != null ? new SealedString(password) : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserInfo getUserSealedString(String userID, SealedString password) {
        Object object = this.getGlobalSynchronizationObject();
        synchronized (object) {
            String canonicalUserID = this.getCanonicalUserID(userID);
            UserInfo info = this.mUserMap.get(canonicalUserID);
            if (info != null) {
                return info;
            }
            boolean validated = this.validateUserSealedString(canonicalUserID, password);
            if (!validated) {
                return null;
            }
            boolean isAdministrator = this.isUserIDAdministrator(canonicalUserID);
            info = new UserInfo(canonicalUserID, password, isAdministrator);
            this.mUserMap.put(canonicalUserID, info);
            return info;
        }
    }

    protected boolean isUserIDAdministrator(String canonicalUserID) {
        return false;
    }

    @Override
    public String getCanonicalUserID(String userID) {
        return userID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyUnusedUser(UserInfo info) {
        Object object = this.getGlobalSynchronizationObject();
        synchronized (object) {
            this.mUserMap.remove(info.getUserID());
        }
    }

    public ClientLogger getClientLog() {
        return this.mLogger;
    }

    @Override
    public int getMaxRunningFlowLimit() {
        return 0;
    }

    @Override
    public long getFileTriggerPeriod() {
        return 81000L;
    }

    @Override
    public long getFileConditionPeriod() {
        return 30000L;
    }

    protected int getMaxHistoriesPerFlow() {
        return 5;
    }

    @Override
    public int getMaxHistoryRecordsPerFlow() {
        return this.getMaxHistoriesPerFlow();
    }

    @Override
    public boolean isClusteringServer() {
        return this.mClusterSupport != null;
    }

    public boolean isJobDirectClusteringServer() {
        return this.isClusteringServer();
    }

    @Override
    public boolean doJobsRunSeparately() {
        return false;
    }

    @Override
    public void setFlowManager(FlowManager manager) {
        this.mFlowManager = manager;
        if (this.mClusterSupport != null) {
            this.mClusterSupport.setManager(this.mFlowManager);
        }
    }

    @Override
    public FlowManager getFlowManager() {
        return this.mFlowManager;
    }

    @Override
    public ClusterSupport getClusteringServer() {
        return this.mClusterSupport;
    }

    @Override
    public boolean isMaster() {
        return !this.isClusteringServer() || this.mClusterSupport.isMasterServer();
    }

    @Override
    public String getWorkerNodePrintString() {
        return "Main server";
    }

    @Override
    public void restoreRunningJobState(List<RunningFlow> runningFlows) {
    }

    @Override
    public void shutdown(long timeout) {
        this.addToAsyncQueue(new ShutdownAction(this));
    }

    @Override
    public int getErrorStreamData(String flowID, String instanceID, String uniqueSubitemID, long startPos, int maxCharacters, StringBuffer buffer) {
        return -1;
    }

    @Override
    public int getOutputStreamData(String flowID, String instanceID, String uniqueSubitemID, long startPos, int maxCharacters, StringBuffer buffer) {
        return -1;
    }

    public Map<String, Long> getRendererAvailability() {
        return new HashMap<String, Long>();
    }

    @Override
    public Collection<JobRendererInfo> getJobRendererSnapshots() {
        return new ArrayList<JobRendererInfo>();
    }

    @Override
    public void loseMastership() {
    }

    @Override
    public void assumeMastership() {
        this.mLastAssignedInstanceID = 0L;
    }

    @Override
    public boolean isFullPersistenceRequired() {
        return false;
    }

    @Override
    public String getJobRoutingRulesXML() {
        return "";
    }

    @Override
    public boolean setJobRoutingRulesXML(String xml) {
        return false;
    }

    @Override
    public void addToAsyncQueue(PersistenceAction action) {
        try {
            this.mAsyncQueue.put(action);
        }
        catch (InterruptedException e) {
            this.mLogger.logMessage(Level.INFO, e);
        }
    }

    @Override
    public void addFlowHistoryItemAsync(TopLevelFlow flow, FlowHistory history) {
        this.addToAsyncQueue(new HistorySaveAction(this, flow, history));
    }

    @Override
    public boolean saveFlowDefinitionAsync(TopLevelFlow newFlow) {
        this.addToAsyncQueue(new FlowSaveAction(this, newFlow));
        return true;
    }

    @Override
    public void saveCalendarAsync(PredefinedCalendar newSchedule) {
        this.addToAsyncQueue(new CalendarSaveAction(this, newSchedule));
    }

    @Override
    public boolean deleteFlowAsync(TopLevelFlow flow) {
        this.addToAsyncQueue(new FlowDeleteAction(this, flow));
        return true;
    }

    @Override
    public void saveFlowInstanceAsync(FlowInstance instance) {
        this.addToAsyncQueue(new FlowInstanceSaveAction(this, instance));
    }

    @Override
    public void saveRunningFlowInstanceAsync(FlowInstance flowInstance) {
        this.addToAsyncQueue(new RunningFlowInstanceSaveAction(this, flowInstance));
    }

    @Override
    public void removeRunningFlowInstanceAsync(String flowInstanceID) {
        this.addToAsyncQueue(new RunningFlowInstanceDeleteAction(this, flowInstanceID));
    }

    @Override
    public void saveUsedTimesAsync(String flowID, Map<String, Long> usedTimes) {
        this.addToAsyncQueue(new UsedTimesSaveAction(this, flowID, usedTimes));
    }

    static class MaintenanceAction
    extends PersistenceAction {
        public MaintenanceAction(ExecutionProvider provider) {
            super(provider);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute() throws ShutdownException {
            this.mProvider.getFlowManager().getLogger().logMessage(Level.FINE, "Performing disk maintenance (Start)");
            long time = System.currentTimeMillis();
            Map<String, Map<String, Long>> usedTimeMap = null;
            ArrayList<FlowInstance> instances = null;
            ArrayList<TopLevelFlow> allFlows = null;
            HashSet<String> validFlowIDs = null;
            FlowManager flowManager = this.mProvider.getFlowManager();
            synchronized (flowManager) {
                if (this.mProvider.getFlowManager().isUsedTimesDirty()) {
                    usedTimeMap = this.mProvider.getFlowManager().getUseTimeTriggermap();
                    this.mProvider.getFlowManager().setUseTimesDirty(false);
                }
                if (this.mProvider.getFlowManager().isRunningFlowsDirty()) {
                    Collection<RunningFlow> rFlows = this.mProvider.getFlowManager().getLiveRunningFlows();
                    instances = new ArrayList<FlowInstance>();
                    for (RunningFlow runningFlow : rFlows) {
                        FlowInstance flowInstance = new FlowInstance(runningFlow.getFlow(), new FlowHistory(runningFlow, this.mProvider.getFlowManager().getLogger()));
                        instances.add(flowInstance);
                    }
                    this.mProvider.getFlowManager().setRunningFlowsDirty(false);
                }
                if (this.mProvider.getFlowManager().isAllFlowDefsDirty()) {
                    allFlows = new ArrayList<TopLevelFlow>();
                    validFlowIDs = new HashSet<String>();
                    for (TopLevelFlow flow : this.mProvider.getFlowManager().getAllFlows()) {
                        allFlows.add((TopLevelFlow)flow.copy(true));
                        validFlowIDs.add(flow.getID());
                    }
                    this.mProvider.getFlowManager().setAllFlowDefsDirty(false);
                }
            }
            if (usedTimeMap != null) {
                ((ExecutionProviderBase)this.mProvider).updateUsedTimes(usedTimeMap);
            } else {
                this.mProvider.getFlowManager().getLogger().logMessage(Level.FINE, "Skipping persistence of used times; no changes");
            }
            if (instances != null) {
                ((ExecutionProviderBase)this.mProvider).updateRunningFlowInstances(instances);
            } else {
                this.mProvider.getFlowManager().getLogger().logMessage(Level.FINE, "Skipping persistence of running flow information; no changes");
            }
            if (allFlows != null) {
                ((ExecutionProviderBase)this.mProvider).updatePersistedFlowDefinitions(allFlows);
            } else {
                this.mProvider.getFlowManager().getLogger().logMessage(Level.FINE, "Skipping persistence of flow definitions; no changes");
            }
            if (validFlowIDs != null) {
                ((ExecutionProviderBase)this.mProvider).removeDeadFlowPersistence(validFlowIDs);
            } else {
                this.mProvider.getFlowManager().getLogger().logMessage(Level.FINE, "Skipping removal of files associated with deleted flows; no changes");
            }
            ((ExecutionProviderBase)this.mProvider).miscellanousMaintenance();
            this.mProvider.getFlowManager().getLogger().logMessage(Level.FINE, "Performing disk maintenance (End).  Time elapsed: " + (System.currentTimeMillis() - time) + "ms");
        }
    }

    static class ShutdownAction
    extends PersistenceAction {
        public ShutdownAction(ExecutionProvider provider) {
            super(provider);
        }

        @Override
        public void execute() throws ShutdownException {
            throw new ShutdownException("Normal shutdown of async write queue");
        }
    }

    static class HistorySaveAction
    extends PersistenceAction {
        private TopLevelFlow mFlow;
        private FlowHistory mHistory;

        public HistorySaveAction(ExecutionProvider provider, TopLevelFlow flow, FlowHistory history) {
            super(provider);
            this.mFlow = flow;
            this.mHistory = history;
        }

        @Override
        public void execute() throws ShutdownException {
            this.mProvider.addFlowHistoryItem(this.mFlow, this.mHistory);
        }
    }

    static class FlowSaveAction
    extends PersistenceAction {
        private TopLevelFlow mFlow;

        public FlowSaveAction(ExecutionProvider provider, TopLevelFlow flow) {
            super(provider);
            this.mFlow = flow;
        }

        @Override
        public void execute() throws ShutdownException {
            this.mProvider.saveFlowDefinition(this.mFlow);
        }
    }

    static class CalendarSaveAction
    extends PersistenceAction {
        private PredefinedCalendar mCalendar;

        public CalendarSaveAction(ExecutionProvider provider, PredefinedCalendar cal) {
            super(provider);
            this.mCalendar = cal;
        }

        @Override
        public void execute() throws ShutdownException {
            this.mProvider.saveCalendar(this.mCalendar);
        }
    }

    static class FlowDeleteAction
    extends PersistenceAction {
        private TopLevelFlow mFlow;

        public FlowDeleteAction(ExecutionProvider provider, TopLevelFlow flow) {
            super(provider);
            this.mFlow = flow;
        }

        @Override
        public void execute() throws ShutdownException {
            this.mProvider.deleteFlow(this.mFlow);
        }
    }

    static class FlowInstanceSaveAction
    extends PersistenceAction {
        private FlowInstance mInstance;

        public FlowInstanceSaveAction(ExecutionProvider provider, FlowInstance instance) {
            super(provider);
            this.mInstance = instance;
        }

        @Override
        public void execute() throws ShutdownException {
            this.mProvider.saveFlowInstance(this.mInstance);
        }
    }

    static class RunningFlowInstanceSaveAction
    extends PersistenceAction {
        private FlowInstance mInstance;

        public RunningFlowInstanceSaveAction(ExecutionProvider provider, FlowInstance instance) {
            super(provider);
            this.mInstance = instance;
        }

        @Override
        public void execute() throws ShutdownException {
            this.mProvider.saveRunningFlowInstance(this.mInstance);
        }
    }

    static class RunningFlowInstanceDeleteAction
    extends PersistenceAction {
        private String mInstanceID;

        public RunningFlowInstanceDeleteAction(ExecutionProvider provider, String instanceID) {
            super(provider);
            this.mInstanceID = instanceID;
        }

        @Override
        public void execute() throws ShutdownException {
            this.mProvider.removeRunningFlowInstance(this.mInstanceID);
        }
    }

    static class UsedTimesSaveAction
    extends PersistenceAction {
        String mFlowID;
        Map<String, Long> mUsedTimes;

        public UsedTimesSaveAction(ExecutionProvider provider, String flowID, Map<String, Long> usedTimes) {
            super(provider);
            this.mFlowID = flowID;
            this.mUsedTimes = usedTimes;
        }

        @Override
        public void execute() throws ShutdownException {
            this.mProvider.saveUsedTimes(this.mFlowID, this.mUsedTimes);
        }
    }
}

