/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.ip.engine;

import com.sas.scheduler.api.servers.ip.engine.EmailItemStatusAction;
import com.sas.scheduler.api.servers.ip.engine.FlowInstance;
import com.sas.scheduler.api.servers.ip.engine.FlowManager;
import com.sas.scheduler.api.servers.ip.engine.JobDependency;
import com.sas.scheduler.api.servers.ip.engine.RunCondition;
import com.sas.scheduler.api.servers.ip.engine.RunItemExitCodeDependency;
import com.sas.scheduler.api.servers.ip.engine.RunItemStatusDependency;
import com.sas.scheduler.api.servers.ip.engine.RunningItem;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AssociatedAction {
    public static final String XML_AtStart_Tag = "AtItemStart";
    public static final String XML_NotificationCondition_Tag = "NotificationConditions";
    private static Map<String, XMLExecutionItemMapVector> mXMLParseVector = new HashMap<String, XMLExecutionItemMapVector>();
    protected boolean mAtItemStart = false;
    protected JobDependency mCondition = null;
    protected boolean isExecuted = false;

    public AssociatedAction(boolean atItemStart) {
        this.mAtItemStart = atItemStart;
    }

    public AssociatedAction(RunItemExitCodeDependency condition) {
        this.mAtItemStart = false;
        this.mCondition = condition;
    }

    public AssociatedAction(RunItemStatusDependency condition) {
        this.mAtItemStart = false;
        this.mCondition = condition;
    }

    public abstract void execute(RunningItem var1, boolean var2);

    public boolean willExecute(RunningItem item, boolean itemStarting) {
        if (itemStarting != this.mAtItemStart) {
            return false;
        }
        if (this.mAtItemStart) {
            return true;
        }
        if (this.mCondition == null) {
            return true;
        }
        this.mCondition.setDependentItem(item);
        return this.mCondition.canExecute(item.getFlowManager(), Calendar.getInstance(), null, null, null, false) == 56;
    }

    public abstract AssociatedAction copy();

    protected void copyFrom(AssociatedAction source) {
        this.mAtItemStart = source.mAtItemStart;
        this.mCondition = null;
        if (source.mCondition != null) {
            this.mCondition = (JobDependency)source.mCondition.copy();
        }
    }

    public JobDependency getCondition() {
        return this.mCondition;
    }

    public void setCondition(JobDependency condition) {
        this.mCondition = condition;
    }

    public abstract void serialize(Document var1, Node var2);

    public String toSerializedForm(FlowManager manager) {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.newDocument();
            this.serialize(doc, doc);
            return FlowInstance.emitXML(doc, manager.getLogger());
        }
        catch (ParserConfigurationException e) {
            manager.getLogger().logMessage(Level.WARNING, e);
            return "";
        }
    }

    public void injectXML(Document doc, Element tag) {
        tag.setAttribute(XML_AtStart_Tag, Boolean.toString(this.mAtItemStart));
        if (this.mCondition != null) {
            Element notificationTag = doc.createElement(XML_NotificationCondition_Tag);
            tag.appendChild(notificationTag);
            this.mCondition.serialize(doc, notificationTag);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AssociatedAction)) {
            return false;
        }
        AssociatedAction other = (AssociatedAction)obj;
        if (other.mAtItemStart != this.mAtItemStart) {
            return false;
        }
        return !(other.mCondition != null && this.mCondition != null ? !other.mCondition.equals(this.mCondition) : other.mCondition != this.mCondition);
    }

    public static List<AssociatedAction> processActions(Node node) {
        ArrayList<AssociatedAction> actions = new ArrayList<AssociatedAction>();
        NodeList children = node.getChildNodes();
        int listLength = children.getLength();
        for (int i = 0; i < listLength; ++i) {
            AssociatedAction action;
            Node child = children.item(i);
            String tagName = child.getNodeName();
            XMLExecutionItemMapVector vectorItem = mXMLParseVector.get(tagName);
            if (vectorItem == null || (action = vectorItem.createItem(child)) == null) continue;
            actions.add(action);
        }
        return actions;
    }

    protected static void processAction(AssociatedAction action, Element e) {
        RunCondition condition;
        action.mAtItemStart = Boolean.valueOf(e.getAttribute(XML_AtStart_Tag));
        action.mCondition = null;
        NodeList conditionTags = e.getElementsByTagName(XML_NotificationCondition_Tag);
        if (conditionTags.getLength() > 0 && (condition = RunCondition.processCondition(conditionTags.item(0), FlowManager.getDefaultLogger())) instanceof JobDependency) {
            action.mCondition = (JobDependency)condition;
        }
    }

    static {
        mXMLParseVector.put("EmailStatusAction", new XMLExecutionItemMapVector(){

            @Override
            public AssociatedAction createItem(Node node) {
                return EmailItemStatusAction.processAction(node);
            }
        });
    }

    private static interface XMLExecutionItemMapVector {
        public AssociatedAction createItem(Node var1);
    }
}

