/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.ip;

import com.sas.scheduler.api.servers.ip.engine.ClientLogger;
import com.sas.scheduler.api.servers.ip.engine.IPUtilities;
import com.sas.scheduler.api.servers.ip.engine.jgroups.JGroupsClusterSupport;
import com.sas.svcs.cluster.DefaultMulticastProperties;
import java.util.Properties;
import java.util.logging.Level;
import org.jgroups.JChannel;
import org.w3c.dom.Element;

public class PIPClusterSupport
extends JGroupsClusterSupport {
    private JChannel mFactory;

    public PIPClusterSupport(String jgroupName, String channelProperties, long timeout, boolean jobServersAreSeparate, Properties serverProperties, ClientLogger logger) throws Exception {
        super(jgroupName, channelProperties, timeout, jobServersAreSeparate, true, serverProperties, -1, -1, logger);
    }

    @Override
    protected void createHashChannel(String channelProperties) throws Exception {
        if (channelProperties == null) {
            if (this.mFactory != null) {
                try {
                    this.mHashChannel = new JChannel(channelProperties);
                    return;
                }
                catch (Exception e) {
                    this.mLogger.logMessage(Level.WARNING, e);
                }
            }
            int port = IPUtilities.getIntegerValue(this.mServerProperties, "PIP.JGroupsPort_HashChannelPort", -1, this.mLogger);
            DefaultMulticastProperties props = new DefaultMulticastProperties();
            props.setPort(port);
            String address = this.mServerProperties.getProperty("PIP.JGroupsMulticastAddress", "228.10.10.10");
            props.setAddress(address);
            int newTTL = IPUtilities.getIntegerValue(this.mServerProperties, "PIP.JGroupsMulticastTTL", 2, this.mLogger);
            if (newTTL < 0 || newTTL > 255) {
                newTTL = 2;
            }
            props.setTtl(newTTL);
            Element properties = props.getPropertiesElement();
            this.mHashChannel = new JChannel(channelProperties);
            return;
        }
        super.createHashChannel(channelProperties);
    }

    @Override
    protected void createMainChannel(String channelProperties) throws Exception {
        if (channelProperties == null) {
            boolean allowSingleChannelAttempt = !"false".equalsIgnoreCase(System.getProperty("DIP_DisallowSingleChannel"));
            int port = IPUtilities.getIntegerValue(this.mServerProperties, "PIP.JGroupsPort_MainChannelPort", -1, this.mLogger);
            DefaultMulticastProperties props = new DefaultMulticastProperties();
            props.setPort(port);
            String address = this.mServerProperties.getProperty("PIP.JGroupsMulticastAddress", "228.10.10.10");
            props.setAddress(address);
            int newTTL = IPUtilities.getIntegerValue(this.mServerProperties, "PIP.JGroupsMulticastTTL", 2, this.mLogger);
            if (newTTL < 0 || newTTL > 255) {
                newTTL = 2;
            }
            props.setTtl(newTTL);
            this.mLogger.logMessage(Level.INFO, "PIP main channel port= " + port);
            this.mLogger.logMessage(Level.INFO, "PIP main channel address= " + address);
            this.mLogger.logMessage(Level.INFO, "PIP multicast TTL= " + newTTL);
            Element properties = props.getPropertiesElement();
            if (this.mChannel == null) {
                this.mChannel = new JChannel(channelProperties);
            }
            return;
        }
        super.createMainChannel(channelProperties);
    }

    @Override
    public void cleanup() {
        super.cleanup();
        if (this.mFactory != null) {
            this.mFactory.disconnect();
            this.mFactory.close();
        }
    }

    public static int getIntegerValue(Properties props, String key, int defaultValue, ClientLogger logger) {
        return IPUtilities.getIntegerValue(props, key, defaultValue, logger);
    }

    public static long getLongValue(Properties props, String key, long defaultValue, ClientLogger logger) {
        return IPUtilities.getLongValue(props, key, defaultValue, logger);
    }

    public static boolean getBooleanValue(Properties props, String key, boolean defaultValue, ClientLogger logger) {
        return IPUtilities.getBooleanValue(props, key, defaultValue, logger);
    }
}

