/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.ip;

import com.sas.metadata.remote.ServerComponent;
import com.sas.net.crypto.SealedString;
import com.sas.scheduler.api.oma.MetaUtilities;
import com.sas.scheduler.api.servers.FlowHistory;
import com.sas.scheduler.api.servers.IConsole;
import com.sas.scheduler.api.servers.ip.IPFlowHistory;
import com.sas.scheduler.api.servers.ip.IPScheduler;
import com.sas.scheduler.api.servers.ip.PIPScheduler;
import com.sas.scheduler.model.FlowInfo;
import com.sas.scheduler.model.JobRendererInfo;
import com.sas.scheduler.model.RunHistory;
import com.sas.scheduler.model.ScheduledFlowInfo;
import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.model.SchedulerResultSet;
import com.sas.scheduler.model.SchedulerServerInfo;
import com.sas.scheduler.visuals.swing.OperationThread;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.services.user.UserIdentityInterface;
import com.sas.svcs.commons.webservice.omrclient.ServiceRegistryHelper;
import com.sas.svcs.scheduling.client.SchedulingExceptionHolder;
import com.sas.svcs.scheduling.client.SchedulingServiceInterface;
import com.sas.workspace.Workspace;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class DIPServiceProxy
extends IPScheduler
implements IConsole {
    public static final String DIP_Running_Inside_ScheduleManager = "DIP_RunningInsideScheduleManager";
    private static SchedulingServiceInterface m_serviceProxy;
    private static SchedulerServerInfo m_connectedServer;
    private static ServerComponent m_sc;
    private static String m_userID;
    private static ApplicationContext m_appContext;
    private static SessionContextInterface m_sessionContext;
    private List<ScheduledFlowInfo> m_flows = null;
    private static String _serviceRegistryURL;
    private static boolean _useCurrentLogin;

    public DIPServiceProxy(SchedulerServerInfo info) {
        super(info);
    }

    @Override
    @Deprecated
    protected boolean maketheConnection(String user, String pass) {
        return this.maketheConnection(user, pass != null ? new SealedString(pass) : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean maketheConnection(String user, SealedString pass) {
        boolean rc = false;
        if (m_connectedServer != null) {
            rc = true;
        } else {
            if (_useCurrentLogin) {
                if (user == null) {
                    user = m_userID;
                }
                if (pass == null) {
                    try {
                        if (m_sessionContext != null) {
                            UserContextInterface userContext;
                            String domain = null;
                            if (m_sc != null) {
                                domain = MetaUtilities.getDomain(m_sc);
                            }
                            if ((userContext = m_sessionContext.getUserContext()) != null) {
                                List identities = userContext.getIdentities();
                                for (UserIdentityInterface uI : identities) {
                                    if (!uI.getDomain().equals(domain) || !uI.getPrincipal().equals(user) && !uI.getResolvedUserName().equals(user)) continue;
                                    pass = uI.getCredential().toString() != null ? new SealedString(uI.getCredential().toString()) : null;
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        pass = null;
                    }
                }
            } else if (pass == null) {
                pass = new SealedString("Anonymous");
            }
            if (user == null || pass == null) {
                return false;
            }
            this.getSchedProxy();
            if (m_serviceProxy != null) {
                try {
                    m_connectedServer = m_serviceProxy.connectToSchedulingServer(this.m_schedulingServer, user, pass != null ? String.valueOf(pass.getCharacters()) : "", "", "", "", "", Integer.valueOf(0), Integer.valueOf(0));
                    if (m_connectedServer != null) {
                        m_sc = MetaUtilities.getSchedulerServer(m_connectedServer);
                        this.m_schedulingServer.setUsername(user);
                        if (MetaUtilities.isAllowPasswordCache()) {
                            this.m_schedulingServer.setPassword(pass != null ? String.valueOf(pass.getCharacters()) : "");
                        }
                        rc = true;
                    } else {
                        rc = false;
                    }
                }
                catch (Exception e) {
                    if (this.isDebug()) {
                        System.err.println(e.toString());
                    }
                    rc = false;
                }
            }
        }
        if (rc) {
            DIPServiceProxy dIPServiceProxy = this;
            synchronized (dIPServiceProxy) {
                OperationThread threadOperation = new OperationThread("SCHEDULEDFLOWS", (Runnable)new cRunnableGenerateInfo(), (Runnable)new cRunnableComplete());
                threadOperation.startThread();
            }
        }
        return rc;
    }

    @Override
    public boolean closeConnection() {
        DIPServiceProxy.clearAppContext(m_userID, m_sessionContext);
        this.m_flows = null;
        try {
            if (m_serviceProxy != null) {
                m_serviceProxy.disconnectFromSchedulingServer(this.m_schedulingServer);
            }
        }
        catch (SchedulingExceptionHolder e) {
            return false;
        }
        return true;
    }

    public synchronized void refreshAppContext() {
        block4: {
            try {
                _serviceRegistryURL = ServiceRegistryHelper.getClientAccessURL((UserContextInterface)Workspace.getWorkspace().getUserContext());
                if (_serviceRegistryURL != null) {
                    System.setProperty("registry.url", _serviceRegistryURL);
                    if (_useCurrentLogin) {
                        GenericApplicationContext ctx = new GenericApplicationContext();
                        ClassLoader rootNodeCl = PIPScheduler.class.getClassLoader();
                        ctx.setClassLoader(rootNodeCl);
                        XmlBeanDefinitionReader beanReader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)ctx);
                        ClassPathResource contextResource = new ClassPathResource("application-context.xml", PIPScheduler.class);
                        beanReader.loadBeanDefinitions((Resource)contextResource);
                        ctx.refresh();
                        m_serviceProxy = (SchedulingServiceInterface)ctx.getBean(SchedulingServiceInterface.class);
                        m_appContext = ctx;
                    }
                }
            }
            catch (Exception e) {
                if (!MetaUtilities.isDebug()) break block4;
                System.err.println(e.toString());
            }
        }
    }

    public static void clearAppContext(String userID, SessionContextInterface sessionContext) {
        m_appContext = null;
        m_serviceProxy = null;
        m_connectedServer = null;
        m_userID = userID;
        m_sessionContext = sessionContext;
    }

    protected void getSchedProxy() {
        if (m_appContext == null) {
            this.refreshAppContext();
        }
    }

    @Override
    public String getClassId() {
        return "c8b4baf0-5f9f-488e-ba76-1201e1e81aef";
    }

    private boolean checkConnection() {
        if (m_serviceProxy == null) {
            try {
                return this.maketheConnection();
            }
            catch (SchedulerException e) {
                if (MetaUtilities.isDebug()) {
                    System.err.println(e.toString());
                }
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isFlowScheduled(String flowName) {
        if (!this.checkConnection()) {
            return false;
        }
        if (m_serviceProxy != null) {
            try {
                FlowInfo foundFlow = m_serviceProxy.getFlowByName(flowName);
                if (foundFlow != null) {
                    return foundFlow.isFlowSubmitted();
                }
                return false;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean isFlowScheduled(FlowInfo flow) {
        return this.isFlowScheduled(flow.getName());
    }

    @Override
    public boolean scheduleFlow(FlowInfo flow) throws SchedulerException, UnsupportedOperationException, InvalidParameterException {
        if (m_serviceProxy != null) {
            try {
                boolean rc;
                SchedulerResultSet results = m_serviceProxy.scheduleFlow(flow);
                boolean bl = rc = results.getReturnValue() != 0;
                if (rc) {
                    ScheduledFlowInfo sflow = new ScheduledFlowInfo(flow.getName(), flow.getScheduleDefinitionId(), flow.getScheduledUser(), flow.getTriggerId());
                    this.m_flows.add(sflow);
                }
                return rc;
            }
            catch (Exception e) {
                SchedulerException exc = new SchedulerException();
                exc.initCause((Throwable)e);
                throw exc;
            }
        }
        return false;
    }

    @Override
    public boolean scheduleFlowNow(FlowInfo flow) throws SchedulerException, UnsupportedOperationException, InvalidParameterException {
        if (m_serviceProxy != null) {
            try {
                boolean rc;
                SchedulerResultSet results = m_serviceProxy.scheduleFlow(flow);
                boolean bl = rc = results.getReturnValue() != 0;
                if (rc) {
                    ScheduledFlowInfo sflow = new ScheduledFlowInfo(flow.getName(), flow.getScheduleDefinitionId(), flow.getScheduledUser(), flow.getTriggerId());
                    this.m_flows.add(sflow);
                }
                return rc;
            }
            catch (SchedulingExceptionHolder e) {
                SchedulerException exc = new SchedulerException();
                exc.initCause((Throwable)e);
                throw exc;
            }
        }
        return false;
    }

    @Override
    public int rescheduleFlow(FlowInfo flow, boolean errorOnDelete) throws SchedulerException, UnsupportedOperationException {
        if (m_serviceProxy != null) {
            try {
                SchedulerResultSet results = m_serviceProxy.rescheduleFlow(flow, true);
                int rc = results.getReturnValue() != 0 ? 0 : 2;
                return rc;
            }
            catch (SchedulingExceptionHolder e) {
                SchedulerException exc = new SchedulerException();
                exc.initCause((Throwable)e);
                throw exc;
            }
        }
        return 2;
    }

    @Override
    public boolean removeFlow(FlowInfo flow, String triggerType) throws UnsupportedOperationException, SchedulerException {
        if (m_serviceProxy != null) {
            try {
                FlowInfo fInfo = m_serviceProxy.unscheduleFlow(flow);
                return fInfo != null;
            }
            catch (SchedulingExceptionHolder e) {
                SchedulerException exc = new SchedulerException();
                exc.initCause((Throwable)e);
                throw exc;
            }
        }
        return false;
    }

    @Override
    public boolean removeFlow(String flowName) throws UnsupportedOperationException {
        if (m_serviceProxy != null) {
            try {
                FlowInfo fInfo = m_serviceProxy.getFlowByName(flowName);
                if (fInfo == null) {
                    return false;
                }
                return (fInfo = m_serviceProxy.unscheduleFlow(fInfo)) != null;
            }
            catch (SchedulingExceptionHolder e) {
                return false;
            }
        }
        return false;
    }

    @Override
    public long getFlowInstance(FlowInfo flow) {
        if (m_serviceProxy != null) {
            try {
                List histories = m_serviceProxy.getFlowHistory(flow);
                if (histories.size() > 0) {
                    return ((com.sas.scheduler.model.FlowHistory)histories.get(0)).getIdDataBinding();
                }
            }
            catch (SchedulingExceptionHolder e) {
                return -2L;
            }
        }
        return -2L;
    }

    @Override
    public String getFlowDefinition(String flowDefId) {
        if (m_serviceProxy != null) {
            try {
                return m_serviceProxy.getFlowDefinitionByScheduler(this.m_schedulingServer.getId(), flowDefId);
            }
            catch (SchedulingExceptionHolder e) {
                return null;
            }
        }
        return null;
    }

    @Override
    public FlowHistory getFlowHistory(FlowInfo flow) {
        if (m_serviceProxy != null) {
            try {
                List histories = m_serviceProxy.getFlowHistory(flow);
                if (histories.size() > 0) {
                    IPFlowHistory history = new IPFlowHistory(flow.getName(), (com.sas.scheduler.model.FlowHistory)histories.get(0));
                    return history;
                }
            }
            catch (SchedulingExceptionHolder e) {
                return null;
            }
        }
        return null;
    }

    @Override
    public List getFlowHistoryList(FlowInfo flow, int count) {
        if (m_serviceProxy != null) {
            try {
                ArrayList<IPFlowHistory> results = new ArrayList<IPFlowHistory>();
                if (count < 0) {
                    return results;
                }
                List histories = m_serviceProxy.getFlowHistory(flow);
                for (com.sas.scheduler.model.FlowHistory flowHistory : histories) {
                    IPFlowHistory history = new IPFlowHistory(flow.getName(), flowHistory);
                    results.add(history);
                }
                return results;
            }
            catch (SchedulingExceptionHolder e) {
                return new ArrayList();
            }
        }
        return new ArrayList();
    }

    @Override
    public List getFlowHistoryList(String userid, List flowList, int count) {
        return new ArrayList();
    }

    @Override
    public List getFlowHistoryList(FlowInfo flow) {
        return this.getFlowHistoryList(flow, 0);
    }

    @Override
    public boolean verifyFlowScheduled(FlowInfo flow) throws SchedulerException {
        return this.isFlowScheduled(flow);
    }

    @Override
    public List<FlowHistory> getFlowHistoryList(String userid, int count) {
        ArrayList<FlowHistory> results;
        block4: {
            results = new ArrayList<FlowHistory>();
            if (m_serviceProxy != null) {
                try {
                    List list = m_serviceProxy.getFlowHistoryByScheduler(this.m_schedulingServer.getId(), userid, count);
                    for (com.sas.scheduler.model.FlowHistory hist : list) {
                        IPFlowHistory h = new IPFlowHistory(hist.getFlowName(), hist);
                        results.add(h);
                    }
                }
                catch (SchedulingExceptionHolder e) {
                    if (!this.isDebug()) break block4;
                    System.err.println(e.toString());
                }
            }
        }
        return results;
    }

    @Override
    public boolean holdFlow(String flowDefinition) throws SchedulerException {
        block3: {
            if (m_serviceProxy != null) {
                try {
                    return m_serviceProxy.holdFlow(this.m_schedulingServer.getId(), flowDefinition);
                }
                catch (SchedulingExceptionHolder e) {
                    if (!this.isDebug()) break block3;
                    System.out.println(e.toString());
                }
            }
        }
        return false;
    }

    @Override
    public boolean releaseFlow(String flowDefinition) throws SchedulerException {
        block3: {
            if (m_serviceProxy != null) {
                try {
                    return m_serviceProxy.releaseFlow(this.m_schedulingServer.getId(), flowDefinition);
                }
                catch (SchedulingExceptionHolder e) {
                    if (!this.isDebug()) break block3;
                    System.out.println(e.toString());
                }
            }
        }
        return false;
    }

    @Override
    public boolean pauseFlowInstance(String flowInstance) throws SchedulerException {
        block3: {
            if (m_serviceProxy != null) {
                try {
                    return m_serviceProxy.pauseFlowInstance(this.m_schedulingServer.getId(), flowInstance);
                }
                catch (SchedulingExceptionHolder e) {
                    if (!this.isDebug()) break block3;
                    System.out.println(e.toString());
                }
            }
        }
        return false;
    }

    @Override
    public boolean resumeFlowInstance(String flowInstance) throws SchedulerException {
        block3: {
            if (m_serviceProxy != null) {
                try {
                    return m_serviceProxy.resumeFlowInstance(this.m_schedulingServer.getId(), flowInstance);
                }
                catch (SchedulingExceptionHolder e) {
                    if (!this.isDebug()) break block3;
                    System.out.println(e.toString());
                }
            }
        }
        return false;
    }

    @Override
    public boolean killFlowInstance(String flowInstance) throws SchedulerException {
        block3: {
            if (m_serviceProxy != null) {
                try {
                    return m_serviceProxy.killFlowInstance(this.m_schedulingServer.getId(), flowInstance);
                }
                catch (SchedulingExceptionHolder e) {
                    if (!this.isDebug()) break block3;
                    System.out.println(e.toString());
                }
            }
        }
        return false;
    }

    @Override
    public boolean killItemInstance(String flowInstance, String itemInstance) throws SchedulerException {
        block3: {
            if (m_serviceProxy != null) {
                try {
                    return m_serviceProxy.killItemInstance(this.m_schedulingServer.getId(), flowInstance, itemInstance);
                }
                catch (SchedulingExceptionHolder e) {
                    if (!this.isDebug()) break block3;
                    System.out.println(e.toString());
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _getScheduledFlows(String id, String user) {
        DIPServiceProxy dIPServiceProxy = this;
        synchronized (dIPServiceProxy) {
            block7: {
                if (this.m_flows == null) {
                    try {
                        this.m_flows = m_serviceProxy.getScheduledFlowsByScheduler(id, user);
                    }
                    catch (NoSuchMethodError nsme) {
                        System.err.println(nsme.toString());
                    }
                    catch (Exception e) {
                        if (!this.isDebug()) break block7;
                        System.err.println(e.toString());
                    }
                }
            }
        }
    }

    @Override
    public List<ScheduledFlowInfo> getScheduledFlows(String id, String user) {
        if (id == null) {
            return null;
        }
        this._getScheduledFlows(id, user);
        return this.m_flows;
    }

    @Override
    public List<FlowHistory> getFlowHistoryList(String flowname, String userid, int count) {
        ArrayList<FlowHistory> results;
        block4: {
            results = new ArrayList<FlowHistory>();
            if (m_serviceProxy != null) {
                try {
                    List list = m_serviceProxy.getFlowHistoryByScheduler(this.m_schedulingServer.getId(), userid, count);
                    for (com.sas.scheduler.model.FlowHistory hist : list) {
                        if (!hist.getFlowName().equals(flowname)) continue;
                        IPFlowHistory h = new IPFlowHistory(hist.getFlowName(), hist);
                        results.add(h);
                    }
                }
                catch (SchedulingExceptionHolder e) {
                    if (!this.isDebug()) break block4;
                    System.err.println(e.toString());
                }
            }
        }
        return results;
    }

    @Override
    public List<RunHistory> getRunningJobs(String id, String user) {
        if (id == null) {
            return null;
        }
        try {
            return m_serviceProxy.getRunningJobsByScheduler(id, user);
        }
        catch (SchedulingExceptionHolder e) {
            if (this.isDebug()) {
                System.out.println(e.toString());
            }
            return null;
        }
    }

    @Override
    public boolean triggerFlow(String id) {
        block6: {
            try {
                return m_serviceProxy.triggerFlow(this.m_schedulingServer.getId(), id);
            }
            catch (InvalidParameterException e) {
                if (this.isDebug()) {
                    System.err.println(e.toString());
                }
            }
            catch (UnsupportedOperationException e) {
                if (this.isDebug()) {
                    System.out.println(e.toString());
                }
            }
            catch (SchedulingExceptionHolder e) {
                if (!this.isDebug()) break block6;
                System.out.println(e.toString());
            }
        }
        return false;
    }

    @Override
    public boolean deleteFlow(String id) {
        block8: {
            try {
                if (this.m_flows == null) {
                    this._getScheduledFlows(this.m_schedulingServer.getId(), this.m_schedulingServer.getUsername());
                }
                for (int i = 0; i < this.m_flows.size(); ++i) {
                    ScheduledFlowInfo sflow = this.m_flows.get(i);
                    if (sflow.getScheduleDefinitionIdDataBinding() != id) continue;
                    FlowInfo flow = m_serviceProxy.getFlowByName(sflow.getName());
                    return this.removeFlow(flow, null);
                }
            }
            catch (SchedulerException e) {
                if (this.isDebug()) {
                    System.err.println(e.toString());
                }
            }
            catch (RuntimeException e) {
                if (this.isDebug()) {
                    System.err.println(e.toString());
                }
            }
            catch (SchedulingExceptionHolder e) {
                if (!this.isDebug()) break block8;
                System.out.println(e.toString());
            }
        }
        return false;
    }

    @Override
    public StringBuffer getStandardOut(String flowInstance, String jobInstance) throws SchedulerException {
        StringBuffer buffer;
        block3: {
            buffer = null;
            if (m_serviceProxy != null) {
                try {
                    buffer = m_serviceProxy.getStandardOutput(this.m_schedulingServer.getId(), flowInstance, jobInstance);
                }
                catch (SchedulingExceptionHolder e) {
                    if (!this.isDebug()) break block3;
                    System.out.println(e.toString());
                }
            }
        }
        return buffer;
    }

    @Override
    public StringBuffer getStandardError(String flowInstance, String jobInstance) throws SchedulerException {
        StringBuffer buffer;
        block3: {
            buffer = null;
            if (m_serviceProxy != null) {
                try {
                    buffer = m_serviceProxy.getStandardError(this.m_schedulingServer.getId(), flowInstance, jobInstance);
                }
                catch (SchedulingExceptionHolder e) {
                    if (!this.isDebug()) break block3;
                    System.out.println(e.toString());
                }
            }
        }
        return buffer;
    }

    @Override
    public List<JobRendererInfo> getJobRenderers(String schId) {
        List list;
        block3: {
            list = null;
            if (m_serviceProxy != null) {
                try {
                    list = m_serviceProxy.getJobRenderers(schId);
                }
                catch (SchedulingExceptionHolder e) {
                    if (!this.isDebug()) break block3;
                    System.out.println(e.toString());
                }
            }
        }
        return list;
    }

    static {
        _serviceRegistryURL = null;
        _useCurrentLogin = true;
    }

    private class cRunnableGenerateInfo
    implements Runnable {
        cRunnableGenerateInfo() {
        }

        @Override
        public void run() {
            DIPServiceProxy.this._getScheduledFlows(DIPServiceProxy.this.m_schedulingServer.getId(), DIPServiceProxy.this.m_schedulingServer.getUsername());
        }
    }

    private class cRunnableComplete
    implements Runnable {
        cRunnableComplete() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            cRunnableComplete cRunnableComplete2 = this;
            synchronized (cRunnableComplete2) {
            }
        }
    }
}

