/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers;

import com.sas.iom.SAS.IFileServicePackage.ListFilesMode;
import com.sas.iom.SAS.IFileServicePackage.TypeCategorySeqHolder;
import com.sas.iom.SAS.IWorkspace;
import com.sas.iom.SAS.IWorkspaceHelper;
import com.sas.iom.SAS.InvalidFieldMask;
import com.sas.iom.SASIOMDefs.DateTimeSeqHolder;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.iom.SASIOMDefs.LongSeqHolder;
import com.sas.iom.SASIOMDefs.StringSeqHolder;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.ServerContext;
import com.sas.metadata.remote.TCPIPConnection;
import com.sas.net.crypto.SealedString;
import com.sas.scheduler.api.oma.MetaUtilities;
import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.visuals.swing.LoginDialog;
import com.sas.scheduler.visuals.swing.MessageUtil;
import com.sas.services.ServiceException;
import com.sas.services.connection.BridgeServer;
import com.sas.services.connection.ConnectionFactoryConfiguration;
import com.sas.services.connection.ConnectionFactoryException;
import com.sas.services.connection.ConnectionFactoryInterface;
import com.sas.services.connection.ConnectionFactoryManager;
import com.sas.services.connection.ConnectionInterface;
import com.sas.services.connection.Credential;
import com.sas.services.connection.FatalConnectionFactoryException;
import com.sas.services.connection.InvalidCredentialsException;
import com.sas.services.connection.LoginException;
import com.sas.services.connection.ManualConnectionFactoryConfiguration;
import com.sas.services.connection.SecurityPackageCredential;
import com.sas.services.connection.Server;
import com.sas.services.connection.platform.PlatformConnectionFactoryConfiguration;
import com.sas.services.connection.platform.PlatformConnectionFactoryInterface;
import com.sas.services.connection.platform.PlatformConnectionFactoryManager;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.LogicalServerInterface;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.user.CallbackCancelledException;
import com.sas.services.user.UserContextInterface;
import com.sas.services.user.UserIdentityInterface;
import java.awt.Frame;
import java.io.Serializable;
import java.net.PasswordAuthentication;
import java.rmi.RemoteException;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.Object;
import org.omg.CORBA.StringHolder;

public class IWorkspaceServer {
    private static final ResourceBundle m_bundle = MetaUtilities.getMyResourceBundle(IWorkspaceServer.class);
    private String m_classid;
    private String m_host;
    private int m_port;
    private UserContextInterface m_userContext;
    private String m_user;
    private SealedString m_password;
    private IWorkspace m_iworkspace = null;
    private ServerComponent m_sc = null;
    private PlatformConnectionFactoryInterface m_pcxf;
    private ConnectionFactoryInterface m_cxf;
    private ConnectionInterface m_cx;
    private boolean m_connected = false;
    public static final int SERVER_NOT_CONNECTED = 0;
    public static final int SERVER_CONNECTED = 1;
    public static final int USER_ABORTED = 2;
    public static final int SYSTEM_ABORTED = 3;
    public static final int SYSTEM_UNSUPPORTED = 4;
    public static final String WORKSPACE_CLASSID = "440196D4-90F0-11D0-9F41-00A024BB830C";
    public static final String OSSCHEDULER_CLASSID = "b379c9c1-89e0-4e72-ba43-6a416899b5dd";

    public IWorkspaceServer(ServerContext sc, String classid, String host, int port) {
        this.m_sc = sc;
        this.m_classid = classid;
        this.m_host = host;
        this.m_port = port;
    }

    public boolean isConnected() {
        return this.m_connected;
    }

    public IWorkspace getWorkspace() {
        return this.m_iworkspace;
    }

    public UserContextInterface getUserContext() {
        return this.m_userContext;
    }

    public String getUsername() {
        return this.m_user;
    }

    @Deprecated
    public String getPassword() {
        return this.m_password != null ? String.valueOf(this.m_password.getCharacters()) : null;
    }

    public SealedString getPasswordSealedString() {
        return this.m_password;
    }

    public ServerComponent getServerComponent() {
        return this.m_sc;
    }

    public static IWorkspace checkConnectionToServer(UserContextInterface user, ServerComponent sc, String classid) throws RemoteException, MdException, InvalidParameterException, SchedulerException, CallbackCancelledException {
        return IWorkspaceServer.__checkConnectionToServer(user, sc, classid);
    }

    public int checkConnectionToServer(Frame frame, UserContextInterface user, ServerComponent sc, String classid) throws RemoteException, MdException, InvalidParameterException {
        return this.__checkConnectionToServer(frame, user, sc, classid);
    }

    public int checkConnectionToServer(Frame frame, ServerComponent sc, String classid) throws RemoteException, MdException, InvalidParameterException {
        SessionContextInterface sessionContext = MetaUtilities.getSessionContext();
        if (sessionContext != null) {
            UserContextInterface userContext = sessionContext.getUserContext();
            return this.__checkConnectionToServer(frame, userContext, sc, classid);
        }
        return this.__checkConnectionToServer(frame, null, sc, classid);
    }

    private int __checkConnectionToServer(Frame frame, UserContextInterface user, ServerComponent sc, String classid) throws RemoteException, MdException, InvalidParameterException {
        int rc = 0;
        if (this.m_iworkspace == null || this.m_sc == null || sc.getFQID().compareTo(this.m_sc.getFQID()) != 0 || this.m_classid == null || classid.compareTo(this.m_classid) != 0) {
            TCPIPConnection connection;
            String userid = "";
            SealedString password = new SealedString("");
            String host = "";
            int port = 0;
            if (this.m_iworkspace != null) {
                this.closeConnection();
            }
            if ((connection = IWorkspaceServer.getTCPIPConnection(sc, classid)) == null) {
                throw new InvalidParameterException(MetaUtilities.messageString(m_bundle.getString("IWorkspaceServer.ErrorMsg.NoServer.fmt"), sc.getName()));
            }
            host = connection.getHostName();
            port = connection.getPort();
            String loginTitle = "";
            try {
                loginTitle = MetaUtilities.messageString(m_bundle.getString("IWorkspaceServer.Logon.title.fmt"), sc.getName());
            }
            catch (RuntimeException ex) {
                loginTitle = MetaUtilities.messageString(m_bundle.getString("IWorkspaceServer.Logon.title.fmt"), host);
            }
            boolean keepTrying = true;
            int count = 0;
            LoginDialog dialog = null;
            while (keepTrying) {
                if (++count == 1 && user == null) {
                    try {
                        PasswordAuthentication l = null;
                        l = sc instanceof ServerContext ? MetaUtilities.getLoginIdentity(IWorkspaceServer.getWorkspace((ServerContext)sc, classid)) : MetaUtilities.getLoginIdentity(sc);
                        if (l != null) {
                            userid = l.getUserName();
                            password = l.getPassword() != null ? new SealedString(l.getPassword()) : null;
                        }
                    }
                    catch (Exception ex) {
                        count = 2;
                    }
                }
                if (count > 1) {
                    dialog = new LoginDialog(frame, loginTitle);
                    dialog.setUserName("");
                    dialog.setPasswordSealedString(new SealedString(""));
                    dialog.makeVisible();
                    if (dialog.getReturnValue() == 1) {
                        userid = dialog.getUserName();
                        password = dialog.getPasswordSealedString();
                    } else if (dialog.getReturnValue() == 2) {
                        keepTrying = false;
                        rc = 2;
                    }
                }
                if (keepTrying) {
                    try {
                        if (userid != null && userid.trim().length() > 0) {
                            this.m_sc = sc;
                            this.m_classid = classid;
                            this.m_host = host;
                            this.m_port = port;
                            if (this.makeConnection(userid, password)) {
                                keepTrying = false;
                                rc = 1;
                            }
                        } else if (user != null) {
                            this.m_sc = sc;
                            this.m_classid = classid;
                            this.m_host = host;
                            this.m_port = port;
                            if (this.makeConnection(user)) {
                                keepTrying = false;
                                rc = 1;
                            }
                        }
                    }
                    catch (CallbackCancelledException cce) {
                        keepTrying = false;
                        rc = 2;
                    }
                    catch (InvalidCredentialsException e) {
                        if (count > 1) {
                            String message = m_bundle.getString("IWorkspaceServer.ErrorMsg.invalidCredentials.txt");
                            MessageUtil.displayMessage((Frame)frame, (String)message, (String)loginTitle, (int)0);
                        }
                        userid = null;
                        password = null;
                    }
                    catch (FatalConnectionFactoryException e) {
                        if (count > 1) {
                            String appName = "";
                            try {
                                appName = sc.getName();
                            }
                            catch (RuntimeException rte) {
                                appName = host;
                            }
                            String message = MetaUtilities.messageString(m_bundle.getString("IWorkspaceServer.ErrorMsg.unableToLaunch.fmt"), appName);
                            MessageUtil.displayMessage((Frame)frame, (String)message, (String)loginTitle, (int)0);
                        }
                        userid = null;
                        password = null;
                    }
                    catch (ServiceException se) {
                        user = null;
                        userid = null;
                        password = null;
                    }
                }
                if (dialog == null) continue;
                dialog.dispose();
                dialog = null;
            }
        } else {
            rc = 1;
        }
        return rc;
    }

    private static IWorkspace __checkConnectionToServer(UserContextInterface user, ServerComponent sc, String classid) throws RemoteException, MdException, InvalidParameterException, SchedulerException, CallbackCancelledException {
        String host = "";
        int port = 0;
        TCPIPConnection connection = IWorkspaceServer.getTCPIPConnection(sc, classid);
        if (connection == null) {
            throw new InvalidParameterException(MetaUtilities.messageString(m_bundle.getString("IWorkspaceServer.ErrorMsg.NoServer.fmt"), sc.getName()));
        }
        host = connection.getHostName();
        port = connection.getPort();
        try {
            if (user != null) {
                try {
                    LogicalServer lc = null;
                    if (sc instanceof ServerContext) {
                        ServerComponent workspace = IWorkspaceServer.getWorkspace((ServerContext)sc, WORKSPACE_CLASSID);
                        lc = (LogicalServer)workspace.getUsedByComponents().get(0);
                    } else if (sc.getClassIdentifier().compareTo(WORKSPACE_CLASSID) == 0) {
                        lc = (LogicalServer)sc.getUsedByComponents().get(0);
                    } else {
                        ServerContext appserver = IWorkspaceServer.getServerContext(sc);
                        ServerComponent workspace = IWorkspaceServer.getWorkspace(appserver, WORKSPACE_CLASSID);
                        lc = (LogicalServer)workspace.getUsedByComponents().get(0);
                    }
                    return IWorkspaceServer.makeConnection(user, lc, classid, host, port);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    return null;
                }
            }
            return null;
        }
        catch (CallbackCancelledException cce) {
            throw cce;
        }
        catch (InvalidCredentialsException e) {
            throw new SchedulerException(m_bundle.getString("IWorkspaceServer.ErrorMsg.invalidCredentials.txt"));
        }
        catch (FatalConnectionFactoryException e) {
            String appName = "";
            try {
                appName = sc.getName();
            }
            catch (RuntimeException rte) {
                appName = host;
            }
            throw new SchedulerException(MetaUtilities.messageString(m_bundle.getString("IWorkspaceServer.ErrorMsg.unableToLaunch.fmt"), appName));
        }
        catch (ConnectionFactoryException e) {
            SchedulerException se = new SchedulerException(m_bundle.getString("IWorkspaceServer.ErrorMsg.invalidCredentials.txt"));
            se.initCause((Throwable)e);
            throw se;
        }
        catch (ServiceException se) {
            return null;
        }
    }

    public IWorkspace checkConnectionToServer(Frame frame, ServerContext sc, String classid) throws RemoteException, MdException {
        try {
            switch (this.checkConnectionToServer(frame, (ServerComponent)sc, classid)) {
                case 1: {
                    return this.m_iworkspace;
                }
            }
            return null;
        }
        catch (InvalidParameterException e) {
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean makeConnection(UserContextInterface user) throws InvalidCredentialsException, FatalConnectionFactoryException, RemoteException, MdException, ServiceException, CallbackCancelledException {
        if (user != null) {
            LogicalServer lc = null;
            try {
                if (this.m_sc instanceof ServerContext) {
                    ServerComponent workspace = IWorkspaceServer.getWorkspace((ServerContext)this.m_sc, WORKSPACE_CLASSID);
                    lc = (LogicalServer)workspace.getUsedByComponents().get(0);
                } else if (this.m_sc.getClassIdentifier().compareTo(WORKSPACE_CLASSID) == 0) {
                    lc = (LogicalServer)this.m_sc.getUsedByComponents().get(0);
                } else {
                    ServerContext appserver = IWorkspaceServer.getServerContext(this.m_sc);
                    ServerComponent workspace = IWorkspaceServer.getWorkspace(appserver, WORKSPACE_CLASSID);
                    lc = (LogicalServer)workspace.getUsedByComponents().get(0);
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                lc = null;
            }
            if (lc == null) {
                this.m_userContext = null;
                this.m_user = null;
                this.m_iworkspace = null;
                this.m_connected = false;
                return this.m_connected;
            }
            String key = lc.getFQID() + "/" + lc.getCMetadataType();
            ServerInterface serverInterface = user.getAuthServer();
            Logger logger = null;
            try {
                PlatformConnectionFactoryManager cxfManager;
                PlatformConnectionFactoryConfiguration cxfConfig;
                if (serverInterface != null) {
                    LogicalServerInterface server = (LogicalServerInterface)serverInterface.fetch(key);
                    cxfConfig = new PlatformConnectionFactoryConfiguration(server);
                    cxfManager = new PlatformConnectionFactoryManager();
                    this.m_pcxf = cxfManager.getPlatformFactory((ConnectionFactoryConfiguration)cxfConfig);
                    this.m_cx = this.m_pcxf.getConnection(user);
                    logger = cxfManager.getConnectionServiceLogger();
                } else {
                    BridgeServer IOMserver = new BridgeServer(this.m_classid, this.m_host, this.m_port);
                    try {
                        ServerComponent sc = (ServerComponent)lc.getUsingComponents().get(0);
                        IOMserver.setServerName(sc.getName());
                    }
                    catch (Exception sc) {
                        // empty catch block
                    }
                    cxfConfig = new ManualConnectionFactoryConfiguration((Server)IOMserver);
                    cxfManager = new ConnectionFactoryManager();
                    this.m_cxf = cxfManager.getFactory((ConnectionFactoryConfiguration)cxfConfig);
                    SecurityPackageCredential cred = SecurityPackageCredential.getInstance();
                    this.m_cx = this.m_cxf.getConnection((Credential)cred);
                    logger = cxfManager.getConnectionServiceLogger();
                }
                logger.setLevel(Level.OFF);
                Object obj = this.m_cx.getObject();
                if (obj != null) {
                    this.m_userContext = user;
                    String domain = MetaUtilities.getDomain(this.m_sc);
                    UserIdentityInterface uId = user.getIdentityByDomain(domain != null ? domain : "");
                    this.m_user = uId != null ? uId.getPrincipal().toString() : null;
                    this.m_iworkspace = IWorkspaceHelper.narrow((Object)obj);
                    this.m_connected = true;
                    return this.m_connected;
                }
                this.m_userContext = null;
                this.m_user = null;
                this.m_iworkspace = null;
                this.m_connected = false;
                return this.m_connected;
            }
            catch (InvalidCredentialsException e) {
                throw e;
            }
            catch (FatalConnectionFactoryException e) {
                throw e;
            }
            catch (ConnectionFactoryException cfe) {
                this.m_userContext = null;
                this.m_user = null;
                this.m_iworkspace = null;
                this.m_connected = false;
                if (!(cfe instanceof LoginException) || !this.containsCause((Exception)((java.lang.Object)cfe), CallbackCancelledException.class)) return this.m_connected;
                throw new CallbackCancelledException();
            }
        }
        this.m_userContext = null;
        this.m_user = null;
        this.m_iworkspace = null;
        this.m_connected = false;
        return this.m_connected;
    }

    public static IWorkspace makeConnection(UserContextInterface user, LogicalServer lc, String classid, String host, int port) throws RemoteException, MdException, ServiceException, CallbackCancelledException, ConnectionFactoryException {
        IWorkspace iworkspace = null;
        if (user != null) {
            if (lc == null) {
                return null;
            }
            String key = lc.getFQID() + "/" + lc.getCMetadataType();
            ServerInterface serverInterface = user.getAuthServer();
            ConnectionInterface cx = null;
            Logger logger = null;
            try {
                if (serverInterface != null) {
                    LogicalServerInterface server = (LogicalServerInterface)serverInterface.fetch(key);
                    PlatformConnectionFactoryConfiguration cxfConfig = new PlatformConnectionFactoryConfiguration(server);
                    PlatformConnectionFactoryManager cxfManager = new PlatformConnectionFactoryManager();
                    PlatformConnectionFactoryInterface pcxf = cxfManager.getPlatformFactory((ConnectionFactoryConfiguration)cxfConfig);
                    cx = pcxf.getConnection(user);
                    logger = cxfManager.getConnectionServiceLogger();
                } else {
                    BridgeServer IOMserver = new BridgeServer(classid, host, port);
                    try {
                        ServerComponent sc = (ServerComponent)lc.getUsingComponents().get(0);
                        IOMserver.setServerName(sc.getName());
                    }
                    catch (Exception sc) {
                        // empty catch block
                    }
                    ManualConnectionFactoryConfiguration cxfConfig = new ManualConnectionFactoryConfiguration((Server)IOMserver);
                    ConnectionFactoryManager cxfManager = new ConnectionFactoryManager();
                    ConnectionFactoryInterface cxf = cxfManager.getFactory((ConnectionFactoryConfiguration)cxfConfig);
                    SecurityPackageCredential cred = SecurityPackageCredential.getInstance();
                    cx = cxf.getConnection((Credential)cred);
                    logger = cxfManager.getConnectionServiceLogger();
                }
                logger.setLevel(Level.OFF);
                Object obj = cx.getObject();
                if (obj != null) {
                    iworkspace = IWorkspaceHelper.narrow((Object)obj);
                }
                iworkspace = null;
            }
            catch (InvalidCredentialsException e) {
                throw e;
            }
            catch (FatalConnectionFactoryException e) {
                throw e;
            }
            catch (ConnectionFactoryException cfe) {
                throw cfe;
            }
        } else {
            iworkspace = null;
        }
        return iworkspace;
    }

    private boolean containsCause(Exception exception, Class<CallbackCancelledException> causeType) {
        for (Throwable cause = exception.getCause(); cause != null; cause = cause.getCause()) {
            if (!causeType.isAssignableFrom(cause.getClass())) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public boolean makeConnection(String username, String password) throws InvalidCredentialsException, FatalConnectionFactoryException {
        return this.makeConnection(username, password != null ? new SealedString(password) : null);
    }

    public boolean makeConnection(String username, SealedString password) throws InvalidCredentialsException, FatalConnectionFactoryException {
        if (username != null && username.length() != 0) {
            BridgeServer IOMserver = new BridgeServer(this.m_classid, this.m_host, this.m_port);
            if (this.m_sc != null && !(this.m_sc instanceof ServerContext)) {
                try {
                    String name = null;
                    if (this.m_sc.getClassIdentifier().compareTo(WORKSPACE_CLASSID) == 0) {
                        name = this.m_sc.getName();
                    } else {
                        ServerContext appserver = IWorkspaceServer.getServerContext(this.m_sc);
                        ServerComponent workspace = IWorkspaceServer.getWorkspace(appserver, WORKSPACE_CLASSID);
                        name = workspace.getName();
                    }
                    IOMserver.setServerName(name);
                }
                catch (RemoteException name) {
                }
                catch (MdException name) {
                    // empty catch block
                }
            }
            ManualConnectionFactoryConfiguration cxfConfig = new ManualConnectionFactoryConfiguration((Server)IOMserver);
            ConnectionFactoryManager cxfManager = new ConnectionFactoryManager();
            try {
                Logger logger = cxfManager.getConnectionServiceLogger();
                logger.setLevel(Level.OFF);
                this.m_cxf = cxfManager.getFactory((ConnectionFactoryConfiguration)cxfConfig);
                this.m_cx = this.m_cxf.getConnection(username, password != null ? String.valueOf(password.getCharacters()) : null);
            }
            catch (InvalidCredentialsException e) {
                throw e;
            }
            catch (FatalConnectionFactoryException e) {
                throw e;
            }
            catch (ConnectionFactoryException se) {
                throw new InvalidParameterException(MetaUtilities.messageString(m_bundle.getString("IWorkspaceServer.ErrorMsg.NoServerAvailable.fmt"), se.getLocalizedMessage()));
            }
            Object obj = this.m_cx.getObject();
            if (obj != null) {
                this.m_iworkspace = IWorkspaceHelper.narrow((Object)obj);
                this.m_user = username;
                this.m_password = password;
                this.m_connected = true;
            } else {
                this.m_user = null;
                this.m_password = null;
                this.m_iworkspace = null;
                this.m_connected = false;
            }
        } else {
            this.m_user = null;
            this.m_password = null;
            this.m_iworkspace = null;
            this.m_connected = false;
        }
        return this.m_connected;
    }

    public static IWorkspace makeConnection(String username, String password, String classid, String host, int port) throws InvalidCredentialsException, FatalConnectionFactoryException {
        return IWorkspaceServer.makeConnection(username, password, classid, null, host, port);
    }

    public static IWorkspace makeConnection(String username, String password, String classid, String servername, String host, int port) throws InvalidCredentialsException, FatalConnectionFactoryException {
        if (username != null && username.length() != 0) {
            BridgeServer IOMserver = new BridgeServer(classid, host, port);
            if (servername != null) {
                IOMserver.setServerName(servername);
            }
            ManualConnectionFactoryConfiguration cxfConfig = new ManualConnectionFactoryConfiguration((Server)IOMserver);
            ConnectionFactoryManager cxfManager = new ConnectionFactoryManager();
            try {
                Logger logger = cxfManager.getConnectionServiceLogger();
                logger.setLevel(Level.OFF);
                ConnectionFactoryInterface cxf = cxfManager.getFactory((ConnectionFactoryConfiguration)cxfConfig);
                ConnectionInterface cx = cxf.getConnection(username, password);
                Object obj = cx.getObject();
                if (obj != null) {
                    return IWorkspaceHelper.narrow((Object)obj);
                }
            }
            catch (InvalidCredentialsException e) {
                throw e;
            }
            catch (FatalConnectionFactoryException e) {
                throw e;
            }
            catch (ConnectionFactoryException se) {
                throw new InvalidParameterException(MetaUtilities.messageString(m_bundle.getString("IWorkspaceServer.ErrorMsg.NoServerAvailable.fmt"), se.getLocalizedMessage()));
            }
        }
        return null;
    }

    public void closeConnection() {
        try {
            if (this.m_iworkspace != null) {
                this.m_iworkspace.Close();
                this.m_cx.close();
                if (this.m_cxf != null) {
                    this.m_cxf.getAdminInterface().shutdown();
                }
                if (this.m_pcxf != null) {
                    this.m_pcxf.getAdminInterface().destroy();
                }
                this.m_iworkspace = null;
            }
        }
        catch (GenericError ex) {
            this.m_iworkspace = null;
        }
        catch (ConnectionFactoryException ex) {
            this.m_iworkspace = null;
        }
        finally {
            this.m_userContext = null;
            this.m_user = null;
            this.m_password = null;
            this.m_cx = null;
            this.m_cxf = null;
            this.m_connected = false;
        }
    }

    public static ServerContext getServerContext(ServerComponent sc) throws RemoteException, MdException {
        if (sc instanceof ServerContext) {
            return (ServerContext)sc;
        }
        try {
            LogicalServer lc = (LogicalServer)sc.getUsedByComponents().get(0);
            if (lc == null) {
                return null;
            }
            return (ServerContext)lc.getUsedByComponents().get(0);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    public static TCPIPConnection getTCPIPConnection(ServerComponent sc, String classid) throws RemoteException, MdException {
        if (sc == null) {
            return null;
        }
        if (sc instanceof ServerContext) {
            return IWorkspaceServer.getTCPIPConnection((ServerContext)sc, classid);
        }
        try {
            LogicalServer lc = (LogicalServer)sc.getUsedByComponents().get(0);
            if (lc == null) {
                return null;
            }
            ServerContext appServer = (ServerContext)lc.getUsedByComponents().get(0);
            if (appServer == null) {
                return null;
            }
            return IWorkspaceServer.getTCPIPConnection(appServer, classid);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    public static TCPIPConnection getTCPIPConnection(ServerContext appServer, String classid) throws RemoteException, MdException {
        ServerComponent workspace = IWorkspaceServer.getWorkspace(appServer, classid);
        if (workspace == null) {
            return null;
        }
        TCPIPConnection connection = (TCPIPConnection)workspace.getSourceConnections().get(0);
        return connection;
    }

    public static ServerComponent getWorkspace(ServerContext appServer, String classid) throws RemoteException, MdException {
        ServerComponent workspace = null;
        AssociationList usingComponents = appServer.getUsingComponents();
        for (LogicalServer logicalServer : usingComponents) {
            String classID = logicalServer.getClassIdentifier();
            if (!classID.equalsIgnoreCase(classid)) continue;
            workspace = (ServerComponent)logicalServer.getUsingComponents().get(0);
            break;
        }
        return workspace;
    }

    public List<String> listFiles(String sDirectoryName) throws GenericError {
        return IWorkspaceServer.listFiles(sDirectoryName, this.m_iworkspace);
    }

    public static List<String> listFiles(String sDirectoryName, IWorkspace iworkspace) throws GenericError {
        DateTimeSeqHolder dtmFiles;
        StringSeqHolder existingFiles;
        TreeSet<java.lang.Object> files;
        block4: {
            files = new TreeSet<java.lang.Object>(new CompareFileObjects());
            boolean[] fieldMask = new boolean[]{true, false, false, false, true, false};
            StringHolder listedPath = new StringHolder();
            existingFiles = new StringSeqHolder();
            dtmFiles = new DateTimeSeqHolder();
            try {
                iworkspace.FileService().ListFiles(sDirectoryName, ListFilesMode.ListFilesModePath, fieldMask, listedPath, existingFiles, new StringSeqHolder(), new TypeCategorySeqHolder(), new LongSeqHolder(), dtmFiles, new StringSeqHolder());
            }
            catch (InvalidFieldMask e) {
                if (!MetaUtilities.isDebug()) break block4;
                e.printStackTrace();
            }
        }
        for (int fileIndex = 0; fileIndex < existingFiles.value.length; ++fileIndex) {
            String name = existingFiles.value[fileIndex];
            long dtm = dtmFiles.value[fileIndex];
            myFile x = new myFile(name, dtm);
            files.add(x);
        }
        ArrayList<String> z = new ArrayList<String>();
        Iterator<java.lang.Object> i = files.iterator();
        while (i.hasNext()) {
            z.add(((myFile)i.next())._name);
        }
        return z;
    }

    private static class CompareFileObjects
    implements Comparator<java.lang.Object>,
    Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public int compare(java.lang.Object a, java.lang.Object b) {
            myFile infoa = (myFile)a;
            myFile infob = (myFile)b;
            if (infoa._dtm == infob._dtm) {
                return 0;
            }
            if (infoa._dtm < infob._dtm) {
                return -1;
            }
            return 1;
        }

        @Override
        public int compare(myFile infoa, myFile infob) {
            if (infoa._dtm == infob._dtm) {
                return 0;
            }
            if (infoa._dtm < infob._dtm) {
                return -1;
            }
            return 1;
        }
    }

    private static class myFile {
        public String _name;
        public long _dtm;

        myFile(String name, long dtm) {
            this._name = name;
            this._dtm = dtm;
        }
    }
}

