/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.report;

import com.sas.iom.SAS.IDataService;
import com.sas.iom.SAS.IDataServicePackage.InvalidEngine;
import com.sas.iom.SAS.IDataServicePackage.LibraryInUse;
import com.sas.iom.SAS.IDataServicePackage.NoLibrary;
import com.sas.iom.SAS.IDataServicePackage.NoWorkDeassign;
import com.sas.iom.SAS.IFileService;
import com.sas.iom.SAS.IFileref;
import com.sas.iom.SAS.ILibref;
import com.sas.iom.SAS.ITextStream;
import com.sas.iom.SAS.IWorkspace;
import com.sas.iom.SAS.InvalidLName;
import com.sas.iom.SAS.InvalidPName;
import com.sas.iom.SAS.LNameNoAssign;
import com.sas.iom.SAS.NoAccessMethod;
import com.sas.iom.SAS.StreamOpenMode;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.metadata.remote.MdException;
import com.sas.scheduler.api.oma.DeployedFlow;
import com.sas.scheduler.api.oma.MetaUtilities;
import com.sas.scheduler.api.report.ReportFlowInterface;
import com.sas.scheduler.api.servers.sasprocs.submitSAS;
import com.sas.scheduler.model.FlowInfo;
import com.sas.scheduler.model.SchedulerException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.security.InvalidParameterException;
import java.security.ProviderException;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Vector;
import org.omg.CORBA.StringHolder;

public class ReportFlowToSAS
extends submitSAS
implements ReportFlowInterface {
    private static final ResourceBundle m_bundle = MetaUtilities.getMyResourceBundle(ReportFlowToSAS.class);
    private DeployedFlow m_flow = null;
    private String m_outdir = null;
    private ITextStream m_outfile = null;
    private StringBuffer m_buffer = null;
    private String m_name = null;
    private String m_physicalName = null;

    public ReportFlowToSAS(DeployedFlow flow, String name, String dirpath, IWorkspace workspace) throws RemoteException {
        super(workspace);
        this.m_flow = flow;
        this.m_outdir = dirpath;
        if (name != null && name.length() > 0) {
            this.setName(name);
        } else {
            this.setName(this.m_flow.getName());
        }
    }

    @Override
    public boolean hasOutputFile() {
        return this.m_physicalName != null;
    }

    @Override
    public String getOutputFile() {
        return this.m_physicalName;
    }

    @Override
    public String getData() {
        return this.m_buffer.toString();
    }

    @Override
    public boolean setOUTDir(String dir) {
        this.m_outdir = dir;
        return true;
    }

    @Override
    public String getOUTDir() {
        return this.m_outdir;
    }

    @Override
    public boolean setName(String name) {
        this.m_name = name;
        return true;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public boolean writeFlow() throws MdException, IOException, InvalidParameterException, SchedulerException {
        this.m_buffer = this.processFlow(this.m_flow);
        if (this.m_workspace != null) {
            InvalidParameterException ivpe = null;
            SchedulerException sche = null;
            IFileService rio_file = this.m_workspace.FileService();
            IDataService rio_data = this.m_workspace.DataService();
            String fileref = "tempDS";
            this.m_physicalName = "";
            String accessMethodOrDevice = "TEMP";
            String hostOptions = "encoding='UTF8'";
            StringHolder assignedName = new StringHolder(fileref);
            String libref = "schedule";
            ILibref libRef = null;
            try {
                IFileref fileRef = rio_file.AssignFileref(fileref, accessMethodOrDevice, this.m_physicalName, hostOptions, assignedName);
                this.m_outfile = fileRef.OpenTextStream(StreamOpenMode.StreamOpenModeForWriting, 1024);
                this.m_outfile.Write(this.m_buffer.toString());
                this.m_outfile.Close();
                libRef = rio_data.AssignLibref(libref, "", this.m_outdir, "");
            }
            catch (GenericError ge) {
                this.m_physicalName = null;
                return false;
            }
            catch (NoLibrary ex) {
                SchedulerException se = new SchedulerException();
                se.initCause((Throwable)ex);
                throw se;
            }
            catch (InvalidEngine ex) {
                SchedulerException se = new SchedulerException();
                se.initCause((Throwable)ex);
                throw se;
            }
            catch (NoAccessMethod ex) {
                SchedulerException se = new SchedulerException();
                se.initCause((Throwable)ex);
                throw se;
            }
            catch (LNameNoAssign ex) {
                SchedulerException se = new SchedulerException();
                se.initCause((Throwable)ex);
                throw se;
            }
            catch (InvalidLName ex) {
                SchedulerException se = new SchedulerException();
                se.initCause((Throwable)ex);
                throw se;
            }
            catch (InvalidPName ex) {
                SchedulerException se = new SchedulerException();
                se.initCause((Throwable)ex);
                throw se;
            }
            StringBuffer sascode = new StringBuffer();
            StringBuffer sascode2 = new StringBuffer();
            sascode.append("options validvarname=any;\n");
            sascode.append("data " + libRef.Name().trim() + ".'" + this.m_name.toLowerCase() + "'n (drop=line);\n");
            sascode.append("  infile " + fileref + " MISSOVER LRECL=1024 PAD;\n");
            sascode.append("  input line $CHAR1024.;\n");
            Vector vars = FlowInfo.getColumns((boolean)false);
            Vector labels = FlowInfo.getColumns();
            int num = vars.size();
            int position = 0;
            for (int i = 0; i < num; ++i) {
                String var = (String)vars.get(i);
                String varname = MetaUtilities.replaceInvalidCharacters(var);
                String label = (String)labels.get(i);
                sascode.append("  attrib " + varname + " length=$512. label='" + label + "';\n");
                sascode2.append("  " + varname + " = scan(line, " + ++position + ", ',');\n");
            }
            sascode.append(sascode2.toString());
            sascode.append("run;\n");
            try {
                super.submitStatements(sascode);
            }
            catch (SchedulerException ex) {
                if (this.m_name.length() > 32) {
                    ivpe = new InvalidParameterException(MetaUtilities.messageString(m_bundle.getString("ReportFlowToSAS.DataSetNameOverflow.fmt"), this.m_name));
                    ivpe.initCause(ex);
                }
                sche = ex;
            }
            try {
                rio_file.DeassignFileref(fileref);
            }
            catch (GenericError ex) {
            }
            catch (RuntimeException ex) {
                // empty catch block
            }
            try {
                rio_data.DeassignLibref(libref);
            }
            catch (LNameNoAssign ex) {
            }
            catch (NoWorkDeassign ex) {
            }
            catch (LibraryInUse ex) {
            }
            catch (GenericError ex) {
            }
            catch (RuntimeException ex) {
                // empty catch block
            }
            if (ivpe != null) {
                throw ivpe;
            }
            if (sche != null) {
                throw sche;
            }
            if (this.m_status == 1) {
                ProviderException ex = new ProviderException(this.m_statusMsg);
                throw ex;
            }
            return true;
        }
        return false;
    }

    private StringBuffer processFlow(DeployedFlow flow) throws MdException, IOException, InvalidParameterException, SchedulerException {
        StringBuffer buffer = new StringBuffer();
        Vector data = flow.getData(true);
        for (Vector row : data) {
            Iterator i2 = row.iterator();
            Object obj = i2.next();
            buffer.append(obj != null ? obj.toString() : " ");
            while (i2.hasNext()) {
                obj = i2.next();
                buffer.append("," + (obj != null ? obj.toString() : " "));
            }
            buffer.append("\n");
        }
        return buffer;
    }
}

