/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.report;

import com.sas.iom.SAS.IFileService;
import com.sas.iom.SAS.IFileref;
import com.sas.iom.SAS.ITextStream;
import com.sas.iom.SAS.IWorkspace;
import com.sas.iom.SAS.StreamOpenMode;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.metadata.remote.MdException;
import com.sas.scheduler.api.oma.CommandUtilities;
import com.sas.scheduler.api.oma.DeployedFlow;
import com.sas.scheduler.api.oma.MetaUtilities;
import com.sas.scheduler.api.report.ReportFlowInterface;
import com.sas.scheduler.api.servers.Scheduler;
import com.sas.scheduler.model.FlowInfo;
import com.sas.scheduler.model.SchedulerException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.security.InvalidParameterException;
import java.util.Iterator;
import java.util.Vector;
import org.omg.CORBA.StringHolder;

public class ReportFlowToCSV
implements ReportFlowInterface {
    private Scheduler m_scheduler = null;
    private IWorkspace m_workspace = null;
    private DeployedFlow m_flow = null;
    private String m_outdir = null;
    private ITextStream m_outfile = null;
    private StringBuffer m_csvbuffer = null;
    private String m_name = null;
    private String m_physicalName = null;

    public ReportFlowToCSV(DeployedFlow flow, String name, String dirpath, IWorkspace workspace) throws RemoteException, MdException {
        this.m_scheduler = flow.getSchedulingServer();
        this.m_workspace = workspace;
        this.m_flow = flow;
        this.m_outdir = dirpath;
        if (name != null && name.length() > 0) {
            this.setName(name + ".csv");
        } else {
            try {
                String flowname = this.m_scheduler.genFlowName(flow.getInfo());
                this.setName(MetaUtilities.replaceInvalidCharactersInFileName(flowname) + ".csv");
            }
            catch (SchedulerException se) {
                this.setName(this.m_flow.getName() + ".csv");
            }
            catch (NullPointerException npe) {
                this.setName(this.m_flow.getName() + ".csv");
            }
        }
    }

    @Override
    public boolean hasOutputFile() {
        return this.m_physicalName != null;
    }

    @Override
    public String getOutputFile() {
        return this.m_physicalName;
    }

    @Override
    public String getData() {
        return this.m_csvbuffer.toString();
    }

    @Override
    public boolean setOUTDir(String dir) {
        this.m_outdir = dir;
        return true;
    }

    @Override
    public String getOUTDir() {
        return this.m_outdir;
    }

    @Override
    public boolean setName(String name) {
        this.m_name = name;
        return true;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public boolean writeFlow() throws MdException, IOException, InvalidParameterException, SchedulerException {
        this.m_csvbuffer = this.processFlow(this.m_flow);
        if (this.m_workspace != null) {
            IFileService rio = this.m_workspace.FileService();
            String fileref = "tempCSV";
            this.m_physicalName = CommandUtilities.createFullPath(this.m_outdir, this.m_name, -1);
            String accessMethodOrDevice = "DISK";
            String hostOptions = "encoding='UTF8'";
            StringHolder assignedName = new StringHolder(fileref);
            try {
                IFileref fileRef = rio.AssignFileref(fileref, accessMethodOrDevice, this.m_physicalName, hostOptions, assignedName);
                this.m_outfile = fileRef.OpenTextStream(StreamOpenMode.StreamOpenModeForWriting, 1024);
                this.m_outfile.Write(this.m_csvbuffer.toString());
                this.m_outfile.Close();
                rio.DeassignFileref(fileref);
                return true;
            }
            catch (GenericError ge) {
                this.m_physicalName = null;
                return false;
            }
        }
        return false;
    }

    private StringBuffer processFlow(DeployedFlow flow) throws MdException, IOException, InvalidParameterException, SchedulerException {
        StringBuffer csvbuffer = new StringBuffer();
        Vector vars = FlowInfo.getColumns((boolean)false);
        Iterator i = vars.iterator();
        csvbuffer.append(i.next().toString());
        while (i.hasNext()) {
            csvbuffer.append("," + i.next().toString());
        }
        csvbuffer.append("\n");
        Vector data = flow.getData(true);
        for (Vector row : data) {
            Iterator i2 = row.iterator();
            Object obj = i2.next();
            csvbuffer.append(obj != null ? obj.toString() : "");
            while (i2.hasNext()) {
                obj = i2.next();
                String objStr = obj != null ? obj.toString() : "";
                csvbuffer.append("," + objStr);
            }
            csvbuffer.append("\n");
        }
        return csvbuffer;
    }
}

