/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.oma;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.JFJob;
import com.sas.metadata.remote.Job;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Transformation;
import com.sas.metadata.remote.Tree;
import com.sas.scheduler.api.oma.DeployedFlow;
import com.sas.scheduler.api.oma.DeployedJob;
import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.model.SchedulingDeleteHelperInterface;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class SchedulingDeleteHelper
implements SchedulingDeleteHelperInterface {
    public void markForDeletion(Object jomaObject) throws RemoteException, SchedulerException {
        try {
            List jfJobs = this.getJFJobsAssociatedWithJomaObject(jomaObject);
            JFJob aJob = null;
            for (JFJob jfJob : jfJobs) {
                jfJob.setTransformRole("SCHEDULER_JOB_DELETE");
                List<JFJob> flows = DeployedJob.getListofFlows(jfJob);
                for (JFJob flow : flows) {
                    DeployedFlow dFlow = new DeployedFlow(flow, (MdObjectStore)flow.getObjectStore());
                    if (dFlow.getNumofJobs() > 1) continue;
                    flow.setTransformRole("SCHEDULER_FLOW_DELETE");
                }
                aJob = jfJob;
            }
            if (aJob != null) {
                aJob.updateMetadataAll();
            }
            this.handleBurstDefinition(jomaObject);
        }
        catch (MdException e) {
            SchedulerException ex = new SchedulerException(e.toString());
            ex.initCause((Throwable)e);
            throw ex;
        }
    }

    private List getJFJobsAssociatedWithJomaObject(Object jomaObject) throws RemoteException, MdException {
        AssociationList sourceTransformations = null;
        if (jomaObject instanceof Tree) {
            Tree tree = (Tree)jomaObject;
            sourceTransformations = tree.getSourceTransformations();
        } else if (jomaObject instanceof Job) {
            Job job = (Job)jomaObject;
            AssociationList jfJobs = job.getJFJobs();
            if (jfJobs.size() > 0) {
                return jfJobs;
            }
            sourceTransformations = job.getSourceTransformations();
        } else if (jomaObject instanceof Transformation) {
            Transformation transformation = (Transformation)jomaObject;
            sourceTransformations = transformation.getSourceTransformations();
        }
        ArrayList results = new ArrayList();
        if (sourceTransformations != null) {
            for (Object element : sourceTransformations) {
                Job job;
                if (!(element instanceof Job) || !(job = (Job)element).getTransformRole().equals("SCHEDULER_BRIDGE_JOB")) continue;
                results.addAll(job.getJFJobs());
            }
        }
        return results;
    }

    private void handleBurstDefinition(Object jomaObject) throws RemoteException, MdException, SchedulerException {
        AssociationList targetTransformations = null;
        if (!(jomaObject instanceof Transformation)) {
            return;
        }
        Transformation transformation = (Transformation)jomaObject;
        targetTransformations = transformation.getTargetTransformations();
        for (Object element : targetTransformations) {
            if (!(element instanceof Transformation) || !(transformation = (Transformation)element).getTransformRole().equals("BurstDefinition")) continue;
            transformation.setTransformRole("BurstDefinitionDeleted");
            this.markForDeletion(transformation);
        }
    }
}

