/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.oma;

import com.sas.scheduler.api.oma.FileEvent;
import com.sas.scheduler.api.oma.JobEvent;
import com.sas.scheduler.api.oma.TimeEvent;
import com.sas.scheduler.model.AbstractEventInfo;
import com.sas.scheduler.model.AbstractEventInterface;
import com.sas.scheduler.model.GroupingEventInfo;
import com.sas.scheduler.model.JobInfo;
import java.util.Vector;

public class GroupingEvent
implements AbstractEventInterface {
    private static final String GroupingEventTag = "PlatformIndependentGroupingEventV1:";
    public static final int AND = 0;
    public static final int OR = 1;
    private int m_condition;
    private Vector<AbstractEventInterface> m_objects = new Vector(2);
    private String m_description;

    public GroupingEvent() {
        this.m_condition = -1;
    }

    public GroupingEvent(String condition) {
        this.m_condition = condition.compareToIgnoreCase("AND") == 0 ? 0 : (condition.compareToIgnoreCase("OR") == 0 ? 1 : -1);
    }

    public GroupingEvent(int condition) {
        switch (condition) {
            case 0: 
            case 1: {
                this.m_condition = condition;
                break;
            }
            default: {
                this.m_condition = -1;
            }
        }
    }

    public int getType() {
        return this.m_condition;
    }

    public boolean addDependency(AbstractEventInterface object) {
        return this.m_objects.add(object);
    }

    public String generateDefinition() {
        StringBuffer groupingDefinition = new StringBuffer(GroupingEventTag);
        if (this.m_condition == 0) {
            groupingDefinition.append("CombinationType=\"AND\"");
        } else {
            groupingDefinition.append("CombinationType=\"OR\"");
        }
        return groupingDefinition.toString();
    }

    public boolean initFromDefinition(String content) {
        if (content == null) {
            return false;
        }
        boolean isGroupEvent = content.startsWith(GroupingEventTag);
        if (!isGroupEvent) {
            return false;
        }
        this.m_condition = content.indexOf("=\"AND\"") > 0 ? 0 : (content.indexOf("=\"OR\"") > 0 ? 1 : -1);
        return true;
    }

    public GroupingEventInfo getInfo(JobInfo job) {
        GroupingEventInfo info = new GroupingEventInfo(job, this.m_condition);
        for (AbstractEventInterface obj : this.m_objects) {
            if (obj instanceof FileEvent) {
                info.addDependency((AbstractEventInfo)((FileEvent)obj).getInfo());
                continue;
            }
            if (obj instanceof TimeEvent) {
                info.addDependency((AbstractEventInfo)((TimeEvent)obj).getInfo());
                continue;
            }
            if (obj instanceof JobEvent) {
                info.addDependency((AbstractEventInfo)((JobEvent)obj).getInfo(job));
                continue;
            }
            if (!(obj instanceof GroupingEvent)) continue;
            info.addDependency((AbstractEventInfo)((GroupingEvent)obj).getInfo(null));
        }
        return info;
    }

    public String generateXML() {
        return this.generateXML(false);
    }

    public String generateXML(boolean exportFormat) {
        StringBuffer buffer = new StringBuffer();
        if (this.m_condition == 0) {
            buffer.append("<Events CombinationType=\"AND\">\n");
        } else {
            buffer.append("<Events CombinationType=\"OR\">\n");
        }
        for (AbstractEventInterface obj : this.m_objects) {
            String xml = null;
            if (obj instanceof FileEvent) {
                xml = ((FileEvent)obj).generateXML(exportFormat);
            } else if (obj instanceof TimeEvent) {
                xml = ((TimeEvent)obj).generateXML(exportFormat);
            } else if (obj instanceof JobEvent) {
                xml = ((JobEvent)obj).generateXML(exportFormat);
            } else if (obj instanceof GroupingEvent) {
                xml = ((GroupingEvent)obj).generateXML(exportFormat);
            }
            if (xml == null) continue;
            buffer.append(xml);
        }
        buffer.append("</Events>\n");
        return buffer.toString();
    }

    public boolean setDescription(String sDescription) {
        this.m_description = sDescription;
        return true;
    }

    public String getDescription() {
        return this.m_description;
    }
}

